/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hpsf;

import java.util.Map;
import org.apache.poi.hpsf.ClassID;
import org.apache.poi.hpsf.HPSFRuntimeException;
import org.apache.poi.hpsf.Property;
import org.apache.poi.hpsf.wellknown.SectionIDMap;
import org.apache.poi.util.LittleEndian;

public class Section {
    protected Map dictionary;
    protected ClassID formatID;
    protected long offset;
    protected int size;
    protected int propertyCount;
    protected Property[] properties;
    private boolean wasNull;

    public ClassID getFormatID() {
        return this.formatID;
    }

    public long getOffset() {
        return this.offset;
    }

    public int getSize() {
        return this.size;
    }

    public int getPropertyCount() {
        return this.propertyCount;
    }

    public Property[] getProperties() {
        return this.properties;
    }

    protected Section() {
    }

    public Section(byte[] src, int offset) {
        int length;
        int sOffset;
        int id;
        int i2;
        this.formatID = new ClassID(src, offset);
        this.offset = LittleEndian.getUInt(src, offset += 16);
        offset = (int)this.offset;
        this.size = (int)LittleEndian.getUInt(src, offset);
        this.propertyCount = (int)LittleEndian.getUInt(src, offset += 4);
        this.properties = new Property[this.propertyCount];
        int codepage = -1;
        int pass1Offset = offset += 4;
        for (i2 = 0; i2 < this.properties.length; ++i2) {
            id = (int)LittleEndian.getUInt(src, pass1Offset);
            sOffset = (int)LittleEndian.getUInt(src, pass1Offset += 4);
            length = i2 == this.properties.length - 1 ? (int)((long)src.length - this.offset - (long)sOffset) : (int)LittleEndian.getUInt(src, (pass1Offset += 4) + 4) - sOffset;
            if (id != 1) continue;
            int o = (int)(this.offset + (long)sOffset);
            long type = LittleEndian.getUInt(src, o);
            o += 4;
            if (type != 2L) {
                throw new HPSFRuntimeException("Value type of property ID 1 is not VT_I2 but " + type + ".");
            }
            codepage = LittleEndian.getUShort(src, o);
        }
        for (i2 = 0; i2 < this.properties.length; ++i2) {
            id = (int)LittleEndian.getUInt(src, offset);
            sOffset = (int)LittleEndian.getUInt(src, offset += 4);
            length = i2 == this.properties.length - 1 ? (int)((long)src.length - this.offset - (long)sOffset) : (int)LittleEndian.getUInt(src, (offset += 4) + 4) - sOffset;
            this.properties[i2] = new Property(id, src, this.offset + (long)sOffset, length, codepage);
        }
        this.dictionary = (Map)this.getProperty(0);
    }

    public Object getProperty(int id) {
        this.wasNull = false;
        for (int i2 = 0; i2 < this.properties.length; ++i2) {
            if (id != this.properties[i2].getID()) continue;
            return this.properties[i2].getValue();
        }
        this.wasNull = true;
        return null;
    }

    protected int getPropertyIntValue(int id) {
        Long i2 = (Long)this.getProperty(id);
        if (i2 != null) {
            return i2.intValue();
        }
        return 0;
    }

    protected boolean getPropertyBooleanValue(int id) {
        Boolean b2 = (Boolean)this.getProperty(id);
        if (b2 != null) {
            return b2;
        }
        return false;
    }

    public boolean wasNull() {
        return this.wasNull;
    }

    public String getPIDString(int pid) {
        String s2 = null;
        if (this.dictionary != null) {
            s2 = (String)this.dictionary.get(new Integer(pid));
        }
        if (s2 == null) {
            s2 = SectionIDMap.getPIDString(this.getFormatID().getBytes(), pid);
        }
        if (s2 == null) {
            s2 = "[undefined]";
        }
        return s2;
    }
}

