/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record;

import java.util.ArrayList;
import java.util.List;
import org.apache.poi.hssf.record.PColor;
import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.RecordFormatException;
import org.apache.poi.util.LittleEndian;

public class PaletteRecord
extends Record {
    public static final short sid = 146;
    public static final byte STANDARD_PALETTE_SIZE = 56;
    public static final short FIRST_COLOR_INDEX = 8;
    private short field_1_numcolors;
    private List field_2_colors;

    public PaletteRecord() {
    }

    public PaletteRecord(short id) {
        super(id, (short)56, PaletteRecord.getDefaultData());
    }

    public PaletteRecord(short id, short size, byte[] data) {
        super(id, size, data);
    }

    public PaletteRecord(short id, short size, byte[] data, int offset) {
        super(id, size, data, offset);
    }

    protected void validateSid(short id) {
        if (id != 146) {
            throw new RecordFormatException("NOT An Palette RECORD");
        }
    }

    protected void fillFields(byte[] data, short size, int offset) {
        this.field_1_numcolors = LittleEndian.getShort(data, offset + 0);
        this.field_2_colors = new ArrayList(this.field_1_numcolors);
        for (int k = 0; k < this.field_1_numcolors; ++k) {
            this.field_2_colors.add(new PColor(data[2 + offset + k * 4 + 0], data[2 + offset + k * 4 + 1], data[2 + offset + k * 4 + 2]));
        }
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[PALETTE]\n");
        buffer.append("  numcolors     = ").append(this.field_1_numcolors).append('\n');
        for (int k = 0; k < this.field_1_numcolors; ++k) {
            PColor c2 = (PColor)this.field_2_colors.get(k);
            buffer.append("* colornum      = ").append(k).append('\n');
            buffer.append(c2.toString());
            buffer.append("/*colornum      = ").append(k).append('\n');
        }
        buffer.append("[/PALETTE]\n");
        return buffer.toString();
    }

    public int serialize(int offset, byte[] data) {
        LittleEndian.putShort(data, 0 + offset, (short)146);
        LittleEndian.putShort(data, 2 + offset, (short)(this.getRecordSize() - 4));
        LittleEndian.putShort(data, 4 + offset, this.field_1_numcolors);
        for (int k = 0; k < this.field_1_numcolors; ++k) {
            PColor c2 = (PColor)this.field_2_colors.get(k);
            c2.serialize(data, 6 + offset + k * 4);
        }
        return this.getRecordSize();
    }

    public int getRecordSize() {
        return 6 + this.field_1_numcolors * 4;
    }

    public short getSid() {
        return 146;
    }

    public byte[] getColor(short byteIndex) {
        int i2 = byteIndex - 8;
        if (i2 < 0 || i2 >= this.field_2_colors.size()) {
            return null;
        }
        PColor color = (PColor)this.field_2_colors.get(i2);
        return new byte[]{color.red, color.green, color.blue};
    }

    public void setColor(short byteIndex, byte red, byte green, byte blue) {
        int i2 = byteIndex - 8;
        if (i2 < 0 || i2 >= 56) {
            return;
        }
        while (this.field_2_colors.size() <= i2) {
            this.field_2_colors.add(new PColor(0, 0, 0));
        }
        PColor custColor = new PColor(red, green, blue);
        this.field_2_colors.set(i2, custColor);
    }

    public static byte[] getDefaultData() {
        return new byte[]{56, 0, 0, 0, 0, 0, -1, -1, -1, 0, -1, 0, 0, 0, 0, -1, 0, 0, 0, 0, -1, 0, -1, -1, 0, 0, -1, 0, -1, 0, 0, -1, -1, 0, -128, 0, 0, 0, 0, -128, 0, 0, 0, 0, -128, 0, -128, -128, 0, 0, -128, 0, -128, 0, 0, -128, -128, 0, -64, -64, -64, 0, -128, -128, -128, 0, -103, -103, -1, 0, -103, 51, 102, 0, -1, -1, -52, 0, -52, -1, -1, 0, 102, 0, 102, 0, -1, -128, -128, 0, 0, 102, -52, 0, -52, -52, -1, 0, 0, 0, -128, 0, -1, 0, -1, 0, -1, -1, 0, 0, 0, -1, -1, 0, -128, 0, -128, 0, -128, 0, 0, 0, 0, -128, -128, 0, 0, 0, -1, 0, 0, -52, -1, 0, -52, -1, -1, 0, -52, -1, -52, 0, -1, -1, -103, 0, -103, -52, -1, 0, -1, -103, -52, 0, -52, -103, -1, 0, -1, -52, -103, 0, 51, 102, -1, 0, 51, -52, -52, 0, -103, -52, 0, 0, -1, -52, 0, 0, -1, -103, 0, 0, -1, 102, 0, 0, 102, 102, -103, 0, -106, -106, -106, 0, 0, 51, 102, 0, 51, -103, 102, 0, 0, 51, 0, 0, 51, 51, 0, 0, -103, 51, 0, 0, -103, 51, 102, 0, 51, 51, -103, 0, 51, 51, 51, 0};
    }
}

