/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.usermodel;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;

public class FontDetails {
    private String fontName;
    private int height;
    private Map charWidths = new HashMap();

    public FontDetails(String fontName, int height) {
        this.fontName = fontName;
        this.height = height;
    }

    public String getFontName() {
        return this.fontName;
    }

    public int getHeight() {
        return this.height;
    }

    public void addChar(char c2, int width) {
        this.charWidths.put(new Character(c2), new Integer(width));
    }

    public int getCharWidth(char c2) {
        Integer widthInteger = (Integer)this.charWidths.get(new Character(c2));
        if (widthInteger == null && c2 != 'W') {
            return this.getCharWidth('W');
        }
        return widthInteger;
    }

    public void addChars(char[] characters, int[] widths) {
        for (int i2 = 0; i2 < characters.length; ++i2) {
            this.charWidths.put(new Character(characters[i2]), new Integer(widths[i2]));
        }
    }

    public static FontDetails create(String fontName, Properties fontMetricsProps) {
        String[] widthsStrArray;
        String heightStr = fontMetricsProps.getProperty("font." + fontName + ".height");
        String widthsStr = fontMetricsProps.getProperty("font." + fontName + ".widths");
        String charactersStr = fontMetricsProps.getProperty("font." + fontName + ".characters");
        int height = Integer.parseInt(heightStr);
        FontDetails d2 = new FontDetails(fontName, height);
        String[] charactersStrArray = FontDetails.split(charactersStr, ",", -1);
        if (charactersStrArray.length != (widthsStrArray = FontDetails.split(widthsStr, ",", -1)).length) {
            throw new RuntimeException("Number of characters does not number of widths for font " + fontName);
        }
        for (int i2 = 0; i2 < widthsStrArray.length; ++i2) {
            if (charactersStrArray[i2].length() == 0) continue;
            d2.addChar(charactersStrArray[i2].charAt(0), Integer.parseInt(widthsStrArray[i2]));
        }
        return d2;
    }

    public int getStringWidth(String str) {
        int width = 0;
        for (int i2 = 0; i2 < str.length(); ++i2) {
            width += this.getCharWidth(str.charAt(i2));
        }
        return width;
    }

    private static String[] split(String text, String separator, int max) {
        StringTokenizer tok = new StringTokenizer(text, separator);
        int listSize = tok.countTokens();
        if (max != -1 && listSize > max) {
            listSize = max;
        }
        String[] list = new String[listSize];
        int i2 = 0;
        while (tok.hasMoreTokens()) {
            if (max != -1 && i2 == listSize - 1) {
                StringBuffer buf = new StringBuffer(text.length() * (listSize - i2) / listSize);
                while (tok.hasMoreTokens()) {
                    buf.append(tok.nextToken());
                    if (!tok.hasMoreTokens()) continue;
                    buf.append(separator);
                }
                list[i2] = buf.toString().trim();
                break;
            }
            list[i2] = tok.nextToken().trim();
            ++i2;
        }
        return list;
    }
}

