/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.wstore;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.compiere.model.MAccessLog;
import org.compiere.model.MLead;
import org.compiere.model.MProductDownload;
import org.compiere.util.CLogger;
import org.compiere.util.Ctx;
import org.compiere.util.Msg;
import org.compiere.util.WebEnv;
import org.compiere.util.WebInfo;
import org.compiere.util.WebUtil;
import org.compiere.wstore.JSPEnv;

public class LeadServlet
extends HttpServlet {
    private static CLogger log = CLogger.getCLogger(LeadServlet.class);
    public static final String NAME = "leadServlet";

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        if (!WebEnv.initWeb(config)) {
            throw new ServletException("LeadServlet.init");
        }
    }

    public String getServletInfo() {
        return "Compiere Web Lead Servlet";
    }

    public void destroy() {
        log.fine("");
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        log.info("Get from " + request.getRemoteHost() + " - " + request.getRemoteAddr());
        Ctx ctx = JSPEnv.getCtx(request);
        HttpSession session = request.getSession(false);
        session.removeAttribute("hdrMessage");
        WebInfo info = (WebInfo)session.getAttribute("info");
        if (info != null) {
            info.setMessage("");
        }
        String forwardTo = request.getParameter("ForwardTo");
        String errorTo = request.getParameter("ErrorTo");
        MLead lead = this.createLead(ctx, request);
        Boolean success = this.download(lead, request, response, ctx);
        if (success != null && success.booleanValue()) {
            return;
        }
        if (success != null && !success.booleanValue() && errorTo != null && errorTo.length() > 0) {
            forwardTo = errorTo;
        }
        if (!(forwardTo != null && forwardTo.length() != 0 || (forwardTo = request.getHeader("referer")) != null && forwardTo.length() != 0)) {
            forwardTo = "/index.html";
        }
        log.info("Forward to " + forwardTo);
        if (forwardTo.startsWith("http")) {
            WebUtil.createForwardPage(response, "Thank you!", forwardTo, 2);
        } else {
            RequestDispatcher dispatcher = this.getServletContext().getRequestDispatcher(forwardTo);
            dispatcher.forward((ServletRequest)request, (ServletResponse)response);
        }
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }

    private MLead createLead(Ctx ctx, HttpServletRequest request) {
        HashMap<String, String> parameter = new HashMap<String, String>();
        Enumeration ee = request.getParameterNames();
        while (ee.hasMoreElements()) {
            String key = ee.nextElement().toString();
            String value = request.getParameter(key);
            if (value == null || value.length() <= 0) continue;
            parameter.put(key, value);
        }
        log.fine(parameter.toString());
        MLead lead = new MLead(ctx, parameter, null);
        lead.setRemote_Host(request.getRemoteHost());
        lead.setRemote_Addr(request.getRemoteAddr());
        if (lead.save()) {
            log.info(lead.toString());
        }
        return lead;
    }

    private Boolean download(MLead lead, HttpServletRequest request, HttpServletResponse response, Ctx ctx) {
        StringBuffer info = new StringBuffer();
        Enumeration ee = request.getParameterNames();
        while (ee.hasMoreElements()) {
            String key = ee.nextElement().toString();
            String value = request.getParameter(key);
            if (value == null || value.length() <= 0) continue;
            info.append(key).append("=").append(value).append(";");
        }
        MAccessLog al = new MAccessLog(ctx, lead.getEMail(), request.getRemoteHost(), request.getRemoteAddr(), info.toString(), null);
        al.setC_Lead_ID(lead.getC_Lead_ID());
        al.save();
        String download = request.getParameter("M_ProductDownload_ID");
        if (download == null || download.length() == 0) {
            return null;
        }
        int M_ProductDownload_ID = 0;
        try {
            M_ProductDownload_ID = Integer.parseInt(download);
        }
        catch (Exception e) {
            log.warning("Parsing M_ProductDownload_ID=" + download + " - " + e.toString());
        }
        if (M_ProductDownload_ID == 0) {
            return Boolean.FALSE;
        }
        MProductDownload pd = MProductDownload.get(ctx, M_ProductDownload_ID);
        if (lead.getAD_Client_ID() != pd.getAD_Client_ID() || !pd.isLeadDownload() || pd.getDownloadName() == null) {
            log.warning("Invalid Download - " + lead);
            al.setReply("InvalidDownload: " + download);
            al.save();
            return Boolean.FALSE;
        }
        InputStream in = pd.getDownloadStream(ctx.getContext("documentDir"));
        if (in == null) {
            String info1 = "Download not found: " + pd.getDownloadURL();
            log.warning(info1);
            al.setReply(info1);
            al.save();
            return Boolean.FALSE;
        }
        byte[] downloadInfo = String.valueOf(M_ProductDownload_ID).getBytes();
        log.info("Stream: " + pd + " - " + lead);
        Object[] args = new Object[]{pd.getName(), lead.getContactName()};
        String readme = Msg.getMsg(ctx, "LeadDeliveryTemplate", args);
        al.setAD_Table_ID(777);
        al.setRecord_ID(M_ProductDownload_ID);
        float speed = 0.0f;
        try {
            response.setContentType("application/zip");
            response.setHeader("Content-Location", "lead.zip");
            int bufferSize = 2048;
            response.setBufferSize(bufferSize);
            log.fine(in + ", available=" + in.available());
            long time = System.currentTimeMillis();
            ServletOutputStream out = response.getOutputStream();
            ZipOutputStream zip = new ZipOutputStream((OutputStream)out);
            zip.setMethod(8);
            zip.setLevel(9);
            zip.setComment(readme);
            ZipEntry entry = new ZipEntry("readme.txt");
            entry.setExtra(downloadInfo);
            zip.putNextEntry(entry);
            zip.write(readme.getBytes(), 0, readme.length());
            zip.closeEntry();
            entry = new ZipEntry(pd.getDownloadName());
            entry.setExtra(downloadInfo);
            zip.putNextEntry(entry);
            byte[] buffer = new byte[bufferSize];
            int count = 0;
            int totalSize = 0;
            do {
                if ((count = in.read(buffer, 0, bufferSize)) <= 0) continue;
                totalSize += count;
                zip.write(buffer, 0, count);
            } while (count != -1);
            zip.closeEntry();
            zip.finish();
            zip.close();
            in.close();
            time = System.currentTimeMillis() - time;
            speed = (float)totalSize / 1024.0f / ((float)time / 1000.0f);
            String msg = totalSize / 1024 + "kB - " + time + " ms - " + speed + " kB/sec";
            log.fine(msg);
            al.setReply(msg);
            al.save();
        }
        catch (IOException ex) {
            String msg = ex.getMessage();
            if (msg == null || msg.length() == 0) {
                msg = ex.toString();
            }
            log.warning(msg);
            try {
                al.setReply(msg);
                al.save();
            }
            catch (Exception ex1) {
                log.log(Level.SEVERE, "2 - " + ex);
            }
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }
}

