/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.management.j2ee;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.jboss.logging.Logger;
import org.jboss.management.j2ee.InvalidParentException;
import org.jboss.management.j2ee.J2EEDomain;
import org.jboss.management.j2ee.J2EEManagedObject;
import org.jboss.management.j2ee.J2EEResource;
import org.jboss.management.j2ee.JDBCResourceMBean;
import org.jboss.management.j2ee.StateManagement;

public class JDBCResource
extends J2EEResource
implements JDBCResourceMBean {
    private static Logger log = Logger.getLogger((Class)(class$org$jboss$management$j2ee$JDBCResource == null ? (class$org$jboss$management$j2ee$JDBCResource = JDBCResource.class$("org.jboss.management.j2ee.JDBCResource")) : class$org$jboss$management$j2ee$JDBCResource));
    private StateManagement mState;
    private ObjectName mService;
    private List mDataSources = new ArrayList();
    static /* synthetic */ Class class$org$jboss$management$j2ee$JDBCResource;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$javax$management$ObjectName;

    public static ObjectName create(MBeanServer pServer, String pName) {
        ObjectName lServer = null;
        try {
            lServer = pServer.queryNames(new ObjectName(J2EEDomain.getDomainName() + ":" + "j2eeType" + "=" + "J2EEServer" + "," + "*"), null).iterator().next();
        }
        catch (Exception e) {
            log.error((Object)"Could not find parent J2EEServer", (Throwable)e);
            return null;
        }
        try {
            return pServer.createMBean("org.jboss.management.j2ee.JDBCResource", null, new Object[]{pName, lServer}, new String[]{(class$java$lang$String == null ? (class$java$lang$String = JDBCResource.class$("java.lang.String")) : class$java$lang$String).getName(), (class$javax$management$ObjectName == null ? (class$javax$management$ObjectName = JDBCResource.class$("javax.management.ObjectName")) : class$javax$management$ObjectName).getName()}).getObjectName();
        }
        catch (Exception e) {
            log.error((Object)"Could not create JSR-77 JDBC Manager", (Throwable)e);
            return null;
        }
    }

    public static void destroy(MBeanServer pServer, String pName) {
        try {
            ObjectName lJDBCResource;
            String[] lDataSources;
            ObjectName lSearch = new ObjectName(J2EEDomain.getDomainName() + ":" + "j2eeType" + "=" + "JDBCResource" + "," + "name=" + pName + "," + "*");
            Set<ObjectName> lNames = pServer.queryNames(lSearch, null);
            if (!lNames.isEmpty() && (lDataSources = (String[])pServer.getAttribute(lJDBCResource = lNames.iterator().next(), "jdbcDataSources")).length == 0) {
                pServer.unregisterMBean(lJDBCResource);
            }
        }
        catch (Exception e) {
            log.error((Object)"Could not destroy JSR-77 JDBC Manager", (Throwable)e);
        }
    }

    public JDBCResource(String pName, ObjectName pServer) throws MalformedObjectNameException, InvalidParentException {
        super("JDBCResource", pName, pServer);
        this.mState = new StateManagement(this);
    }

    public String[] getEventTypes() {
        return StateManagement.stateTypes;
    }

    public String getEventType(int pIndex) {
        if (pIndex >= 0 && pIndex < StateManagement.stateTypes.length) {
            return StateManagement.stateTypes[pIndex];
        }
        return null;
    }

    public long getStartTime() {
        return this.mState.getStartTime();
    }

    public int getState() {
        return this.mState.getState();
    }

    public void mejbStart() {
        this.mState.setState(4);
        this.mState.setState(5);
    }

    public void mejbStartRecursive() {
        this.mState.setState(3);
        Iterator i = this.mDataSources.iterator();
        String lDataSource = null;
        while (i.hasNext()) {
            lDataSource = (String)i.next();
            try {
                this.getServer().invoke(JDBCResource.newObjectName(lDataSource), "mejbStart", new Object[0], new String[0]);
            }
            catch (JMException jme) {
                this.getLog().error((Object)("Could not start JSR-77 JDBC-DataSource: " + lDataSource), (Throwable)jme);
            }
        }
        this.mState.setState(2);
    }

    public void mejbStop() {
        this.mState.setState(3);
        Iterator i = this.mDataSources.iterator();
        while (i.hasNext()) {
            String lDataSource = (String)i.next();
            try {
                this.getServer().invoke(JDBCResource.newObjectName(lDataSource), "mejbStop", new Object[0], new String[0]);
            }
            catch (JMException jme) {
                this.getLog().error((Object)("Could not stop JSR-77 JDBC-DataSource: " + lDataSource), (Throwable)jme);
            }
        }
        this.mState.setState(2);
    }

    public void postCreation() {
        this.sendNotification("j2ee.object.deleted", "JDBC Resource Resource deleted");
    }

    public void preDestruction() {
        this.sendNotification("j2ee.object.created", "JDBC Resource Resource created");
    }

    public String[] getjdbcDataSources() {
        return this.mDataSources.toArray(new String[this.mDataSources.size()]);
    }

    public String getjdbcDataSource(int pIndex) {
        if (pIndex >= 0 && pIndex < this.mDataSources.size()) {
            return (String)this.mDataSources.get(pIndex);
        }
        return null;
    }

    public void addChild(ObjectName pChild) {
        String lType = J2EEManagedObject.getType(pChild);
        if ("JDBCDataSource".equals(lType)) {
            this.mDataSources.add(pChild.getCanonicalName());
        }
    }

    public void removeChild(ObjectName pChild) {
        String lType = J2EEManagedObject.getType(pChild);
        if ("JDBCDataSource".equals(lType)) {
            this.mDataSources.remove(pChild.getCanonicalName());
        }
    }

    public String toString() {
        return "JDBCResource { " + super.toString() + " } [ " + "Datasources: " + this.mDataSources + " ]";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

