/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart;

import com.keypoint.PngEncoder;
import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGEncodeParam;
import com.sun.image.codec.jpeg.JPEGImageEncoder;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Iterator;
import org.jfree.chart.ChartRenderingInfo;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.entity.ChartEntity;
import org.jfree.chart.entity.EntityCollection;
import org.jfree.chart.imagemap.OverLIBToolTipTagFragmentGenerator;
import org.jfree.chart.imagemap.StandardToolTipTagFragmentGenerator;
import org.jfree.chart.imagemap.StandardURLTagFragmentGenerator;
import org.jfree.chart.imagemap.ToolTipTagFragmentGenerator;
import org.jfree.chart.imagemap.URLTagFragmentGenerator;

public abstract class ChartUtilities {
    private static final float DEFAULT_JPEG_QUALITY = 0.75f;
    private static final int DEFAULT_PNG_COMPRESSION = 9;

    public static void writeChartAsPNG(OutputStream out, JFreeChart chart, int width, int height) throws IOException {
        ChartUtilities.writeChartAsPNG(out, chart, width, height, null, false, 9);
    }

    public static void writeChartAsPNG(OutputStream out, JFreeChart chart, int width, int height, boolean encodeAlpha, int compression) throws IOException {
        ChartUtilities.writeChartAsPNG(out, chart, width, height, null, encodeAlpha, compression);
    }

    public static void writeChartAsPNG(OutputStream out, JFreeChart chart, int width, int height, ChartRenderingInfo info) throws IOException {
        ChartUtilities.writeChartAsPNG(out, chart, width, height, info, false, 9);
    }

    public static void writeChartAsPNG(OutputStream out, JFreeChart chart, int width, int height, ChartRenderingInfo info, boolean encodeAlpha, int compression) throws IOException {
        if (out == null) {
            throw new IllegalArgumentException("Null 'out' argument.");
        }
        if (chart == null) {
            throw new IllegalArgumentException("Null 'chart' argument.");
        }
        BufferedImage chartImage = chart.createBufferedImage(width, height, 2, info);
        ChartUtilities.writeBufferedImageAsPNG(out, chartImage, encodeAlpha, compression);
    }

    public static void writeScaledChartAsPNG(OutputStream out, JFreeChart chart, int width, int height, int widthScaleFactor, int heightScaleFactor) throws IOException {
        if (out == null) {
            throw new IllegalArgumentException("Null 'out' argument.");
        }
        if (chart == null) {
            throw new IllegalArgumentException("Null 'chart' argument.");
        }
        double desiredWidth = width * widthScaleFactor;
        double desiredHeight = height * heightScaleFactor;
        double defaultWidth = width;
        double defaultHeight = height;
        boolean scale = false;
        if (widthScaleFactor != 1 || heightScaleFactor != 1) {
            scale = true;
        }
        double scaleX = desiredWidth / defaultWidth;
        double scaleY = desiredHeight / defaultHeight;
        BufferedImage image = new BufferedImage((int)desiredWidth, (int)desiredHeight, 2);
        Graphics2D g2 = image.createGraphics();
        if (scale) {
            AffineTransform saved = g2.getTransform();
            g2.transform(AffineTransform.getScaleInstance(scaleX, scaleY));
            chart.draw(g2, new Rectangle2D.Double(0.0, 0.0, defaultWidth, defaultHeight), null, null);
            g2.setTransform(saved);
            g2.dispose();
        } else {
            chart.draw(g2, new Rectangle2D.Double(0.0, 0.0, defaultWidth, defaultHeight), null, null);
        }
        out.write(ChartUtilities.encodeAsPNG(image));
    }

    public static void saveChartAsPNG(File file, JFreeChart chart, int width, int height) throws IOException {
        ChartUtilities.saveChartAsPNG(file, chart, width, height, null);
    }

    public static void saveChartAsPNG(File file, JFreeChart chart, int width, int height, ChartRenderingInfo info) throws IOException {
        ChartUtilities.saveChartAsPNG(file, chart, width, height, info, true, 9);
    }

    public static void saveChartAsPNG(File file, JFreeChart chart, int width, int height, ChartRenderingInfo info, boolean encodeAlpha, int compression) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("Null 'file' argument.");
        }
        if (chart == null) {
            throw new IllegalArgumentException("Null 'chart' argument.");
        }
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(file));
        ChartUtilities.writeChartAsPNG(out, chart, width, height, info, encodeAlpha, compression);
        ((OutputStream)out).close();
    }

    public static void writeChartAsJPEG(OutputStream out, JFreeChart chart, int width, int height) throws IOException {
        ChartUtilities.writeChartAsJPEG(out, 0.75f, chart, width, height, null);
    }

    public static void writeChartAsJPEG(OutputStream out, float quality, JFreeChart chart, int width, int height) throws IOException {
        ChartUtilities.writeChartAsJPEG(out, quality, chart, width, height, null);
    }

    public static void writeChartAsJPEG(OutputStream out, JFreeChart chart, int width, int height, ChartRenderingInfo info) throws IOException {
        ChartUtilities.writeChartAsJPEG(out, 0.75f, chart, width, height, info);
    }

    public static void writeChartAsJPEG(OutputStream out, float quality, JFreeChart chart, int width, int height, ChartRenderingInfo info) throws IOException {
        if (out == null) {
            throw new IllegalArgumentException("Null 'out' argument.");
        }
        if (chart == null) {
            throw new IllegalArgumentException("Null 'chart' argument.");
        }
        BufferedImage chartImage = chart.createBufferedImage(width, height, info);
        ChartUtilities.writeBufferedImageAsJPEG(out, quality, chartImage);
    }

    public static void saveChartAsJPEG(File file, JFreeChart chart, int width, int height) throws IOException {
        ChartUtilities.saveChartAsJPEG(file, 0.75f, chart, width, height, null);
    }

    public static void saveChartAsJPEG(File file, float quality, JFreeChart chart, int width, int height) throws IOException {
        ChartUtilities.saveChartAsJPEG(file, quality, chart, width, height, null);
    }

    public static void saveChartAsJPEG(File file, JFreeChart chart, int width, int height, ChartRenderingInfo info) throws IOException {
        ChartUtilities.saveChartAsJPEG(file, 0.75f, chart, width, height, info);
    }

    public static void saveChartAsJPEG(File file, float quality, JFreeChart chart, int width, int height, ChartRenderingInfo info) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("Null 'file' argument.");
        }
        if (chart == null) {
            throw new IllegalArgumentException("Null 'chart' argument.");
        }
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(file));
        ChartUtilities.writeChartAsJPEG(out, quality, chart, width, height, info);
        ((OutputStream)out).close();
    }

    public static void writeBufferedImageAsJPEG(OutputStream out, BufferedImage image) throws IOException {
        ChartUtilities.writeBufferedImageAsJPEG(out, 0.75f, image);
    }

    public static void writeBufferedImageAsJPEG(OutputStream out, float quality, BufferedImage image) throws IOException {
        if (out == null) {
            throw new IllegalArgumentException("Null 'out' argument.");
        }
        if (image == null) {
            throw new IllegalArgumentException("Null 'image' argument.");
        }
        JPEGImageEncoder encoder = JPEGCodec.createJPEGEncoder((OutputStream)out);
        JPEGEncodeParam param = encoder.getDefaultJPEGEncodeParam(image);
        param.setQuality(quality, true);
        encoder.encode(image, param);
    }

    public static void writeBufferedImageAsPNG(OutputStream out, BufferedImage image) throws IOException {
        ChartUtilities.writeBufferedImageAsPNG(out, image, false, 9);
    }

    public static void writeBufferedImageAsPNG(OutputStream out, BufferedImage image, boolean encodeAlpha, int compression) throws IOException {
        if (out == null) {
            throw new IllegalArgumentException("Null 'out' argument.");
        }
        if (image == null) {
            throw new IllegalArgumentException("Null 'image' argument.");
        }
        out.write(ChartUtilities.encodeAsPNG(image, encodeAlpha, compression));
    }

    public static byte[] encodeAsPNG(BufferedImage image) {
        return ChartUtilities.encodeAsPNG(image, false, 9);
    }

    public static byte[] encodeAsPNG(BufferedImage image, boolean encodeAlpha, int compression) {
        if (image == null) {
            throw new IllegalArgumentException("Null 'image' argument.");
        }
        PngEncoder encoder = new PngEncoder((Image)image, encodeAlpha, 0, compression);
        return encoder.pngEncode();
    }

    public static void writeImageMap(PrintWriter writer, String name, ChartRenderingInfo info) throws IOException {
        ChartUtilities.writeImageMap(writer, name, info, new StandardToolTipTagFragmentGenerator(), new StandardURLTagFragmentGenerator());
    }

    public static void writeImageMap(PrintWriter writer, String name, ChartRenderingInfo info, boolean useOverLibForToolTips) throws IOException {
        ToolTipTagFragmentGenerator toolTipTagFragmentGenerator = null;
        toolTipTagFragmentGenerator = useOverLibForToolTips ? new OverLIBToolTipTagFragmentGenerator() : new StandardToolTipTagFragmentGenerator();
        ChartUtilities.writeImageMap(writer, name, info, toolTipTagFragmentGenerator, new StandardURLTagFragmentGenerator());
    }

    public static void writeImageMap(PrintWriter writer, String name, ChartRenderingInfo info, ToolTipTagFragmentGenerator toolTipTagFragmentGenerator, URLTagFragmentGenerator urlTagFragmentGenerator) throws IOException {
        writer.println(ChartUtilities.getImageMap(name, info, toolTipTagFragmentGenerator, urlTagFragmentGenerator));
    }

    public static String getImageMap(String name, ChartRenderingInfo info) {
        return ChartUtilities.getImageMap(name, info, new StandardToolTipTagFragmentGenerator(), new StandardURLTagFragmentGenerator());
    }

    public static String getImageMap(String name, ChartRenderingInfo info, ToolTipTagFragmentGenerator toolTipTagFragmentGenerator, URLTagFragmentGenerator urlTagFragmentGenerator) {
        StringBuffer sb = new StringBuffer();
        sb.append("<MAP NAME=\"" + name + "\">");
        sb.append(System.getProperty("line.separator"));
        EntityCollection entities = info.getEntityCollection();
        if (entities != null) {
            Iterator iterator = entities.iterator();
            while (iterator.hasNext()) {
                ChartEntity entity = (ChartEntity)iterator.next();
                String area = entity.getImageMapAreaTag(toolTipTagFragmentGenerator, urlTagFragmentGenerator);
                if (area.length() <= 0) continue;
                sb.append(area);
                sb.append(System.getProperty("line.separator"));
            }
        }
        sb.append("</MAP>");
        return sb.toString();
    }
}

