/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.acct;

import java.math.BigDecimal;
import org.compiere.acct.Doc;
import org.compiere.acct.DocLine;
import org.compiere.model.MAllocationLine;
import org.compiere.util.DB;

public class DocLine_Allocation
extends DocLine {
    private int m_C_Invoice_ID;
    private int m_C_Payment_ID;
    private int m_C_CashLine_ID;
    private int m_C_Order_ID;
    private BigDecimal m_DiscountAmt;
    private BigDecimal m_WriteOffAmt;
    private BigDecimal m_OverUnderAmt;

    public DocLine_Allocation(MAllocationLine line, Doc doc) {
        super(line, doc);
        this.m_C_Payment_ID = line.getC_Payment_ID();
        this.m_C_CashLine_ID = line.getC_CashLine_ID();
        this.m_C_Invoice_ID = line.getC_Invoice_ID();
        this.m_C_Order_ID = line.getC_Order_ID();
        this.setAmount(line.getAmount());
        this.m_DiscountAmt = line.getDiscountAmt();
        this.m_WriteOffAmt = line.getWriteOffAmt();
        this.m_OverUnderAmt = line.getOverUnderAmt();
    }

    public int getInvoiceC_Currency_ID() {
        if (this.m_C_Invoice_ID == 0) {
            return 0;
        }
        String sql = "SELECT C_Currency_ID FROM C_Invoice WHERE C_Invoice_ID=?";
        return DB.getSQLValue(null, sql, this.m_C_Invoice_ID);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("DocLine_Allocation[");
        sb.append(this.get_ID()).append(",Amt=").append(this.getAmtSource()).append(",Discount=").append(this.getDiscountAmt()).append(",WriteOff=").append(this.getWriteOffAmt()).append(",OverUnderAmt=").append(this.getOverUnderAmt()).append(" - C_Payment_ID=").append(this.m_C_Payment_ID).append(",C_CashLine_ID=").append(this.m_C_CashLine_ID).append(",C_Invoice_ID=").append(this.m_C_Invoice_ID).append("]");
        return sb.toString();
    }

    public int getC_Order_ID() {
        return this.m_C_Order_ID;
    }

    public BigDecimal getDiscountAmt() {
        return this.m_DiscountAmt;
    }

    public BigDecimal getOverUnderAmt() {
        return this.m_OverUnderAmt;
    }

    public BigDecimal getWriteOffAmt() {
        return this.m_WriteOffAmt;
    }

    public int getC_CashLine_ID() {
        return this.m_C_CashLine_ID;
    }

    public int getC_Invoice_ID() {
        return this.m_C_Invoice_ID;
    }

    public int getC_Payment_ID() {
        return this.m_C_Payment_ID;
    }
}

