/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.acct;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.logging.Level;
import org.compiere.acct.Doc;
import org.compiere.acct.DocLine;
import org.compiere.acct.DocLine_Allocation;
import org.compiere.acct.Doc_AllocationTax;
import org.compiere.acct.Doc_Invoice;
import org.compiere.acct.Doc_Order;
import org.compiere.acct.Fact;
import org.compiere.acct.FactLine;
import org.compiere.model.MAccount;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MAllocationHdr;
import org.compiere.model.MAllocationLine;
import org.compiere.model.MCashLine;
import org.compiere.model.MConversionRate;
import org.compiere.model.MFactAcct;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MPayment;
import org.compiere.model.X_C_Invoice;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Doc_Allocation
extends Doc {
    private static final BigDecimal TOLERANCE = new BigDecimal(0.02);
    private ArrayList<Fact> m_facts = null;

    public Doc_Allocation(MAcctSchema[] ass, ResultSet rs, String trxName) {
        super(ass, MAllocationHdr.class, rs, "CMA", trxName);
    }

    @Override
    public String loadDocumentDetails() {
        MAllocationHdr alloc = (MAllocationHdr)this.getPO();
        this.setDateDoc(alloc.getDateTrx());
        this.p_lines = this.loadLines(alloc);
        return null;
    }

    private DocLine[] loadLines(MAllocationHdr alloc) {
        ArrayList<DocLine_Allocation> list = new ArrayList<DocLine_Allocation>();
        MAllocationLine[] lines = alloc.getLines(false);
        for (int i = 0; i < lines.length; ++i) {
            MAllocationLine line = lines[i];
            if (!lines[i].isActive()) continue;
            DocLine_Allocation docLine = new DocLine_Allocation(line, (Doc)this);
            if (line.getC_Payment_ID() != 0) {
                MPayment payment = new MPayment(this.getCtx(), line.getC_Payment_ID(), this.getTrxName());
                int C_ConversionType_ID = payment.getC_ConversionType_ID();
                docLine.setC_ConversionType_ID(C_ConversionType_ID);
            }
            this.log.fine(docLine.toString());
            list.add(docLine);
        }
        DocLine[] dls = new DocLine[list.size()];
        list.toArray(dls);
        return dls;
    }

    @Override
    public BigDecimal getBalance() {
        BigDecimal retValue = Env.ZERO;
        return retValue;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public ArrayList<Fact> createFacts(MAcctSchema as) {
        this.m_facts = new ArrayList();
        Fact fact = new Fact(this, as, "A");
        int i = 0;
        while (true) {
            block35: {
                X_C_Invoice invoice;
                MAccount bpAcct;
                BigDecimal allocationAccounted;
                BigDecimal allocationSource;
                DocLine_Allocation line;
                block37: {
                    MCashLine cashLine;
                    MPayment payment;
                    FactLine fl;
                    block38: {
                        block36: {
                            if (i >= this.p_lines.length) {
                                this.setC_BPartner_ID(0);
                                this.m_facts.add(fact);
                                return this.m_facts;
                            }
                            line = (DocLine_Allocation)this.p_lines[i];
                            this.setC_BPartner_ID(line.getC_BPartner_ID());
                            if (line.getC_Payment_ID() != 0 && line.getC_Invoice_ID() == 0 && line.getC_Order_ID() == 0 && line.getC_CashLine_ID() == 0 && line.getC_BPartner_ID() == 0 && Env.ZERO.compareTo(line.getDiscountAmt()) == 0 && Env.ZERO.compareTo(line.getWriteOffAmt()) == 0) break block35;
                            allocationSource = line.getAmtSource().add(line.getDiscountAmt()).add(line.getWriteOffAmt());
                            allocationAccounted = null;
                            fl = null;
                            bpAcct = null;
                            payment = null;
                            if (line.getC_Payment_ID() != 0) {
                                payment = new MPayment(this.getCtx(), line.getC_Payment_ID(), this.getTrxName());
                            }
                            invoice = null;
                            if (line.getC_Invoice_ID() != 0) {
                                invoice = new MInvoice(this.getCtx(), line.getC_Invoice_ID(), null);
                            }
                            if (invoice != null) break block36;
                            if (line.getC_Invoice_ID() == 0 && line.getC_Payment_ID() != 0) {
                                fl = fact.createLine((DocLine)line, this.getPaymentAcct(as, line.getC_Payment_ID()), this.getC_Currency_ID(), line.getAmtSource(), null);
                                if (fl != null && payment != null) {
                                    fl.setAD_Org_ID(payment.getAD_Org_ID());
                                }
                                break block37;
                            } else {
                                this.p_Error = "Cannot determine SO/PO";
                                this.log.log(Level.SEVERE, this.p_Error);
                                return null;
                            }
                        }
                        if (!invoice.isSOTrx()) break block38;
                        if (line.getC_Payment_ID() != 0) {
                            fl = fact.createLine((DocLine)line, this.getPaymentAcct(as, line.getC_Payment_ID()), this.getC_Currency_ID(), line.getAmtSource(), null);
                            if (fl != null && payment != null) {
                                fl.setAD_Org_ID(payment.getAD_Org_ID());
                            }
                        } else if (line.getC_CashLine_ID() != 0) {
                            fl = fact.createLine((DocLine)line, this.getCashAcct(as, line.getC_CashLine_ID()), this.getC_Currency_ID(), line.getAmtSource(), null);
                            cashLine = new MCashLine(this.getCtx(), line.getC_CashLine_ID(), this.getTrxName());
                            if (fl != null && cashLine.get_ID() != 0) {
                                fl.setAD_Org_ID(cashLine.getAD_Org_ID());
                            }
                        }
                        if (Env.ZERO.compareTo(line.getDiscountAmt()) != 0 && (fl = fact.createLine((DocLine)line, this.getAccount(30, as), this.getC_Currency_ID(), line.getDiscountAmt(), null)) != null && payment != null) {
                            fl.setAD_Org_ID(payment.getAD_Org_ID());
                        }
                        if (Env.ZERO.compareTo(line.getWriteOffAmt()) != 0 && (fl = fact.createLine((DocLine)line, this.getAccount(32, as), this.getC_Currency_ID(), line.getWriteOffAmt(), null)) != null && payment != null) {
                            fl.setAD_Org_ID(payment.getAD_Org_ID());
                        }
                        if (as.isAccrual()) {
                            bpAcct = this.getAccount(1, as);
                            fl = fact.createLine((DocLine)line, bpAcct, this.getC_Currency_ID(), null, allocationSource);
                            if (fl != null) {
                                allocationAccounted = fl.getAcctBalance().negate();
                            }
                            if (fl != null && invoice != null) {
                                fl.setAD_Org_ID(invoice.getAD_Org_ID());
                            }
                            break block37;
                        } else {
                            allocationAccounted = this.createCashBasedAcct(as, fact, (MInvoice)invoice, allocationSource);
                        }
                        break block37;
                    }
                    allocationSource = allocationSource.negate();
                    if (as.isAccrual()) {
                        bpAcct = this.getAccount(2, as);
                        fl = fact.createLine((DocLine)line, bpAcct, this.getC_Currency_ID(), allocationSource, null);
                        if (fl != null) {
                            allocationAccounted = fl.getAcctBalance();
                        }
                        if (fl != null && invoice != null) {
                            fl.setAD_Org_ID(invoice.getAD_Org_ID());
                        }
                    } else {
                        allocationAccounted = this.createCashBasedAcct(as, fact, (MInvoice)invoice, allocationSource);
                    }
                    if (Env.ZERO.compareTo(line.getDiscountAmt()) != 0 && (fl = fact.createLine((DocLine)line, this.getAccount(31, as), this.getC_Currency_ID(), null, line.getDiscountAmt().negate())) != null && payment != null) {
                        fl.setAD_Org_ID(payment.getAD_Org_ID());
                    }
                    if (Env.ZERO.compareTo(line.getWriteOffAmt()) != 0 && (fl = fact.createLine((DocLine)line, this.getAccount(32, as), this.getC_Currency_ID(), null, line.getWriteOffAmt().negate())) != null && payment != null) {
                        fl.setAD_Org_ID(payment.getAD_Org_ID());
                    }
                    if (line.getC_Payment_ID() != 0) {
                        fl = fact.createLine((DocLine)line, this.getPaymentAcct(as, line.getC_Payment_ID()), this.getC_Currency_ID(), null, line.getAmtSource().negate());
                        if (fl != null && payment != null) {
                            fl.setAD_Org_ID(payment.getAD_Org_ID());
                        }
                    } else if (line.getC_CashLine_ID() != 0) {
                        fl = fact.createLine((DocLine)line, this.getCashAcct(as, line.getC_CashLine_ID()), this.getC_Currency_ID(), null, line.getAmtSource().negate());
                        cashLine = new MCashLine(this.getCtx(), line.getC_CashLine_ID(), this.getTrxName());
                        if (fl != null && cashLine.get_ID() != 0) {
                            fl.setAD_Org_ID(cashLine.getAD_Org_ID());
                        }
                    }
                }
                if (invoice != null && as.isTaxCorrection()) {
                    BigDecimal taxCorrectionAmt = Env.ZERO;
                    if (as.isTaxCorrectionDiscount()) {
                        taxCorrectionAmt = line.getDiscountAmt();
                    }
                    if (as.isTaxCorrectionWriteOff()) {
                        taxCorrectionAmt = taxCorrectionAmt.add(line.getWriteOffAmt());
                    }
                    if (taxCorrectionAmt.signum() != 0 && !this.createTaxCorrection(as, fact, line, this.getAccount(invoice.isSOTrx() ? 30 : 31, as), this.getAccount(32, as))) {
                        this.p_Error = "Cannot create Tax correction";
                        return null;
                    }
                }
                if (invoice != null && (this.getC_Currency_ID() != as.getC_Currency_ID() || this.getC_Currency_ID() != line.getInvoiceC_Currency_ID())) {
                    this.p_Error = this.createRealizedGainLoss(as, fact, bpAcct, (MInvoice)invoice, allocationSource, allocationAccounted);
                    if (this.p_Error != null) {
                        return null;
                    }
                }
            }
            ++i;
        }
    }

    private BigDecimal createCashBasedAcct(MAcctSchema as, Fact fact, MInvoice invoice, BigDecimal allocationSource) {
        BigDecimal allocationAccounted = Env.ZERO;
        double percent = invoice.getGrandTotal().doubleValue() / allocationSource.doubleValue();
        if (percent > 0.99 && percent < 1.01) {
            percent = 1.0;
        }
        this.log.config("Multiplier=" + percent + " - GrandTotal=" + invoice.getGrandTotal() + " - Allocation Source=" + allocationSource);
        Doc_Invoice docInvoice = (Doc_Invoice)Doc.get(new MAcctSchema[]{as}, 318, invoice.getC_Invoice_ID(), this.getTrxName());
        docInvoice.loadDocumentDetails();
        allocationAccounted = docInvoice.createFactCash(as, fact, new BigDecimal(percent));
        this.log.config("Allocation Accounted=" + allocationAccounted);
        if (as.isCreateCommitment() && !invoice.isSOTrx()) {
            MInvoiceLine[] lines = invoice.getLines();
            for (int i = 0; i < lines.length; ++i) {
                Fact factC = Doc_Order.getCommitmentRelease(as, this, lines[i].getQtyInvoiced(), lines[i].getC_InvoiceLine_ID(), new BigDecimal(percent));
                if (factC == null) {
                    return null;
                }
                this.m_facts.add(factC);
            }
        }
        return allocationAccounted;
    }

    private MAccount getPaymentAcct(MAcctSchema as, int C_Payment_ID) {
        this.setC_BankAccount_ID(0);
        int accountType = 10;
        String sql = "SELECT p.C_BankAccount_ID, d.DocBaseType, p.IsReceipt, p.IsPrepayment FROM C_Payment p INNER JOIN C_DocType d ON (p.C_DocType_ID=d.C_DocType_ID) WHERE C_Payment_ID=?";
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql, this.getTrxName());
            pstmt.setInt(1, C_Payment_ID);
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                this.setC_BankAccount_ID(rs.getInt(1));
                if ("APP".equals(rs.getString(2))) {
                    accountType = 12;
                }
                if ("Y".equals(rs.getString(4))) {
                    accountType = "Y".equals(rs.getString(3)) ? 13 : 14;
                }
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, sql, e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        if (this.getC_BankAccount_ID() <= 0) {
            this.log.log(Level.SEVERE, "NONE for C_Payment_ID=" + C_Payment_ID);
            return null;
        }
        return this.getAccount(accountType, as);
    }

    private MAccount getCashAcct(MAcctSchema as, int C_CashLine_ID) {
        String sql = "SELECT c.C_CashBook_ID FROM C_Cash c, C_CashLine cl WHERE c.C_Cash_ID=cl.C_Cash_ID AND cl.C_CashLine_ID=?";
        this.setC_CashBook_ID(DB.getSQLValue(null, sql, C_CashLine_ID));
        if (this.getC_CashBook_ID() <= 0) {
            this.log.log(Level.SEVERE, "NONE for C_CashLine_ID=" + C_CashLine_ID);
            return null;
        }
        return this.getAccount(21, as);
    }

    private String createRealizedGainLoss(MAcctSchema as, Fact fact, MAccount acct, MInvoice invoice, BigDecimal allocationSource, BigDecimal allocationAccounted) {
        String d2;
        BigDecimal invoiceSource = null;
        BigDecimal invoiceAccounted = null;
        String sql = "SELECT " + (invoice.isSOTrx() ? "SUM(AmtSourceDr), SUM(AmtAcctDr)" : "SUM(AmtSourceCr), SUM(AmtAcctCr)") + " FROM Fact_Acct " + "WHERE AD_Table_ID=318 AND Record_ID=?" + " AND C_AcctSchema_ID=?" + " AND PostingType='A'";
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql, this.getTrxName());
            pstmt.setInt(1, invoice.getC_Invoice_ID());
            pstmt.setInt(2, as.getC_AcctSchema_ID());
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                invoiceSource = rs.getBigDecimal(1);
                invoiceAccounted = rs.getBigDecimal(2);
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, sql, e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        if (invoiceSource == null || invoiceAccounted == null) {
            return "Gain/Loss - Invoice not posted yet";
        }
        String description = "Invoice=(" + invoice.getC_Currency_ID() + ")" + invoiceSource + "/" + invoiceAccounted + " - Allocation=(" + this.getC_Currency_ID() + ")" + allocationSource + "/" + allocationAccounted;
        this.log.fine(description);
        if (this.getC_Currency_ID() != invoice.getC_Currency_ID()) {
            BigDecimal allocationSourceNew = MConversionRate.convert(this.getCtx(), allocationSource, this.getC_Currency_ID(), invoice.getC_Currency_ID(), this.getDateAcct(), invoice.getC_ConversionType_ID(), invoice.getAD_Client_ID(), invoice.getAD_Org_ID());
            if (allocationSourceNew == null) {
                return "Gain/Loss - No Conversion from Allocation->Invoice";
            }
            d2 = "Allocation=(" + this.getC_Currency_ID() + ")" + allocationSource + "->(" + invoice.getC_Currency_ID() + ")" + allocationSourceNew;
            this.log.fine(d2);
            description = description + " - " + d2;
            allocationSource = allocationSourceNew;
        }
        BigDecimal acctDifference = null;
        if (allocationSource.compareTo(invoiceSource) == 0) {
            acctDifference = invoiceAccounted.subtract(allocationAccounted);
            d2 = "(full) = " + acctDifference;
            this.log.fine(d2);
            description = description + " - " + d2;
        } else {
            double multiplier = allocationSource.doubleValue() / invoiceSource.doubleValue();
            acctDifference = (invoiceAccounted = invoiceAccounted.multiply(new BigDecimal(multiplier))).subtract(allocationAccounted);
            if (acctDifference.abs().compareTo(TOLERANCE) < 0) {
                acctDifference = Env.ZERO;
            }
            int precision = as.getStdPrecision();
            if (acctDifference.scale() > precision) {
                acctDifference = acctDifference.setScale(precision, 4);
            }
            String d22 = "(partial) = " + acctDifference + " - Multiplier=" + multiplier;
            this.log.fine(d22);
            description = description + " - " + d22;
        }
        if (acctDifference.signum() == 0) {
            this.log.fine("No Difference");
            return null;
        }
        MAccount gain = MAccount.get(as.getCtx(), as.getAcctSchemaDefault().getRealizedGain_Acct());
        MAccount loss = MAccount.get(as.getCtx(), as.getAcctSchemaDefault().getRealizedLoss_Acct());
        if (invoice.isSOTrx()) {
            FactLine fl = fact.createLine(null, loss, gain, as.getC_Currency_ID(), acctDifference);
            fl.setDescription(description);
            fact.createLine(null, acct, as.getC_Currency_ID(), acctDifference.negate());
            fl.setDescription(description);
        } else {
            fact.createLine(null, acct, as.getC_Currency_ID(), acctDifference);
            fact.createLine(null, loss, gain, as.getC_Currency_ID(), acctDifference.negate());
        }
        return null;
    }

    private boolean createTaxCorrection(MAcctSchema as, Fact fact, DocLine_Allocation line, MAccount DiscountAccount, MAccount WriteOffAccoint) {
        this.log.info(line.toString());
        BigDecimal discount = Env.ZERO;
        if (as.isTaxCorrectionDiscount()) {
            discount = line.getDiscountAmt();
        }
        BigDecimal writeOff = Env.ZERO;
        if (as.isTaxCorrectionWriteOff()) {
            writeOff = line.getWriteOffAmt();
        }
        Doc_AllocationTax tax = new Doc_AllocationTax(DiscountAccount, discount, WriteOffAccoint, writeOff);
        String sql = "SELECT * FROM Fact_Acct WHERE AD_Table_ID=318 AND Record_ID=? AND C_AcctSchema_ID=? AND Line_ID IS NULL";
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql, this.getTrxName());
            pstmt.setInt(1, line.getC_Invoice_ID());
            pstmt.setInt(2, as.getC_AcctSchema_ID());
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                tax.addInvoiceFact(new MFactAcct(this.getCtx(), rs, fact.get_TrxName()));
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, sql, e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        if (tax.getLineCount() == 0) {
            this.log.warning("Invoice not posted yet - " + line);
            return false;
        }
        if (tax.getLineCount() < 2) {
            return true;
        }
        return tax.createEntries(as, fact, line);
    }
}

