/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.acct;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.logging.Level;
import org.compiere.acct.Doc;
import org.compiere.acct.Fact;
import org.compiere.acct.FactLine;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MConversionRate;
import org.compiere.model.MCostDetail;
import org.compiere.model.MMatchPO;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MProduct;
import org.compiere.model.MProductCategoryAcct;
import org.compiere.model.ProductCost;
import org.compiere.util.Env;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Doc_MatchPO
extends Doc {
    private int m_C_OrderLine_ID = 0;
    private MOrderLine m_oLine = null;
    private int m_M_InOutLine_ID = 0;
    private ProductCost m_pc;
    private int m_M_AttributeSetInstance_ID = 0;

    public Doc_MatchPO(MAcctSchema[] ass, ResultSet rs, String trxName) {
        super(ass, MMatchPO.class, rs, "MXP", trxName);
    }

    @Override
    public String loadDocumentDetails() {
        this.setC_Currency_ID(-2);
        MMatchPO matchPO = (MMatchPO)this.getPO();
        this.setDateDoc(matchPO.getDateTrx());
        this.m_M_AttributeSetInstance_ID = matchPO.getM_AttributeSetInstance_ID();
        this.setQty(matchPO.getQty());
        this.m_C_OrderLine_ID = matchPO.getC_OrderLine_ID();
        this.m_oLine = new MOrderLine(this.getCtx(), this.m_C_OrderLine_ID, this.getTrxName());
        this.m_M_InOutLine_ID = matchPO.getM_InOutLine_ID();
        this.m_pc = new ProductCost(Env.getCtx(), this.getM_Product_ID(), this.m_M_AttributeSetInstance_ID, this.getTrxName());
        this.m_pc.setQty(this.getQty());
        return null;
    }

    @Override
    public BigDecimal getBalance() {
        return Env.ZERO;
    }

    @Override
    public ArrayList<Fact> createFacts(MAcctSchema as) {
        FactLine dr;
        BigDecimal costs;
        MOrder order;
        ArrayList<Fact> facts = new ArrayList<Fact>();
        if (this.getM_Product_ID() == 0 || this.getQty().signum() == 0 || this.m_M_InOutLine_ID == 0) {
            this.log.fine("No Product/Qty - M_Product_ID=" + this.getM_Product_ID() + ",Qty=" + this.getQty());
            return facts;
        }
        Fact fact = new Fact(this, as, "A");
        this.setC_Currency_ID(as.getC_Currency_ID());
        BigDecimal poCost = this.m_oLine.getPriceCost();
        if (poCost == null || poCost.signum() == 0) {
            poCost = this.m_oLine.getPriceActual();
        }
        poCost = poCost.multiply(this.getQty());
        if (this.m_oLine.getC_Currency_ID() != as.getC_Currency_ID()) {
            order = this.m_oLine.getParent();
            BigDecimal rate = MConversionRate.getRate(order.getC_Currency_ID(), as.getC_Currency_ID(), order.getDateAcct(), order.getC_ConversionType_ID(), this.m_oLine.getAD_Client_ID(), this.m_oLine.getAD_Org_ID());
            if (rate == null) {
                this.p_Error = "Purchase Order not convertible - " + as.getName();
                return null;
            }
            if ((poCost = poCost.multiply(rate)).scale() > as.getCostingPrecision()) {
                poCost = poCost.setScale(as.getCostingPrecision(), 4);
            }
        }
        order = this.m_oLine.getParent();
        boolean isReturnTrx = order.isReturnTrx();
        this.log.fine("Temp");
        MCostDetail.createOrder(as, this.m_oLine.getAD_Org_ID(), this.getM_Product_ID(), this.m_M_AttributeSetInstance_ID, this.m_C_OrderLine_ID, 0, isReturnTrx ? poCost.negate() : poCost, isReturnTrx ? this.getQty().negate() : this.getQty(), this.m_oLine.getDescription(), this.getTrxName());
        String costingMethod = as.getCostingMethod();
        MProduct product = MProduct.get(this.getCtx(), this.getM_Product_ID());
        MProductCategoryAcct pca = MProductCategoryAcct.get(this.getCtx(), product.getM_Product_Category_ID(), as.getC_AcctSchema_ID(), this.getTrxName());
        if (pca.getCostingMethod() != null) {
            costingMethod = pca.getCostingMethod();
        }
        if ((costs = this.m_pc.getProductCosts(as, this.getAD_Org_ID(), costingMethod, this.m_C_OrderLine_ID, false)) == null || costs.signum() == 0) {
            this.p_Error = "Resubmit - No Costs for " + product.getName();
            this.log.log(Level.SEVERE, this.p_Error);
            return null;
        }
        BigDecimal difference = poCost.subtract(costs);
        if (difference.signum() == 0) {
            this.log.log(Level.FINE, "No Cost Difference for M_Product_ID=" + this.getM_Product_ID());
            facts.add(fact);
            return facts;
        }
        FactLine cr = fact.createLine(null, this.m_pc.getAccount(5, as), as.getC_Currency_ID(), difference);
        if (cr != null) {
            cr.setQty(this.getQty());
            cr.setC_BPartner_ID(this.m_oLine.getC_BPartner_ID());
            cr.setC_Activity_ID(this.m_oLine.getC_Activity_ID());
            cr.setC_Campaign_ID(this.m_oLine.getC_Campaign_ID());
            cr.setC_Project_ID(this.m_oLine.getC_Project_ID());
            cr.setC_UOM_ID(this.m_oLine.getC_UOM_ID());
            cr.setUser1_ID(this.m_oLine.getUser1_ID());
            cr.setUser2_ID(this.m_oLine.getUser2_ID());
        }
        if ((dr = fact.createLine(null, this.getAccount(101, as), as.getC_Currency_ID(), difference.negate())) != null) {
            dr.setQty(this.getQty().negate());
            dr.setC_BPartner_ID(this.m_oLine.getC_BPartner_ID());
            dr.setC_Activity_ID(this.m_oLine.getC_Activity_ID());
            dr.setC_Campaign_ID(this.m_oLine.getC_Campaign_ID());
            dr.setC_Project_ID(this.m_oLine.getC_Project_ID());
            dr.setC_UOM_ID(this.m_oLine.getC_UOM_ID());
            dr.setUser1_ID(this.m_oLine.getUser1_ID());
            dr.setUser2_ID(this.m_oLine.getUser2_ID());
        }
        facts.add(fact);
        return facts;
    }
}

