/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.DocWriter;
import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.pdf.PdfArray;
import com.lowagie.text.pdf.PdfNumber;
import com.lowagie.text.pdf.PdfWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class PdfDashPattern
extends PdfArray {
    private float dash = -1.0f;
    private float gap = -1.0f;
    private float phase;

    public PdfDashPattern() {
    }

    public PdfDashPattern(float f) {
        super(new PdfNumber(f));
        this.dash = f;
    }

    public PdfDashPattern(float f, float f2) {
        super(new PdfNumber(f));
        this.add(new PdfNumber(f2));
        this.dash = f;
        this.gap = f2;
    }

    public PdfDashPattern(float f, float f2, float f3) {
        super(new PdfNumber(f));
        this.add(new PdfNumber(f2));
        this.dash = f;
        this.gap = f2;
        this.phase = f3;
    }

    public void add(float f) {
        this.add(new PdfNumber(f));
    }

    public byte[] toPdf(PdfWriter pdfWriter) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byteArrayOutputStream.write(DocWriter.getISOBytes("["));
            if (this.dash >= 0.0f) {
                byteArrayOutputStream.write(new PdfNumber(this.dash).toPdf(null));
                if (this.gap >= 0.0f) {
                    byteArrayOutputStream.write(DocWriter.getISOBytes(" "));
                    byteArrayOutputStream.write(new PdfNumber(this.gap).toPdf(null));
                }
            }
            byteArrayOutputStream.write(DocWriter.getISOBytes("]"));
            if (this.phase >= 0.0f) {
                byteArrayOutputStream.write(DocWriter.getISOBytes(" "));
                byteArrayOutputStream.write(new PdfNumber(this.phase).toPdf(null));
            }
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            throw new ExceptionConverter(iOException);
        }
    }
}

