/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.rowset;

import java.io.IOException;
import java.io.Writer;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Iterator;
import java.util.Map;
import java.util.Stack;
import javax.sql.RowSet;
import oracle.jdbc.rowset.OracleWebRowSet;
import oracle.jdbc.rowset.OracleWebRowSetXmlWriter;

class OracleWebRowSetXmlWriterImpl
implements OracleWebRowSetXmlWriter {
    private Writer m_writer;
    private Stack m_stack;

    private void beginSection(String string) throws IOException {
        this.beginTag(string);
        this.m_writer.write("\n");
    }

    private void beginTag(String string) throws IOException {
        this.setCurrentTag(string);
        this.writeIndent(this.m_stack.size());
        this.m_writer.write("<" + string + ">");
    }

    private void emptyTag(String string) throws IOException {
        this.m_writer.write("<" + string + "/>");
    }

    private void endSection() throws IOException {
        this.writeIndent(this.m_stack.size());
        String string = this.getCurrentTag();
        this.m_writer.write("</" + string + ">\n");
        this.m_writer.flush();
    }

    private void endSection(String string) throws IOException {
        this.writeIndent(this.m_stack.size());
        this.endTag(string);
    }

    private void endTag(String string) throws IOException {
        String string2 = this.getCurrentTag();
        if (string.equals(string2)) {
            this.m_writer.write("</" + string2 + ">\n");
        }
        this.m_writer.flush();
    }

    private String getCurrentTag() {
        return (String)this.m_stack.pop();
    }

    private void propBoolean(String string, boolean bl) throws IOException {
        this.beginTag(string);
        this.writeBoolean(bl);
        this.endTag(string);
    }

    private void propInteger(String string, int n2) throws IOException {
        this.beginTag(string);
        this.writeInteger(n2);
        this.endTag(string);
    }

    private void propString(String string, String string2) throws IOException {
        this.beginTag(string);
        this.writeString(string2);
        this.endTag(string);
    }

    private void setCurrentTag(String string) {
        this.m_stack.push(string);
    }

    private void writeBigDecimal(BigDecimal bigDecimal) throws IOException {
        if (bigDecimal != null) {
            this.m_writer.write(bigDecimal.toString());
        } else {
            this.emptyTag("null");
        }
    }

    private void writeBoolean(boolean bl) throws IOException {
        this.m_writer.write(new Boolean(bl).toString());
    }

    private void writeBytes(byte[] byArray) throws IOException {
        this.m_writer.write(new String(byArray));
    }

    private void writeData(OracleWebRowSet oracleWebRowSet) throws IOException {
        try {
            ResultSetMetaData resultSetMetaData = oracleWebRowSet.getMetaData();
            int n2 = resultSetMetaData.getColumnCount();
            this.beginSection("data");
            oracleWebRowSet.beforeFirst();
            oracleWebRowSet.setShowDeleted(true);
            while (oracleWebRowSet.next()) {
                if (oracleWebRowSet.rowDeleted() && oracleWebRowSet.rowInserted()) {
                    this.beginSection("insdel");
                } else if (oracleWebRowSet.rowDeleted()) {
                    this.beginSection("del");
                } else if (oracleWebRowSet.rowInserted()) {
                    this.beginSection("ins");
                } else {
                    this.beginSection("row");
                }
                int n3 = 1;
                while (n3 <= n2) {
                    boolean bl = oracleWebRowSet.getCurrentRow().isColumnChanged(n3);
                    if (bl) {
                        ResultSet resultSet = oracleWebRowSet.getOriginalRow();
                        resultSet.next();
                        this.beginTag("col");
                        this.writeValue(n3, (RowSet)resultSet);
                        this.endTag("col");
                        this.beginTag("upd");
                        this.writeValue(n3, oracleWebRowSet);
                        this.endTag("upd");
                    } else {
                        this.beginTag("col");
                        this.writeValue(n3, oracleWebRowSet);
                        this.endTag("col");
                    }
                    ++n3;
                }
                this.endSection();
            }
            this.endSection("data");
        }
        catch (SQLException sQLException) {
            throw new IOException("SQLException: " + sQLException.getMessage());
        }
    }

    private void writeDouble(double d2) throws IOException {
        this.m_writer.write(Double.toString(d2));
    }

    private void writeFloat(float f2) throws IOException {
        this.m_writer.write(Float.toString(f2));
    }

    private void writeHeader() throws IOException {
        this.m_writer.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        this.m_writer.write("<!DOCTYPE RowSet PUBLIC '" + OracleWebRowSet.PUBLIC_DTD_ID + "' '" + OracleWebRowSet.SYSTEM_ID + "'>");
        this.m_writer.write("\n\n");
    }

    private void writeIndent(int n2) throws IOException {
        int n3 = 1;
        while (n3 < n2) {
            this.m_writer.write("  ");
            ++n3;
        }
    }

    private void writeInteger(int n2) throws IOException {
        this.m_writer.write(Integer.toString(n2));
    }

    private void writeLong(long l2) throws IOException {
        this.m_writer.write(Long.toString(l2));
    }

    private void writeMetaData(OracleWebRowSet oracleWebRowSet) throws IOException {
        this.beginSection("metadata");
        try {
            ResultSetMetaData resultSetMetaData = oracleWebRowSet.getMetaData();
            int n2 = resultSetMetaData.getColumnCount();
            this.propInteger("column-count", n2);
            int n3 = 1;
            while (n3 <= n2) {
                this.beginSection("column-definition");
                this.propInteger("column-index", n3);
                this.propBoolean("auto-increment", resultSetMetaData.isAutoIncrement(n3));
                this.propBoolean("case-sensitive", resultSetMetaData.isCaseSensitive(n3));
                this.propBoolean("currency", resultSetMetaData.isCurrency(n3));
                this.propInteger("nullable", resultSetMetaData.isNullable(n3));
                this.propBoolean("signed", resultSetMetaData.isSigned(n3));
                this.propBoolean("searchable", resultSetMetaData.isSearchable(n3));
                this.propInteger("column-display-size", resultSetMetaData.getColumnDisplaySize(n3));
                this.propString("column-label", resultSetMetaData.getColumnLabel(n3));
                this.propString("column-name", resultSetMetaData.getColumnName(n3));
                this.propString("schema-name", resultSetMetaData.getSchemaName(n3));
                this.propInteger("column-precision", resultSetMetaData.getPrecision(n3));
                this.propInteger("column-scale", resultSetMetaData.getScale(n3));
                this.propString("table-name", resultSetMetaData.getTableName(n3));
                this.propString("catalog-name", resultSetMetaData.getCatalogName(n3));
                this.propInteger("column-type", resultSetMetaData.getColumnType(n3));
                this.propString("column-type-name", resultSetMetaData.getColumnTypeName(n3));
                this.endSection("column-definition");
                ++n3;
            }
        }
        catch (SQLException sQLException) {
            throw new IOException("SQLException: " + sQLException.getMessage());
        }
        this.endSection("metadata");
    }

    private void writeNull() throws IOException {
        this.emptyTag("null");
    }

    private void writeProperties(OracleWebRowSet oracleWebRowSet) throws IOException {
        this.beginSection("properties");
        try {
            this.propString("command", oracleWebRowSet.getCommand());
            this.propInteger("concurrency", oracleWebRowSet.getConcurrency());
            this.propString("datasource", oracleWebRowSet.getDataSourceName());
            this.propBoolean("escape-processing", oracleWebRowSet.getEscapeProcessing());
            this.propInteger("fetch-direction", oracleWebRowSet.getFetchDirection());
            this.propInteger("fetch-size", oracleWebRowSet.getFetchSize());
            this.propInteger("isolation-level", oracleWebRowSet.getTransactionIsolation());
            this.beginSection("key-columns");
            this.endSection("key-columns");
            this.beginTag("map");
            Map map = oracleWebRowSet.getTypeMap();
            if (map != null) {
                Iterator iterator = map.keySet().iterator();
                while (iterator.hasNext()) {
                    String string = (String)iterator.next();
                    Class clazz = (Class)map.get(string);
                    this.propString("type", string);
                    this.propString("class", clazz.getName());
                }
            }
            this.endTag("map");
            this.propInteger("max-field-size", oracleWebRowSet.getMaxFieldSize());
            this.propInteger("max-rows", oracleWebRowSet.getMaxRows());
            this.propInteger("query-timeout", oracleWebRowSet.getQueryTimeout());
            this.propBoolean("read-only", oracleWebRowSet.isReadOnly());
            this.propInteger("rowset-type", oracleWebRowSet.getType());
            this.propBoolean("show-deleted", oracleWebRowSet.getShowDeleted());
            this.propString("url", oracleWebRowSet.getUrl());
        }
        catch (SQLException sQLException) {
            throw new IOException("SQLException: " + sQLException.getMessage());
        }
        this.endSection("properties");
    }

    private void writeRowSet(OracleWebRowSet oracleWebRowSet) throws SQLException {
        try {
            this.writeHeader();
            this.beginSection("RowSet");
            this.writeProperties(oracleWebRowSet);
            this.writeMetaData(oracleWebRowSet);
            this.writeData(oracleWebRowSet);
            this.endSection("RowSet");
        }
        catch (IOException iOException) {
            throw new SQLException("IOException: " + iOException.getMessage());
        }
    }

    private void writeShort(short s2) throws IOException {
        this.m_writer.write(Short.toString(s2));
    }

    private void writeString(String string) throws IOException {
        if (string != null) {
            this.m_writer.write(string);
        } else {
            this.writeNull();
        }
    }

    private void writeValue(int n2, RowSet rowSet) throws IOException {
        try {
            int n3 = rowSet.getMetaData().getColumnType(n2);
            switch (n3) {
                case -7: 
                case 5: {
                    short s2 = rowSet.getShort(n2);
                    if (rowSet.wasNull()) {
                        this.writeNull();
                    } else {
                        this.writeShort(s2);
                    }
                    break;
                }
                case 4: {
                    int n4 = rowSet.getInt(n2);
                    if (rowSet.wasNull()) {
                        this.writeNull();
                    } else {
                        this.writeInteger(rowSet.getInt(n2));
                    }
                    break;
                }
                case -5: {
                    long l2 = rowSet.getLong(n2);
                    if (rowSet.wasNull()) {
                        this.writeNull();
                    } else {
                        this.writeLong(l2);
                    }
                    break;
                }
                case 6: 
                case 7: {
                    float f2 = rowSet.getFloat(n2);
                    if (rowSet.wasNull()) {
                        this.writeNull();
                    } else {
                        this.writeFloat(f2);
                    }
                    break;
                }
                case 8: {
                    double d2 = rowSet.getDouble(n2);
                    if (rowSet.wasNull()) {
                        this.writeNull();
                    } else {
                        this.writeDouble(d2);
                    }
                    break;
                }
                case 2: 
                case 3: {
                    this.writeBigDecimal(rowSet.getBigDecimal(n2));
                    break;
                }
                case 91: {
                    Date date = rowSet.getDate(n2);
                    if (rowSet.wasNull()) {
                        this.writeNull();
                    } else {
                        this.writeLong(date.getTime());
                    }
                    break;
                }
                case 92: {
                    Time time = rowSet.getTime(n2);
                    if (rowSet.wasNull()) {
                        this.writeNull();
                    } else {
                        this.writeLong(time.getTime());
                    }
                    break;
                }
                case 93: {
                    Timestamp timestamp = rowSet.getTimestamp(n2);
                    if (rowSet.wasNull()) {
                        this.writeNull();
                    } else {
                        this.writeLong(((java.util.Date)timestamp).getTime());
                    }
                    break;
                }
                case -4: 
                case -3: 
                case -2: {
                    this.writeBytes(rowSet.getBytes(n2));
                    break;
                }
                case -1: 
                case 1: 
                case 12: {
                    this.writeString(rowSet.getString(n2));
                    break;
                }
                default: {
                    throw new SQLException("The type " + n3 + " is not supported currently.");
                }
            }
        }
        catch (SQLException sQLException) {
            throw new IOException("Failed to writeValue: " + sQLException.getMessage());
        }
    }

    public void writeXML(OracleWebRowSet oracleWebRowSet, Writer writer) throws SQLException {
        this.m_stack = new Stack();
        this.m_writer = writer;
        this.writeRowSet(oracleWebRowSet);
    }
}

