/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.portlet;

import java.io.PrintStream;
import java.io.PrintWriter;
import org.apache.jetspeed.portlet.Portlet;
import org.apache.jetspeed.portlet.PortletException;

public class UnavailableException
extends PortletException {
    private Portlet portlet;
    private boolean permanent;
    private int seconds;

    public UnavailableException(Portlet portlet, String msg) {
        super(msg);
        this.portlet = portlet;
        this.permanent = true;
    }

    public UnavailableException(int seconds, Portlet portlet, String msg) {
        super(msg);
        this.portlet = portlet;
        this.seconds = seconds <= 0 ? -1 : seconds;
        this.permanent = false;
    }

    public UnavailableException(String msg) {
        super(msg);
        this.permanent = true;
    }

    public UnavailableException(String msg, int seconds) {
        super(msg);
        this.seconds = seconds <= 0 ? -1 : seconds;
        this.permanent = false;
    }

    public boolean isPermanent() {
        return this.permanent;
    }

    public Portlet getPortlet() {
        return this.portlet;
    }

    public int getUnavailableSeconds() {
        return this.permanent ? -1 : this.seconds;
    }

    public void printStackTrace() {
        this.printStackTrace(System.err);
    }

    public void printStackTrace(PrintStream out) {
        this.printStackTrace(new PrintWriter(out, true));
    }

    public void printStackTrace(PrintWriter out) {
        super.printStackTrace(out);
        if (this.getRootCause() != null) {
            out.println();
            out.print("Nested Exception is ");
            this.getRootCause().printStackTrace(out);
        }
    }
}

