/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jcs.utils.data;

import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;

public class PropertyGroups
extends Hashtable {
    private Properties props = new Properties();
    private String fileName = null;
    int simpleKeys = 0;
    int compoundKeys = 0;

    public PropertyGroups() {
    }

    public PropertyGroups(String name) throws Exception {
        this();
        this.load(name);
    }

    public void load(String name) throws Exception {
        this.fileName = name;
        this.load();
    }

    public void load() throws Exception {
        InputStream is = this.getClass().getResourceAsStream(this.fileName);
        if (null == is) {
            throw new Exception("PropertyGroups.load: can't get resource " + this.fileName);
        }
        this.props.load(is);
        is.close();
        Enumeration<Object> keys = this.props.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            int sloc = key.indexOf(95);
            if (0 > sloc) {
                ++this.simpleKeys;
                this.put(key, this.props.get(key));
                continue;
            }
            String key1 = key.substring(0, sloc);
            String key2 = key.substring(1 + sloc);
            Properties subprops = (Properties)this.get(key1);
            if (null == subprops) {
                ++this.compoundKeys;
                subprops = new Properties();
                this.put(key1, subprops);
            }
            subprops.put(key2, this.props.get(key));
        }
    }

    public String getProperty(String key) {
        Object ob = this.get(key);
        if (ob instanceof String) {
            return (String)ob;
        }
        return null;
    }

    public String getProperty(String key, String dflt) {
        if (null == key) {
            return dflt;
        }
        String p = this.getProperty(key);
        return p == null ? dflt : p;
    }

    public Properties getProperties(String key) {
        if (null == key) {
            return null;
        }
        Object ob = this.get(key);
        if (ob instanceof Properties) {
            return (Properties)ob;
        }
        return null;
    }

    public Enumeration propertyKeys() {
        return new PropertyKeysEnum();
    }

    public Enumeration simpleKeys() {
        return new SimpleKeysEnum();
    }

    private void keyVal(StringBuffer sB, Object key) {
        String k = (String)key;
        sB.append(k);
        sB.append("=");
        sB.append(this.get(key).toString());
    }

    public synchronized String toString() {
        StringBuffer sB = new StringBuffer();
        Enumeration pk = this.propertyKeys();
        if (pk.hasMoreElements()) {
            this.keyVal(sB, pk.nextElement());
        }
        while (pk.hasMoreElements()) {
            sB.append(", ");
            this.keyVal(sB, pk.nextElement());
        }
        Enumeration sk = this.simpleKeys();
        if (sk.hasMoreElements()) {
            this.keyVal(sB, sk.nextElement());
        }
        while (sk.hasMoreElements()) {
            sB.append(", ");
            this.keyVal(sB, sk.nextElement());
        }
        return sB.toString();
    }

    class SimpleKeysEnum
    implements Enumeration {
        int howMany;
        Enumeration baseEnum;

        public SimpleKeysEnum() {
            this.howMany = PropertyGroups.this.simpleKeys;
            this.baseEnum = PropertyGroups.this.keys();
        }

        public boolean hasMoreElements() {
            return this.howMany > 0;
        }

        public Object nextElement() {
            while (this.baseEnum.hasMoreElements()) {
                Object k = this.baseEnum.nextElement();
                Object v = PropertyGroups.this.get(k);
                if (!(v instanceof String)) continue;
                --this.howMany;
                return k;
            }
            this.howMany = 0;
            return null;
        }
    }

    class PropertyKeysEnum
    implements Enumeration {
        int howMany;
        Enumeration baseEnum;

        public PropertyKeysEnum() {
            this.howMany = PropertyGroups.this.compoundKeys;
            this.baseEnum = PropertyGroups.this.keys();
        }

        public boolean hasMoreElements() {
            return this.howMany > 0;
        }

        public Object nextElement() {
            while (this.baseEnum.hasMoreElements()) {
                Object k = this.baseEnum.nextElement();
                Object v = PropertyGroups.this.get(k);
                if (!(v instanceof Properties)) continue;
                --this.howMany;
                return k;
            }
            this.howMany = 0;
            return null;
        }
    }
}

