/*
 * Decompiled with CFR 0.152.
 */
package bsh;

import bsh.BshIterator;
import bsh.Capabilities;
import bsh.Interpreter;
import java.lang.reflect.Array;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class CollectionManager {
    private static CollectionManager manager;

    public static synchronized CollectionManager getCollectionManager() {
        if (manager == null && Capabilities.classExists("java.util.Collection")) {
            try {
                Class<?> clazz = Class.forName("bsh.collection.CollectionManagerImpl");
                manager = (CollectionManager)clazz.newInstance();
            }
            catch (Exception exception) {
                Interpreter.debug("unable to load CollectionManagerImpl: " + exception);
            }
        }
        if (manager == null) {
            manager = new CollectionManager();
        }
        return manager;
    }

    public boolean isBshIterable(Object object2) {
        try {
            this.getBshIterator(object2);
            return true;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
    }

    public BshIterator getBshIterator(Object object2) throws IllegalArgumentException {
        return new BasicBshIterator(object2);
    }

    public boolean isMap(Object object2) {
        return object2 instanceof Hashtable;
    }

    public Object getFromMap(Object object2, Object object3) {
        return ((Hashtable)object2).get(object3);
    }

    public Object putInMap(Object object2, Object object3, Object object4) {
        return ((Hashtable)object2).put(object3, object4);
    }

    public static class BasicBshIterator
    implements BshIterator {
        Enumeration enumeration;

        public BasicBshIterator(Object object2) {
            this.enumeration = this.createEnumeration(object2);
        }

        protected Enumeration createEnumeration(Object object2) {
            if (object2 == null) {
                throw new NullPointerException("Object arguments passed to the BasicBshIterator constructor cannot be null.");
            }
            if (object2 instanceof Enumeration) {
                return (Enumeration)object2;
            }
            if (object2 instanceof Vector) {
                return ((Vector)object2).elements();
            }
            if (object2.getClass().isArray()) {
                Object object3 = object2;
                return new Enumeration(this, object3){
                    int index;
                    int length;
                    private final /* synthetic */ Object val$array;
                    private final /* synthetic */ BasicBshIterator this$0;
                    {
                        this.this$0 = basicBshIterator;
                        this.val$array = object2;
                        this.index = 0;
                        this.length = Array.getLength(this.val$array);
                    }

                    public Object nextElement() {
                        return Array.get(this.val$array, this.index++);
                    }

                    public boolean hasMoreElements() {
                        return this.index < this.length;
                    }
                };
            }
            if (object2 instanceof String) {
                return this.createEnumeration(((String)object2).toCharArray());
            }
            if (object2 instanceof StringBuffer) {
                return this.createEnumeration(object2.toString().toCharArray());
            }
            throw new IllegalArgumentException("Cannot enumerate object of type " + object2.getClass());
        }

        public Object next() {
            return this.enumeration.nextElement();
        }

        public boolean hasNext() {
            return this.enumeration.hasMoreElements();
        }
    }
}

