/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record;

import java.util.Iterator;
import java.util.Stack;
import org.apache.poi.hssf.record.CustomField;
import org.apache.poi.hssf.record.formula.Ptg;
import org.apache.poi.util.LittleEndian;

public class LinkedDataFormulaField
implements CustomField {
    Stack formulaTokens = new Stack();

    public int getSize() {
        int size = 0;
        Iterator iterator = this.formulaTokens.iterator();
        while (iterator.hasNext()) {
            Ptg token = (Ptg)iterator.next();
            size += token.getSize();
        }
        return size + 2;
    }

    public int fillField(byte[] data, short size, int offset) {
        short tokenSize = LittleEndian.getShort(data, offset);
        this.formulaTokens = this.getParsedExpressionTokens(data, size, offset + 2);
        return tokenSize + 2;
    }

    public void toString(StringBuffer buffer) {
        for (int k = 0; k < this.formulaTokens.size(); ++k) {
            buffer.append("Formula ").append(k).append("=").append(this.formulaTokens.get(k).toString()).append("\n").append(((Ptg)this.formulaTokens.get(k)).toDebugString()).append("\n");
        }
    }

    public String toString() {
        StringBuffer b2 = new StringBuffer();
        this.toString(b2);
        return b2.toString();
    }

    public int serializeField(int offset, byte[] data) {
        int size = this.getSize();
        LittleEndian.putShort(data, offset, (short)(size - 2));
        int pos = offset + 2;
        Iterator iterator = this.formulaTokens.iterator();
        while (iterator.hasNext()) {
            Ptg ptg = (Ptg)iterator.next();
            ptg.writeBytes(data, pos);
            pos += ptg.getSize();
        }
        return size;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e2) {
            return null;
        }
    }

    private Stack getParsedExpressionTokens(byte[] data, short size, int offset) {
        Ptg ptg;
        Stack<Ptg> stack = new Stack<Ptg>();
        for (int pos = offset; pos < size; pos += ptg.getSize()) {
            ptg = Ptg.createPtg(data, pos);
            stack.push(ptg);
        }
        return stack;
    }

    public void setFormulaTokens(Stack formulaTokens) {
        this.formulaTokens = (Stack)formulaTokens.clone();
    }

    public Stack getFormulaTokens() {
        return (Stack)this.formulaTokens.clone();
    }
}

