/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.rowset;

import java.io.IOException;
import java.io.Writer;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Iterator;
import java.util.Map;
import java.util.Stack;
import javax.sql.RowSet;
import oracle.jdbc.rowset.OracleWebRowSet;
import oracle.jdbc.rowset.OracleWebRowSetXmlWriter;

class OracleWebRowSetXmlWriterImpl
implements OracleWebRowSetXmlWriter {
    private Writer m_writer;
    private Stack m_stack;

    private void beginSection(String string) throws IOException {
        this.beginTag(string);
        this.m_writer.write("\n");
    }

    private void beginTag(String string) throws IOException {
        this.setCurrentTag(string);
        this.writeIndent(this.m_stack.size());
        this.m_writer.write("<" + string + ">");
    }

    private void emptyTag(String string) throws IOException {
        this.m_writer.write("<" + string + "/>");
    }

    private void endSection() throws IOException {
        this.writeIndent(this.m_stack.size());
        String string = this.getCurrentTag();
        this.m_writer.write("</" + string + ">\n");
        this.m_writer.flush();
    }

    private void endSection(String string) throws IOException {
        this.writeIndent(this.m_stack.size());
        this.endTag(string);
    }

    private void endTag(String string) throws IOException {
        String string2 = this.getCurrentTag();
        if (string.equals(string2)) {
            this.m_writer.write("</" + string2 + ">\n");
        }
        this.m_writer.flush();
    }

    private String getCurrentTag() {
        return (String)this.m_stack.pop();
    }

    private void propBoolean(String string, boolean bl) throws IOException {
        this.beginTag(string);
        this.writeBoolean(bl);
        this.endTag(string);
    }

    private void propInteger(String string, int n) throws IOException {
        this.beginTag(string);
        this.writeInteger(n);
        this.endTag(string);
    }

    private void propString(String string, String string2) throws IOException {
        this.beginTag(string);
        this.writeString(string2);
        this.endTag(string);
    }

    private void setCurrentTag(String string) {
        this.m_stack.push(string);
    }

    private void writeBigDecimal(BigDecimal bigDecimal) throws IOException {
        if (bigDecimal != null) {
            this.m_writer.write(bigDecimal.toString());
        } else {
            this.emptyTag("null");
        }
    }

    private void writeBoolean(boolean bl) throws IOException {
        this.m_writer.write(new Boolean(bl).toString());
    }

    private void writeBytes(byte[] byArray) throws IOException {
        this.m_writer.write(new String(byArray));
    }

    private void writeData(OracleWebRowSet oracleWebRowSet) throws IOException {
        try {
            ResultSetMetaData resultSetMetaData = oracleWebRowSet.getMetaData();
            int n = resultSetMetaData.getColumnCount();
            this.beginSection("data");
            oracleWebRowSet.beforeFirst();
            oracleWebRowSet.setShowDeleted(true);
            while (oracleWebRowSet.next()) {
                if (oracleWebRowSet.rowDeleted() && oracleWebRowSet.rowInserted()) {
                    this.beginSection("insdel");
                } else if (oracleWebRowSet.rowDeleted()) {
                    this.beginSection("del");
                } else if (oracleWebRowSet.rowInserted()) {
                    this.beginSection("ins");
                } else {
                    this.beginSection("row");
                }
                int n2 = 1;
                while (n2 <= n) {
                    boolean bl = oracleWebRowSet.getCurrentRow().isColumnChanged(n2);
                    if (bl) {
                        ResultSet resultSet = oracleWebRowSet.getOriginalRow();
                        resultSet.next();
                        this.beginTag("col");
                        this.writeValue(n2, (RowSet)resultSet);
                        this.endTag("col");
                        this.beginTag("upd");
                        this.writeValue(n2, oracleWebRowSet);
                        this.endTag("upd");
                    } else {
                        this.beginTag("col");
                        this.writeValue(n2, oracleWebRowSet);
                        this.endTag("col");
                    }
                    ++n2;
                }
                this.endSection();
            }
            this.endSection("data");
        }
        catch (SQLException sQLException) {
            throw new IOException("SQLException: " + sQLException.getMessage());
        }
    }

    private void writeDouble(double d) throws IOException {
        this.m_writer.write(Double.toString(d));
    }

    private void writeFloat(float f) throws IOException {
        this.m_writer.write(Float.toString(f));
    }

    private void writeHeader() throws IOException {
        this.m_writer.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        this.m_writer.write("<!DOCTYPE RowSet PUBLIC '" + OracleWebRowSet.PUBLIC_DTD_ID + "' '" + OracleWebRowSet.SYSTEM_ID + "'>");
        this.m_writer.write("\n\n");
    }

    private void writeIndent(int n) throws IOException {
        int n2 = 1;
        while (n2 < n) {
            this.m_writer.write("  ");
            ++n2;
        }
    }

    private void writeInteger(int n) throws IOException {
        this.m_writer.write(Integer.toString(n));
    }

    private void writeLong(long l) throws IOException {
        this.m_writer.write(Long.toString(l));
    }

    private void writeMetaData(OracleWebRowSet oracleWebRowSet) throws IOException {
        this.beginSection("metadata");
        try {
            ResultSetMetaData resultSetMetaData = oracleWebRowSet.getMetaData();
            int n = resultSetMetaData.getColumnCount();
            this.propInteger("column-count", n);
            int n2 = 1;
            while (n2 <= n) {
                this.beginSection("column-definition");
                this.propInteger("column-index", n2);
                this.propBoolean("auto-increment", resultSetMetaData.isAutoIncrement(n2));
                this.propBoolean("case-sensitive", resultSetMetaData.isCaseSensitive(n2));
                this.propBoolean("currency", resultSetMetaData.isCurrency(n2));
                this.propInteger("nullable", resultSetMetaData.isNullable(n2));
                this.propBoolean("signed", resultSetMetaData.isSigned(n2));
                this.propBoolean("searchable", resultSetMetaData.isSearchable(n2));
                this.propInteger("column-display-size", resultSetMetaData.getColumnDisplaySize(n2));
                this.propString("column-label", resultSetMetaData.getColumnLabel(n2));
                this.propString("column-name", resultSetMetaData.getColumnName(n2));
                this.propString("schema-name", resultSetMetaData.getSchemaName(n2));
                this.propInteger("column-precision", resultSetMetaData.getPrecision(n2));
                this.propInteger("column-scale", resultSetMetaData.getScale(n2));
                this.propString("table-name", resultSetMetaData.getTableName(n2));
                this.propString("catalog-name", resultSetMetaData.getCatalogName(n2));
                this.propInteger("column-type", resultSetMetaData.getColumnType(n2));
                this.propString("column-type-name", resultSetMetaData.getColumnTypeName(n2));
                this.endSection("column-definition");
                ++n2;
            }
        }
        catch (SQLException sQLException) {
            throw new IOException("SQLException: " + sQLException.getMessage());
        }
        this.endSection("metadata");
    }

    private void writeNull() throws IOException {
        this.emptyTag("null");
    }

    private void writeProperties(OracleWebRowSet oracleWebRowSet) throws IOException {
        this.beginSection("properties");
        try {
            this.propString("command", oracleWebRowSet.getCommand());
            this.propInteger("concurrency", oracleWebRowSet.getConcurrency());
            this.propString("datasource", oracleWebRowSet.getDataSourceName());
            this.propBoolean("escape-processing", oracleWebRowSet.getEscapeProcessing());
            this.propInteger("fetch-direction", oracleWebRowSet.getFetchDirection());
            this.propInteger("fetch-size", oracleWebRowSet.getFetchSize());
            this.propInteger("isolation-level", oracleWebRowSet.getTransactionIsolation());
            this.beginSection("key-columns");
            this.endSection("key-columns");
            this.beginTag("map");
            Map map = oracleWebRowSet.getTypeMap();
            if (map != null) {
                Iterator iterator = map.keySet().iterator();
                while (iterator.hasNext()) {
                    String string = (String)iterator.next();
                    Class clazz = (Class)map.get(string);
                    this.propString("type", string);
                    this.propString("class", clazz.getName());
                }
            }
            this.endTag("map");
            this.propInteger("max-field-size", oracleWebRowSet.getMaxFieldSize());
            this.propInteger("max-rows", oracleWebRowSet.getMaxRows());
            this.propInteger("query-timeout", oracleWebRowSet.getQueryTimeout());
            this.propBoolean("read-only", oracleWebRowSet.isReadOnly());
            this.propInteger("rowset-type", oracleWebRowSet.getType());
            this.propBoolean("show-deleted", oracleWebRowSet.getShowDeleted());
            this.propString("url", oracleWebRowSet.getUrl());
        }
        catch (SQLException sQLException) {
            throw new IOException("SQLException: " + sQLException.getMessage());
        }
        this.endSection("properties");
    }

    private void writeRowSet(OracleWebRowSet oracleWebRowSet) throws SQLException {
        try {
            this.writeHeader();
            this.beginSection("RowSet");
            this.writeProperties(oracleWebRowSet);
            this.writeMetaData(oracleWebRowSet);
            this.writeData(oracleWebRowSet);
            this.endSection("RowSet");
        }
        catch (IOException iOException) {
            throw new SQLException("IOException: " + iOException.getMessage());
        }
    }

    private void writeShort(short s) throws IOException {
        this.m_writer.write(Short.toString(s));
    }

    private void writeString(String string) throws IOException {
        if (string != null) {
            this.m_writer.write(string);
        } else {
            this.writeNull();
        }
    }

    private void writeValue(int n, RowSet rowSet) throws IOException {
        try {
            int n2 = rowSet.getMetaData().getColumnType(n);
            switch (n2) {
                case -7: 
                case 5: {
                    short s = rowSet.getShort(n);
                    if (rowSet.wasNull()) {
                        this.writeNull();
                    } else {
                        this.writeShort(s);
                    }
                    break;
                }
                case 4: {
                    int n3 = rowSet.getInt(n);
                    if (rowSet.wasNull()) {
                        this.writeNull();
                    } else {
                        this.writeInteger(rowSet.getInt(n));
                    }
                    break;
                }
                case -5: {
                    long l = rowSet.getLong(n);
                    if (rowSet.wasNull()) {
                        this.writeNull();
                    } else {
                        this.writeLong(l);
                    }
                    break;
                }
                case 6: 
                case 7: {
                    float f = rowSet.getFloat(n);
                    if (rowSet.wasNull()) {
                        this.writeNull();
                    } else {
                        this.writeFloat(f);
                    }
                    break;
                }
                case 8: {
                    double d = rowSet.getDouble(n);
                    if (rowSet.wasNull()) {
                        this.writeNull();
                    } else {
                        this.writeDouble(d);
                    }
                    break;
                }
                case 2: 
                case 3: {
                    this.writeBigDecimal(rowSet.getBigDecimal(n));
                    break;
                }
                case 91: {
                    Date date = rowSet.getDate(n);
                    if (rowSet.wasNull()) {
                        this.writeNull();
                    } else {
                        this.writeLong(date.getTime());
                    }
                    break;
                }
                case 92: {
                    Time time = rowSet.getTime(n);
                    if (rowSet.wasNull()) {
                        this.writeNull();
                    } else {
                        this.writeLong(time.getTime());
                    }
                    break;
                }
                case 93: {
                    Timestamp timestamp = rowSet.getTimestamp(n);
                    if (rowSet.wasNull()) {
                        this.writeNull();
                    } else {
                        this.writeLong(((java.util.Date)timestamp).getTime());
                    }
                    break;
                }
                case -4: 
                case -3: 
                case -2: {
                    this.writeBytes(rowSet.getBytes(n));
                    break;
                }
                case -1: 
                case 1: 
                case 12: {
                    this.writeString(rowSet.getString(n));
                    break;
                }
                default: {
                    throw new SQLException("The type " + n2 + " is not supported currently.");
                }
            }
        }
        catch (SQLException sQLException) {
            throw new IOException("Failed to writeValue: " + sQLException.getMessage());
        }
    }

    public void writeXML(OracleWebRowSet oracleWebRowSet, Writer writer) throws SQLException {
        this.m_stack = new Stack();
        this.m_writer = writer;
        this.writeRowSet(oracleWebRowSet);
    }
}

