/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.management.j2ee;

import java.io.ByteArrayInputStream;
import javax.management.Attribute;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.jboss.logging.Logger;
import org.jboss.management.j2ee.InvalidParentException;
import org.jboss.management.j2ee.J2EEDomain;
import org.jboss.management.j2ee.J2EEManagedObject;
import org.jboss.management.j2ee.J2EEResource;
import org.jboss.management.j2ee.JavaMailResourceMBean;
import org.jboss.management.j2ee.StateManagement;
import org.w3c.dom.Document;

public class JavaMailResource
extends J2EEResource
implements JavaMailResourceMBean {
    private static Logger log = Logger.getLogger((Class)(class$org$jboss$management$j2ee$JavaMailResource == null ? (class$org$jboss$management$j2ee$JavaMailResource = JavaMailResource.class$("org.jboss.management.j2ee.JavaMailResource")) : class$org$jboss$management$j2ee$JavaMailResource));
    private StateManagement mState;
    private ObjectName mailServiceName;
    static /* synthetic */ Class class$org$jboss$management$j2ee$JavaMailResource;

    public static ObjectName create(MBeanServer mbeanServer, String resName, ObjectName mailServiceName) {
        ObjectName j2eeServerName = J2EEDomain.getDomainServerName(mbeanServer);
        ObjectName jsr77Name = null;
        try {
            JavaMailResource mailRes = new JavaMailResource(resName, j2eeServerName, mailServiceName);
            jsr77Name = mailRes.getObjectName();
            mbeanServer.registerMBean(mailRes, jsr77Name);
            log.debug((Object)("Created JSR-77 JavaMailResource: " + resName));
        }
        catch (Exception e) {
            log.debug((Object)("Could not create JSR-77 JavaMailResource: " + resName), (Throwable)e);
        }
        return jsr77Name;
    }

    public static void destroy(MBeanServer mbeanServer, String resName) {
        try {
            J2EEManagedObject.removeObject(mbeanServer, J2EEDomain.getDomainName() + ":" + "j2eeType" + "=" + "JavaMailResource" + "," + "name=" + resName + "," + "*");
        }
        catch (Exception e) {
            log.debug((Object)("Could not destroy JSR-77 JNDIResource: " + resName), (Throwable)e);
        }
    }

    public JavaMailResource(String resName, ObjectName j2eeServerName, ObjectName mailServiceName) throws MalformedObjectNameException, InvalidParentException {
        super("JavaMailResource", resName, j2eeServerName);
        this.mailServiceName = mailServiceName;
        this.mState = new StateManagement(this);
    }

    public String getuserName() throws Exception {
        return (String)this.server.getAttribute(this.mailServiceName, "User");
    }

    public void setuserName(String pName) throws Exception {
        this.server.setAttribute(this.mailServiceName, new Attribute("User", pName));
    }

    public void setpassword(String pPassword) throws Exception {
        this.server.setAttribute(this.mailServiceName, new Attribute("Password", pPassword));
    }

    public String getjndiName() throws Exception {
        return (String)this.server.getAttribute(this.mailServiceName, "JNDIName");
    }

    public void setjndiName(String pName) throws Exception {
        this.server.setAttribute(this.mailServiceName, new Attribute("JNDIName", pName));
    }

    public String getconfiguration() throws Exception {
        return this.server.getAttribute(this.mailServiceName, "Configuration") + "";
    }

    public void setconfiguration(String pConfigurationElement) throws Exception {
        if (pConfigurationElement == null || pConfigurationElement.length() == 0) {
            pConfigurationElement = "<configuration/>";
        }
        DocumentBuilder lParser = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        ByteArrayInputStream lInput = new ByteArrayInputStream(pConfigurationElement.getBytes());
        Document lDocument = lParser.parse(lInput);
        this.server.setAttribute(this.mailServiceName, new Attribute("Configuration", lDocument.getDocumentElement()));
    }

    public String[] getEventTypes() {
        return StateManagement.stateTypes;
    }

    public String getEventType(int pIndex) {
        if (pIndex >= 0 && pIndex < StateManagement.stateTypes.length) {
            return StateManagement.stateTypes[pIndex];
        }
        return null;
    }

    public long getStartTime() {
        return this.mState.getStartTime();
    }

    public int getState() {
        return this.mState.getState();
    }

    public void mejbStart() {
        try {
            this.server.invoke(this.mailServiceName, "start", new Object[0], new String[0]);
        }
        catch (Exception e) {
            log.error((Object)"start failed", (Throwable)e);
        }
    }

    public void mejbStartRecursive() {
        try {
            this.mejbStart();
        }
        catch (Exception e) {
            log.error((Object)"start failed", (Throwable)e);
        }
    }

    public void mejbStop() {
        try {
            this.server.invoke(this.mailServiceName, "stop", new Object[0], new String[0]);
        }
        catch (Exception e) {
            log.error((Object)"Stop of JavaMailResource failed", (Throwable)e);
        }
    }

    public void postCreation() {
        try {
            this.server.addNotificationListener(this.mailServiceName, this.mState, null, null);
        }
        catch (JMException e) {
            log.debug((Object)"Failed to add notification listener", (Throwable)e);
        }
        this.sendNotification("j2ee.object.created", "Java Mail Resource created");
    }

    public void preDestruction() {
        this.sendNotification("j2ee.object.deleted", "Java Mail Resource deleted");
        try {
            this.server.removeNotificationListener(this.mailServiceName, this.mState);
        }
        catch (JMException jMException) {
            // empty catch block
        }
    }

    public String toString() {
        return "JavaMailResource { " + super.toString() + " } [ " + " ]";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

