/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.wstore;

import java.io.IOException;
import java.io.PrintWriter;
import java.net.URLEncoder;
import java.util.Date;
import java.util.logging.Level;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.compiere.model.MIssue;
import org.compiere.util.CLogger;
import org.compiere.util.Ctx;
import org.compiere.util.WebEnv;
import org.compiere.util.WebUtil;
import org.compiere.wstore.JSPEnv;

public class IssueReportServlet
extends HttpServlet {
    private static CLogger log = CLogger.getCLogger(IssueReportServlet.class);

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        if (!WebEnv.initWeb(config)) {
            throw new ServletException("IssueReportServlet.init");
        }
    }

    public String getServletInfo() {
        return "Compiere Issue Reporting";
    }

    public void destroy() {
        log.info("");
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        log.info("From " + request.getRemoteHost() + " - " + request.getRemoteAddr());
        Ctx ctx = JSPEnv.getCtx(request);
        HttpSession session = request.getSession(true);
        int AD_Issue_ID = WebUtil.getParameterAsInt(request, "RECORDID");
        String DBAddress = WebUtil.getParameter(request, "DBADDRESS");
        String Comments = WebUtil.getParameter(request, "COMMENTS");
        String IssueString = WebUtil.getParameter(request, "ISSUE");
        StringBuffer responseText = new StringBuffer("Compiere Support - ").append(new Date().toString()).append("\n");
        MIssue issue = null;
        if (AD_Issue_ID != 0) {
            issue = new MIssue(ctx, AD_Issue_ID, null);
            if (issue.get_ID() != AD_Issue_ID) {
                responseText.append("Issue Unknown - Request Ignored");
            } else if (!issue.getDBAddress().equals(DBAddress)) {
                responseText.append("Not Issue Owner - Request Ignored");
            } else {
                issue.addComments(Comments);
                responseText.append(issue.createAnswer());
            }
        } else if (IssueString == null || IssueString.length() == 0) {
            responseText.append("Unknown Request");
        } else {
            issue = MIssue.create(ctx, IssueString);
            if (issue == null || !issue.save()) {
                responseText.append("Could not save Issue");
            } else {
                responseText.append(issue.process());
            }
        }
        StringBuffer answer = new StringBuffer();
        if (issue != null && issue.get_ID() != 0) {
            answer.append("RECORDID=").append(issue.get_ID()).append(MIssue.DELIMITER);
        }
        answer.append("RESPONSE=").append(responseText);
        response.setHeader("Cache-Control", "no-cache");
        response.setContentType("text/html; charset=UTF-8");
        PrintWriter out = response.getWriter();
        out.write(URLEncoder.encode(answer.toString(), "UTF-8"));
        out.flush();
        if (out.checkError()) {
            log.log(Level.SEVERE, "error writing");
        }
        out.close();
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        log.info("Post from " + request.getRemoteHost() + " - " + request.getRemoteAddr());
        this.doGet(request, response);
    }
}

