/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.print;

import java.awt.Insets;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.awt.print.PrinterJob;
import javax.print.attribute.Attribute;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.print.attribute.standard.MediaPrintableArea;
import javax.print.attribute.standard.MediaSize;
import javax.print.attribute.standard.MediaSizeName;
import javax.print.attribute.standard.OrientationRequested;
import org.compiere.util.CLogger;
import org.compiere.util.Ctx;
import org.compiere.util.Language;
import org.compiere.util.Msg;

public class CPaper
extends Paper {
    private MediaSize m_mediaSize;
    private boolean m_landscape = false;
    private static CLogger log = CLogger.getCLogger(CPaper.class);

    public CPaper(PageFormat pf) {
        this.m_landscape = pf.getOrientation() != 1;
        float x = (float)pf.getWidth();
        float y = (float)pf.getHeight();
        MediaSizeName msn = MediaSize.findMedia(x / 72.0f, y / 72.0f, 25400);
        MediaSize ms = null;
        if (msn == null) {
            msn = MediaSize.findMedia(y / 72.0f, x / 72.0f, 25400);
        }
        if (msn != null) {
            ms = MediaSize.getMediaSizeForName(msn);
        }
        this.setMediaSize(ms, this.m_landscape);
        this.setSize(pf.getWidth(), pf.getHeight());
        this.setImageableArea(pf.getImageableX(), pf.getImageableY(), pf.getImageableWidth(), pf.getImageableHeight());
    }

    public CPaper(boolean landscape) {
        this(Language.getLoginLanguage(), landscape);
    }

    private CPaper(Language language, boolean landscape) {
        this(language.getMediaSize(), landscape);
    }

    private CPaper(MediaSize mediaSize, boolean landscape) {
        this(mediaSize, landscape, 36.0, 36.0, 36.0, 36.0);
    }

    public CPaper(MediaSize mediaSize, boolean landscape, double left, double top, double right, double bottom) {
        this.setMediaSize(mediaSize, landscape);
        this.setImageableArea(left, top, this.getWidth() - left - right, this.getHeight() - top - bottom);
    }

    public void setMediaSize(MediaSize mediaSize, boolean landscape) {
        if (mediaSize == null) {
            throw new IllegalArgumentException("MediaSize is null");
        }
        this.m_mediaSize = mediaSize;
        this.m_landscape = landscape;
        double width = this.m_mediaSize.getX(25400) * 72.0f;
        double height = this.m_mediaSize.getY(25400) * 72.0f;
        this.setSize(width, height);
        log.fine(mediaSize.getMediaSizeName() + ": " + this.m_mediaSize + " - Landscape=" + this.m_landscape);
    }

    public MediaSizeName getMediaSizeName() {
        return this.m_mediaSize.getMediaSizeName();
    }

    public MediaSize getMediaSize() {
        return this.m_mediaSize;
    }

    public MediaPrintableArea getMediaPrintableArea() {
        MediaPrintableArea area = new MediaPrintableArea((float)this.getImageableX() / 72.0f, (float)this.getImageableY() / 72.0f, (float)this.getImageableWidth() / 72.0f, (float)this.getImageableHeight() / 72.0f, 25400);
        return area;
    }

    public void setMediaPrintableArea(MediaPrintableArea area) {
        int inch = 25400;
        log.fine(area.toString(inch, "\""));
        this.setImageableArea(area.getX(inch) * 72.0f, area.getY(inch) * 72.0f, area.getWidth(inch) * 72.0f, area.getHeight(inch) * 72.0f);
    }

    public boolean isLandscape() {
        return this.m_landscape;
    }

    public boolean pageSetupDialog(PrinterJob job) {
        PrintRequestAttributeSet prats = this.getPrintRequestAttributeSet();
        PageFormat pf = job.pageDialog(prats);
        this.setPrintRequestAttributeSet(prats);
        return true;
    }

    public PrintRequestAttributeSet getPrintRequestAttributeSet() {
        HashPrintRequestAttributeSet pratts = new HashPrintRequestAttributeSet();
        pratts.add(this.getMediaPrintableArea());
        if (this.isLandscape()) {
            pratts.add(OrientationRequested.LANDSCAPE);
        } else {
            pratts.add(OrientationRequested.PORTRAIT);
        }
        pratts.add(this.getMediaSizeName());
        return pratts;
    }

    public void setPrintRequestAttributeSet(PrintRequestAttributeSet prats) {
        boolean landscape = this.m_landscape;
        MediaSize ms = this.m_mediaSize;
        MediaPrintableArea area = this.getMediaPrintableArea();
        Attribute[] atts = prats.toArray();
        for (int i = 0; i < atts.length; ++i) {
            if (atts[i] instanceof OrientationRequested) {
                OrientationRequested or = (OrientationRequested)atts[i];
                if (or.equals(OrientationRequested.PORTRAIT)) {
                    landscape = false;
                    continue;
                }
                landscape = true;
                continue;
            }
            if (atts[i] instanceof MediaSizeName) {
                MediaSizeName msn = (MediaSizeName)atts[i];
                ms = MediaSize.getMediaSizeForName(msn);
                continue;
            }
            if (atts[i] instanceof MediaPrintableArea) {
                area = (MediaPrintableArea)atts[i];
                continue;
            }
            System.out.println(atts[i].getName() + " = " + atts[i] + " - " + atts[i].getCategory());
        }
        this.setMediaSize(ms, landscape);
        this.setMediaPrintableArea(area);
    }

    public PageFormat getPageFormat() {
        PageFormat pf = new PageFormat();
        pf.setPaper(this);
        int orient = 1;
        if (this.m_landscape) {
            orient = 0;
        }
        pf.setOrientation(orient);
        return pf;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("CPaper[");
        sb.append(this.getWidth() / 72.0).append("x").append(this.getHeight() / 72.0).append('\"').append(this.m_landscape ? " Landscape " : " Portrait ").append("x=").append(this.getImageableX()).append(",y=").append(this.getImageableY()).append(" w=").append(this.getImageableWidth()).append(",h=").append(this.getImageableHeight()).append("]");
        return sb.toString();
    }

    public String toString(Ctx ctx) {
        StringBuffer sb = new StringBuffer();
        sb.append(this.m_mediaSize.getMediaSizeName());
        String name = this.m_mediaSize.getMediaSizeName().toString();
        if (!name.startsWith("iso")) {
            sb.append(" - ").append(this.m_mediaSize.toString(25400, "\"")).append(" (").append(this.getMediaPrintableArea().toString(25400, "\""));
        }
        if (!name.startsWith("na")) {
            sb.append(" - ").append(this.m_mediaSize.toString(1000, "mm")).append(" (").append(this.getMediaPrintableArea().toString(1000, "mm"));
        }
        sb.append(") - ").append(Msg.getMsg((Ctx)ctx, (String)(this.m_landscape ? "Landscape" : "Portrait")));
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (obj instanceof CPaper) {
            CPaper cp = (CPaper)obj;
            if (cp.isLandscape() != this.m_landscape) {
                return false;
            }
            if (this.getImageableX() == cp.getImageableX() && this.getImageableY() == cp.getImageableY() && this.getImageableWidth() == cp.getImageableWidth() && this.getImageableHeight() == cp.getImageableHeight()) {
                return true;
            }
        }
        return false;
    }

    public double getWidth(boolean orientationCorrected) {
        if (orientationCorrected && this.m_landscape) {
            return super.getHeight();
        }
        return super.getWidth();
    }

    public double getHeight(boolean orientationCorrected) {
        if (orientationCorrected && this.m_landscape) {
            return super.getWidth();
        }
        return super.getHeight();
    }

    public double getImageableY(boolean orientationCorrected) {
        if (orientationCorrected && this.m_landscape) {
            return super.getImageableX();
        }
        return super.getImageableY();
    }

    public double getImageableX(boolean orientationCorrected) {
        if (orientationCorrected && this.m_landscape) {
            return super.getImageableY();
        }
        return super.getImageableX();
    }

    public double getImageableHeight(boolean orientationCorrected) {
        if (orientationCorrected && this.m_landscape) {
            return super.getImageableWidth();
        }
        return super.getImageableHeight();
    }

    public double getImageableWidth(boolean orientationCorrected) {
        if (orientationCorrected && this.m_landscape) {
            return super.getImageableHeight();
        }
        return super.getImageableWidth();
    }

    public Insets getMargin(boolean orientationCorrected) {
        return new Insets((int)this.getImageableY(orientationCorrected), (int)this.getImageableX(orientationCorrected), (int)(this.getHeight(orientationCorrected) - this.getImageableY(orientationCorrected) - this.getImageableHeight(orientationCorrected)), (int)(this.getWidth(orientationCorrected) - this.getImageableX(orientationCorrected) - this.getImageableWidth(orientationCorrected)));
    }
}

