/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.print;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.logging.Level;
import org.compiere.Compiere;
import org.compiere.framework.PO;
import org.compiere.framework.Query;
import org.compiere.model.MRole;
import org.compiere.model.X_AD_PrintFormat;
import org.compiere.print.MPrintFormatItem;
import org.compiere.print.MPrintTableFormat;
import org.compiere.util.CCache;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.Ctx;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Language;
import org.compiere.util.Msg;
import org.compiere.util.Util;

public class MPrintFormat
extends X_AD_PrintFormat {
    private MPrintFormatItem[] m_items = null;
    private String m_translationViewLanguage = null;
    private Language m_language;
    private MPrintTableFormat m_tFormat;
    private static CLogger s_log = CLogger.getCLogger(MPrintFormat.class);
    private static CCache<Integer, MPrintFormat> s_formats = new CCache("AD_PrintFormat", 30);

    public MPrintFormat(Ctx ctx, int AD_PrintFormat_ID, String trxName) {
        super(ctx, AD_PrintFormat_ID, trxName);
        this.m_language = Env.getLanguage((Ctx)ctx);
        if (AD_PrintFormat_ID == 0) {
            this.setStandardHeaderFooter(true);
            this.setIsTableBased(true);
            this.setIsForm(false);
            this.setIsDefault(false);
        }
        this.m_items = this.getItems();
    }

    public MPrintFormat(Ctx ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
        this.m_language = Env.getLanguage((Ctx)ctx);
        this.m_items = this.getItems();
    }

    public Language getLanguage() {
        return this.m_language;
    }

    public void setLanguage(Language language) {
        if (language != null) {
            this.m_language = language;
        }
        this.m_translationViewLanguage = null;
    }

    public int[] getOrderAD_Column_IDs() {
        HashMap<Integer, Integer> map = new HashMap<Integer, Integer>();
        for (int i = 0; i < this.m_items.length; ++i) {
            if (this.m_items[i].getSortNo() == 0 || this.m_items[i].getAD_Column_ID() == 0) continue;
            map.put(new Integer(this.m_items[i].getSortNo()), new Integer(this.m_items[i].getAD_Column_ID()));
        }
        Object[] keys = new Integer[map.keySet().size()];
        map.keySet().toArray(keys);
        Arrays.sort(keys);
        int[] retValue = new int[keys.length];
        for (int i = 0; i < keys.length; ++i) {
            Integer value = (Integer)map.get(keys[i]);
            retValue[i] = value;
        }
        return retValue;
    }

    public int[] getAD_Column_IDs() {
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (int i = 0; i < this.m_items.length; ++i) {
            if (this.m_items[i].getAD_Column_ID() == 0 || !this.m_items[i].isPrinted()) continue;
            list.add(new Integer(this.m_items[i].getAD_Column_ID()));
        }
        int[] retValue = new int[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            retValue[i] = (Integer)list.get(i);
        }
        return retValue;
    }

    private void setItems(MPrintFormatItem[] items) {
        if (items != null) {
            this.m_items = items;
        }
    }

    private MPrintFormatItem[] getItems() {
        ArrayList<MPrintFormatItem> list = new ArrayList<MPrintFormatItem>();
        String sql = "SELECT * FROM AD_PrintFormatItem pfi WHERE pfi.AD_PrintFormat_ID=? AND pfi.IsActive='Y' AND NOT EXISTS (SELECT * FROM AD_Field f WHERE pfi.AD_Column_ID=f.AD_Column_ID AND (f.IsEncrypted='Y' OR f.ObscureType IS NOT NULL))ORDER BY SeqNo";
        MRole role = MRole.getDefault((Ctx)this.getCtx(), (boolean)false);
        try {
            CPreparedStatement pstmt = DB.prepareStatement((String)sql, null);
            pstmt.setInt(1, this.get_ID());
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                MPrintFormatItem pfi = new MPrintFormatItem(this.p_ctx, rs, this.get_TrxName());
                if (!role.isColumnAccess(this.getAD_Table_ID(), pfi.getAD_Column_ID(), true)) continue;
                list.add(pfi);
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            this.log.log(Level.SEVERE, sql, (Throwable)e);
        }
        MPrintFormatItem[] retValue = new MPrintFormatItem[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    public int getItemCount() {
        if (this.m_items == null) {
            return -1;
        }
        return this.m_items.length;
    }

    public MPrintFormatItem getItem(int index) {
        if (index < 0 || index >= this.m_items.length) {
            throw new ArrayIndexOutOfBoundsException("Index=" + index + " - Length=" + this.m_items.length);
        }
        return this.m_items[index];
    }

    public void setTranslation() {
        StringBuffer sb = new StringBuffer("UPDATE AD_PrintFormatItem_Trl t SET (PrintName, PrintNameSuffix)= (SELECT PrintName, PrintNameSuffix FROM AD_PrintFormatItem i WHERE i.AD_PrintFormatItem_ID=t.AD_PrintFormatItem_ID) WHERE AD_PrintFormatItem_ID IN (SELECT AD_PrintFormatItem_ID FROM AD_PrintFormatItem WHERE AD_PrintFormat_ID=").append(this.get_ID()).append(")");
        int no = DB.executeUpdate((String)sb.toString(), (String)this.get_TrxName());
        this.log.fine("setTranslation #" + no);
    }

    public void setStandardHeaderFooter(boolean standardHeaderFooter) {
        super.setIsStandardHeaderFooter(standardHeaderFooter);
        if (standardHeaderFooter) {
            this.setFooterMargin(0);
            this.setHeaderMargin(0);
        }
    }

    public void setIsTableBased(boolean tableBased) {
        super.setIsTableBased(tableBased);
        if (tableBased) {
            super.setIsForm(false);
        }
    }

    public void setTranslationLanguage(Language language) {
        if (language == null || language.isBaseLanguage()) {
            this.log.info("Ignored - " + language);
            this.m_translationViewLanguage = null;
        } else {
            this.log.info("Language=" + language.getAD_Language());
            this.m_translationViewLanguage = language.getAD_Language();
            this.m_language = language;
        }
    }

    public boolean isTranslationView() {
        return this.m_translationViewLanguage != null;
    }

    public void setTranslationViewQuery(Query query) {
        if (this.m_translationViewLanguage != null && query != null && query.getTableName().toUpperCase().endsWith("_V")) {
            query.setTableName(query.getTableName() + "t");
            query.addRestriction("AD_Language", "=", (Object)this.m_translationViewLanguage);
        }
    }

    public void setAD_PrintTableFormat_ID(int AD_PrintTableFormat_ID) {
        super.setAD_PrintTableFormat_ID(AD_PrintTableFormat_ID);
        this.m_tFormat = MPrintTableFormat.get(this.getCtx(), AD_PrintTableFormat_ID, this.getAD_PrintFont_ID());
    }

    public MPrintTableFormat getTableFormat() {
        if (this.m_tFormat == null) {
            this.m_tFormat = MPrintTableFormat.get(this.getCtx(), this.getAD_PrintTableFormat_ID(), this.getAD_PrintFont_ID());
        }
        return this.m_tFormat;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("MPrintFormat[ID=").append(this.get_ID()).append(",Name=").append(this.getName()).append(",Language=").append(this.getLanguage()).append(",Items=").append(this.getItemCount()).append("]");
        return sb.toString();
    }

    protected Object loadSpecial(ResultSet rs, int index) throws SQLException {
        return null;
    }

    protected String saveNewSpecial(Object value, int index) {
        if (value == null) {
            return "NULL";
        }
        return value.toString();
    }

    public static MPrintFormat createFromTable(Ctx ctx, int AD_Table_ID) {
        return MPrintFormat.createFromTable(ctx, AD_Table_ID, 0);
    }

    public static MPrintFormat createFromTable(Ctx ctx, int AD_Table_ID, int AD_PrintFormat_ID) {
        int AD_Client_ID = ctx.getAD_Client_ID();
        s_log.info("AD_Table_ID=" + AD_Table_ID + " - AD_Client_ID=" + AD_Client_ID);
        MPrintFormat pf = new MPrintFormat(ctx, AD_PrintFormat_ID, null);
        pf.setAD_Table_ID(AD_Table_ID);
        String sql = "SELECT TableName, (SELECT COUNT(*) FROM AD_PrintFormat x WHERE x.AD_Table_ID=t.AD_Table_ID AND x.AD_Client_ID=c.AD_Client_ID) AS Count, COALESCE (cpc.AD_PrintColor_ID, pc.AD_PrintColor_ID) AS AD_PrintColor_ID, COALESCE (cpf.AD_PrintFont_ID, pf.AD_PrintFont_ID) AS AD_PrintFont_ID, COALESCE (cpp.AD_PrintPaper_ID, pp.AD_PrintPaper_ID) AS AD_PrintPaper_ID FROM AD_Table t, AD_Client c LEFT OUTER JOIN AD_PrintColor cpc ON (cpc.AD_Client_ID=c.AD_Client_ID AND cpc.IsDefault='Y') LEFT OUTER JOIN AD_PrintFont cpf ON (cpf.AD_Client_ID=c.AD_Client_ID AND cpf.IsDefault='Y') LEFT OUTER JOIN AD_PrintPaper cpp ON (cpp.AD_Client_ID=c.AD_Client_ID AND cpp.IsDefault='Y'), AD_PrintColor pc, AD_PrintFont pf, AD_PrintPaper pp WHERE t.AD_Table_ID=? AND c.AD_Client_ID=? AND pc.IsDefault='Y' AND pf.IsDefault='Y' AND pp.IsDefault='Y'";
        boolean error = true;
        try {
            CPreparedStatement pstmt = DB.prepareStatement((String)sql, null);
            pstmt.setInt(1, AD_Table_ID);
            pstmt.setInt(2, AD_Client_ID);
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                int count;
                String ColumnName;
                String TableName = rs.getString(1);
                String s = ColumnName = TableName + "_ID";
                if (!ColumnName.equals("T_Report_ID") && ColumnName.equals(s = Msg.translate((Ctx)ctx, (String)ColumnName))) {
                    s = Msg.translate((Ctx)ctx, (String)TableName);
                }
                if ((count = rs.getInt(2)) > 0) {
                    s = s + "_" + (count + 1);
                }
                pf.setName(s);
                pf.setAD_PrintColor_ID(rs.getInt(3));
                pf.setAD_PrintFont_ID(rs.getInt(4));
                pf.setAD_PrintPaper_ID(rs.getInt(5));
                error = false;
            } else {
                s_log.log(Level.SEVERE, "No info found " + AD_Table_ID);
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            s_log.log(Level.SEVERE, sql, (Throwable)e);
        }
        if (error) {
            return null;
        }
        if (!pf.save()) {
            return null;
        }
        pf.setItems(MPrintFormat.createItems(ctx, pf));
        return pf;
    }

    public static MPrintFormat createFromReportView(Ctx ctx, int AD_ReportView_ID, String ReportName) {
        int AD_Client_ID = ctx.getAD_Client_ID();
        s_log.info("AD_ReportView_ID=" + AD_ReportView_ID + " - AD_Client_ID=" + AD_Client_ID + " - " + ReportName);
        MPrintFormat pf = new MPrintFormat(ctx, 0, null);
        pf.setAD_ReportView_ID(AD_ReportView_ID);
        String sql = "SELECT t.TableName, (SELECT COUNT(*) FROM AD_PrintFormat x WHERE x.AD_ReportView_ID=rv.AD_ReportView_ID AND x.AD_Client_ID=c.AD_Client_ID) AS Count, COALESCE (cpc.AD_PrintColor_ID, pc.AD_PrintColor_ID) AS AD_PrintColor_ID, COALESCE (cpf.AD_PrintFont_ID, pf.AD_PrintFont_ID) AS AD_PrintFont_ID, COALESCE (cpp.AD_PrintPaper_ID, pp.AD_PrintPaper_ID) AS AD_PrintPaper_ID, t.AD_Table_ID FROM AD_ReportView rv INNER JOIN AD_Table t ON (rv.AD_Table_ID=t.AD_Table_ID), AD_Client c LEFT OUTER JOIN AD_PrintColor cpc ON (cpc.AD_Client_ID=c.AD_Client_ID AND cpc.IsDefault='Y') LEFT OUTER JOIN AD_PrintFont cpf ON (cpf.AD_Client_ID=c.AD_Client_ID AND cpf.IsDefault='Y') LEFT OUTER JOIN AD_PrintPaper cpp ON (cpp.AD_Client_ID=c.AD_Client_ID AND cpp.IsDefault='Y'), AD_PrintColor pc, AD_PrintFont pf, AD_PrintPaper pp WHERE rv.AD_ReportView_ID=? AND c.AD_Client_ID=? AND pc.IsDefault='Y' AND pf.IsDefault='Y' AND pp.IsDefault='Y'";
        boolean error = true;
        try {
            CPreparedStatement pstmt = DB.prepareStatement((String)sql, null);
            pstmt.setInt(1, AD_ReportView_ID);
            pstmt.setInt(2, AD_Client_ID);
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                int count;
                String name = ReportName;
                if (name == null || name.length() == 0) {
                    name = rs.getString(1);
                }
                if ((count = rs.getInt(2)) > 0) {
                    name = name + "_" + count;
                }
                pf.setName(name);
                pf.setAD_PrintColor_ID(rs.getInt(3));
                pf.setAD_PrintFont_ID(rs.getInt(4));
                pf.setAD_PrintPaper_ID(rs.getInt(5));
                pf.setAD_Table_ID(rs.getInt(6));
                error = false;
            } else {
                s_log.log(Level.SEVERE, "Not found: AD_ReportView_ID=" + AD_ReportView_ID);
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            s_log.log(Level.SEVERE, sql, (Throwable)e);
        }
        if (error) {
            return null;
        }
        if (!pf.save()) {
            return null;
        }
        pf.setItems(MPrintFormat.createItems(ctx, pf));
        return pf;
    }

    private static MPrintFormatItem[] createItems(Ctx ctx, MPrintFormat format) {
        MPrintFormatItem pfi;
        int seqNo;
        ResultSet rs;
        CPreparedStatement pstmt;
        s_log.fine("From window Tab ...");
        ArrayList<MPrintFormatItem> list = new ArrayList<MPrintFormatItem>();
        String sql = "SELECT AD_Column_ID FROM AD_Field WHERE AD_Tab_ID=(SELECT MIN(AD_Tab_ID) FROM AD_Tab WHERE AD_Table_ID=?) AND IsEncrypted='N' AND ObscureType IS NULL ORDER BY COALESCE(IsDisplayed,'N') DESC, SortNo, COALESCE(MRSeqNo, SeqNo), Name";
        try {
            pstmt = DB.prepareStatement((String)sql, (String)format.get_TrxName());
            pstmt.setInt(1, format.getAD_Table_ID());
            rs = pstmt.executeQuery();
            seqNo = 1;
            while (rs.next()) {
                pfi = MPrintFormatItem.createFromColumn(format, rs.getInt(1), seqNo++);
                if (pfi == null) continue;
                list.add(pfi);
                s_log.finest("Tab: " + (Object)((Object)pfi));
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            s_log.log(Level.SEVERE, "(tab) - " + sql, (Throwable)e);
        }
        if (list.size() == 0) {
            s_log.fine("From Table ...");
            sql = "SELECT AD_Column_ID FROM AD_Column WHERE AD_Table_ID=? ORDER BY IsIdentifier DESC, SeqNo, Name";
            try {
                pstmt = DB.prepareStatement((String)sql, (String)format.get_TrxName());
                pstmt.setInt(1, format.getAD_Table_ID());
                rs = pstmt.executeQuery();
                seqNo = 1;
                while (rs.next()) {
                    pfi = MPrintFormatItem.createFromColumn(format, rs.getInt(1), seqNo++);
                    if (pfi == null) continue;
                    list.add(pfi);
                    s_log.finest("Table: " + (Object)((Object)pfi));
                }
                rs.close();
                pstmt.close();
            }
            catch (SQLException e) {
                s_log.log(Level.SEVERE, "(table) - " + sql, (Throwable)e);
            }
        }
        MPrintFormatItem[] retValue = new MPrintFormatItem[list.size()];
        list.toArray(retValue);
        s_log.info((Object)((Object)format) + " - #" + retValue.length);
        return retValue;
    }

    private static MPrintFormatItem[] copyItems(MPrintFormat fromFormat, MPrintFormat toFormat) {
        s_log.info("From=" + (Object)((Object)fromFormat));
        ArrayList<MPrintFormatItem> list = new ArrayList<MPrintFormatItem>();
        MPrintFormatItem[] items = fromFormat.getItems();
        for (int i = 0; i < items.length; ++i) {
            MPrintFormatItem pfi = items[i].copyToClient(toFormat.getAD_Client_ID(), toFormat.get_ID());
            if (pfi == null) continue;
            list.add(pfi);
        }
        MPrintFormatItem[] retValue = new MPrintFormatItem[list.size()];
        list.toArray(retValue);
        MPrintFormat.copyTranslationItems(items, retValue);
        return retValue;
    }

    private static void copyTranslationItems(MPrintFormatItem[] fromItems, MPrintFormatItem[] toItems) {
        if (fromItems == null || toItems == null) {
            return;
        }
        int counter = 0;
        for (int i = 0; i < fromItems.length; ++i) {
            int fromID = fromItems[i].getAD_PrintFormatItem_ID();
            int toID = toItems[i].getAD_PrintFormatItem_ID();
            StringBuffer sql = new StringBuffer("UPDATE AD_PrintFormatItem_Trl new ").append("SET (PrintName, PrintNameSuffix, IsTranslated) = ").append("(").append("SELECT PrintName, PrintNameSuffix, IsTranslated ").append("FROM AD_PrintFormatItem_Trl old ").append("WHERE old.AD_Language=new.AD_Language").append(" AND AD_PrintFormatItem_ID =").append(fromID).append(") ").append("WHERE  AD_PrintFormatItem_ID=").append(toID).append(" AND EXISTS (SELECT AD_PrintFormatItem_ID ").append(" FROM AD_PrintFormatItem_trl old").append(" WHERE old.AD_Language=new.AD_Language").append(" AND AD_PrintFormatItem_ID =").append(fromID).append(") ");
            int no = DB.executeUpdate((String)sql.toString(), null);
            if (no == 0) break;
            counter += no;
        }
        s_log.finest("#" + counter);
    }

    public static MPrintFormat copy(Ctx ctx, int from_AD_PrintFormat_ID, int to_AD_PrintFormat_ID) {
        return MPrintFormat.copy(ctx, from_AD_PrintFormat_ID, to_AD_PrintFormat_ID, -1);
    }

    public static MPrintFormat copyToClient(Ctx ctx, int AD_PrintFormat_ID, int to_Client_ID) {
        return MPrintFormat.copy(ctx, AD_PrintFormat_ID, 0, to_Client_ID);
    }

    private static MPrintFormat copy(Ctx ctx, int from_AD_PrintFormat_ID, int to_AD_PrintFormat_ID, int to_Client_ID) {
        s_log.info("From AD_PrintFormat_ID=" + from_AD_PrintFormat_ID + ", To AD_PrintFormat_ID=" + to_AD_PrintFormat_ID + ", To Client_ID=" + to_Client_ID);
        if (from_AD_PrintFormat_ID == 0) {
            throw new IllegalArgumentException("From_AD_PrintFormat_ID is 0");
        }
        MPrintFormat from = new MPrintFormat(ctx, from_AD_PrintFormat_ID, null);
        MPrintFormat to = new MPrintFormat(ctx, to_AD_PrintFormat_ID, null);
        MPrintFormat.copyValues((PO)from, (PO)to);
        if (to_AD_PrintFormat_ID == 0) {
            if (to_Client_ID < 0) {
                to_Client_ID = ctx.getAD_Client_ID();
            }
            to.setClientOrg(to_Client_ID, 0);
        }
        to.setName(Util.replace((String)to.getName(), (String)"TEMPLATE", (String)String.valueOf(to_Client_ID)));
        to.setName(to.getName() + " " + Msg.getMsg((Ctx)ctx, (String)"Copy") + " " + to.hashCode());
        to.save();
        to.setItems(MPrintFormat.copyItems(from, to));
        return to;
    }

    public static MPrintFormat get(Ctx ctx, int AD_PrintFormat_ID, boolean readFromDisk) {
        Integer key = new Integer(AD_PrintFormat_ID);
        MPrintFormat pf = null;
        if (!readFromDisk) {
            pf = (MPrintFormat)((Object)s_formats.get((Object)key));
        }
        if (pf == null) {
            pf = new MPrintFormat(ctx, AD_PrintFormat_ID, null);
            s_formats.put((Object)key, (Object)pf);
        }
        return pf;
    }

    public static MPrintFormat get(Ctx ctx, int AD_ReportView_ID, int AD_Table_ID) {
        MPrintFormat retValue = null;
        CPreparedStatement pstmt = null;
        String sql = "SELECT * FROM AD_PrintFormat WHERE ";
        sql = AD_ReportView_ID > 0 ? sql + "AD_ReportView_ID=?" : sql + "AD_Table_ID=?";
        sql = sql + " ORDER BY IsDefault DESC";
        try {
            pstmt = DB.prepareStatement((String)sql, null);
            pstmt.setInt(1, AD_ReportView_ID > 0 ? AD_ReportView_ID : AD_Table_ID);
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                retValue = new MPrintFormat(ctx, rs, null);
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            s_log.log(Level.SEVERE, sql, (Throwable)e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        return retValue;
    }

    public static void deleteFromCache(int AD_PrintFormat_ID) {
        Integer key = new Integer(AD_PrintFormat_ID);
        s_formats.put((Object)key, null);
    }

    public static void main(String[] args) {
        Compiere.startup((boolean)true);
    }
}

