/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.print;

import java.sql.ResultSet;
import java.util.logging.Level;
import org.compiere.Compiere;
import org.compiere.print.MPrintFormat;
import org.compiere.print.MPrintFormatItem;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.Ctx;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class PrintFormatUtil {
    private CLogger log = CLogger.getCLogger(this.getClass());
    private Ctx m_ctx;

    public PrintFormatUtil(Ctx ctx) {
        this.m_ctx = ctx;
    }

    public void addMissingColumns() {
        int total = 0;
        String sql = "SELECT * FROM AD_PrintFormat pf ORDER BY Name";
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement((String)sql, null);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                total += this.addMissingColumns(new MPrintFormat(this.m_ctx, rs, null));
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, sql, (Throwable)e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        this.log.info("Total = " + total);
    }

    public int addMissingColumns(MPrintFormat pf) {
        this.log.config(pf.toString());
        String sql = "SELECT c.AD_Column_ID, c.ColumnName FROM AD_Column c WHERE NOT EXISTS (SELECT * FROM AD_PrintFormatItem pfi INNER JOIN AD_PrintFormat pf ON (pfi.AD_PrintFormat_ID=pf.AD_PrintFormat_ID) WHERE pf.AD_Table_ID=c.AD_Table_ID AND pfi.AD_Column_ID=c.AD_Column_ID AND pfi.AD_PrintFormat_ID=?) AND c.AD_Table_ID=? ORDER BY 1";
        CPreparedStatement pstmt = null;
        int counter = 0;
        try {
            pstmt = DB.prepareStatement((String)sql, null);
            pstmt.setInt(1, pf.getAD_PrintFormat_ID());
            pstmt.setInt(2, pf.getAD_Table_ID());
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                int AD_Column_ID = rs.getInt(1);
                String ColumnName = rs.getString(2);
                MPrintFormatItem pfi = MPrintFormatItem.createFromColumn(pf, AD_Column_ID, 0);
                if (pfi.get_ID() != 0) {
                    this.log.fine("#" + ++counter + " - added " + ColumnName);
                    continue;
                }
                this.log.warning("Not added: " + ColumnName);
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, sql, (Throwable)e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        if (counter == 0) {
            this.log.fine("None");
        } else {
            this.log.fine("Added=" + counter);
        }
        return counter;
    }

    public static void main(String[] args) {
        Compiere.startup((boolean)true);
        PrintFormatUtil pfu = new PrintFormatUtil(Env.getCtx());
        pfu.addMissingColumns();
    }
}

