/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.print;

import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.util.logging.Level;
import javax.print.DocFlavor;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.ServiceUIFactory;
import javax.print.StreamPrintServiceFactory;
import javax.print.attribute.Attribute;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.print.attribute.PrintServiceAttributeSet;
import javax.print.attribute.standard.Copies;
import javax.print.attribute.standard.JobName;
import javax.print.attribute.standard.JobPriority;
import javax.print.attribute.standard.OrientationRequested;
import javax.swing.JDialog;
import javax.swing.JPanel;
import org.compiere.print.CPrinter;
import org.compiere.print.MPrintFormat;
import org.compiere.util.CLogMgt;
import org.compiere.util.CLogger;
import org.compiere.util.Ctx;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Language;
import org.compiere.util.Msg;

public class PrintUtil {
    static CLogger log = CLogger.getCLogger(PrintUtil.class);
    private static PrintRequestAttributeSet s_prats = new HashPrintRequestAttributeSet();

    public static PrintRequestAttributeSet getDefaultPrintRequestAttributes() {
        return s_prats;
    }

    public static DocFlavor getDefaultFlavor() {
        return DocFlavor.SERVICE_FORMATTED.PAGEABLE;
    }

    public static PrintService[] getPrintServices() {
        return PrintServiceLookup.lookupPrintServices(PrintUtil.getDefaultFlavor(), PrintUtil.getDefaultPrintRequestAttributes());
    }

    public static PrintService getDefaultPrintService() {
        return PrintServiceLookup.lookupDefaultPrintService();
    }

    public static void print(Pageable pageable, String printerName, String jobName, int copies, boolean withDialog) {
        if (pageable == null) {
            return;
        }
        String name = "Compiere_";
        if (jobName != null) {
            name = name + jobName;
        }
        PrinterJob job = CPrinter.getPrinterJob(printerName);
        job.setJobName(name);
        job.setPageable(pageable);
        HashPrintRequestAttributeSet prats = new HashPrintRequestAttributeSet();
        prats.add(new Copies(copies));
        if (pageable.getPageFormat(0).getOrientation() == 1) {
            prats.add(OrientationRequested.PORTRAIT);
        } else {
            prats.add(OrientationRequested.LANDSCAPE);
        }
        prats.add(new JobName(name, Language.getLoginLanguage().getLocale()));
        prats.add(PrintUtil.getJobPriority(pageable.getNumberOfPages(), copies, withDialog));
        PrintUtil.print(job, prats, withDialog, false);
    }

    public static void print(Pageable pageable, PrintRequestAttributeSet prats) {
        PrinterJob job = CPrinter.getPrinterJob();
        job.setPageable(pageable);
        PrintUtil.print(job, prats, true, false);
    }

    public static void print(final PrinterJob job, final PrintRequestAttributeSet prats, boolean withDialog, boolean waitForIt) {
        if (job == null) {
            return;
        }
        boolean printed = true;
        if (withDialog) {
            printed = job.printDialog(prats);
        }
        if (printed) {
            if (withDialog) {
                Attribute[] atts = prats.toArray();
                for (int i = 0; i < atts.length; ++i) {
                    log.fine(atts[i].getName() + "=" + atts[i]);
                }
            }
            if (waitForIt) {
                log.fine("(wait) " + job.getPrintService());
                try {
                    job.print(prats);
                }
                catch (Exception ex) {
                    log.log(Level.SEVERE, "(wait)", (Throwable)ex);
                }
            } else {
                Thread printThread = new Thread(){

                    public void run() {
                        log.fine("print: " + job.getPrintService());
                        try {
                            job.print(prats);
                        }
                        catch (Exception ex) {
                            log.log(Level.SEVERE, "print", (Throwable)ex);
                        }
                    }
                };
                printThread.start();
            }
        }
    }

    public static JobPriority getJobPriority(int pages, int copies, boolean withDialog) {
        int priority = copies * pages;
        if (withDialog) {
            priority *= 2;
        }
        if ((priority = 100 - priority) < 10) {
            priority = 10;
        } else if (priority > 100) {
            priority = 100;
        }
        return new JobPriority(priority);
    }

    public static void dump(PrinterJob job) {
        StringBuffer sb = new StringBuffer(job.getJobName());
        sb.append("/").append(job.getUserName()).append(" Service=").append(job.getPrintService().getName()).append(" Copies=").append(job.getCopies());
        PageFormat pf = job.defaultPage();
        sb.append(" DefaultPage ").append("x=").append(pf.getImageableX()).append(",y=").append(pf.getImageableY()).append(" w=").append(pf.getImageableWidth()).append(",h=").append(pf.getImageableHeight());
        System.out.println(sb.toString());
    }

    public static void dump(PrintServiceAttributeSet psas) {
        System.out.println("PrintServiceAttributeSet - length=" + psas.size());
        Attribute[] ats = psas.toArray();
        for (int i = 0; i < ats.length; ++i) {
            System.out.println(ats[i].getName() + " = " + ats[i] + "  (" + ats[i].getCategory() + ")");
        }
    }

    public static void dump(PrintRequestAttributeSet prats) {
        System.out.println("PrintRequestAttributeSet - length=" + prats.size());
        Attribute[] ats = prats.toArray();
        for (int i = 0; i < ats.length; ++i) {
            System.out.println(ats[i].getName() + " = " + ats[i] + "  (" + ats[i].getCategory() + ")");
        }
    }

    public static void dump(DocFlavor docFlavor, String outputMimeType) {
        System.out.println();
        System.out.println("DocFlavor=" + docFlavor + ", Output=" + outputMimeType);
        StreamPrintServiceFactory[] spsfactories = StreamPrintServiceFactory.lookupStreamPrintServiceFactories(docFlavor, outputMimeType);
        for (int i = 0; i < spsfactories.length; ++i) {
            System.out.println("- " + spsfactories[i]);
            DocFlavor[] dfs = spsfactories[i].getSupportedDocFlavors();
            for (int j = 0; j < dfs.length; ++j) {
                System.out.println("   -> " + dfs[j]);
            }
        }
    }

    public static void dump(DocFlavor docFlavor) {
        System.out.println();
        System.out.println("DocFlavor=" + docFlavor);
        HashPrintRequestAttributeSet pras = new HashPrintRequestAttributeSet();
        PrintService[] pss = PrintServiceLookup.lookupPrintServices(docFlavor, pras);
        for (int i = 0; i < pss.length; ++i) {
            PrintService ps = pss[i];
            System.out.println("- " + ps);
            System.out.println("  Factory=" + ps.getServiceUIFactory());
            ServiceUIFactory uiF = pss[i].getServiceUIFactory();
            if (uiF != null) {
                System.out.println("about");
                JDialog about = (JDialog)uiF.getUI(1, "javax.swing.JDialog");
                about.setVisible(true);
                System.out.println("admin");
                JDialog admin = (JDialog)uiF.getUI(2, "javax.swing.JDialog");
                admin.setVisible(true);
                System.out.println("main");
                JDialog main = (JDialog)uiF.getUI(3, "javax.swing.JDialog");
                main.setVisible(true);
                System.out.println("reserved");
                JDialog res = (JDialog)uiF.getUI(99, "javax.swing.JDialog");
                res.setVisible(true);
            }
            DocFlavor[] dfs = pss[i].getSupportedDocFlavors();
            System.out.println("  - Supported Doc Flavors");
            for (int j = 0; j < dfs.length; ++j) {
                System.out.println("    -> " + dfs[j]);
            }
            Class<?>[] attCat = pss[i].getSupportedAttributeCategories();
            System.out.println("  - Supported Attribute Categories");
            for (int j = 0; j < attCat.length; ++j) {
                System.out.println("    -> " + attCat[j].getName() + " = " + pss[i].getDefaultAttributeValue(attCat[j]));
            }
        }
    }

    private static void testPS() {
        int i;
        PrintService ps = PrintUtil.getDefaultPrintService();
        ServiceUIFactory factory = ps.getServiceUIFactory();
        System.out.println(factory);
        if (factory != null) {
            System.out.println("Factory");
            JPanel p0 = (JPanel)factory.getUI(1, "javax.swing.JDialog");
            p0.setVisible(true);
            JPanel p1 = (JPanel)factory.getUI(2, "javax.swing.JDialog");
            p1.setVisible(true);
            JPanel p2 = (JPanel)factory.getUI(3, "javax.swing.JDialog");
            p2.setVisible(true);
        }
        System.out.println("1----------");
        PrinterJob pj = PrinterJob.getPrinterJob();
        PrintRequestAttributeSet pratts = PrintUtil.getDefaultPrintRequestAttributes();
        PageFormat pf = pj.pageDialog(pratts);
        System.out.println("Pratts Size = " + pratts.size());
        Attribute[] atts = pratts.toArray();
        for (i = 0; i < atts.length; ++i) {
            System.out.println(atts[i].getName() + " = " + atts[i] + " - " + atts[i].getCategory());
        }
        System.out.println("PageFormat h=" + pf.getHeight() + ",w=" + pf.getWidth() + " - x=" + pf.getImageableX() + ",y=" + pf.getImageableY() + " - ih=" + pf.getImageableHeight() + ",iw=" + pf.getImageableWidth() + " - Orient=" + pf.getOrientation());
        ps = pj.getPrintService();
        System.out.println("PrintService = " + ps.getName());
        System.out.println("2----------");
        pj.printDialog(pratts);
        System.out.println("Pratts Size = " + pratts.size());
        atts = pratts.toArray();
        for (i = 0; i < atts.length; ++i) {
            System.out.println(atts[i].getName() + " = " + atts[i] + " - " + atts[i].getCategory());
        }
        pf = pj.defaultPage();
        System.out.println("PageFormat h=" + pf.getHeight() + ",w=" + pf.getWidth() + " - x=" + pf.getImageableX() + ",y=" + pf.getImageableY() + " - ih=" + pf.getImageableHeight() + ",iw=" + pf.getImageableWidth() + " - Orient=" + pf.getOrientation());
        ps = pj.getPrintService();
        System.out.println("PrintService= " + ps.getName());
        System.out.println("3----------");
        try {
            pj.setPrintService(ps);
        }
        catch (PrinterException pe) {
            System.out.println(pe);
        }
        pf = pj.validatePage(pf);
        System.out.println("PageFormat h=" + pf.getHeight() + ",w=" + pf.getWidth() + " - x=" + pf.getImageableX() + ",y=" + pf.getImageableY() + " - ih=" + pf.getImageableHeight() + ",iw=" + pf.getImageableWidth() + " - Orient=" + pf.getOrientation());
        ps = pj.getPrintService();
        System.out.println("PrintService= " + ps.getName());
        System.out.println("4----------");
        pj.printDialog();
    }

    private static void testSPS() {
        HashPrintRequestAttributeSet pras = new HashPrintRequestAttributeSet();
        PrintService[] pss = PrintServiceLookup.lookupPrintServices(DocFlavor.SERVICE_FORMATTED.PAGEABLE, pras);
        for (int i = 0; i < pss.length; ++i) {
            PrintService ps = pss[i];
            String name = ps.getName();
            if (name.indexOf("PDF") == -1 && name.indexOf("Acrobat") == -1) continue;
            System.out.println("----");
            System.out.println(ps);
            Class<?>[] cat = ps.getSupportedAttributeCategories();
            for (int j = 0; j < cat.length; ++j) {
                System.out.println("- " + cat[j]);
            }
        }
    }

    public static void setupPrintForm(int AD_Client_ID) {
        log.config("AD_Client_ID=" + AD_Client_ID);
        Ctx ctx = Env.getCtx();
        CLogMgt.enable((boolean)false);
        int Order_PrintFormat_ID = MPrintFormat.copyToClient(ctx, 100, AD_Client_ID).get_ID();
        int OrderLine_PrintFormat_ID = MPrintFormat.copyToClient(ctx, 101, AD_Client_ID).get_ID();
        PrintUtil.updatePrintFormatHeader(Order_PrintFormat_ID, OrderLine_PrintFormat_ID);
        int Invoice_PrintFormat_ID = MPrintFormat.copyToClient(ctx, 102, AD_Client_ID).get_ID();
        int InvoiceLine_PrintFormat_ID = MPrintFormat.copyToClient(ctx, 103, AD_Client_ID).get_ID();
        PrintUtil.updatePrintFormatHeader(Invoice_PrintFormat_ID, InvoiceLine_PrintFormat_ID);
        int Shipment_PrintFormat_ID = MPrintFormat.copyToClient(ctx, 104, AD_Client_ID).get_ID();
        int ShipmentLine_PrintFormat_ID = MPrintFormat.copyToClient(ctx, 105, AD_Client_ID).get_ID();
        PrintUtil.updatePrintFormatHeader(Shipment_PrintFormat_ID, ShipmentLine_PrintFormat_ID);
        int Check_PrintFormat_ID = MPrintFormat.copyToClient(ctx, 106, AD_Client_ID).get_ID();
        int RemittanceLine_PrintFormat_ID = MPrintFormat.copyToClient(ctx, 107, AD_Client_ID).get_ID();
        PrintUtil.updatePrintFormatHeader(Check_PrintFormat_ID, RemittanceLine_PrintFormat_ID);
        int Remittance_PrintFormat_ID = MPrintFormat.copyToClient(ctx, 108, AD_Client_ID).get_ID();
        PrintUtil.updatePrintFormatHeader(Remittance_PrintFormat_ID, RemittanceLine_PrintFormat_ID);
        int AD_PrintForm_ID = DB.getNextID((int)AD_Client_ID, (String)"AD_PrintForm", null);
        String sql = "INSERT INTO AD_PrintForm(AD_Client_ID,AD_Org_ID,IsActive,Created,CreatedBy,Updated,UpdatedBy,AD_PrintForm_ID,Name,Order_PrintFormat_ID,Invoice_PrintFormat_ID,Remittance_PrintFormat_ID,Shipment_PrintFormat_ID) VALUES (" + AD_Client_ID + ",0,'Y',SysDate,0,SysDate,0," + AD_PrintForm_ID + "," + "'" + Msg.translate((Ctx)ctx, (String)"Standard") + "'," + Order_PrintFormat_ID + "," + Invoice_PrintFormat_ID + "," + Remittance_PrintFormat_ID + "," + Shipment_PrintFormat_ID + ")";
        int no = DB.executeUpdate((String)sql, null);
        if (no != 1) {
            log.log(Level.SEVERE, "PrintForm NOT inserted");
        }
        CLogMgt.enable((boolean)true);
    }

    private static void updatePrintFormatHeader(int Header_ID, int Line_ID) {
        StringBuffer sb = new StringBuffer();
        sb.append("UPDATE AD_PrintFormatItem SET AD_PrintFormatChild_ID=").append(Line_ID).append(" WHERE AD_PrintFormatChild_ID IS NOT NULL AND AD_PrintFormat_ID=").append(Header_ID);
        int no = DB.executeUpdate((String)sb.toString(), null);
    }

    public static void main(String[] args) {
        PrintUtil.testPS();
        PrintUtil.testSPS();
    }
}

