/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.print.layout;

import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.font.FontRenderContext;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.geom.Point2D;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.regex.Pattern;
import org.compiere.framework.Query;
import org.compiere.print.layout.LayoutEngine;
import org.compiere.print.layout.PrintElement;
import org.compiere.util.Ctx;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Msg;
import org.compiere.util.NamePair;
import org.compiere.util.Util;

public class StringElement
extends PrintElement {
    private AttributedString[] m_string_view = null;
    private AttributedString[] m_string_paper = null;
    private String m_originalString = null;
    private Font m_font = null;
    private Paint m_paint = null;
    private NamePair m_ID = null;
    private Boolean m_check = null;

    public StringElement(String inText, Font font, Paint paint, NamePair ID, boolean translateText) {
        int count;
        this.log.finest("Text=" + inText + ", ID=" + ID + ", Translate=" + translateText);
        this.p_info = inText;
        this.m_font = font;
        this.m_paint = paint;
        if (translateText && (count = Util.getCount((String)inText, (char)'@')) > 0 && count % 2 == 0) {
            this.m_originalString = inText;
            inText = Msg.parseTranslation((Ctx)Env.getCtx(), (String)this.m_originalString);
        }
        this.m_ID = ID;
        String[] lines = Pattern.compile("$", 8).split(inText);
        this.m_string_paper = new AttributedString[lines.length];
        this.m_string_view = new AttributedString[lines.length];
        for (int i = 0; i < lines.length; ++i) {
            String line = Util.removeCRLF((String)lines[i]);
            this.m_string_paper[i] = new AttributedString(line);
            if (line.length() == 0) continue;
            this.log.finest(" - line=" + i + " - " + line);
            this.m_string_paper[i].addAttribute(TextAttribute.FONT, font);
            this.m_string_paper[i].addAttribute(TextAttribute.FOREGROUND, paint);
            if (this.m_ID != null && i == 0) {
                this.m_string_view[i] = new AttributedString(line);
                this.m_string_view[i].addAttribute(TextAttribute.FONT, font);
                int endIndex = line.length();
                this.m_string_view[i].addAttribute(TextAttribute.FOREGROUND, LINK_COLOR);
                this.m_string_view[i].addAttribute(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_LOW_ONE_PIXEL, 0, endIndex);
                continue;
            }
            this.m_string_view[i] = this.m_string_paper[i];
        }
        this.waitForLoad(LayoutEngine.IMAGE_TRUE);
        this.waitForLoad(LayoutEngine.IMAGE_FALSE);
    }

    public StringElement(AttributedString string) {
        this.m_string_paper = new AttributedString[]{string};
        this.m_string_view = this.m_string_paper;
    }

    public StringElement(Object content, Font font, Paint paint, NamePair ID, String label, String labelSuffix) {
        this.log.finest("Label=" + label + "|" + labelSuffix + ", Content=" + content + ", ID=" + ID);
        this.m_font = font;
        this.m_paint = paint;
        int startIndex = 0;
        int endOffset = 0;
        StringBuffer text = new StringBuffer();
        if (label != null && label.length() > 0) {
            text.append(label).append(" ");
            startIndex = label.length() + 1;
        }
        if (content instanceof Boolean) {
            this.m_check = (Boolean)content;
        } else {
            text.append(content);
        }
        if (labelSuffix != null && labelSuffix.length() > 0) {
            text.append(labelSuffix);
            endOffset = labelSuffix.length();
        }
        this.m_ID = ID;
        String[] lines = Pattern.compile("$", 8).split(text);
        this.m_string_paper = new AttributedString[lines.length];
        this.m_string_view = new AttributedString[lines.length];
        for (int i = 0; i < lines.length; ++i) {
            String line = Util.removeCRLF((String)lines[i]);
            this.m_string_paper[i] = new AttributedString(line);
            if (line.length() == 0) continue;
            this.log.finest(" - line=" + i + " - " + line);
            this.m_string_paper[i].addAttribute(TextAttribute.FONT, font);
            this.m_string_paper[i].addAttribute(TextAttribute.FOREGROUND, paint);
            if (this.m_ID != null && i == 0) {
                this.m_string_view[i] = new AttributedString(line);
                this.m_string_view[i].addAttribute(TextAttribute.FONT, font);
                this.m_string_view[i].addAttribute(TextAttribute.FOREGROUND, paint);
                int endIndex = line.length() - endOffset;
                if (endIndex <= startIndex) continue;
                this.m_string_view[i].addAttribute(TextAttribute.FOREGROUND, LINK_COLOR, startIndex, endIndex);
                this.m_string_view[i].addAttribute(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_LOW_ONE_PIXEL, startIndex, endIndex);
                continue;
            }
            this.m_string_view[i] = this.m_string_paper[i];
        }
    }

    public NamePair getID() {
        return this.m_ID;
    }

    public String getOriginalString() {
        return this.m_originalString;
    }

    public void translate(Ctx ctx) {
        if (this.m_originalString == null) {
            return;
        }
        String inText = Msg.parseTranslation((Ctx)ctx, (String)this.m_originalString);
        String[] lines = Pattern.compile("$", 8).split(inText);
        this.m_string_paper = new AttributedString[lines.length];
        for (int i = 0; i < lines.length; ++i) {
            String line = Util.removeCRLF((String)lines[i]);
            this.m_string_paper[i] = new AttributedString(line);
            if (line.length() <= 0) continue;
            this.m_string_paper[i].addAttribute(TextAttribute.FONT, this.m_font);
            this.m_string_paper[i].addAttribute(TextAttribute.FOREGROUND, this.m_paint);
        }
        this.m_string_view = this.m_string_paper;
    }

    protected boolean calculateSize() {
        int i;
        if (this.p_sizeCalculated) {
            return true;
        }
        FontRenderContext frc = new FontRenderContext(null, true, true);
        TextLayout layout = null;
        this.p_height = 0.0f;
        this.p_width = 0.0f;
        if (this.p_maxWidth == 0.0f && this.p_maxHeight == 0.0f) {
            for (i = 0; i < this.m_string_paper.length; ++i) {
                AttributedCharacterIterator iter = this.m_string_paper[i].getIterator();
                if (iter.getBeginIndex() == iter.getEndIndex()) continue;
                int tabPos = -1;
                char c = iter.first();
                while (c != '\uffff' && tabPos == -1) {
                    if (c == '\t') {
                        tabPos = iter.getIndex();
                    }
                    c = iter.next();
                }
                if (tabPos == -1) {
                    layout = new TextLayout(iter, frc);
                    this.p_height += layout.getAscent() + layout.getDescent() + layout.getLeading();
                    if (!(this.p_width < layout.getAdvance())) continue;
                    this.p_width = layout.getAdvance();
                    continue;
                }
                LineBreakMeasurer measurer = new LineBreakMeasurer(iter, frc);
                layout = measurer.nextLayout(9999.0f, tabPos, false);
                this.p_height += layout.getAscent() + layout.getDescent() + layout.getLeading();
                float width = this.getTabPos(0.0f, layout.getAdvance());
                layout = measurer.nextLayout(9999.0f, iter.getEndIndex(), true);
                if (!(this.p_width < (width += layout.getAdvance()))) continue;
                this.p_width = width;
            }
            if (this.m_check != null) {
                this.p_width += (float)LayoutEngine.IMAGE_SIZE.width;
                if (this.p_height < (float)LayoutEngine.IMAGE_SIZE.height) {
                    this.p_height = LayoutEngine.IMAGE_SIZE.height;
                }
            }
        } else {
            this.p_width = this.p_maxWidth;
            for (i = 0; i < this.m_string_paper.length; ++i) {
                AttributedCharacterIterator iter = this.m_string_paper[i].getIterator();
                if (iter.getBeginIndex() == iter.getEndIndex()) continue;
                LineBreakMeasurer measurer = new LineBreakMeasurer(iter, frc);
                while (measurer.getPosition() < iter.getEndIndex()) {
                    layout = measurer.nextLayout(this.p_maxWidth);
                    float lineHeight = layout.getAscent() + layout.getDescent() + layout.getLeading();
                    if (this.p_maxHeight == -1.0f && i == 0) {
                        this.p_maxHeight = lineHeight;
                    }
                    if (this.p_maxHeight != 0.0f && !(this.p_height + lineHeight <= this.p_maxHeight)) continue;
                    this.p_height += lineHeight;
                }
            }
            if (this.m_check != null && this.p_height < (float)LayoutEngine.IMAGE_SIZE.height) {
                this.p_height = LayoutEngine.IMAGE_SIZE.height;
            }
        }
        if (this.p_FieldAlignmentType != null) {
            boolean changed = false;
            if (this.p_height < this.p_maxHeight) {
                this.p_height = this.p_maxHeight;
                changed = true;
            }
            if (this.p_width < this.p_maxWidth) {
                this.p_width = this.p_maxWidth;
                changed = true;
            }
            if (changed) {
                this.log.finest("Width=" + this.p_width + "(" + this.p_maxWidth + ") - Height=" + this.p_height + "(" + this.p_maxHeight + ")");
            }
        }
        return true;
    }

    public Query getDrillDown(Point relativePoint, int pageNo) {
        if (this.m_ID != null && this.getBounds().contains(relativePoint)) {
            this.log.fine(this.toString());
            String columnName = Query.getZoomColumnName((String)this.m_ID.getName());
            String tableName = Query.getZoomTableName((String)columnName);
            Object code = this.m_ID.getID();
            if (this.m_ID instanceof KeyNamePair) {
                code = new Integer(((KeyNamePair)this.m_ID).getKey());
            }
            Query query = new Query(tableName);
            query.addRestriction(columnName, "=", code);
            return query;
        }
        return null;
    }

    public Query getDrillAcross(Point relativePoint, int pageNo) {
        return null;
    }

    public void paint(Graphics2D g2D, int pageNo, Point2D pageStart, Ctx ctx, boolean isView) {
        Point2D.Double location = this.getAbsoluteLocation(pageStart);
        if (this.m_originalString != null) {
            this.translate(ctx);
        }
        AttributedString aString = null;
        AttributedCharacterIterator iter = null;
        float xPos = (float)location.x;
        float yPos = (float)location.y;
        float yPen = 0.0f;
        float height = 0.0f;
        float width = 0.0f;
        for (int i = 0; i < this.m_string_paper.length; ++i) {
            if (isView) {
                if (this.m_string_view[i] == null) continue;
                aString = this.m_string_view[i];
            } else {
                if (this.m_string_paper[i] == null) continue;
                aString = this.m_string_paper[i];
            }
            iter = aString.getIterator();
            if (iter.getBeginIndex() == iter.getEndIndex()) continue;
            int tabPos = -1;
            boolean is8Bit = true;
            char c = iter.first();
            while (c != '\uffff') {
                if (c == '\t' && tabPos == -1) {
                    tabPos = iter.getIndex();
                }
                if (c > '\u00ff') {
                    is8Bit = false;
                }
                c = iter.next();
            }
            TextLayout layout = null;
            float xPen = xPos;
            if (this.p_maxWidth == 0.0f) {
                if (tabPos == -1) {
                    layout = new TextLayout(iter, g2D.getFontRenderContext());
                    yPen = yPos + layout.getAscent();
                    layout.draw(g2D, xPen, yPen);
                    yPos += layout.getAscent() + layout.getDescent() + layout.getLeading();
                    if (!(width < layout.getAdvance())) continue;
                    width = layout.getAdvance();
                    continue;
                }
                LineBreakMeasurer measurer = new LineBreakMeasurer(iter, g2D.getFontRenderContext());
                layout = measurer.nextLayout(9999.0f, tabPos, false);
                float lineHeight_1 = layout.getAscent() + layout.getDescent() + layout.getLeading();
                yPen = yPos + layout.getAscent();
                layout.draw(g2D, xPen, yPen);
                xPen = this.getTabPos(xPos, layout.getAdvance());
                float lineWidth = xPen - xPos;
                layout = measurer.nextLayout(9999.0f);
                float lineHeight_2 = layout.getAscent() + layout.getDescent() + layout.getLeading();
                layout.draw(g2D, xPen, yPen);
                yPos += Math.max(lineHeight_1, lineHeight_2);
                lineWidth += layout.getAdvance();
                if (!(width < lineWidth)) continue;
                width = lineWidth;
                continue;
            }
            boolean fastDraw = LayoutEngine.s_FASTDRAW;
            if (fastDraw && !isView && !is8Bit) {
                fastDraw = false;
            }
            LineBreakMeasurer measurer = new LineBreakMeasurer(iter, g2D.getFontRenderContext());
            while (measurer.getPosition() < iter.getEndIndex()) {
                if (tabPos == -1) {
                    layout = measurer.nextLayout(this.p_maxWidth);
                    if (iter.getEndIndex() != measurer.nextOffset(this.p_maxWidth)) {
                        fastDraw = false;
                    }
                } else {
                    fastDraw = false;
                    layout = measurer.nextLayout(this.p_maxWidth, tabPos, false);
                }
                float lineHeight = layout.getAscent() + layout.getDescent() + layout.getLeading();
                if (this.p_maxHeight == -1.0f && i == 0) {
                    this.p_maxHeight = lineHeight;
                }
                if (this.p_maxHeight != 0.0f && !(height + lineHeight <= this.p_maxHeight)) continue;
                yPen = (float)location.y + height + layout.getAscent();
                if (tabPos != -1) {
                    layout.draw(g2D, xPen, yPen);
                    xPen = this.getTabPos(xPos, layout.getAdvance());
                    layout = measurer.nextLayout(this.p_width, iter.getEndIndex(), true);
                    tabPos = -1;
                } else if ("T".equals(this.p_FieldAlignmentType) && layout.isLeftToRight() || "L".equals(this.p_FieldAlignmentType) && !layout.isLeftToRight()) {
                    xPen += this.p_maxWidth - layout.getAdvance();
                } else if ("C".equals(this.p_FieldAlignmentType)) {
                    xPen += (this.p_maxWidth - layout.getAdvance()) / 2.0f;
                } else if ("B".equals(this.p_FieldAlignmentType) && measurer.getPosition() < iter.getEndIndex()) {
                    layout = layout.getJustifiedLayout(this.p_maxWidth);
                    fastDraw = false;
                }
                if (fastDraw) {
                    g2D.setFont(this.m_font);
                    g2D.setPaint(this.m_paint);
                    g2D.drawString(iter, xPen, yPen);
                } else {
                    layout.draw(g2D, xPen, yPen);
                }
                height += lineHeight;
            }
            width = this.p_maxWidth;
        }
        if (this.m_check != null) {
            int x = (int)(location.x + (double)width + 1.0);
            int y = (int)location.y;
            g2D.drawImage(this.m_check != false ? LayoutEngine.IMAGE_TRUE : LayoutEngine.IMAGE_FALSE, x, y, this);
        }
    }

    private float getTabPos(float xPos, float length) {
        float retValue = xPos + length;
        int iLength = (int)Math.ceil(length);
        int tabSpace = iLength % 30;
        return retValue += (float)(30 - tabSpace);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("StringElement[");
        sb.append("Bounds=").append(this.getBounds()).append(",Height=").append(this.p_height).append("(").append(this.p_maxHeight).append("),Width=").append(this.p_width).append("(").append(this.p_maxHeight).append("),PageLocation=").append(this.p_pageLocation).append(" - ");
        for (int i = 0; i < this.m_string_paper.length; ++i) {
            if (this.m_string_paper.length > 1) {
                sb.append(Env.NL).append(i).append(":");
            }
            AttributedCharacterIterator iter = this.m_string_paper[i].getIterator();
            char c = iter.first();
            while (c != '\uffff') {
                sb.append(c);
                c = iter.next();
            }
        }
        if (this.m_ID != null) {
            sb.append(",ID=(").append(this.m_ID.toStringX()).append(")");
        }
        sb.append("]");
        return sb.toString();
    }
}

