/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.logging.Level;
import org.compiere.model.CalloutEngine;
import org.compiere.model.GridField;
import org.compiere.model.GridTab;
import org.compiere.model.MInOutLine;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MProduct;
import org.compiere.model.MProductLocator;
import org.compiere.model.MUOM;
import org.compiere.model.MUOMConversion;
import org.compiere.model.MWarehouse;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.Ctx;
import org.compiere.util.DB;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;

public class CalloutInOut
extends CalloutEngine {
    public String order(Ctx ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        Integer C_Order_ID = (Integer)value;
        if (C_Order_ID == null || C_Order_ID == 0) {
            return "";
        }
        if (CalloutInOut.isCalloutActive()) {
            return "";
        }
        MOrder order = new MOrder(ctx, C_Order_ID, null);
        if (order.get_ID() != 0) {
            mTab.setValue("DateOrdered", (Object)order.getDateOrdered());
            mTab.setValue("POReference", (Object)order.getPOReference());
            mTab.setValue("AD_Org_ID", (Object)new Integer(order.getAD_Org_ID()));
            mTab.setValue("DeliveryRule", (Object)order.getDeliveryRule());
            mTab.setValue("DeliveryViaRule", (Object)order.getDeliveryViaRule());
            mTab.setValue("M_Shipper_ID", (Object)new Integer(order.getM_Shipper_ID()));
            mTab.setValue("FreightCostRule", (Object)order.getFreightCostRule());
            mTab.setValue("FreightAmt", (Object)order.getFreightAmt());
            mTab.setValue("C_BPartner_ID", (Object)new Integer(order.getC_BPartner_ID()));
            mTab.setValue("C_BPartner_Location_ID", (Object)new Integer(order.getC_BPartner_Location_ID()));
            mTab.setValue("AD_OrgTrx_ID", (Object)new Integer(order.getAD_OrgTrx_ID()));
            mTab.setValue("C_Activity_ID", (Object)new Integer(order.getC_Activity_ID()));
            mTab.setValue("C_Campaign_ID", (Object)new Integer(order.getC_Campaign_ID()));
            mTab.setValue("C_Project_ID", (Object)new Integer(order.getC_Project_ID()));
            mTab.setValue("User1_ID", (Object)new Integer(order.getUser1_ID()));
            mTab.setValue("User2_ID", (Object)new Integer(order.getUser2_ID()));
            mTab.setValue("M_Warehouse_ID", (Object)new Integer(order.getM_Warehouse_ID()));
            boolean isReturnTrx = (Boolean)mTab.getValue("IsReturnTrx");
            if (isReturnTrx) {
                mTab.setValue("Orig_Order_ID", (Object)order.getOrig_Order_ID());
                mTab.setValue("Orig_InOut_ID", (Object)order.getOrig_InOut_ID());
            }
        }
        return "";
    }

    public String docType(Ctx ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        Integer C_DocType_ID = (Integer)value;
        if (C_DocType_ID == null || C_DocType_ID == 0) {
            return "";
        }
        String sql = "SELECT d.DocBaseType, d.IsDocNoControlled, s.CurrentNext, d.IsReturnTrx FROM C_DocType d, AD_Sequence s WHERE C_DocType_ID=? AND d.DocNoSequence_ID=s.AD_Sequence_ID(+)";
        try {
            ctx.setContext(WindowNo, "C_DocTypeTarget_ID", C_DocType_ID.intValue());
            CPreparedStatement pstmt = DB.prepareStatement((String)sql, null);
            pstmt.setInt(1, C_DocType_ID);
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                String DocBaseType = rs.getString("DocBaseType");
                Boolean isReturnTrx = rs.getString("IsReturnTrx").equals("Y");
                if (DocBaseType.equals("MMS") && !isReturnTrx.booleanValue()) {
                    mTab.setValue("MovementType", (Object)"C-");
                } else if (DocBaseType.equals("MMS") && isReturnTrx.booleanValue()) {
                    mTab.setValue("MovementType", (Object)"C+");
                } else if (DocBaseType.equals("MMR") && !isReturnTrx.booleanValue()) {
                    mTab.setValue("MovementType", (Object)"V+");
                } else if (DocBaseType.equals("MMR") && isReturnTrx.booleanValue()) {
                    mTab.setValue("MovementType", (Object)"V-");
                }
                if (rs.getString("IsDocNoControlled").equals("Y")) {
                    mTab.setValue("DocumentNo", (Object)("<" + rs.getString("CurrentNext") + ">"));
                }
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            this.log.log(Level.SEVERE, sql, (Throwable)e);
            return e.getLocalizedMessage();
        }
        return "";
    }

    public String bpartner(Ctx ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        Integer C_BPartner_ID = (Integer)value;
        if (C_BPartner_ID == null || C_BPartner_ID == 0) {
            return "";
        }
        boolean isReturnTrx = (Boolean)mTab.getValue("IsReturnTrx");
        Integer order = (Integer)mTab.getValue("C_Order_ID");
        String sql = "SELECT p.AD_Language, p.POReference,SO_CreditLimit, p.SO_CreditLimit-p.SO_CreditUsed AS CreditAvailable,l.C_BPartner_Location_ID, c.AD_User_ID FROM C_BPartner p LEFT OUTER JOIN C_BPartner_Location l ON (p.C_BPartner_ID=l.C_BPartner_ID) LEFT OUTER JOIN AD_User c ON (p.C_BPartner_ID=c.C_BPartner_ID) WHERE p.C_BPartner_ID=?";
        try {
            CPreparedStatement pstmt = DB.prepareStatement((String)sql, null);
            pstmt.setInt(1, C_BPartner_ID);
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                Integer ii = new Integer(rs.getInt("C_BPartner_Location_ID"));
                if (order == null) {
                    if (rs.wasNull()) {
                        mTab.setValue("C_BPartner_Location_ID", null);
                    } else {
                        mTab.setValue("C_BPartner_Location_ID", (Object)ii);
                    }
                }
                ii = new Integer(rs.getInt("AD_User_ID"));
                if (rs.wasNull()) {
                    mTab.setValue("AD_User_ID", null);
                } else {
                    mTab.setValue("AD_User_ID", (Object)ii);
                }
                if (!isReturnTrx) {
                    double CreditAvailable = rs.getDouble("CreditAvailable");
                    if (!rs.wasNull() && CreditAvailable < 0.0) {
                        mTab.fireDataStatusEEvent("CreditLimitOver", DisplayType.getNumberFormat((int)12).format(CreditAvailable), false);
                    }
                }
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            this.log.log(Level.SEVERE, sql, (Throwable)e);
            return e.getLocalizedMessage();
        }
        return "";
    }

    public String warehouse(Ctx ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        if (CalloutInOut.isCalloutActive()) {
            return "";
        }
        Integer M_Warehouse_ID = (Integer)value;
        if (M_Warehouse_ID == null || M_Warehouse_ID == 0) {
            return "";
        }
        CalloutInOut.setCalloutActive(true);
        String sql = "SELECT w.AD_Org_ID, l.M_Locator_ID FROM M_Warehouse w LEFT OUTER JOIN M_Locator l ON (l.M_Warehouse_ID=w.M_Warehouse_ID AND l.IsDefault='Y') WHERE w.M_Warehouse_ID=?";
        try {
            CPreparedStatement pstmt = DB.prepareStatement((String)sql, null);
            pstmt.setInt(1, M_Warehouse_ID);
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                Integer ii = new Integer(rs.getInt(1));
                int AD_Org_ID = ctx.getContextAsInt(WindowNo, "AD_Org_ID");
                if (AD_Org_ID != ii) {
                    mTab.setValue("AD_Org_ID", (Object)ii);
                }
                ii = new Integer(rs.getInt(2));
                if (rs.wasNull()) {
                    ctx.setContext(WindowNo, 0, "M_Locator_ID", null);
                } else {
                    this.log.config("M_Locator_ID=" + ii);
                    ctx.setContext(WindowNo, "M_Locator_ID", ii.intValue());
                }
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            this.log.log(Level.SEVERE, sql, (Throwable)e);
            CalloutInOut.setCalloutActive(false);
            return e.getLocalizedMessage();
        }
        CalloutInOut.setCalloutActive(false);
        return "";
    }

    public String orderLine(Ctx ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        Integer C_OrderLine_ID = (Integer)value;
        if (C_OrderLine_ID == null || C_OrderLine_ID == 0) {
            return "";
        }
        CalloutInOut.setCalloutActive(true);
        MOrderLine ol = new MOrderLine(ctx, C_OrderLine_ID, null);
        if (ol.get_ID() != 0) {
            mTab.setValue("M_Product_ID", (Object)new Integer(ol.getM_Product_ID()));
            mTab.setValue("M_AttributeSetInstance_ID", (Object)new Integer(ol.getM_AttributeSetInstance_ID()));
            mTab.setValue("C_UOM_ID", (Object)new Integer(ol.getC_UOM_ID()));
            BigDecimal MovementQty = ol.getQtyOrdered().subtract(ol.getQtyDelivered());
            mTab.setValue("MovementQty", (Object)MovementQty);
            BigDecimal QtyEntered = MovementQty;
            if (ol.getQtyEntered().compareTo(ol.getQtyOrdered()) != 0) {
                QtyEntered = QtyEntered.multiply(ol.getQtyEntered()).divide(ol.getQtyOrdered(), 12, 4);
            }
            mTab.setValue("QtyEntered", (Object)QtyEntered);
            mTab.setValue("C_Activity_ID", (Object)new Integer(ol.getC_Activity_ID()));
            mTab.setValue("C_Campaign_ID", (Object)new Integer(ol.getC_Campaign_ID()));
            mTab.setValue("C_Project_ID", (Object)new Integer(ol.getC_Project_ID()));
            mTab.setValue("C_ProjectPhase_ID", (Object)new Integer(ol.getC_ProjectPhase_ID()));
            mTab.setValue("C_ProjectTask_ID", (Object)new Integer(ol.getC_ProjectTask_ID()));
            mTab.setValue("AD_OrgTrx_ID", (Object)new Integer(ol.getAD_OrgTrx_ID()));
            mTab.setValue("User1_ID", (Object)new Integer(ol.getUser1_ID()));
            mTab.setValue("User2_ID", (Object)new Integer(ol.getUser2_ID()));
            if (ol.getParent().isReturnTrx()) {
                mTab.setValue("Orig_OrderLine_ID", (Object)new Integer(ol.getOrig_OrderLine_ID()));
                MInOutLine ioLine = new MInOutLine(ctx, ol.getOrig_InOutLine_ID(), null);
                mTab.setValue("M_Locator_ID", (Object)ioLine.getM_Locator_ID());
            }
        }
        CalloutInOut.setCalloutActive(false);
        return "";
    }

    public String product(Ctx ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        boolean IsSOTrx;
        if (CalloutInOut.isCalloutActive()) {
            return "";
        }
        Integer M_Product_ID = (Integer)value;
        if (M_Product_ID == null || M_Product_ID == 0) {
            return "";
        }
        CalloutInOut.setCalloutActive(true);
        int M_Locator_ID = 0;
        if (ctx.getContextAsInt(1113, 1113, "M_Product_ID") == M_Product_ID.intValue() && ctx.getContextAsInt(1113, 1113, "M_AttributeSetInstance_ID") != 0) {
            mTab.setValue("M_AttributeSetInstance_ID", (Object)new Integer(ctx.getContextAsInt(1113, 1113, "M_AttributeSetInstance_ID")));
            M_Locator_ID = ctx.getContextAsInt(1113, 1113, "M_Locator_ID");
            if (M_Locator_ID != 0) {
                mTab.setValue("M_Locator_ID", (Object)new Integer(M_Locator_ID));
            }
        } else {
            mTab.setValue("M_AttributeSetInstance_ID", null);
        }
        if (IsSOTrx = ctx.isSOTrx(WindowNo)) {
            CalloutInOut.setCalloutActive(false);
            return "";
        }
        MProduct product = MProduct.get(ctx, M_Product_ID);
        mTab.setValue("C_UOM_ID", (Object)new Integer(product.getC_UOM_ID()));
        BigDecimal QtyEntered = (BigDecimal)mTab.getValue("QtyEntered");
        mTab.setValue("MovementQty", (Object)QtyEntered);
        if (M_Locator_ID == 0) {
            int M_Warehouse_ID = ctx.getContextAsInt(WindowNo, "M_Warehouse_ID");
            M_Locator_ID = MProductLocator.getFirstM_Locator_ID(product, M_Warehouse_ID);
            if (M_Locator_ID != 0) {
                mTab.setValue("M_Locator_ID", (Object)new Integer(M_Locator_ID));
            } else {
                MWarehouse wh = MWarehouse.get((Ctx)ctx, (int)M_Warehouse_ID);
                mTab.setValue("M_Locator_ID", (Object)new Integer(wh.getDefaultM_Locator_ID()));
            }
        }
        CalloutInOut.setCalloutActive(false);
        return "";
    }

    public String qty(Ctx ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        MInOutLine orig_IOLine;
        BigDecimal shippedQty;
        Integer orig_IOLine_ID;
        Integer oLine_ID;
        MOrderLine oLine;
        BigDecimal MovementQty;
        int C_UOM_To_ID;
        BigDecimal QtyEntered;
        if (CalloutInOut.isCalloutActive() || value == null) {
            return "";
        }
        CalloutInOut.setCalloutActive(true);
        int M_Product_ID = ctx.getContextAsInt(WindowNo, "M_Product_ID");
        if (M_Product_ID == 0) {
            QtyEntered = (BigDecimal)mTab.getValue("QtyEntered");
            mTab.setValue("MovementQty", (Object)QtyEntered);
        } else if (mField.getColumnName().equals("C_UOM_ID")) {
            BigDecimal QtyEntered1;
            C_UOM_To_ID = (Integer)value;
            QtyEntered = (BigDecimal)mTab.getValue("QtyEntered");
            if (QtyEntered.compareTo(QtyEntered1 = QtyEntered.setScale(MUOM.getPrecision(ctx, C_UOM_To_ID), 4)) != 0) {
                this.log.fine("Corrected QtyEntered Scale UOM=" + C_UOM_To_ID + "; QtyEntered=" + QtyEntered + "->" + QtyEntered1);
                QtyEntered = QtyEntered1;
                mTab.setValue("QtyEntered", (Object)QtyEntered);
            }
            if ((MovementQty = MUOMConversion.convertProductFrom(ctx, M_Product_ID, C_UOM_To_ID, QtyEntered)) == null) {
                MovementQty = QtyEntered;
            }
            boolean conversion = QtyEntered.compareTo(MovementQty) != 0;
            this.log.fine("UOM=" + C_UOM_To_ID + ", QtyEntered=" + QtyEntered + " -> " + conversion + " MovementQty=" + MovementQty);
            ctx.setContext(WindowNo, "UOMConversion", conversion ? "Y" : "N");
            mTab.setValue("MovementQty", (Object)MovementQty);
        } else if (ctx.getContextAsInt(WindowNo, "C_UOM_ID") == 0) {
            QtyEntered = (BigDecimal)mTab.getValue("QtyEntered");
            mTab.setValue("MovementQty", (Object)QtyEntered);
        } else if (mField.getColumnName().equals("QtyEntered")) {
            QtyEntered = (BigDecimal)value;
            C_UOM_To_ID = ctx.getContextAsInt(WindowNo, "C_UOM_ID");
            BigDecimal QtyEntered1 = QtyEntered.setScale(MUOM.getPrecision(ctx, C_UOM_To_ID), 4);
            if (QtyEntered.compareTo(QtyEntered1) != 0) {
                this.log.fine("Corrected QtyEntered Scale UOM=" + C_UOM_To_ID + "; QtyEntered=" + QtyEntered + "->" + QtyEntered1);
                QtyEntered = QtyEntered1;
                mTab.setValue("QtyEntered", (Object)QtyEntered);
            }
            if ((MovementQty = MUOMConversion.convertProductFrom(ctx, M_Product_ID, C_UOM_To_ID, QtyEntered)) == null) {
                MovementQty = QtyEntered;
            }
            boolean conversion = QtyEntered.compareTo(MovementQty) != 0;
            this.log.fine("UOM=" + C_UOM_To_ID + ", QtyEntered=" + QtyEntered + " -> " + conversion + " MovementQty=" + MovementQty);
            ctx.setContext(WindowNo, "UOMConversion", conversion ? "Y" : "N");
            mTab.setValue("MovementQty", (Object)MovementQty);
        } else if (mField.getColumnName().equals("MovementQty")) {
            C_UOM_To_ID = ctx.getContextAsInt(WindowNo, "C_UOM_ID");
            MovementQty = (BigDecimal)value;
            int precision = MProduct.get(ctx, M_Product_ID).getUOMPrecision();
            BigDecimal MovementQty1 = MovementQty.setScale(precision, 4);
            if (MovementQty.compareTo(MovementQty1) != 0) {
                this.log.fine("Corrected MovementQty " + MovementQty + "->" + MovementQty1);
                MovementQty = MovementQty1;
                mTab.setValue("MovementQty", (Object)MovementQty);
            }
            if ((QtyEntered = MUOMConversion.convertProductTo(ctx, M_Product_ID, C_UOM_To_ID, MovementQty)) == null) {
                QtyEntered = MovementQty;
            }
            boolean conversion = MovementQty.compareTo(QtyEntered) != 0;
            this.log.fine("UOM=" + C_UOM_To_ID + ", MovementQty=" + MovementQty + " -> " + conversion + " QtyEntered=" + QtyEntered);
            ctx.setContext(WindowNo, "UOMConversion", conversion ? "Y" : "N");
            mTab.setValue("QtyEntered", (Object)QtyEntered);
        }
        boolean isReturnTrx = "Y".equals(ctx.getContext(WindowNo, "IsReturnTrx"));
        if (M_Product_ID != 0 && isReturnTrx && (oLine = new MOrderLine(ctx, oLine_ID = (Integer)mTab.getValue("C_OrderLine_ID"), null)).get_ID() != 0 && (orig_IOLine_ID = Integer.valueOf(oLine.getOrig_InOutLine_ID())) != 0 && (shippedQty = (orig_IOLine = new MInOutLine(ctx, orig_IOLine_ID, null)).getMovementQty()).compareTo(MovementQty = (BigDecimal)mTab.getValue("MovementQty")) < 0) {
            if (ctx.isSOTrx(WindowNo)) {
                mTab.fireDataStatusEEvent("QtyShippedLessThanQtyReturned", shippedQty.toString(), false);
            } else {
                mTab.fireDataStatusEEvent("QtyReceivedLessThanQtyReturned", shippedQty.toString(), false);
            }
            mTab.setValue("MovementQty", (Object)shippedQty);
            MovementQty = shippedQty;
            int C_UOM_To_ID2 = ctx.getContextAsInt(WindowNo, "C_UOM_ID");
            QtyEntered = MUOMConversion.convertProductTo(ctx, M_Product_ID, C_UOM_To_ID2, MovementQty);
            if (QtyEntered == null) {
                QtyEntered = MovementQty;
            }
            mTab.setValue("QtyEntered", (Object)QtyEntered);
            mTab.setValue("MovementQty", (Object)MovementQty);
            this.log.fine("QtyEntered : " + QtyEntered.toString() + "MovementQty : " + MovementQty.toString());
        }
        CalloutInOut.setCalloutActive(false);
        return "";
    }

    public String asi(Ctx ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        int selectedM_Locator_ID;
        if (CalloutInOut.isCalloutActive()) {
            return "";
        }
        Integer M_ASI_ID = (Integer)value;
        if (M_ASI_ID == null || M_ASI_ID == 0) {
            return "";
        }
        CalloutInOut.setCalloutActive(true);
        int M_Product_ID = ctx.getContextAsInt(WindowNo, "M_Product_ID");
        int M_Warehouse_ID = ctx.getContextAsInt(WindowNo, "M_Warehouse_ID");
        int M_Locator_ID = ctx.getContextAsInt(WindowNo, "M_Locator_ID");
        this.log.fine("M_Product_ID=" + M_Product_ID + ", M_ASI_ID=" + M_ASI_ID + " - M_Warehouse_ID=" + M_Warehouse_ID + ", M_Locator_ID=" + M_Locator_ID);
        int M_AttributeSetInstance_ID = Env.getCtx().getContextAsInt(1113, 1113, "M_AttributeSetInstance_ID");
        if (M_ASI_ID == M_AttributeSetInstance_ID && (selectedM_Locator_ID = Env.getCtx().getContextAsInt(1113, 1113, "M_Locator_ID")) != 0) {
            this.log.fine("Selected M_Locator_ID=" + selectedM_Locator_ID);
            mTab.setValue("M_Locator_ID", (Object)new Integer(selectedM_Locator_ID));
        }
        CalloutInOut.setCalloutActive(false);
        return "";
    }
}

