/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.logging.Level;
import org.compiere.model.CalloutEngine;
import org.compiere.model.GridField;
import org.compiere.model.GridTab;
import org.compiere.model.MPayment;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.Ctx;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class CalloutPaymentAllocate
extends CalloutEngine {
    public String invoice(Ctx ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        Integer C_Invoice_ID = (Integer)value;
        if (CalloutPaymentAllocate.isCalloutActive() || C_Invoice_ID == null || C_Invoice_ID == 0) {
            return "";
        }
        int C_Payment_ID = ctx.getContextAsInt(WindowNo, "C_Payment_ID");
        MPayment payment = new MPayment(ctx, C_Payment_ID, null);
        if (payment.getC_Charge_ID() != 0 || payment.getC_Invoice_ID() != 0 || payment.getC_Order_ID() != 0) {
            return Msg.getMsg((Ctx)ctx, (String)"PaymentIsAllocated");
        }
        CalloutPaymentAllocate.setCalloutActive(true);
        mTab.setValue("DiscountAmt", (Object)Env.ZERO);
        mTab.setValue("WriteOffAmt", (Object)Env.ZERO);
        mTab.setValue("OverUnderAmt", (Object)Env.ZERO);
        int C_InvoicePaySchedule_ID = 0;
        if (ctx.getContextAsInt(1113, 1113, "C_Invoice_ID") == C_Invoice_ID.intValue() && ctx.getContextAsInt(1113, 1113, "C_InvoicePaySchedule_ID") != 0) {
            C_InvoicePaySchedule_ID = ctx.getContextAsInt(1113, 1113, "C_InvoicePaySchedule_ID");
        }
        Timestamp ts = new Timestamp(ctx.getContextAsTime(WindowNo, "DateTrx"));
        String sql = "SELECT C_BPartner_ID,C_Currency_ID, invoiceOpen(C_Invoice_ID, ?), invoiceDiscount(C_Invoice_ID,?,?), IsSOTrx FROM C_Invoice WHERE C_Invoice_ID=?";
        try {
            CPreparedStatement pstmt = DB.prepareStatement((String)sql, null);
            pstmt.setInt(1, C_InvoicePaySchedule_ID);
            pstmt.setTimestamp(2, ts);
            pstmt.setInt(3, C_InvoicePaySchedule_ID);
            pstmt.setInt(4, C_Invoice_ID);
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                BigDecimal DiscountAmt;
                BigDecimal InvoiceOpen = rs.getBigDecimal(3);
                if (InvoiceOpen == null) {
                    InvoiceOpen = Env.ZERO;
                }
                if ((DiscountAmt = rs.getBigDecimal(4)) == null) {
                    DiscountAmt = Env.ZERO;
                }
                mTab.setValue("InvoiceAmt", (Object)InvoiceOpen);
                mTab.setValue("Amount", (Object)InvoiceOpen.subtract(DiscountAmt));
                mTab.setValue("DiscountAmt", (Object)DiscountAmt);
                ctx.setContext(WindowNo, "C_Invoice_ID", C_Invoice_ID.toString());
                mTab.setValue("C_Invoice_ID", (Object)C_Invoice_ID);
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            this.log.log(Level.SEVERE, sql, (Throwable)e);
            CalloutPaymentAllocate.setCalloutActive(false);
            return e.getLocalizedMessage();
        }
        CalloutPaymentAllocate.setCalloutActive(false);
        return "";
    }

    public String amounts(Ctx ctx, int WindowNo, GridTab mTab, GridField mField, Object value, Object oldValue) {
        if (CalloutPaymentAllocate.isCalloutActive()) {
            return "";
        }
        int C_Invoice_ID = ctx.getContextAsInt(WindowNo, "C_Invoice_ID");
        if (C_Invoice_ID == 0) {
            return "";
        }
        CalloutPaymentAllocate.setCalloutActive(true);
        BigDecimal Amount = (BigDecimal)mTab.getValue("Amount");
        BigDecimal DiscountAmt = (BigDecimal)mTab.getValue("DiscountAmt");
        BigDecimal WriteOffAmt = (BigDecimal)mTab.getValue("WriteOffAmt");
        BigDecimal OverUnderAmt = (BigDecimal)mTab.getValue("OverUnderAmt");
        BigDecimal InvoiceAmt = (BigDecimal)mTab.getValue("InvoiceAmt");
        this.log.fine("Amt=" + Amount + ", Discount=" + DiscountAmt + ", WriteOff=" + WriteOffAmt + ", OverUnder=" + OverUnderAmt + ", Invoice=" + InvoiceAmt);
        String colName = mField.getColumnName();
        if (colName.equals("Amount")) {
            WriteOffAmt = InvoiceAmt.subtract(Amount).subtract(DiscountAmt).subtract(OverUnderAmt);
            mTab.setValue("WriteOffAmt", (Object)WriteOffAmt);
        } else {
            Amount = InvoiceAmt.subtract(DiscountAmt).subtract(WriteOffAmt).subtract(OverUnderAmt);
            mTab.setValue("Amount", (Object)Amount);
        }
        CalloutPaymentAllocate.setCalloutActive(false);
        return "";
    }
}

