/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.math.BigDecimal;
import java.sql.Timestamp;
import org.compiere.model.CalloutEngine;
import org.compiere.model.GridField;
import org.compiere.model.GridTab;
import org.compiere.model.MProductPricing;
import org.compiere.util.Ctx;
import org.compiere.util.Env;

public class CalloutProject
extends CalloutEngine {
    public String planned(Ctx ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        BigDecimal multiplier;
        String columnName;
        BigDecimal Discount;
        BigDecimal PriceList;
        BigDecimal PlannedPrice;
        if (CalloutProject.isCalloutActive() || value == null) {
            return "";
        }
        CalloutProject.setCalloutActive(true);
        int StdPrecision = ctx.getStdPrecision();
        BigDecimal PlannedQty = (BigDecimal)mTab.getValue("PlannedQty");
        if (PlannedQty == null) {
            PlannedQty = Env.ONE;
        }
        if ((PlannedPrice = (BigDecimal)mTab.getValue("PlannedPrice")) == null) {
            PlannedPrice = Env.ZERO;
        }
        if ((PriceList = (BigDecimal)mTab.getValue("PriceList")) == null) {
            PriceList = PlannedPrice;
        }
        if ((Discount = (BigDecimal)mTab.getValue("Discount")) == null) {
            Discount = Env.ZERO;
        }
        if ((columnName = mField.getColumnName()).equals("PlannedPrice")) {
            if (PriceList.signum() == 0) {
                Discount = Env.ZERO;
            } else {
                multiplier = PlannedPrice.multiply(Env.ONEHUNDRED).divide(PriceList, StdPrecision, 4);
                Discount = Env.ONEHUNDRED.subtract(multiplier);
            }
            mTab.setValue("Discount", (Object)Discount);
            this.log.fine("PriceList=" + PriceList + " - Discount=" + Discount + " -> [PlannedPrice=" + PlannedPrice + "] (Precision=" + StdPrecision + ")");
        } else if (columnName.equals("PriceList")) {
            if (PriceList.signum() == 0) {
                Discount = Env.ZERO;
            } else {
                multiplier = PlannedPrice.multiply(Env.ONEHUNDRED).divide(PriceList, StdPrecision, 4);
                Discount = Env.ONEHUNDRED.subtract(multiplier);
            }
            mTab.setValue("Discount", (Object)Discount);
            this.log.fine("[PriceList=" + PriceList + "] - Discount=" + Discount + " -> PlannedPrice=" + PlannedPrice + " (Precision=" + StdPrecision + ")");
        } else if (columnName.equals("Discount")) {
            multiplier = Discount.divide(Env.ONEHUNDRED, 10, 4);
            PlannedPrice = PriceList.multiply(multiplier = Env.ONE.subtract(multiplier));
            if (PlannedPrice.scale() > StdPrecision) {
                PlannedPrice = PlannedPrice.setScale(StdPrecision, 4);
            }
            mTab.setValue("PlannedPrice", (Object)PlannedPrice);
            this.log.fine("PriceList=" + PriceList + " - [Discount=" + Discount + "] -> PlannedPrice=" + PlannedPrice + " (Precision=" + StdPrecision + ")");
        }
        BigDecimal PlannedAmt = PlannedQty.multiply(PlannedPrice);
        if (PlannedAmt.scale() > StdPrecision) {
            PlannedAmt = PlannedAmt.setScale(StdPrecision, 4);
        }
        this.log.fine("PlannedQty=" + PlannedQty + " * PlannedPrice=" + PlannedPrice + " -> PlannedAmt=" + PlannedAmt + " (Precision=" + StdPrecision + ")");
        mTab.setValue("PlannedAmt", (Object)PlannedAmt);
        CalloutProject.setCalloutActive(false);
        return "";
    }

    public String product(Ctx ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        Integer M_Product_ID = (Integer)value;
        int M_PriceList_Version_ID = ctx.getContextAsInt(WindowNo, "M_PriceList_Version_ID");
        if (M_Product_ID == null || M_Product_ID == 0 || M_PriceList_Version_ID == 0) {
            return "";
        }
        CalloutProject.setCalloutActive(true);
        int C_BPartner_ID = ctx.getContextAsInt(WindowNo, "C_BPartner_ID");
        BigDecimal Qty = (BigDecimal)mTab.getValue("PlannedQty");
        boolean IsSOTrx = true;
        MProductPricing pp = new MProductPricing(ctx.getAD_Client_ID(), ctx.getAD_Org_ID(), M_Product_ID, C_BPartner_ID, Qty, IsSOTrx);
        pp.setM_PriceList_Version_ID(M_PriceList_Version_ID);
        Timestamp date = (Timestamp)mTab.getValue("PlannedDate");
        if (date == null && (date = (Timestamp)mTab.getValue("DateContract")) == null && (date = (Timestamp)mTab.getValue("DateFinish")) == null) {
            date = new Timestamp(System.currentTimeMillis());
        }
        pp.setPriceDate(date);
        BigDecimal PriceList = pp.getPriceList();
        mTab.setValue("PriceList", (Object)PriceList);
        BigDecimal PlannedPrice = pp.getPriceStd();
        mTab.setValue("PlannedPrice", (Object)PlannedPrice);
        BigDecimal Discount = pp.getDiscount();
        mTab.setValue("Discount", (Object)Discount);
        int curPrecision = 2;
        BigDecimal PlannedAmt = pp.getLineAmt(curPrecision);
        mTab.setValue("PlannedAmt", (Object)PlannedAmt);
        this.log.fine("PlannedQty=" + Qty + " * PlannedPrice=" + PlannedPrice + " -> PlannedAmt=" + PlannedAmt);
        return "";
    }
}

