/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.logging.Level;
import org.compiere.model.CalloutEngine;
import org.compiere.model.GridField;
import org.compiere.model.GridTab;
import org.compiere.model.MConversionRate;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.Ctx;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class CalloutTimeExpense
extends CalloutEngine {
    public String product(Ctx ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        Integer M_Product_ID = (Integer)value;
        if (M_Product_ID == null || M_Product_ID == 0) {
            return "";
        }
        CalloutTimeExpense.setCalloutActive(true);
        BigDecimal priceActual = null;
        Timestamp DateExpense = new Timestamp(ctx.getContextAsTime(WindowNo, "DateExpense"));
        String sql = null;
        try {
            Integer ii;
            Date plDate;
            boolean noPrice = true;
            sql = "SELECT bomPriceStd(p.M_Product_ID,pv.M_PriceList_Version_ID) AS PriceStd,bomPriceList(p.M_Product_ID,pv.M_PriceList_Version_ID) AS PriceList,bomPriceLimit(p.M_Product_ID,pv.M_PriceList_Version_ID) AS PriceLimit,p.C_UOM_ID,pv.ValidFrom,pl.C_Currency_ID FROM M_Product p, M_ProductPrice pp, M_PriceList pl, M_PriceList_Version pv WHERE p.M_Product_ID=pp.M_Product_ID AND pp.M_PriceList_Version_ID=pv.M_PriceList_Version_ID AND pv.M_PriceList_ID=pl.M_PriceList_ID AND pv.IsActive='Y' AND p.M_Product_ID=? AND pl.M_PriceList_ID=? ORDER BY pv.ValidFrom DESC";
            CPreparedStatement pstmt = DB.prepareStatement((String)sql, null);
            pstmt.setInt(1, M_Product_ID);
            pstmt.setInt(2, ctx.getContextAsInt(WindowNo, "M_PriceList_ID"));
            ResultSet rs = pstmt.executeQuery();
            while (rs.next() && noPrice) {
                plDate = rs.getTimestamp("ValidFrom");
                if (plDate != null && DateExpense.before((Timestamp)plDate)) continue;
                noPrice = false;
                priceActual = rs.getBigDecimal("PriceStd");
                if (priceActual == null) {
                    priceActual = rs.getBigDecimal("PriceList");
                }
                if (priceActual == null) {
                    priceActual = rs.getBigDecimal("PriceLimit");
                }
                ii = new Integer(rs.getInt("C_Currency_ID"));
                if (rs.wasNull()) continue;
                mTab.setValue("C_Currency_ID", (Object)ii);
            }
            rs.close();
            pstmt.close();
            if (noPrice) {
                sql = "SELECT bomPriceStd(p.M_Product_ID,pv.M_PriceList_Version_ID) AS PriceStd,bomPriceList(p.M_Product_ID,pv.M_PriceList_Version_ID) AS PriceList,bomPriceLimit(p.M_Product_ID,pv.M_PriceList_Version_ID) AS PriceLimit,p.C_UOM_ID,pv.ValidFrom,pl.C_Currency_ID FROM M_Product p, M_ProductPrice pp, M_PriceList pl, M_PriceList bpl, M_PriceList_Version pv WHERE p.M_Product_ID=pp.M_Product_ID AND pp.M_PriceList_Version_ID=pv.M_PriceList_Version_ID AND pv.M_PriceList_ID=bpl.M_PriceList_ID AND pv.IsActive='Y' AND bpl.M_PriceList_ID=pl.BasePriceList_ID AND p.M_Product_ID=? AND pl.M_PriceList_ID=? ORDER BY pv.ValidFrom DESC";
                pstmt = DB.prepareStatement((String)sql, null);
                pstmt.setInt(1, M_Product_ID);
                pstmt.setInt(2, ctx.getContextAsInt(WindowNo, "M_PriceList_ID"));
                rs = pstmt.executeQuery();
                while (rs.next() && noPrice) {
                    plDate = rs.getDate("ValidFrom");
                    if (plDate != null && DateExpense.before(plDate)) continue;
                    noPrice = false;
                    priceActual = rs.getBigDecimal("PriceStd");
                    if (priceActual == null) {
                        priceActual = rs.getBigDecimal("PriceList");
                    }
                    if (priceActual == null) {
                        priceActual = rs.getBigDecimal("PriceLimit");
                    }
                    ii = new Integer(rs.getInt("C_Currency_ID"));
                    if (rs.wasNull()) continue;
                    mTab.setValue("C_Currency_ID", (Object)ii);
                }
                rs.close();
                pstmt.close();
            }
        }
        catch (SQLException e) {
            this.log.log(Level.SEVERE, sql, (Throwable)e);
            CalloutTimeExpense.setCalloutActive(false);
            return e.getLocalizedMessage();
        }
        CalloutTimeExpense.setCalloutActive(false);
        if (priceActual == null) {
            priceActual = Env.ZERO;
        }
        mTab.setValue("ExpenseAmt", (Object)priceActual);
        return "";
    }

    public String amount(Ctx ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        if (CalloutTimeExpense.isCalloutActive()) {
            return "";
        }
        CalloutTimeExpense.setCalloutActive(true);
        BigDecimal ExpenseAmt = (BigDecimal)mTab.getValue("ExpenseAmt");
        Integer C_Currency_From_ID = (Integer)mTab.getValue("C_Currency_ID");
        int C_Currency_To_ID = ctx.getContextAsInt("$C_Currency_ID");
        Timestamp DateExpense = new Timestamp(ctx.getContextAsTime(WindowNo, "DateExpense"));
        this.log.fine("Amt=" + ExpenseAmt + ", C_Currency_ID=" + C_Currency_From_ID);
        BigDecimal ConvertedAmt = ExpenseAmt;
        if (!ConvertedAmt.equals(Env.ZERO) && C_Currency_To_ID != C_Currency_From_ID) {
            int AD_Client_ID = ctx.getContextAsInt(WindowNo, "AD_Client_ID");
            int AD_Org_ID = ctx.getContextAsInt(WindowNo, "AD_Org_ID");
            ConvertedAmt = MConversionRate.convert((Ctx)ctx, (BigDecimal)ConvertedAmt, (int)C_Currency_From_ID, (int)C_Currency_To_ID, (Timestamp)DateExpense, (int)0, (int)AD_Client_ID, (int)AD_Org_ID);
        }
        mTab.setValue("ConvertedAmt", (Object)ConvertedAmt);
        this.log.fine("= ConvertedAmt=" + ConvertedAmt);
        CalloutTimeExpense.setCalloutActive(false);
        return "";
    }
}

