/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.logging.Level;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import org.compiere.framework.PO;
import org.compiere.framework.PO_LOB;
import org.compiere.model.DataStatusEvent;
import org.compiere.model.DataStatusListener;
import org.compiere.model.GridField;
import org.compiere.model.MRole;
import org.compiere.model.MSession;
import org.compiere.model.MTable;
import org.compiere.swing.MSort;
import org.compiere.util.CLogMgt;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.Ctx;
import org.compiere.util.DB;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.SecureEngine;
import org.compiere.util.Util;
import org.compiere.util.ValueNamePair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GridTable
extends AbstractTableModel
implements Serializable {
    static CLogger log = CLogger.getCLogger((String)GridTable.class.getName());
    private Ctx m_ctx;
    private int m_AD_Table_ID;
    private String m_tableName = "";
    private int m_WindowNo;
    private int m_TabNo;
    private boolean m_withAccessControl;
    private boolean m_readOnly = true;
    private boolean m_deleteable = true;
    private int m_rowCount = 0;
    private boolean m_changed = false;
    private int m_rowChanged = -1;
    private boolean m_inserting = false;
    private int m_newRow = -1;
    private boolean m_open = false;
    private boolean m_compareDB = true;
    volatile ArrayList<Object[]> m_buffer = new ArrayList(100);
    volatile ArrayList<MSort> m_sort = new ArrayList(100);
    private Object[] m_rowData = null;
    private Object[] m_oldValue = null;
    Loader m_loader = null;
    ArrayList<GridField> m_fields = new ArrayList(30);
    ArrayList<Object> m_parameterSELECT = new ArrayList(5);
    ArrayList<Object> m_parameterWHERE = new ArrayList(5);
    String m_SQL;
    String m_SQL_Count;
    private String m_SQL_Select;
    private String m_whereClause = "";
    private String m_orderClause = "";
    private int m_maxRows = 0;
    private int m_indexKeyColumn = -1;
    private int m_indexColorColumn = -1;
    private int m_indexProcessedColumn = -1;
    private int m_indexActiveColumn = -1;
    private int m_indexClientColumn = -1;
    private int m_indexOrgColumn = -1;
    private VetoableChangeSupport m_vetoableChangeSupport = new VetoableChangeSupport(this);
    public static final String PROPERTY = "MTable-RowSave";
    public static final char SAVE_OK = 'O';
    public static final char SAVE_ERROR = 'E';
    public static final char SAVE_ACCESS = 'A';
    public static final char SAVE_MANDATORY = 'M';
    public static final char SAVE_ABORT = 'U';
    private ArrayList<String> m_createSqlColumn = new ArrayList();
    private ArrayList<String> m_createSqlValue = new ArrayList();
    private ArrayList<PO_LOB> m_lobInfo = null;

    public GridTable(Ctx ctx, int AD_Table_ID, String TableName, int WindowNo, int TabNo, boolean withAccessControl) {
        log.info(TableName);
        this.m_ctx = ctx;
        this.m_AD_Table_ID = AD_Table_ID;
        this.setTableName(TableName);
        this.m_WindowNo = WindowNo;
        this.m_TabNo = TabNo;
        this.m_withAccessControl = withAccessControl;
    }

    public void setTableName(String newTableName) {
        if (this.m_open) {
            log.log(Level.SEVERE, "Table already open - ignored");
            return;
        }
        if (newTableName == null || newTableName.length() == 0) {
            return;
        }
        this.m_tableName = newTableName;
    }

    public String getTableName() {
        return this.m_tableName;
    }

    public boolean setSelectWhereClause(String newWhereClause) {
        if (this.m_open) {
            log.log(Level.SEVERE, "Table already open - ignored");
            return false;
        }
        this.m_whereClause = newWhereClause;
        if (this.m_whereClause == null) {
            this.m_whereClause = "";
        }
        return true;
    }

    public String getSelectWhereClause() {
        return this.m_whereClause;
    }

    public void setOrderClause(String newOrderClause) {
        this.m_orderClause = newOrderClause;
        if (this.m_orderClause == null) {
            this.m_orderClause = "";
        }
    }

    public String getOrderClause() {
        return this.m_orderClause;
    }

    private String createSelectSql() {
        if (this.m_fields.size() == 0 || this.m_tableName == null || this.m_tableName.equals("")) {
            return "";
        }
        StringBuffer select = new StringBuffer("SELECT ");
        for (int i = 0; i < this.m_fields.size(); ++i) {
            if (i > 0) {
                select.append(",");
            }
            GridField field = this.m_fields.get(i);
            select.append(field.getColumnSQL(true));
        }
        select.append(" FROM ").append(this.m_tableName);
        this.m_SQL_Select = select.toString();
        this.m_SQL_Count = "SELECT COUNT(*) FROM " + this.m_tableName;
        StringBuffer m_SQL_Where = new StringBuffer("");
        if (this.m_whereClause.length() > 0) {
            m_SQL_Where.append(" WHERE ");
            if (this.m_whereClause.indexOf("@") == -1) {
                m_SQL_Where.append(this.m_whereClause);
            } else {
                m_SQL_Where.append(Env.parseContext((Ctx)this.m_ctx, (int)this.m_WindowNo, (String)this.m_whereClause, (boolean)false));
            }
            if (this.m_whereClause.toUpperCase().indexOf("=NULL") > 0) {
                log.severe("Invalid NULL - " + this.m_tableName + "=" + this.m_whereClause);
            }
        }
        this.m_SQL = this.m_SQL_Select + m_SQL_Where.toString();
        this.m_SQL_Count = this.m_SQL_Count + m_SQL_Where.toString();
        if (this.m_withAccessControl) {
            this.m_SQL = MRole.getDefault((Ctx)this.m_ctx, (boolean)false).addAccessSQL(this.m_SQL, this.m_tableName, true, false);
            this.m_SQL_Count = MRole.getDefault((Ctx)this.m_ctx, (boolean)false).addAccessSQL(this.m_SQL_Count, this.m_tableName, true, false);
        }
        if (!this.m_orderClause.equals("")) {
            this.m_SQL = this.m_SQL + " ORDER BY " + this.m_orderClause;
        }
        log.fine(this.m_SQL_Count);
        this.m_ctx.setContext(this.m_WindowNo, this.m_TabNo, "SQL", this.m_SQL);
        return this.m_SQL;
    }

    public void addField(GridField field) {
        log.fine("(" + this.m_tableName + ") - " + field.getColumnName());
        if (this.m_open) {
            log.log(Level.SEVERE, "Table already open - ignored: " + field.getColumnName());
            return;
        }
        if (!MRole.getDefault((Ctx)this.m_ctx, (boolean)false).isColumnAccess(this.m_AD_Table_ID, field.getAD_Column_ID(), true)) {
            log.fine("No Column Access " + field.getColumnName());
            return;
        }
        if (field.isKey()) {
            this.m_indexKeyColumn = this.m_fields.size();
        } else if (field.getColumnName().equals("IsActive")) {
            this.m_indexActiveColumn = this.m_fields.size();
        } else if (field.getColumnName().equals("Processed")) {
            this.m_indexProcessedColumn = this.m_fields.size();
        } else if (field.getColumnName().equals("AD_Client_ID")) {
            this.m_indexClientColumn = this.m_fields.size();
        } else if (field.getColumnName().equals("AD_Org_ID")) {
            this.m_indexOrgColumn = this.m_fields.size();
        }
        this.m_fields.add(field);
        this.fireTableStructureChanged();
    }

    @Override
    public String getColumnName(int index) {
        if (index < 0 || index > this.m_fields.size()) {
            log.log(Level.SEVERE, "Invalid index=" + index);
            return "";
        }
        GridField field = this.m_fields.get(index);
        return field.getColumnName();
    }

    @Override
    public int findColumn(String columnName) {
        for (int i = 0; i < this.m_fields.size(); ++i) {
            GridField field = this.m_fields.get(i);
            if (!columnName.equals(field.getColumnName())) continue;
            return i;
        }
        return -1;
    }

    @Override
    public Class<?> getColumnClass(int index) {
        if (index < 0 || index >= this.m_fields.size()) {
            log.log(Level.SEVERE, "Invalid index=" + index);
            return null;
        }
        GridField field = this.m_fields.get(index);
        return DisplayType.getClass((int)field.getDisplayType(), (boolean)false);
    }

    public void setParameterSELECT(int index, Object parameter) {
        if (index >= this.m_parameterSELECT.size()) {
            this.m_parameterSELECT.add(parameter);
        } else {
            this.m_parameterSELECT.set(index, parameter);
        }
    }

    public void setParameterWHERE(int index, Object parameter) {
        if (index >= this.m_parameterWHERE.size()) {
            this.m_parameterWHERE.add(parameter);
        } else {
            this.m_parameterWHERE.set(index, parameter);
        }
    }

    protected GridField getField(int index) {
        if (index < 0 || index >= this.m_fields.size()) {
            return null;
        }
        return this.m_fields.get(index);
    }

    protected GridField getField(String identifier) {
        if (identifier == null || identifier.length() == 0) {
            return null;
        }
        int cols = this.m_fields.size();
        for (int i = 0; i < cols; ++i) {
            GridField field = this.m_fields.get(i);
            if (!identifier.equalsIgnoreCase(field.getColumnName())) continue;
            return field;
        }
        return null;
    }

    public GridField[] getFields() {
        GridField[] retValue = new GridField[this.m_fields.size()];
        this.m_fields.toArray(retValue);
        return retValue;
    }

    public boolean open(int maxRows) {
        log.info("MaxRows=" + maxRows);
        this.m_maxRows = maxRows;
        if (this.m_open) {
            log.fine("already open");
            this.dataRefreshAll();
            return true;
        }
        this.createSelectSql();
        if (this.m_SQL == null || this.m_SQL.equals("")) {
            log.log(Level.SEVERE, "No SQL");
            return false;
        }
        this.m_loader = new Loader();
        this.m_rowCount = this.m_loader.open(maxRows);
        this.m_buffer = new ArrayList(this.m_rowCount + 10);
        this.m_sort = new ArrayList(this.m_rowCount + 10);
        if (this.m_rowCount > 0) {
            this.m_loader.start();
        } else {
            this.m_loader.close();
        }
        this.m_open = true;
        this.m_changed = false;
        this.m_rowChanged = -1;
        this.fireTableDataChanged();
        if (this.m_rowCount > 0) {
            MSession session = MSession.get((Ctx)this.m_ctx, (boolean)true);
            session.queryLog(this.m_ctx.getAD_Client_ID(), this.m_ctx.getAD_Org_ID(), this.m_AD_Table_ID, this.m_SQL_Count, this.m_rowCount);
        }
        return true;
    }

    public void loadComplete() {
        if (this.m_loader != null && this.m_loader.isAlive()) {
            try {
                this.m_loader.join();
            }
            catch (InterruptedException ie) {
                log.log(Level.SEVERE, "Join interrupted", (Throwable)ie);
            }
        }
        for (int i = 0; i < this.m_fields.size(); ++i) {
            GridField field = this.m_fields.get(i);
            field.lookupLoadComplete();
        }
    }

    public boolean isLoading() {
        return this.m_loader != null && this.m_loader.isAlive();
    }

    public boolean isOpen() {
        return this.m_open;
    }

    public void close(boolean finalCall) {
        if (!this.m_open) {
            return;
        }
        log.fine("final=" + finalCall);
        if (finalCall) {
            DataStatusListener[] evl = (DataStatusListener[])this.listenerList.getListeners(DataStatusListener.class);
            for (int i = 0; i < evl.length; ++i) {
                this.listenerList.remove(DataStatusListener.class, evl[i]);
            }
            TableModelListener[] ev2 = (TableModelListener[])this.listenerList.getListeners(TableModelListener.class);
            for (int i = 0; i < ev2.length; ++i) {
                this.listenerList.remove(TableModelListener.class, ev2[i]);
            }
            VetoableChangeListener[] vcl = this.m_vetoableChangeSupport.getVetoableChangeListeners();
            for (int i = 0; i < vcl.length; ++i) {
                this.m_vetoableChangeSupport.removeVetoableChangeListener(vcl[i]);
            }
        }
        while (this.m_loader != null && this.m_loader.isAlive()) {
            log.fine("Interrupting Loader ...");
            this.m_loader.interrupt();
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (!this.m_inserting) {
            this.dataSave(false);
        }
        if (this.m_buffer != null) {
            this.m_buffer.clear();
        }
        this.m_buffer = null;
        if (this.m_sort != null) {
            this.m_sort.clear();
        }
        this.m_sort = null;
        if (finalCall) {
            this.dispose();
        }
        log.fine("");
        this.m_open = false;
    }

    private void dispose() {
        for (int i = 0; i < this.m_fields.size(); ++i) {
            this.m_fields.get(i).dispose();
        }
        this.m_fields.clear();
        this.m_fields = null;
        this.m_vetoableChangeSupport = null;
        this.m_parameterSELECT.clear();
        this.m_parameterSELECT = null;
        this.m_parameterWHERE.clear();
        this.m_parameterWHERE = null;
        this.m_buffer = null;
        this.m_sort = null;
        this.m_rowData = null;
        this.m_oldValue = null;
        this.m_loader = null;
    }

    @Override
    public int getColumnCount() {
        return this.m_fields.size();
    }

    public int getFieldCount() {
        return this.m_fields.size();
    }

    @Override
    public int getRowCount() {
        return this.m_rowCount;
    }

    public void setColorColumn(String columnName) {
        this.m_indexColorColumn = this.findColumn(columnName);
    }

    public int getColorCode(int row) {
        if (this.m_indexColorColumn == -1) {
            return 0;
        }
        Object data = this.getValueAt(row, this.m_indexColorColumn);
        if (data == null || !(data instanceof BigDecimal)) {
            return 0;
        }
        BigDecimal bd = (BigDecimal)data;
        return bd.signum();
    }

    public void sort(int col, boolean ascending) {
        log.info("#" + col + " " + ascending);
        if (this.getRowCount() == 0) {
            return;
        }
        GridField field = this.getField(col);
        if (field.getDisplayType() == 26) {
            return;
        }
        boolean isLookup = DisplayType.isLookup((int)field.getDisplayType());
        boolean isASI = 35 == field.getDisplayType();
        for (int i = 0; i < this.m_sort.size(); ++i) {
            MSort sort = this.m_sort.get(i);
            Object[] rowData = this.m_buffer.get(sort.index);
            sort.data = rowData[col] == null ? null : (isLookup || isASI ? field.getLookup().getDisplay(rowData[col]) : rowData[col]);
        }
        log.info(field.toString() + " #" + this.m_sort.size());
        MSort sort = new MSort(0, null);
        sort.setSortAsc(ascending);
        Collections.sort(this.m_sort, sort);
        this.fireTableDataChanged();
        this.fireDataStatusIEvent("Sorted", "#" + this.m_sort.size());
    }

    public int getKeyID(int row) {
        if (this.m_indexKeyColumn != -1) {
            try {
                Integer ii = (Integer)this.getValueAt(row, this.m_indexKeyColumn);
                if (ii == null) {
                    return -1;
                }
                return ii;
            }
            catch (Exception e) {
                return -1;
            }
        }
        return -1;
    }

    public String getKeyColumnName() {
        if (this.m_indexKeyColumn != -1) {
            return this.getColumnName(this.m_indexKeyColumn);
        }
        return "";
    }

    @Override
    public Object getValueAt(int row, int col) {
        if (!this.m_open || row < 0 || col < 0 || row >= this.m_rowCount) {
            return null;
        }
        for (int loops = 0; row >= this.m_buffer.size() && this.m_loader.isAlive() && loops < 15; ++loops) {
            log.fine("Waiting for loader row=" + row + ", size=" + this.m_buffer.size());
            try {
                Thread.sleep(500L);
                continue;
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
        }
        if (row >= this.m_buffer.size()) {
            return null;
        }
        MSort sort = this.m_sort.get(row);
        Object[] rowData = this.m_buffer.get(sort.index);
        if (rowData == null || col > rowData.length) {
            return null;
        }
        return rowData[col];
    }

    public void setChanged(boolean changed) {
        if (!this.m_open || this.m_readOnly) {
            return;
        }
        this.m_changed = changed;
        if (!changed) {
            this.m_rowChanged = -1;
        }
        if (changed) {
            this.fireDataStatusIEvent("", "");
        }
    }

    @Override
    public final void setValueAt(Object value, int row, int col) {
        this.setValueAt(value, row, col, false);
    }

    public final void setValueAt(Object value, int row, int col, boolean force) {
        if (!this.m_open || this.m_readOnly || row < 0 || col < 0 || this.m_rowCount == 0) {
            log.finest("r=" + row + " c=" + col + " - R/O=" + this.m_readOnly + ", Rows=" + this.m_rowCount + " - Ignored");
            return;
        }
        this.dataSave(row, false);
        Object oldValue = this.getValueAt(row, col);
        if (!force && (oldValue == null && value == null || oldValue != null && oldValue.equals(value) || oldValue != null && value != null && oldValue.toString().equals(value.toString()) || oldValue == null && "".equals(value))) {
            log.finest("r=" + row + " c=" + col + " - New=" + value + "==Old=" + oldValue + " - Ignored");
            return;
        }
        log.fine("r=" + row + " c=" + col + " = " + value + " (" + oldValue + ")");
        this.m_oldValue = new Object[3];
        this.m_oldValue[0] = new Integer(row);
        this.m_oldValue[1] = new Integer(col);
        this.m_oldValue[2] = oldValue;
        MSort sort = this.m_sort.get(row);
        Object[] rowData = this.m_buffer.get(sort.index);
        this.m_rowChanged = row;
        if (this.m_rowData == null) {
            int size = this.m_fields.size();
            this.m_rowData = new Object[size];
            for (int i = 0; i < size; ++i) {
                this.m_rowData[i] = rowData[i];
            }
        }
        rowData[col] = value;
        this.m_buffer.set(sort.index, rowData);
        this.fireTableCellUpdated(row, col);
        GridField field = this.getField(col);
        field.setValue(value, this.m_inserting);
        DataStatusEvent evt = this.createDSE();
        evt.setChangedColumn(col, field.getColumnName());
        this.fireDataStatusChanged(evt);
    }

    public Object getOldValue(int row, int col) {
        if (this.m_oldValue == null) {
            return null;
        }
        if ((Integer)this.m_oldValue[0] == row && (Integer)this.m_oldValue[1] == col) {
            return this.m_oldValue[2];
        }
        return null;
    }

    public boolean needSave(boolean onlyRealChange) {
        return this.needSave(this.m_rowChanged, onlyRealChange);
    }

    public boolean needSave() {
        return this.needSave(this.m_rowChanged, false);
    }

    public boolean needSave(int newRow) {
        return this.needSave(newRow, false);
    }

    public boolean needSave(int newRow, boolean onlyRealChange) {
        log.fine("Row=" + newRow + ", Changed=" + this.m_rowChanged + "/" + this.m_changed);
        if (!this.m_changed && this.m_rowChanged == -1) {
            return false;
        }
        if (this.m_changed && this.m_rowChanged == -1 && onlyRealChange) {
            return false;
        }
        return newRow != this.m_rowChanged;
    }

    public boolean dataSave(int newRow, boolean manualCmd) {
        log.fine("Row=" + newRow + ", Changed=" + this.m_rowChanged + "/" + this.m_changed);
        if (!this.m_changed && this.m_rowChanged == -1) {
            return true;
        }
        if (newRow == this.m_rowChanged) {
            return true;
        }
        return this.dataSave(manualCmd) == 'O';
    }

    public char dataSave(boolean manualCmd) {
        if (!this.m_open) {
            log.warning("Error - Open=" + this.m_open);
            return 'E';
        }
        if (this.m_rowChanged == -1) {
            log.config("NoNeed - Changed=" + this.m_changed + ", Row=" + this.m_rowChanged);
            if (!manualCmd) {
                return 'O';
            }
        }
        if (this.m_rowData == null) {
            log.fine("No Changes");
            return 'E';
        }
        if (this.m_readOnly) {
            log.warning("IsReadOnly - ignored");
            this.dataIgnore();
            return 'A';
        }
        if (this.m_rowChanged == -1) {
            if (this.m_newRow != -1) {
                this.m_rowChanged = this.m_newRow;
            } else {
                this.fireDataStatusEEvent("SaveErrorNoChange", "", false);
                return 'E';
            }
        }
        int[] co = this.getClientOrg(this.m_rowChanged);
        int AD_Client_ID = co[0];
        int AD_Org_ID = co[1];
        boolean createError = true;
        if (!MRole.getDefault((Ctx)this.m_ctx, (boolean)false).canUpdate(AD_Client_ID, AD_Org_ID, this.m_AD_Table_ID, 0, createError)) {
            this.fireDataStatusEEvent(CLogger.retrieveError());
            this.dataIgnore();
            return 'A';
        }
        log.info("Row=" + this.m_rowChanged);
        try {
            if (!manualCmd) {
                this.m_vetoableChangeSupport.fireVetoableChange(PROPERTY, 0, this.m_rowChanged);
            }
        }
        catch (PropertyVetoException pve) {
            log.warning(pve.getMessage());
            this.dataIgnore();
            return 'U';
        }
        MSort sort = this.m_sort.get(this.m_rowChanged);
        Object[] rowData = this.m_buffer.get(sort.index);
        String missingColumns = this.getMandatory(rowData);
        if (missingColumns.length() != 0) {
            this.fireDataStatusEEvent("FillMandatory", missingColumns + "\n", true);
            return 'M';
        }
        String errorColumns = this.getErrorColumns();
        if (errorColumns.length() != 0) {
            this.fireDataStatusEEvent("Error", errorColumns + "\n", true);
            return 'E';
        }
        int Record_ID = 0;
        if (!this.m_inserting) {
            Record_ID = this.getKeyID(this.m_rowChanged);
        }
        try {
            if (!this.m_tableName.endsWith("_Trl")) {
                return this.dataSavePO(Record_ID);
            }
        }
        catch (Exception e) {
            if (e instanceof ClassNotFoundException) {
                log.warning(this.m_tableName + " - " + e.getLocalizedMessage());
            }
            log.log(Level.SEVERE, "Persistency Issue - " + this.m_tableName + ": " + e.getLocalizedMessage(), (Throwable)e);
            return 'E';
        }
        log.info("NonPO");
        boolean error = false;
        this.lobReset();
        String is = null;
        String ERROR = "ERROR: ";
        String INFO = "Info: ";
        StringBuffer select = new StringBuffer("SELECT ");
        for (int i = 0; i < this.m_fields.size(); ++i) {
            GridField field = this.m_fields.get(i);
            if (this.m_inserting && field.isVirtualColumn()) continue;
            if (i > 0) {
                select.append(",");
            }
            select.append(field.getColumnSQL(true));
        }
        select.append(" FROM ").append(this.m_tableName);
        StringBuffer singleRowWHERE = new StringBuffer();
        StringBuffer multiRowWHERE = new StringBuffer();
        if (this.m_inserting) {
            select.append(" WHERE 1=2");
        } else {
            select.append(" WHERE ").append(this.getWhereClause(rowData));
        }
        CPreparedStatement pstmt = null;
        try {
            String sql;
            boolean manualUpdate;
            pstmt = DB.prepareStatement((String)select.toString(), (int)1005, (int)1008, null);
            ResultSet rs = pstmt.executeQuery();
            if (!this.m_inserting && !rs.next()) {
                rs.close();
                pstmt.close();
                this.fireDataStatusEEvent("SaveErrorRowNotFound", "", true);
                this.dataRefresh(this.m_rowChanged);
                return 'E';
            }
            Object[] rowDataDB = null;
            boolean bl = manualUpdate = 1007 == rs.getConcurrency();
            if (DB.isRemoteObjects()) {
                manualUpdate = true;
            }
            if (manualUpdate) {
                this.createUpdateSqlReset();
            }
            if (this.m_inserting) {
                if (manualUpdate) {
                    log.fine("Prepare inserting ... manual");
                } else {
                    log.fine("Prepare inserting ... RowSet");
                    rs.moveToInsertRow();
                }
            } else {
                log.fine("Prepare updating ... manual=" + manualUpdate);
                rowDataDB = this.readData(rs);
            }
            Timestamp now = new Timestamp(System.currentTimeMillis());
            int user = this.m_ctx.getAD_User_ID();
            int size = this.m_fields.size();
            int colRs = 1;
            for (int col = 0; col < size; ++col) {
                GridField field = this.m_fields.get(col);
                if (field.isVirtualColumn()) {
                    if (this.m_inserting) continue;
                    ++colRs;
                    continue;
                }
                String columnName = field.getColumnName();
                if (field.getDisplayType() != 26 && !field.isVirtualColumn()) {
                    if (field.isKey() && this.m_inserting) {
                        if (columnName.endsWith("_ID") || columnName.toUpperCase().endsWith("_ID")) {
                            int insertID = DB.getNextID((Ctx)this.m_ctx, (String)this.m_tableName, null);
                            if (manualUpdate) {
                                this.createUpdateSql(columnName, String.valueOf(insertID));
                            } else {
                                rs.updateInt(colRs, insertID);
                            }
                            singleRowWHERE.append(columnName).append("=").append(insertID);
                            is = "Info: " + columnName + " -> " + insertID + " (Key)";
                        } else {
                            String str = rowData[col].toString();
                            if (manualUpdate) {
                                this.createUpdateSql(columnName, DB.TO_STRING((String)str));
                            } else {
                                rs.updateString(colRs, str);
                            }
                            singleRowWHERE = new StringBuffer();
                            singleRowWHERE.append(columnName).append("=").append(DB.TO_STRING((String)str));
                            is = "Info: " + columnName + " -> " + str + " (StringKey)";
                        }
                        log.fine(is);
                    } else if (columnName.equals("DocumentNo")) {
                        boolean newDocNo = false;
                        String docNo = (String)rowData[col];
                        if (docNo == null || docNo.length() == 0) {
                            newDocNo = true;
                        } else if (docNo.startsWith("<") && docNo.endsWith(">")) {
                            newDocNo = true;
                        }
                        if (newDocNo || this.m_inserting) {
                            String insertDoc = null;
                            if (this.m_inserting) {
                                insertDoc = DB.getDocumentNo((Ctx)this.m_ctx, (int)this.m_WindowNo, (String)this.m_tableName, (boolean)true, null);
                            }
                            log.fine("DocumentNo entered=" + docNo + ", DocTypeInsert=" + insertDoc + ", newDocNo=" + newDocNo);
                            if (insertDoc == null || insertDoc.length() == 0) {
                                insertDoc = !newDocNo && docNo != null && docNo.length() > 0 ? docNo : DB.getDocumentNo((Ctx)this.m_ctx, (int)this.m_WindowNo, (String)this.m_tableName, (boolean)false, null);
                            }
                            if (insertDoc == null || insertDoc.length() == 0) {
                                if (docNo != null && docNo.length() != 0) {
                                    insertDoc = (String)rowData[col];
                                } else {
                                    error = true;
                                    is = "ERROR: " + field.getColumnName() + "= " + rowData[col] + " NO DocumentNo";
                                    log.fine(is);
                                    break;
                                }
                            }
                            if (manualUpdate) {
                                this.createUpdateSql(columnName, DB.TO_STRING((String)insertDoc));
                            } else {
                                rs.updateString(colRs, insertDoc);
                            }
                            is = "Info: " + columnName + " -> " + insertDoc + " (DocNo)";
                            log.fine(is);
                        }
                    } else if (columnName.equals("Value") && this.m_inserting) {
                        String value = (String)rowData[col];
                        if (!(value != null && value.length() != 0 || (value = DB.getDocumentNo((Ctx)this.m_ctx, (int)this.m_WindowNo, (String)this.m_tableName, (boolean)false, null)) != null && value.length() != 0)) {
                            error = true;
                            is = "ERROR: " + field.getColumnName() + "= " + rowData[col] + " No Value";
                            log.fine(is);
                            break;
                        }
                        if (manualUpdate) {
                            this.createUpdateSql(columnName, DB.TO_STRING((String)value));
                        } else {
                            rs.updateString(colRs, value);
                        }
                        is = "Info: " + columnName + " -> " + value + " (Value)";
                        log.fine(is);
                    } else if (columnName.equals("Updated")) {
                        if (this.m_compareDB && !this.m_inserting && !this.m_rowData[col].equals(rowDataDB[col])) {
                            error = true;
                            is = "ERROR: " + field.getColumnName() + "= " + this.m_rowData[col] + " != DB: " + rowDataDB[col];
                            log.fine(is);
                            break;
                        }
                        if (manualUpdate) {
                            this.createUpdateSql(columnName, DB.TO_DATE((Timestamp)now, (boolean)false));
                        } else {
                            rs.updateTimestamp(colRs, now);
                        }
                        is = "Info: Updated/By -> " + now + " - " + user;
                        log.fine(is);
                    } else if (columnName.equals("UpdatedBy")) {
                        if (manualUpdate) {
                            this.createUpdateSql(columnName, String.valueOf(user));
                        } else {
                            rs.updateInt(colRs, user);
                        }
                    } else if (this.m_inserting && columnName.equals("Created")) {
                        if (manualUpdate) {
                            this.createUpdateSql(columnName, DB.TO_DATE((Timestamp)now, (boolean)false));
                        } else {
                            rs.updateTimestamp(colRs, now);
                        }
                    } else if (this.m_inserting && columnName.equals("CreatedBy")) {
                        if (manualUpdate) {
                            this.createUpdateSql(columnName, String.valueOf(user));
                        } else {
                            rs.updateInt(colRs, user);
                        }
                    } else if (this.m_rowData[col] == null && rowData[col] == null) {
                        if (this.m_inserting) {
                            if (manualUpdate) {
                                this.createUpdateSql(columnName, "NULL");
                            } else {
                                rs.updateNull(colRs);
                            }
                            is = "Info: " + columnName + "= NULL";
                            log.fine(is);
                        }
                    } else if (this.m_inserting || !Util.isEqual((Object)this.m_rowData[col], (Object)rowData[col])) {
                        if (this.m_inserting || !this.m_compareDB || Util.isEqual((Object)this.m_rowData[col], (Object)rowDataDB[col])) {
                            if (CLogMgt.isLevelFinest()) {
                                log.fine(columnName + "=" + rowData[col] + " " + (rowData[col] == null ? "" : rowData[col].getClass().getName()));
                            }
                            boolean encrypted = field.isEncryptedColumn();
                            String type = "String";
                            if (rowData[col] == null) {
                                if (manualUpdate) {
                                    this.createUpdateSql(columnName, "NULL");
                                } else {
                                    rs.updateNull(colRs);
                                }
                            } else if (DisplayType.isID((int)field.getDisplayType()) || field.getDisplayType() == 11) {
                                try {
                                    Object dd = rowData[col];
                                    Integer iii = null;
                                    iii = dd instanceof Integer ? (Integer)dd : new Integer(dd.toString());
                                    if (encrypted) {
                                        iii = (Integer)this.encrypt(iii);
                                    }
                                    if (manualUpdate) {
                                        this.createUpdateSql(columnName, String.valueOf(iii));
                                    } else {
                                        rs.updateInt(colRs, (int)iii);
                                    }
                                }
                                catch (Exception e) {
                                    if (manualUpdate) {
                                        this.createUpdateSql(columnName, DB.TO_STRING((String)rowData[col].toString()));
                                    }
                                    rs.updateString(colRs, rowData[col].toString());
                                }
                                type = "Int";
                            } else if (DisplayType.isNumeric((int)field.getDisplayType())) {
                                BigDecimal bd = (BigDecimal)rowData[col];
                                if (encrypted) {
                                    bd = (BigDecimal)this.encrypt(bd);
                                }
                                if (manualUpdate) {
                                    this.createUpdateSql(columnName, bd.toString());
                                } else {
                                    rs.updateBigDecimal(colRs, bd);
                                }
                                type = "Number";
                            } else if (DisplayType.isDate((int)field.getDisplayType())) {
                                Timestamp ts = (Timestamp)rowData[col];
                                if (encrypted) {
                                    ts = (Timestamp)this.encrypt(ts);
                                }
                                if (manualUpdate) {
                                    this.createUpdateSql(columnName, DB.TO_DATE((Timestamp)ts, (boolean)false));
                                } else {
                                    rs.updateTimestamp(colRs, ts);
                                }
                                type = "Date";
                            } else if (field.getDisplayType() == 36) {
                                PO_LOB lob = new PO_LOB(this.getTableName(), columnName, null, field.getDisplayType(), rowData[col]);
                                this.lobAdd(lob);
                                type = "CLOB";
                            } else if (field.getDisplayType() == 23 || field.getDisplayType() == 32) {
                                PO_LOB lob = new PO_LOB(this.getTableName(), columnName, null, field.getDisplayType(), rowData[col]);
                                this.lobAdd(lob);
                                type = "BLOB";
                            } else if (field.getDisplayType() == 20) {
                                String yn = null;
                                if (rowData[col] instanceof Boolean) {
                                    Boolean bb = (Boolean)rowData[col];
                                    yn = bb != false ? "Y" : "N";
                                } else {
                                    String string = yn = "Y".equals(rowData[col]) ? "Y" : "N";
                                }
                                if (encrypted) {
                                    // empty if block
                                }
                                if (manualUpdate) {
                                    this.createUpdateSql(columnName, DB.TO_STRING((String)yn));
                                } else {
                                    rs.updateString(colRs, yn);
                                }
                            } else {
                                String str = rowData[col].toString();
                                if (encrypted) {
                                    str = (String)this.encrypt(str);
                                }
                                if (manualUpdate) {
                                    this.createUpdateSql(columnName, DB.TO_STRING((String)str));
                                } else {
                                    rs.updateString(colRs, str);
                                }
                            }
                            is = "Info: " + columnName + "= " + this.m_rowData[col] + " -> " + rowData[col] + " (" + type + ")";
                            if (encrypted) {
                                is = is + " encrypted";
                            }
                            log.fine(is);
                        } else {
                            error = true;
                            is = "ERROR: " + field.getColumnName() + "= " + this.m_rowData[col] + " != DB: " + rowDataDB[col] + " -> " + rowData[col];
                            log.fine(is);
                            Object o1 = this.m_rowData[col];
                            Object o2 = rowDataDB[col];
                            boolean eq = o1.equals(o2);
                            log.fine((o1 == o2) + "  " + eq);
                        }
                    }
                }
                if (field.isKey() && !this.m_inserting) {
                    if (rowData[col] == null) {
                        throw new RuntimeException("Key is NULL - " + columnName);
                    }
                    if (columnName.endsWith("_ID")) {
                        singleRowWHERE.append(columnName).append("=").append(rowData[col]);
                    } else {
                        singleRowWHERE = new StringBuffer();
                        singleRowWHERE.append(columnName).append("=").append(DB.TO_STRING((String)rowData[col].toString()));
                    }
                }
                if (field.isParentColumn()) {
                    if (rowData[col] == null) {
                        throw new RuntimeException("MultiKey Parent is NULL - " + columnName);
                    }
                    if (multiRowWHERE.length() != 0) {
                        multiRowWHERE.append(" AND ");
                    }
                    if (columnName.endsWith("_ID")) {
                        multiRowWHERE.append(columnName).append("=").append(rowData[col]);
                    } else {
                        multiRowWHERE.append(columnName).append("=").append(DB.TO_STRING((String)rowData[col].toString()));
                    }
                }
                ++colRs;
            }
            if (error) {
                if (manualUpdate) {
                    this.createUpdateSqlReset();
                } else {
                    rs.cancelRowUpdates();
                }
                rs.close();
                pstmt.close();
                this.fireDataStatusEEvent("SaveErrorDataChanged", "", true);
                this.dataRefresh(this.m_rowChanged);
                return 'E';
            }
            String whereClause = singleRowWHERE.toString();
            if (whereClause.length() == 0) {
                whereClause = multiRowWHERE.toString();
            }
            if (this.m_inserting) {
                log.fine("Inserting ...");
                if (manualUpdate) {
                    sql = this.createUpdateSql(true, null);
                    int no = DB.executeUpdateEx((String)sql, null);
                    if (no != 1) {
                        log.log(Level.SEVERE, "Insert #=" + no + " - " + sql);
                    }
                } else {
                    rs.insertRow();
                }
            } else {
                log.fine("Updating ... " + whereClause);
                if (manualUpdate) {
                    sql = this.createUpdateSql(false, whereClause);
                    int no = DB.executeUpdateEx((String)sql, null);
                    if (no != 1) {
                        log.log(Level.SEVERE, "Update #=" + no + " - " + sql);
                    }
                } else {
                    rs.updateRow();
                }
            }
            log.fine("Committing ...");
            DB.commit((boolean)true, null);
            this.lobSave(whereClause);
            rs.close();
            pstmt.close();
            log.fine("Reading ... " + whereClause);
            StringBuffer refreshSQL = new StringBuffer(this.m_SQL_Select).append(" WHERE ").append(whereClause);
            pstmt = DB.prepareStatement((String)refreshSQL.toString(), null);
            rs = pstmt.executeQuery();
            if (rs.next()) {
                rowDataDB = this.readData(rs);
                this.m_buffer.set(sort.index, rowDataDB);
                this.fireTableRowsUpdated(this.m_rowChanged, this.m_rowChanged);
            } else {
                log.log(Level.SEVERE, "Inserted row not found");
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (SQLException e) {
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
                pstmt = null;
            }
            catch (Exception ex) {
                // empty catch block
            }
            String msg = "SaveError";
            if (e.getErrorCode() == 1) {
                log.log(Level.SEVERE, "Key Not Unique", (Throwable)e);
                msg = "SaveErrorNotUnique";
            } else {
                log.log(Level.SEVERE, select.toString(), (Throwable)e);
            }
            this.fireDataStatusEEvent(msg, e.getLocalizedMessage(), true);
            return 'E';
        }
        this.m_rowData = null;
        this.m_changed = false;
        this.m_compareDB = true;
        this.m_rowChanged = -1;
        this.m_newRow = -1;
        this.m_inserting = false;
        this.fireDataStatusIEvent("Saved", "");
        log.info("fini");
        return 'O';
    }

    private char dataSavePO(int Record_ID) throws Exception {
        String msg;
        log.fine("ID=" + Record_ID);
        MSort sort = this.m_sort.get(this.m_rowChanged);
        Object[] rowData = this.m_buffer.get(sort.index);
        MTable table = MTable.get((Ctx)this.m_ctx, (int)this.m_AD_Table_ID);
        PO po = null;
        po = table.isSingleKey() || Record_ID == 0 ? table.getPO(this.m_ctx, Record_ID, null) : table.getPO(this.m_ctx, this.getWhereClause(rowData), null);
        if (po == null) {
            throw new ClassNotFoundException("No Persistent Object");
        }
        int size = this.m_fields.size();
        for (int col = 0; col < size; ++col) {
            GridField field = this.m_fields.get(col);
            if (field.isVirtualColumn()) continue;
            String columnName = field.getColumnName();
            Object value = rowData[col];
            Object oldValue = this.m_rowData[col];
            if (field.getDisplayType() == 26 || oldValue == null && value == null || !this.m_inserting && Util.isEqual((Object)oldValue, (Object)value)) continue;
            int poIndex = po.get_ColumnIndex(columnName);
            if (poIndex < 0) {
                po.set_CustomColumn(columnName, value);
                continue;
            }
            Object dbValue = po.get_Value(poIndex);
            if (this.m_inserting || !this.m_compareDB || Util.isEqual((Object)oldValue, (Object)dbValue) || Util.isEqual((Object)value, (Object)dbValue)) {
                po.set_ValueNoCheck(columnName, value);
                continue;
            }
            String msg2 = columnName + "= " + oldValue + (oldValue == null ? "" : "(" + oldValue.getClass().getName() + ")") + " != DB: " + dbValue + (dbValue == null ? "" : "(" + dbValue.getClass().getName() + ")") + " -> New: " + value + (value == null ? "" : "(" + value.getClass().getName() + ")");
            this.fireDataStatusEEvent("SaveErrorDataChanged", msg2, true);
            this.dataRefresh(this.m_rowChanged);
            return 'E';
        }
        if (!po.save()) {
            String msg3 = "SaveError";
            String info = "";
            ValueNamePair ppE = CLogger.retrieveError();
            if (ppE != null) {
                msg3 = ppE.getValue();
                info = ppE.getName();
                Exception ex = CLogger.retrieveException();
                if (ex != null && ex instanceof SQLException && ((SQLException)ex).getErrorCode() == 1) {
                    msg3 = "SaveErrorNotUnique";
                }
            }
            this.fireDataStatusEEvent(msg3, info, true);
            return 'E';
        }
        String whereClause = po.get_WhereClause(true);
        log.fine("Reading ... " + whereClause);
        StringBuffer refreshSQL = new StringBuffer(this.m_SQL_Select).append(" WHERE ").append(whereClause);
        CPreparedStatement pstmt = DB.prepareStatement((String)refreshSQL.toString(), null);
        try {
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                Object[] rowDataDB = this.readData(rs);
                this.m_buffer.set(sort.index, rowDataDB);
                this.fireTableRowsUpdated(this.m_rowChanged, this.m_rowChanged);
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (SQLException e) {
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
                pstmt = null;
            }
            catch (Exception ex) {
                // empty catch block
            }
            msg = "SaveError";
            log.log(Level.SEVERE, refreshSQL.toString(), (Throwable)e);
            this.fireDataStatusEEvent(msg, e.getLocalizedMessage(), true);
            return 'E';
        }
        this.m_rowData = null;
        this.m_changed = false;
        this.m_compareDB = true;
        this.m_rowChanged = -1;
        this.m_newRow = -1;
        this.m_inserting = false;
        ValueNamePair pp = CLogger.retrieveWarning();
        if (pp != null) {
            msg = pp.getValue();
            String info = pp.getName();
            this.fireDataStatusEEvent(msg, info, false);
        } else {
            pp = CLogger.retrieveInfo();
            msg = "Saved";
            String info = "";
            if (pp != null) {
                msg = pp.getValue();
                info = pp.getName();
            }
            this.fireDataStatusIEvent(msg, info);
        }
        log.config("fini");
        return 'O';
    }

    private String getWhereClause(Object[] rowData) {
        int size = this.m_fields.size();
        StringBuffer singleRowWHERE = null;
        StringBuffer multiRowWHERE = null;
        for (int col = 0; col < size; ++col) {
            Object value;
            String columnName;
            GridField field = this.m_fields.get(col);
            if (field.isKey()) {
                columnName = field.getColumnName();
                value = rowData[col];
                if (value == null) {
                    log.log(Level.WARNING, "PK data is null - " + columnName);
                    return null;
                }
                if (columnName.endsWith("_ID")) {
                    singleRowWHERE = new StringBuffer(columnName).append("=").append(value);
                    continue;
                }
                singleRowWHERE = new StringBuffer(columnName).append("=").append(DB.TO_STRING((String)value.toString()));
                continue;
            }
            if (!field.isParentColumn()) continue;
            columnName = field.getColumnName();
            value = rowData[col];
            if (value == null) {
                log.log(Level.INFO, "FK data is null - " + columnName);
                continue;
            }
            if (multiRowWHERE == null) {
                multiRowWHERE = new StringBuffer();
            } else {
                multiRowWHERE.append(" AND ");
            }
            if (columnName.endsWith("_ID")) {
                multiRowWHERE.append(columnName).append("=").append(value);
                continue;
            }
            multiRowWHERE.append(columnName).append("=").append(DB.TO_STRING((String)value.toString()));
        }
        if (singleRowWHERE != null) {
            return singleRowWHERE.toString();
        }
        if (multiRowWHERE != null) {
            return multiRowWHERE.toString();
        }
        log.log(Level.WARNING, "No key Found");
        return null;
    }

    private void createUpdateSql(String columnName, String value) {
        this.m_createSqlColumn.add(columnName);
        this.m_createSqlValue.add(value);
        log.finest("#" + this.m_createSqlColumn.size() + " - " + columnName + "=" + value);
    }

    private String createUpdateSql(boolean insert, String whereClause) {
        StringBuffer sb = new StringBuffer();
        if (insert) {
            int i;
            sb.append("INSERT INTO ").append(this.m_tableName).append(" (");
            for (i = 0; i < this.m_createSqlColumn.size(); ++i) {
                if (i != 0) {
                    sb.append(",");
                }
                sb.append(this.m_createSqlColumn.get(i));
            }
            sb.append(") VALUES ( ");
            for (i = 0; i < this.m_createSqlValue.size(); ++i) {
                if (i != 0) {
                    sb.append(",");
                }
                sb.append(this.m_createSqlValue.get(i));
            }
            sb.append(")");
        } else {
            sb.append("UPDATE ").append(this.m_tableName).append(" SET ");
            for (int i = 0; i < this.m_createSqlColumn.size(); ++i) {
                if (i != 0) {
                    sb.append(",");
                }
                sb.append(this.m_createSqlColumn.get(i)).append("=").append(this.m_createSqlValue.get(i));
            }
            sb.append(" WHERE ").append(whereClause);
        }
        log.fine(sb.toString());
        this.createUpdateSqlReset();
        return sb.toString();
    }

    private void createUpdateSqlReset() {
        this.m_createSqlColumn = new ArrayList();
        this.m_createSqlValue = new ArrayList();
    }

    private String getMandatory(Object[] rowData) {
        StringBuffer sb = new StringBuffer();
        int size = this.m_fields.size();
        for (int i = 0; i < size; ++i) {
            GridField field = this.m_fields.get(i);
            if (!field.isMandatory(true) || rowData[i] != null && rowData[i].toString().length() != 0) continue;
            field.setInserting(true);
            field.setError(true);
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(field.getHeader());
        }
        if (sb.length() == 0) {
            return "";
        }
        return sb.toString();
    }

    private String getErrorColumns() {
        StringBuffer sb = new StringBuffer();
        int size = this.m_fields.size();
        for (int i = 0; i < size; ++i) {
            GridField field = this.m_fields.get(i);
            if (!field.isError()) continue;
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(field.getHeader());
        }
        if (sb.length() == 0) {
            return "";
        }
        return sb.toString();
    }

    private void lobReset() {
        this.m_lobInfo = null;
    }

    private void lobAdd(PO_LOB lob) {
        log.fine("LOB=" + lob);
        if (this.m_lobInfo == null) {
            this.m_lobInfo = new ArrayList();
        }
        this.m_lobInfo.add(lob);
    }

    private void lobSave(String whereClause) {
        if (this.m_lobInfo == null) {
            return;
        }
        for (int i = 0; i < this.m_lobInfo.size(); ++i) {
            PO_LOB lob = this.m_lobInfo.get(i);
            lob.save(whereClause, null);
        }
        this.lobReset();
    }

    public boolean dataNew(int currentRow, boolean copyCurrent) {
        MSort sort;
        log.info("Current=" + currentRow + ", Copy=" + copyCurrent);
        if (this.m_readOnly) {
            this.fireDataStatusEEvent("AccessCannotInsert", "", true);
            return false;
        }
        this.dataSave(-2, false);
        this.m_inserting = true;
        int size = this.m_fields.size();
        this.m_rowData = new Object[size];
        Object[] rowData = new Object[size];
        if (copyCurrent) {
            sort = this.m_sort.get(currentRow);
            Object[] origData = this.m_buffer.get(sort.index);
            for (int i = 0; i < size; ++i) {
                GridField field = this.m_fields.get(i);
                String columnName = field.getColumnName();
                if (field.isVirtualColumn()) continue;
                if (field.isKey() || columnName.equals("AD_Client_ID") || columnName.startsWith("Created") || columnName.startsWith("Updated") || columnName.equals("EntityType") || columnName.equals("DocumentNo") || columnName.equals("Processed") || columnName.equals("IsSelfService") || columnName.equals("DocAction") || columnName.equals("DocStatus") || columnName.startsWith("Ref_") || columnName.equals("Posted") || columnName.equals("GrandTotal") || columnName.equals("TotalLines") || columnName.equals("C_CashLine_ID") || columnName.equals("C_Payment_ID") || columnName.equals("IsPaid") || columnName.equals("IsAllocated")) {
                    rowData[i] = field.getDefault();
                    field.setValue(rowData[i], this.m_inserting);
                    continue;
                }
                rowData[i] = origData[i];
            }
        } else {
            for (int i = 0; i < size; ++i) {
                GridField field = this.m_fields.get(i);
                rowData[i] = field.getDefault();
                field.setValue(rowData[i], this.m_inserting);
            }
        }
        this.m_changed = true;
        this.m_compareDB = true;
        this.m_rowChanged = -1;
        this.m_newRow = currentRow + 1;
        if (this.m_buffer.size() < this.m_newRow) {
            this.m_newRow = this.m_buffer.size();
        }
        sort = new MSort(this.m_buffer.size(), null);
        this.m_buffer.add(rowData);
        this.m_sort.add(this.m_newRow, sort);
        ++this.m_rowCount;
        log.fine("Current=" + currentRow + ", New=" + this.m_newRow);
        this.fireTableRowsInserted(this.m_newRow, this.m_newRow);
        this.fireDataStatusIEvent(copyCurrent ? "UpdateCopied" : "Inserted", "");
        log.fine("Current=" + currentRow + ", New=" + this.m_newRow + " - complete");
        return true;
    }

    public boolean dataDelete(int row) {
        Boolean processed;
        log.info("Row=" + row);
        if (row < 0) {
            return false;
        }
        if (this.m_readOnly) {
            this.fireDataStatusEEvent("AccessCannotDelete", "", true);
            return false;
        }
        if (!this.m_deleteable) {
            this.fireDataStatusEEvent("AccessNotDeleteable", "", true);
            return false;
        }
        if (this.m_indexProcessedColumn > 0 && !this.m_tableName.startsWith("I_") && (processed = (Boolean)this.getValueAt(row, this.m_indexProcessedColumn)) != null && processed.booleanValue()) {
            this.fireDataStatusEEvent("CannotDeleteTrx", "", true);
            return false;
        }
        MSort sort = this.m_sort.get(row);
        Object[] rowData = this.m_buffer.get(sort.index);
        MTable table = MTable.get((Ctx)this.m_ctx, (int)this.m_AD_Table_ID);
        PO po = null;
        int Record_ID = this.getKeyID(this.m_rowChanged);
        po = Record_ID != -1 ? table.getPO(this.m_ctx, Record_ID, null) : table.getPO(this.m_ctx, this.getWhereClause(rowData), null);
        if (po != null) {
            boolean ok = false;
            try {
                ok = po.delete(false);
            }
            catch (Throwable t) {
                log.log(Level.SEVERE, "Delete", t);
            }
            if (!ok) {
                ValueNamePair vp = CLogger.retrieveError();
                if (vp != null) {
                    this.fireDataStatusEEvent(vp);
                } else {
                    this.fireDataStatusEEvent("DeleteError", "", true);
                }
                return false;
            }
        } else {
            StringBuffer sql = new StringBuffer("DELETE FROM ");
            sql.append(this.m_tableName).append(" WHERE ").append(this.getWhereClause(rowData));
            int no = 0;
            try {
                CPreparedStatement pstmt = DB.prepareStatement((String)sql.toString(), null);
                no = pstmt.executeUpdate();
                pstmt.close();
            }
            catch (SQLException e) {
                log.log(Level.SEVERE, sql.toString(), (Throwable)e);
                String msg = "DeleteError";
                if (e.getErrorCode() == 2292) {
                    msg = "DeleteErrorDependent";
                }
                this.fireDataStatusEEvent(msg, e.getLocalizedMessage(), true);
                return false;
            }
            if (no != 1) {
                log.log(Level.SEVERE, "Number of deleted rows = " + no);
                return false;
            }
        }
        int bufferRow = sort.index;
        this.m_buffer.remove(bufferRow);
        --this.m_rowCount;
        this.m_sort.remove(row);
        for (int i = 0; i < this.m_sort.size(); ++i) {
            MSort ptr = this.m_sort.get(i);
            if (ptr.index <= bufferRow) continue;
            --ptr.index;
        }
        this.m_changed = false;
        this.m_rowChanged = -1;
        this.fireTableRowsDeleted(row, row);
        this.fireDataStatusIEvent("Deleted", "");
        log.fine("Row=" + row + " complete");
        return true;
    }

    public void dataIgnore() {
        if (!this.m_inserting && !this.m_changed && this.m_rowChanged < 0) {
            log.fine("Nothing to ignore");
            return;
        }
        log.info("Inserting=" + this.m_inserting);
        if (this.m_inserting) {
            MSort sort = this.m_sort.get(this.m_newRow);
            int bufferRow = sort.index;
            this.m_buffer.remove(bufferRow);
            --this.m_rowCount;
            this.m_sort.remove(this.m_newRow);
            this.m_changed = false;
            this.m_rowData = null;
            this.m_rowChanged = -1;
            this.m_inserting = false;
            this.fireTableRowsDeleted(this.m_newRow, this.m_newRow);
        } else {
            if (this.m_rowData != null) {
                MSort sort = this.m_sort.get(this.m_rowChanged);
                this.m_buffer.set(sort.index, this.m_rowData);
            }
            this.m_changed = false;
            this.m_rowData = null;
            this.m_rowChanged = -1;
            this.m_inserting = false;
        }
        this.m_newRow = -1;
        this.fireDataStatusIEvent("Ignored", "");
    }

    public void dataRefresh(int row) {
        log.info("Row=" + row);
        if (row < 0 || this.m_sort.size() == 0 || this.m_inserting) {
            return;
        }
        MSort sort = this.m_sort.get(row);
        Object[] rowData = this.m_buffer.get(sort.index);
        this.dataIgnore();
        String where = this.getWhereClause(rowData);
        if (where == null || where.length() == 0) {
            where = "1=2";
        }
        String sql = this.m_SQL_Select + " WHERE " + where;
        sort = this.m_sort.get(row);
        Object[] rowDataDB = null;
        try {
            CPreparedStatement pstmt = DB.prepareStatement((String)sql, null);
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                rowDataDB = this.readData(rs);
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            log.log(Level.SEVERE, sql, (Throwable)e);
            this.fireTableRowsUpdated(row, row);
            this.fireDataStatusEEvent("RefreshError", sql, true);
            return;
        }
        this.m_buffer.set(sort.index, rowDataDB);
        this.m_rowData = null;
        this.m_changed = false;
        this.m_rowChanged = -1;
        this.m_inserting = false;
        this.fireTableRowsUpdated(row, row);
        this.fireDataStatusIEvent("Refreshed", "");
    }

    public void dataRefreshAll() {
        log.info("");
        this.m_inserting = false;
        this.dataIgnore();
        this.close(false);
        this.open(this.m_maxRows);
        this.m_rowData = null;
        this.m_changed = false;
        this.m_rowChanged = -1;
        this.m_inserting = false;
        this.fireTableDataChanged();
        this.fireDataStatusIEvent("Refreshed", "");
    }

    public boolean dataRequery(String whereClause) {
        log.info(whereClause);
        this.close(false);
        this.setSelectWhereClause(whereClause);
        this.open(this.m_maxRows);
        this.m_rowData = null;
        this.m_changed = false;
        this.m_rowChanged = -1;
        this.m_inserting = false;
        this.fireTableDataChanged();
        this.fireDataStatusIEvent("Refreshed", "");
        return true;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        if (this.m_readOnly) {
            return false;
        }
        if (col == this.m_indexKeyColumn) {
            return false;
        }
        if (col < 0 && col >= this.m_fields.size()) {
            return false;
        }
        if (col == this.m_indexActiveColumn && this.m_indexProcessedColumn == -1) {
            return true;
        }
        if (!this.isRowEditable(row)) {
            return false;
        }
        return this.m_fields.get(col).isEditable(false);
    }

    public boolean isRowEditable(int row) {
        Object processed;
        Object value;
        if (this.m_readOnly || row < 0) {
            return false;
        }
        if (this.m_indexActiveColumn > 0 && ((value = this.getValueAt(row, this.m_indexActiveColumn)) instanceof Boolean ? (Boolean)value == false : "N".equals(value))) {
            return false;
        }
        if (this.m_indexProcessedColumn > 0 && ((processed = this.getValueAt(row, this.m_indexProcessedColumn)) instanceof Boolean ? (Boolean)processed != false : "Y".equals(processed))) {
            return false;
        }
        int[] co = this.getClientOrg(row);
        int AD_Client_ID = co[0];
        int AD_Org_ID = co[1];
        int Record_ID = this.getKeyID(row);
        return MRole.getDefault((Ctx)this.m_ctx, (boolean)false).canUpdate(AD_Client_ID, AD_Org_ID, this.m_AD_Table_ID, Record_ID, false);
    }

    private int[] getClientOrg(int row) {
        Integer ii;
        Integer ii2;
        int AD_Client_ID = -1;
        if (this.m_indexClientColumn != -1 && (ii2 = (Integer)this.getValueAt(row, this.m_indexClientColumn)) != null) {
            AD_Client_ID = ii2;
        }
        int AD_Org_ID = 0;
        if (this.m_indexOrgColumn != -1 && (ii = (Integer)this.getValueAt(row, this.m_indexOrgColumn)) != null) {
            AD_Org_ID = ii;
        }
        return new int[]{AD_Client_ID, AD_Org_ID};
    }

    public void setReadOnly(boolean value) {
        log.fine("ReadOnly=" + value);
        this.m_readOnly = value;
    }

    public boolean isReadOnly() {
        return this.m_readOnly;
    }

    public boolean isInserting() {
        return this.m_inserting;
    }

    public void setCompareDB(boolean compareDB) {
        this.m_compareDB = compareDB;
    }

    public boolean getCompareDB() {
        return this.m_compareDB;
    }

    public void setDeleteable(boolean value) {
        log.fine("Deleteable=" + value);
        this.m_deleteable = value;
    }

    Object[] readData(ResultSet rs) {
        int size = this.m_fields.size();
        Object[] rowData = new Object[size];
        String columnName = null;
        int displayType = 0;
        try {
            for (int j = 0; j < size; ++j) {
                GridField field = this.m_fields.get(j);
                columnName = field.getColumnName();
                displayType = field.getDisplayType();
                if (displayType == 11 || DisplayType.isID((int)displayType) && (columnName.endsWith("_ID") || columnName.endsWith("_Acct")) || columnName.endsWith("atedBy")) {
                    rowData[j] = new Integer(rs.getInt(j + 1));
                    if (rs.wasNull()) {
                        rowData[j] = null;
                    }
                } else if (DisplayType.isNumeric((int)displayType)) {
                    rowData[j] = rs.getBigDecimal(j + 1);
                } else if (DisplayType.isDate((int)displayType)) {
                    rowData[j] = rs.getTimestamp(j + 1);
                } else if (displayType == 26) {
                    rowData[j] = null;
                } else if (displayType == 20) {
                    String str = rs.getString(j + 1);
                    if (field.isEncryptedColumn()) {
                        str = (String)this.decrypt(str);
                    }
                    rowData[j] = new Boolean("Y".equals(str));
                } else if (DisplayType.isLOB((int)displayType)) {
                    long length;
                    Object lob;
                    Object value = rs.getObject(j + 1);
                    if (rs.wasNull()) {
                        rowData[j] = null;
                    } else if (value instanceof Clob) {
                        lob = (Clob)value;
                        length = lob.length();
                        rowData[j] = lob.getSubString(1L, (int)length);
                    } else if (value instanceof Blob) {
                        lob = (Blob)value;
                        length = lob.length();
                        rowData[j] = lob.getBytes(1L, (int)length);
                    } else if (value instanceof String) {
                        rowData[j] = value.toString();
                    }
                } else {
                    rowData[j] = rs.getString(j + 1);
                }
                if (!field.isEncryptedColumn() || displayType == 20) continue;
                rowData[j] = this.decrypt(rowData[j]);
            }
        }
        catch (SQLException e) {
            log.log(Level.SEVERE, columnName + ", DT=" + displayType, (Throwable)e);
        }
        return rowData;
    }

    private Object encrypt(Object xx) {
        if (xx == null) {
            return null;
        }
        return SecureEngine.encrypt((Object)xx);
    }

    private Object decrypt(Object yy) {
        if (yy == null) {
            return null;
        }
        return SecureEngine.decrypt((Object)yy);
    }

    public synchronized void removeDataStatusListener(DataStatusListener l) {
        this.listenerList.remove(DataStatusListener.class, l);
    }

    public synchronized void addDataStatusListener(DataStatusListener l) {
        this.listenerList.add(DataStatusListener.class, l);
    }

    void fireDataStatusChanged(DataStatusEvent e) {
        DataStatusListener[] listeners = (DataStatusListener[])this.listenerList.getListeners(DataStatusListener.class);
        for (int i = 0; i < listeners.length; ++i) {
            listeners[i].dataStatusChanged(e);
        }
    }

    DataStatusEvent createDSE() {
        boolean changed = this.m_changed;
        if (this.m_rowChanged != -1) {
            changed = true;
        }
        DataStatusEvent dse = new DataStatusEvent(this, this.m_rowCount, changed, this.m_ctx.isAutoCommit(this.m_WindowNo), this.m_inserting);
        dse.AD_Table_ID = this.m_AD_Table_ID;
        dse.Record_ID = null;
        return dse;
    }

    protected void fireDataStatusIEvent(String AD_Message, String info) {
        DataStatusEvent e = this.createDSE();
        e.setInfo(AD_Message, info, false, false);
        this.fireDataStatusChanged(e);
    }

    protected void fireDataStatusEEvent(String AD_Message, String info, boolean isError) {
        DataStatusEvent e = this.createDSE();
        e.setInfo(AD_Message, info, isError, !isError);
        if (isError) {
            log.saveWarning(AD_Message, info);
        }
        this.fireDataStatusChanged(e);
    }

    protected void fireDataStatusEEvent(ValueNamePair errorLog) {
        if (errorLog != null) {
            this.fireDataStatusEEvent(errorLog.getValue(), errorLog.getName(), true);
        }
    }

    public synchronized void removeVetoableChangeListener(VetoableChangeListener l) {
        this.m_vetoableChangeSupport.removeVetoableChangeListener(l);
    }

    public synchronized void addVetoableChangeListener(VetoableChangeListener l) {
        this.m_vetoableChangeSupport.addVetoableChangeListener(l);
    }

    protected void fireVetoableChange(PropertyChangeEvent e) throws PropertyVetoException {
        this.m_vetoableChangeSupport.fireVetoableChange(e);
    }

    public String toString() {
        return new StringBuffer("MTable[").append(this.m_tableName).append(",WindowNo=").append(this.m_WindowNo).append(",Tab=").append(this.m_TabNo).append("]").toString();
    }

    class Loader
    extends Thread
    implements Serializable {
        private PreparedStatement m_pstmt;
        private ResultSet m_rs;

        public Loader() {
            super("TLoader");
            this.m_pstmt = null;
            this.m_rs = null;
        }

        protected int open(int maxRows) {
            int rows = 0;
            try {
                CPreparedStatement pstmt = DB.prepareStatement((String)GridTable.this.m_SQL_Count, null);
                this.setParameter((PreparedStatement)pstmt, true);
                ResultSet rs = pstmt.executeQuery();
                if (rs.next()) {
                    rows = rs.getInt(1);
                }
                rs.close();
                pstmt.close();
            }
            catch (SQLException e0) {
                if (e0.getErrorCode() == 904) {
                    log.warning("Count - " + e0.getLocalizedMessage() + "\nSQL=" + GridTable.this.m_SQL_Count);
                } else {
                    log.log(Level.SEVERE, "Count SQL=" + GridTable.this.m_SQL_Count, (Throwable)e0);
                }
                return 0;
            }
            StringBuffer info = new StringBuffer("Rows=");
            info.append(rows);
            if (rows == 0) {
                info.append(" - ").append(GridTable.this.m_SQL_Count);
            }
            try {
                this.m_pstmt = DB.prepareStatement((String)GridTable.this.m_SQL, null);
                if (maxRows > 0 && rows > maxRows) {
                    this.m_pstmt.setMaxRows(maxRows);
                    info.append(" - MaxRows=").append(maxRows);
                    rows = maxRows;
                }
                this.setParameter(this.m_pstmt, false);
                this.m_rs = this.m_pstmt.executeQuery();
            }
            catch (SQLException e) {
                log.log(Level.SEVERE, GridTable.this.m_SQL, (Throwable)e);
                return 0;
            }
            log.fine(info.toString());
            return rows;
        }

        void close() {
            try {
                if (this.m_rs != null) {
                    this.m_rs.close();
                }
                if (this.m_pstmt != null) {
                    this.m_pstmt.close();
                }
            }
            catch (SQLException e) {
                log.log(Level.SEVERE, "closeRS", (Throwable)e);
            }
            this.m_rs = null;
            this.m_pstmt = null;
        }

        public void run() {
            log.info("");
            if (this.m_rs == null) {
                return;
            }
            try {
                while (this.m_rs.next()) {
                    if (this.isInterrupted()) {
                        log.fine("Interrupted");
                        this.close();
                        return;
                    }
                    Object[] rowData = GridTable.this.readData(this.m_rs);
                    MSort sort = new MSort(GridTable.this.m_buffer.size(), null);
                    GridTable.this.m_buffer.add(rowData);
                    GridTable.this.m_sort.add(sort);
                    if (GridTable.this.m_buffer.size() % 250 != 0) continue;
                    try {
                        Loader.yield();
                        Loader.sleep(10L);
                    }
                    catch (InterruptedException ie) {
                        log.fine("Interrupted while sleeping");
                        this.close();
                        return;
                    }
                    DataStatusEvent evt = GridTable.this.createDSE();
                    evt.setLoading(GridTable.this.m_buffer.size());
                    GridTable.this.fireDataStatusChanged(evt);
                }
            }
            catch (SQLException e) {
                log.log(Level.SEVERE, "run", (Throwable)e);
            }
            this.close();
            GridTable.this.fireDataStatusIEvent("", "");
        }

        private void setParameter(PreparedStatement pstmt, boolean countSQL) {
            if (GridTable.this.m_parameterSELECT.size() == 0 && GridTable.this.m_parameterWHERE.size() == 0) {
                return;
            }
            try {
                Integer ii;
                Object para;
                int i;
                int pos = 1;
                for (i = 0; !countSQL && i < GridTable.this.m_parameterSELECT.size(); ++i) {
                    para = GridTable.this.m_parameterSELECT.get(i);
                    if (para != null) {
                        log.fine("Select " + i + "=" + para);
                    }
                    if (para == null) continue;
                    if (para instanceof Integer) {
                        ii = (Integer)para;
                        pstmt.setInt(pos++, ii);
                        continue;
                    }
                    if (para instanceof BigDecimal) {
                        pstmt.setBigDecimal(pos++, (BigDecimal)para);
                        continue;
                    }
                    pstmt.setString(pos++, para.toString());
                }
                for (i = 0; i < GridTable.this.m_parameterWHERE.size(); ++i) {
                    para = GridTable.this.m_parameterWHERE.get(i);
                    if (para != null) {
                        log.fine("Where " + i + "=" + para);
                    }
                    if (para == null) continue;
                    if (para instanceof Integer) {
                        ii = (Integer)para;
                        pstmt.setInt(pos++, ii);
                        continue;
                    }
                    if (para instanceof BigDecimal) {
                        pstmt.setBigDecimal(pos++, (BigDecimal)para);
                        continue;
                    }
                    pstmt.setString(pos++, para.toString());
                }
            }
            catch (SQLException e) {
                log.log(Level.SEVERE, "parameter", (Throwable)e);
            }
        }
    }
}

