/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.logging.Level;
import org.compiere.model.CompiereProcessor;
import org.compiere.model.CompiereProcessorLog;
import org.compiere.model.MAlert;
import org.compiere.model.MAlertProcessorLog;
import org.compiere.model.X_AD_AlertProcessor;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.Ctx;
import org.compiere.util.DB;

public class MAlertProcessor
extends X_AD_AlertProcessor
implements CompiereProcessor {
    private static CLogger s_log = CLogger.getCLogger(MAlertProcessor.class);
    private MAlert[] m_alerts = null;

    public static MAlertProcessor[] getActive(Ctx ctx) {
        ArrayList<MAlertProcessor> list = new ArrayList<MAlertProcessor>();
        String sql = "SELECT * FROM AD_AlertProcessor WHERE IsActive='Y'";
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement((String)sql, null);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                list.add(new MAlertProcessor(ctx, rs, null));
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            s_log.log(Level.SEVERE, sql, (Throwable)e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        MAlertProcessor[] retValue = new MAlertProcessor[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    public MAlertProcessor(Ctx ctx, int AD_AlertProcessorLog_ID, String trxName) {
        super(ctx, AD_AlertProcessorLog_ID, trxName);
    }

    public MAlertProcessor(Ctx ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public String getServerID() {
        return "AlertProcessor" + this.get_ID();
    }

    public Timestamp getDateNextRun(boolean requery) {
        if (requery) {
            this.load(this.get_TrxName());
        }
        return this.getDateNextRun();
    }

    public CompiereProcessorLog[] getLogs() {
        ArrayList<MAlertProcessorLog> list = new ArrayList<MAlertProcessorLog>();
        String sql = "SELECT * FROM AD_AlertProcessorLog WHERE AD_AlertProcessor_ID=? ORDER BY Created DESC";
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement((String)sql, null);
            pstmt.setInt(1, this.getAD_AlertProcessor_ID());
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                list.add(new MAlertProcessorLog(this.getCtx(), rs, null));
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, sql, (Throwable)e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        CompiereProcessorLog[] retValue = new MAlertProcessorLog[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    public int deleteLog() {
        if (this.getKeepLogDays() < 1) {
            return 0;
        }
        String sql = "DELETE FROM AD_AlertProcessorLog WHERE AD_AlertProcessor_ID=" + this.getAD_AlertProcessor_ID() + " AND addDays(Created," + this.getKeepLogDays() + ") < SysDate";
        int no = DB.executeUpdate((String)sql, (String)this.get_TrxName());
        return 0;
    }

    public MAlert[] getAlerts(boolean reload) {
        if (this.m_alerts != null && !reload) {
            return this.m_alerts;
        }
        String sql = "SELECT * FROM AD_Alert WHERE AD_AlertProcessor_ID=?";
        ArrayList<MAlert> list = new ArrayList<MAlert>();
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement((String)sql, null);
            pstmt.setInt(1, this.getAD_AlertProcessor_ID());
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                list.add(new MAlert(this.getCtx(), rs, null));
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, sql, (Throwable)e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        this.m_alerts = new MAlert[list.size()];
        list.toArray(this.m_alerts);
        return this.m_alerts;
    }
}

