/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.logging.Level;
import org.compiere.model.X_M_BOM;
import org.compiere.util.CCache;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.Ctx;
import org.compiere.util.DB;
import org.compiere.util.Msg;

public class MBOM
extends X_M_BOM {
    private static CCache<Integer, MBOM> s_cache = new CCache("M_BOM", 20);
    private static CLogger s_log = CLogger.getCLogger(MBOM.class);

    public static MBOM get(Ctx ctx, int M_BOM_ID) {
        Integer key = new Integer(M_BOM_ID);
        MBOM retValue = (MBOM)((Object)s_cache.get((Object)key));
        if (retValue != null) {
            return retValue;
        }
        retValue = new MBOM(ctx, M_BOM_ID, null);
        if (retValue.get_ID() != 0) {
            s_cache.put((Object)key, (Object)retValue);
        }
        return retValue;
    }

    public static MBOM[] getOfProduct(Ctx ctx, int M_Product_ID, String trxName, String whereClause) {
        ArrayList<MBOM> list = new ArrayList<MBOM>();
        String sql = "SELECT * FROM M_BOM WHERE M_Product_ID=?";
        if (whereClause != null && whereClause.length() > 0) {
            sql = sql + " AND " + whereClause;
        }
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement((String)sql, (String)trxName);
            pstmt.setInt(1, M_Product_ID);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                list.add(new MBOM(ctx, rs, trxName));
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            s_log.log(Level.SEVERE, sql, (Throwable)e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        MBOM[] retValue = new MBOM[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    public MBOM(Ctx ctx, int M_BOM_ID, String trxName) {
        super(ctx, M_BOM_ID, trxName);
        if (M_BOM_ID == 0) {
            this.setBOMType("A");
            this.setBOMUse("A");
        }
    }

    public MBOM(Ctx ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    protected boolean beforeSave(boolean newRecord) {
        if (newRecord || this.is_ValueChanged("BOMType")) {
            MBOM[] boms;
            if (this.getBOMType().equals("A")) {
                MBOM[] boms2 = MBOM.getOfProduct(this.getCtx(), this.getM_Product_ID(), this.get_TrxName(), "BOMType='A' AND BOMUse='" + this.getBOMUse() + "' AND IsActive='Y'");
                if (boms2.length != 0 && (boms2.length != 1 || boms2[0].getM_BOM_ID() != this.getM_BOM_ID())) {
                    this.log.saveError("Error", Msg.parseTranslation((Ctx)this.getCtx(), (String)("Can only have one Current Active BOM for Product BOM Use (" + this.getBOMType() + ")")));
                    return false;
                }
            } else if (this.getBOMType().equals("O") && (boms = MBOM.getOfProduct(this.getCtx(), this.getM_Product_ID(), this.get_TrxName(), "IsActive='Y'")).length != 0 && (boms.length != 1 || boms[0].getM_BOM_ID() != this.getM_BOM_ID())) {
                this.log.saveError("Error", Msg.parseTranslation((Ctx)this.getCtx(), (String)"Can only have single Make-to-Order BOM for Product"));
                return false;
            }
        }
        return true;
    }
}

