/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.util.logging.Level;
import org.compiere.model.MCStage;
import org.compiere.model.X_CM_CStage_Element;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.Ctx;
import org.compiere.util.DB;

public class MCStageElement
extends X_CM_CStage_Element {
    private static CLogger s_log = CLogger.getCLogger(MCStageElement.class);
    private MCStage m_parent = null;

    public MCStageElement(Ctx ctx, int CM_CStage_Element_ID, String trxName) {
        super(ctx, CM_CStage_Element_ID, trxName);
        if (CM_CStage_Element_ID == 0) {
            this.setIsValid(false);
        }
    }

    public MCStageElement(Ctx ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public static MCStageElement getByName(Ctx ctx, int CM_CStage_ID, String elementName, String trxName) {
        String sql = "SELECT * FROM CM_CStage_Element WHERE CM_CStage_ID=? AND Name LIKE ?";
        MCStageElement thisElement = null;
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement((String)sql, (String)trxName);
            pstmt.setInt(1, CM_CStage_ID);
            pstmt.setString(2, elementName);
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                thisElement = new MCStageElement(ctx, rs, trxName);
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            s_log.log(Level.SEVERE, "getByName", (Throwable)e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        return thisElement;
    }

    public MCStage getParent() {
        if (this.m_parent != null) {
            return this.m_parent;
        }
        this.m_parent = new MCStage(this.getCtx(), this.getCM_CStage_ID(), this.get_TrxName());
        return this.m_parent;
    }

    protected boolean afterSave(boolean newRecord, boolean success) {
        if (!success) {
            return success;
        }
        if (!this.getParent().isModified()) {
            this.getParent().setIsModified(true);
            this.getParent().save();
        }
        return success;
    }
}

