/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.io.File;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.logging.Level;
import org.compiere.api.UICallout;
import org.compiere.framework.ModelValidationEngine;
import org.compiere.framework.PO;
import org.compiere.model.MAllocationHdr;
import org.compiere.model.MAllocationLine;
import org.compiere.model.MCashBook;
import org.compiere.model.MCashLine;
import org.compiere.model.MConversionRate;
import org.compiere.model.MOrg;
import org.compiere.model.MPayment;
import org.compiere.model.MPeriod;
import org.compiere.model.X_C_Cash;
import org.compiere.process.DocAction;
import org.compiere.process.DocumentEngine;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.Ctx;
import org.compiere.util.DB;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.TimeUtil;

public class MCash
extends X_C_Cash
implements DocAction {
    private static CLogger s_log = CLogger.getCLogger(MCash.class);
    private MCashLine[] m_lines = null;
    private MCashBook m_book = null;
    private String m_processMsg = null;
    private boolean m_justPrepared = false;

    public static MCash get(Ctx ctx, int AD_Org_ID, Timestamp dateAcct, int C_Currency_ID, String trxName) {
        MCash retValue = null;
        String sql = "SELECT * FROM C_Cash c WHERE c.AD_Org_ID=? AND TRUNC(c.StatementDate, 'DD')=? AND c.Processed='N' AND EXISTS (SELECT * FROM C_CashBook cb WHERE c.C_CashBook_ID=cb.C_CashBook_ID AND cb.AD_Org_ID=c.AD_Org_ID AND cb.C_Currency_ID=?)";
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement((String)sql, (String)trxName);
            pstmt.setInt(1, AD_Org_ID);
            pstmt.setTimestamp(2, TimeUtil.getDay((Timestamp)dateAcct));
            pstmt.setInt(3, C_Currency_ID);
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                retValue = new MCash(ctx, rs, trxName);
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            s_log.log(Level.SEVERE, sql, (Throwable)e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        if (retValue != null) {
            return retValue;
        }
        MCashBook cb = MCashBook.get(ctx, AD_Org_ID, C_Currency_ID);
        if (cb == null) {
            s_log.warning("No CashBook for AD_Org_ID=" + AD_Org_ID + ", C_Currency_ID=" + C_Currency_ID);
            return null;
        }
        retValue = new MCash(cb, dateAcct);
        retValue.save(trxName);
        return retValue;
    }

    public static MCash get(Ctx ctx, int C_CashBook_ID, Timestamp dateAcct, String trxName) {
        MCash retValue = null;
        String sql = "SELECT * FROM C_Cash c WHERE c.C_CashBook_ID=? AND TRUNC(c.StatementDate,'DD')=? AND c.Processed='N'";
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement((String)sql, (String)trxName);
            pstmt.setInt(1, C_CashBook_ID);
            pstmt.setTimestamp(2, TimeUtil.getDay((Timestamp)dateAcct));
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                retValue = new MCash(ctx, rs, trxName);
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            s_log.log(Level.SEVERE, sql, (Throwable)e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        if (retValue != null) {
            return retValue;
        }
        MCashBook cb = new MCashBook(ctx, C_CashBook_ID, trxName);
        if (cb.get_ID() == 0) {
            s_log.warning("Not found C_CashBook_ID=" + C_CashBook_ID);
            return null;
        }
        retValue = new MCash(cb, dateAcct);
        retValue.save(trxName);
        return retValue;
    }

    public MCash(Ctx ctx, int C_Cash_ID, String trxName) {
        super(ctx, C_Cash_ID, trxName);
        if (C_Cash_ID == 0) {
            this.setBeginningBalance(Env.ZERO);
            this.setEndingBalance(Env.ZERO);
            this.setStatementDifference(Env.ZERO);
            this.setDocAction("CO");
            this.setDocStatus("DR");
            Timestamp today = TimeUtil.getDay((long)System.currentTimeMillis());
            this.setStatementDate(today);
            this.setDateAcct(today);
            String name = DisplayType.getDateFormat((int)15).format(today) + " " + MOrg.get((Ctx)ctx, (int)this.getAD_Org_ID()).getValue();
            this.setName(name);
            this.setIsApproved(false);
            this.setPosted(false);
            this.setProcessed(false);
        }
    }

    public MCash(Ctx ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MCash(MCashBook cb, Timestamp today) {
        this(cb.getCtx(), 0, cb.get_TrxName());
        this.setClientOrg((PO)cb);
        this.setC_CashBook_ID(cb.getC_CashBook_ID());
        if (today != null) {
            this.setStatementDate(today);
            this.setDateAcct(today);
            String name = DisplayType.getDateFormat((int)15).format(today) + " " + cb.getName();
            this.setName(name);
        }
        this.m_book = cb;
    }

    public MCashLine[] getLines(boolean requery) {
        if (this.m_lines != null && !requery) {
            return this.m_lines;
        }
        ArrayList<MCashLine> list = new ArrayList<MCashLine>();
        String sql = "SELECT * FROM C_CashLine WHERE C_Cash_ID=? ORDER BY Line";
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement((String)sql, (String)this.get_TrxName());
            pstmt.setInt(1, this.getC_Cash_ID());
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                list.add(new MCashLine(this.getCtx(), rs, this.get_TrxName()));
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, sql, (Throwable)e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        this.m_lines = new MCashLine[list.size()];
        list.toArray(this.m_lines);
        return this.m_lines;
    }

    public MCashBook getCashBook() {
        if (this.m_book == null) {
            this.m_book = MCashBook.get(this.getCtx(), this.getC_CashBook_ID());
        }
        return this.m_book;
    }

    public String getDocumentNo() {
        return this.getName();
    }

    public String getDocumentInfo() {
        return Msg.getElement((Ctx)this.getCtx(), (String)"C_Cash_ID") + " " + this.getDocumentNo();
    }

    public File createPDF() {
        try {
            File temp = File.createTempFile(this.get_TableName() + this.get_ID() + "_", ".pdf");
            return this.createPDF(temp);
        }
        catch (Exception e) {
            this.log.severe("Could not create PDF - " + e.getMessage());
            return null;
        }
    }

    public File createPDF(File file) {
        return null;
    }

    @UICallout
    public void setStatementDate(String oldStatementDate, String newStatementDate, int windowNo) throws Exception {
        if (newStatementDate == null || newStatementDate.length() == 0) {
            return;
        }
        Timestamp statementDate = PO.convertToTimestamp((String)newStatementDate);
        if (statementDate == null) {
            return;
        }
        this.setStatementDate(statementDate);
    }

    public void setStatementDate(Timestamp statementDate) {
        super.setStatementDate(statementDate);
        super.setDateAcct(statementDate);
    }

    protected boolean beforeSave(boolean newRecord) {
        this.setAD_Org_ID(this.getCashBook().getAD_Org_ID());
        if (this.getAD_Org_ID() == 0) {
            this.log.saveError("Error", Msg.parseTranslation((Ctx)this.getCtx(), (String)"@AD_Org_ID@"));
            return false;
        }
        this.setEndingBalance(this.getBeginningBalance().add(this.getStatementDifference()));
        return true;
    }

    public boolean processIt(String processAction) {
        this.m_processMsg = null;
        DocumentEngine engine = new DocumentEngine((DocAction)this, this.getDocStatus());
        return engine.processIt(processAction, this.getDocAction());
    }

    public boolean unlockIt() {
        this.log.info(this.toString());
        this.setProcessing(false);
        return true;
    }

    public boolean invalidateIt() {
        this.log.info(this.toString());
        this.setDocAction("PR");
        return true;
    }

    public String prepareIt() {
        this.log.info(this.toString());
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 1);
        if (this.m_processMsg != null) {
            return "IN";
        }
        if (!MPeriod.isOpen(this.getCtx(), this.getDateAcct(), "CMC")) {
            this.m_processMsg = "@PeriodClosed@";
            return "IN";
        }
        MCashLine[] lines = this.getLines(false);
        if (lines.length == 0) {
            this.m_processMsg = "@NoLines@";
            return "IN";
        }
        BigDecimal difference = Env.ZERO;
        int C_Currency_ID = this.getC_Currency_ID();
        for (int i = 0; i < lines.length; ++i) {
            MCashLine line = lines[i];
            if (!line.isActive()) continue;
            if (C_Currency_ID == line.getC_Currency_ID()) {
                difference = difference.add(line.getAmount());
                continue;
            }
            BigDecimal amt = MConversionRate.convert((Ctx)this.getCtx(), (BigDecimal)line.getAmount(), (int)line.getC_Currency_ID(), (int)C_Currency_ID, (Timestamp)this.getDateAcct(), (int)0, (int)this.getAD_Client_ID(), (int)this.getAD_Org_ID());
            if (amt == null) {
                this.m_processMsg = "No Conversion Rate found - @C_CashLine_ID@= " + line.getLine();
                return "IN";
            }
            difference = difference.add(amt);
        }
        this.setStatementDifference(difference);
        this.m_justPrepared = true;
        if (!"CO".equals(this.getDocAction())) {
            this.setDocAction("CO");
        }
        return "IP";
    }

    public boolean approveIt() {
        this.log.info(this.toString());
        this.setIsApproved(true);
        return true;
    }

    public boolean rejectIt() {
        this.log.info(this.toString());
        this.setIsApproved(false);
        return true;
    }

    public String completeIt() {
        String status;
        if (!this.m_justPrepared && !"IP".equals(status = this.prepareIt())) {
            return status;
        }
        if (!this.isApproved()) {
            this.approveIt();
        }
        this.log.info(this.toString());
        MAllocationHdr alloc = new MAllocationHdr(this.getCtx(), false, this.getDateAcct(), this.getC_Currency_ID(), Msg.translate((Ctx)this.getCtx(), (String)"C_Cash_ID") + ": " + this.getName(), this.get_TrxName());
        alloc.setAD_Org_ID(this.getAD_Org_ID());
        if (!alloc.save()) {
            this.m_processMsg = "Could not create Allocation Hdr";
            return "IN";
        }
        MCashLine[] lines = this.getLines(false);
        for (int i = 0; i < lines.length; ++i) {
            MCashLine line = lines[i];
            if ("I".equals(line.getCashType())) {
                boolean differentCurrency = this.getC_Currency_ID() != line.getC_Currency_ID();
                MAllocationHdr hdr = alloc;
                if (differentCurrency) {
                    hdr = new MAllocationHdr(this.getCtx(), false, this.getDateAcct(), line.getC_Currency_ID(), Msg.translate((Ctx)this.getCtx(), (String)"C_Cash_ID") + ": " + this.getName(), this.get_TrxName());
                    hdr.setAD_Org_ID(this.getAD_Org_ID());
                    if (!hdr.save()) {
                        this.m_processMsg = "Could not create Allocation Hdr";
                        return "IN";
                    }
                }
                MAllocationLine aLine = new MAllocationLine(hdr, line.getAmount(), line.getDiscountAmt(), line.getWriteOffAmt(), Env.ZERO);
                aLine.setC_Invoice_ID(line.getC_Invoice_ID());
                aLine.setC_CashLine_ID(line.getC_CashLine_ID());
                if (!aLine.save()) {
                    this.m_processMsg = "Could not create Allocation Line";
                    return "IN";
                }
                if (!differentCurrency) continue;
                hdr.processIt("CO");
                hdr.save();
                continue;
            }
            if (!"T".equals(line.getCashType())) continue;
            MPayment pay = new MPayment(this.getCtx(), 0, this.get_TrxName());
            pay.setAD_Org_ID(this.getAD_Org_ID());
            String documentNo = this.getName();
            pay.setDocumentNo(documentNo);
            pay.setR_PnRef(documentNo);
            pay.set_Value("TrxType", "X");
            pay.set_Value("TenderType", "X");
            pay.setC_BankAccount_ID(line.getC_BankAccount_ID());
            pay.setC_DocType_ID(true);
            pay.setDateTrx(this.getStatementDate());
            pay.setDateAcct(this.getDateAcct());
            pay.setAmount(line.getC_Currency_ID(), line.getAmount().negate());
            pay.setDescription(line.getDescription());
            pay.setDocStatus("CL");
            pay.setDocAction("--");
            pay.setPosted(true);
            pay.setIsAllocated(true);
            pay.setProcessed(true);
            if (pay.save()) continue;
            this.m_processMsg = "Could not create Payment";
            return "IN";
        }
        alloc.processIt("CO");
        alloc.save();
        String valid = ModelValidationEngine.get().fireDocValidate((PO)this, 9);
        if (valid != null) {
            this.m_processMsg = valid;
            return "IN";
        }
        this.setProcessed(true);
        this.setDocAction("CL");
        return "CO";
    }

    public boolean voidIt() {
        this.log.info(this.toString());
        this.setDocAction("--");
        return false;
    }

    public boolean closeIt() {
        this.log.info(this.toString());
        this.setDocAction("--");
        return true;
    }

    public boolean reverseCorrectIt() {
        this.log.info(this.toString());
        return false;
    }

    public boolean reverseAccrualIt() {
        this.log.info(this.toString());
        return false;
    }

    public boolean reActivateIt() {
        this.log.info(this.toString());
        this.setProcessed(false);
        return this.reverseCorrectIt();
    }

    public void setProcessed(boolean processed) {
        super.setProcessed(processed);
        String sql = "UPDATE C_CashLine SET Processed='" + (processed ? "Y" : "N") + "' WHERE C_Cash_ID=" + this.getC_Cash_ID();
        int noLine = DB.executeUpdate((String)sql, (String)this.get_TrxName());
        this.m_lines = null;
        this.log.fine(processed + " - Lines=" + noLine);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("MCash[");
        sb.append(this.get_ID()).append("-").append(this.getName()).append(", Balance=").append(this.getBeginningBalance()).append("->").append(this.getEndingBalance()).append("]");
        return sb.toString();
    }

    public String getSummary() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getName());
        sb.append(": ").append(Msg.translate((Ctx)this.getCtx(), (String)"BeginningBalance")).append("=").append(this.getBeginningBalance()).append(",").append(Msg.translate((Ctx)this.getCtx(), (String)"EndingBalance")).append("=").append(this.getEndingBalance()).append(" (#").append(this.getLines(false).length).append(")");
        if (this.getDescription() != null && this.getDescription().length() > 0) {
            sb.append(" - ").append(this.getDescription());
        }
        return sb.toString();
    }

    public String getProcessMsg() {
        return this.m_processMsg;
    }

    public int getDoc_User_ID() {
        return this.getCreatedBy();
    }

    public BigDecimal getApprovalAmt() {
        return this.getStatementDifference();
    }

    public int getC_Currency_ID() {
        return this.getCashBook().getC_Currency_ID();
    }
}

