/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.logging.Level;
import org.compiere.framework.PO;
import org.compiere.model.MCommission;
import org.compiere.model.MCommissionAmt;
import org.compiere.model.X_C_CommissionRun;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.Ctx;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class MCommissionRun
extends X_C_CommissionRun {
    public MCommissionRun(Ctx ctx, int C_CommissionRun_ID, String trxName) {
        super(ctx, C_CommissionRun_ID, trxName);
        if (C_CommissionRun_ID == 0) {
            this.setGrandTotal(Env.ZERO);
            this.setProcessed(false);
        }
    }

    public MCommissionRun(MCommission commission) {
        this(commission.getCtx(), 0, commission.get_TrxName());
        this.setClientOrg((PO)commission);
        this.setC_Commission_ID(commission.getC_Commission_ID());
    }

    public MCommissionRun(Ctx ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MCommissionAmt[] getAmts() {
        String sql = "SELECT * FROM C_CommissionAmt WHERE C_CommissionRun_ID=?";
        ArrayList<MCommissionAmt> list = new ArrayList<MCommissionAmt>();
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement((String)sql, (String)this.get_TrxName());
            pstmt.setInt(1, this.getC_CommissionRun_ID());
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                list.add(new MCommissionAmt(this.getCtx(), rs, this.get_TrxName()));
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, sql, (Throwable)e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        MCommissionAmt[] retValue = new MCommissionAmt[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    public void updateFromAmt() {
        MCommissionAmt[] amts = this.getAmts();
        BigDecimal GrandTotal = Env.ZERO;
        for (int i = 0; i < amts.length; ++i) {
            MCommissionAmt amt = amts[i];
            GrandTotal = GrandTotal.add(amt.getCommissionAmt());
        }
        this.setGrandTotal(GrandTotal);
    }
}

