/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.logging.Level;
import org.compiere.Compiere;
import org.compiere.framework.PO;
import org.compiere.model.MInterestArea;
import org.compiere.model.MLead;
import org.compiere.model.MRequest;
import org.compiere.model.MSource;
import org.compiere.model.MUser;
import org.compiere.model.X_R_ContactInterest;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.Ctx;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class MContactInterest
extends X_R_ContactInterest {
    private static CLogger s_log = CLogger.getCLogger(MContactInterest.class);

    public static MContactInterest get(Ctx ctx, int R_InterestArea_ID, int AD_User_ID, boolean isActive, String trxName) {
        MContactInterest retValue = null;
        String sql = "SELECT * FROM R_ContactInterest WHERE R_InterestArea_ID=? AND AD_User_ID=?";
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement((String)sql, (String)trxName);
            pstmt.setInt(1, R_InterestArea_ID);
            pstmt.setInt(2, AD_User_ID);
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                retValue = new MContactInterest(ctx, rs, trxName);
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            s_log.log(Level.SEVERE, sql, (Throwable)e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        if (retValue == null) {
            retValue = new MContactInterest(ctx, R_InterestArea_ID, AD_User_ID, isActive, trxName);
            s_log.fine("NOT found - " + (Object)((Object)retValue));
        } else {
            s_log.fine("Found - " + retValue);
        }
        return retValue;
    }

    public MContactInterest(Ctx ctx, int ignored, String trxName) {
        super(ctx, 0, trxName);
        if (ignored != 0) {
            throw new IllegalArgumentException("Multi-Key");
        }
    }

    public MContactInterest(Ctx ctx, int R_InterestArea_ID, int AD_User_ID, boolean isActive, String trxName) {
        super(ctx, 0, trxName);
        this.setR_InterestArea_ID(R_InterestArea_ID);
        this.setAD_User_ID(AD_User_ID);
        this.setIsActive(isActive);
    }

    public MContactInterest(Ctx ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public void setOptOutDate(Timestamp OptOutDate) {
        if (OptOutDate == null) {
            OptOutDate = new Timestamp(System.currentTimeMillis());
        }
        this.log.fine("" + OptOutDate);
        super.setOptOutDate(OptOutDate);
        this.setIsActive(false);
    }

    public void unsubscribe() {
        this.setOptOutDate(null);
    }

    public boolean isOptOut() {
        return this.getOptOutDate() != null;
    }

    public void setSubscribeDate(Timestamp SubscribeDate) {
        if (SubscribeDate == null) {
            SubscribeDate = new Timestamp(System.currentTimeMillis());
        }
        this.log.fine("" + SubscribeDate);
        super.setSubscribeDate(SubscribeDate);
        super.setOptOutDate(null);
        this.setIsActive(true);
    }

    public void subscribe() {
        this.setSubscribeDate(null);
        if (!this.isActive()) {
            this.setIsActive(true);
        }
    }

    public void subscribe(boolean subscribe) {
        if (subscribe) {
            this.setSubscribeDate(null);
        } else {
            this.setOptOutDate(null);
        }
    }

    public boolean isSubscribed() {
        return this.isActive() && this.getOptOutDate() == null;
    }

    protected boolean afterSave(boolean newRecord, boolean success) {
        MInterestArea ia;
        if (success && newRecord && this.isSubscribed() && (ia = MInterestArea.get(this.getCtx(), this.getR_InterestArea_ID())).getR_Source_ID() != 0) {
            String summary = "Subscribe: " + ia.getName();
            MSource source = MSource.get(this.getCtx(), ia.getR_Source_ID());
            MUser user = null;
            user = this.get_TrxName() == null ? MUser.get((Ctx)this.getCtx(), (int)this.getAD_User_ID()) : new MUser(this.getCtx(), this.getAD_User_ID(), this.get_TrxName());
            if ("B".equals(source.getSourceCreateType()) || "R".equals(source.getSourceCreateType())) {
                MRequest request = new MRequest(this.getCtx(), 0, this.get_TrxName());
                request.setClientOrg((PO)this);
                request.setSummary(summary);
                request.setAD_User_ID(this.getAD_User_ID());
                request.setC_BPartner_ID(user.getC_BPartner_ID());
                request.setR_Source_ID(source.getR_Source_ID());
                request.save();
            }
            if ("B".equals(source.getSourceCreateType()) || "L".equals(source.getSourceCreateType())) {
                MLead lead = new MLead(this.getCtx(), 0, this.get_TrxName());
                lead.setClientOrg((PO)this);
                lead.setDescription(summary);
                lead.setAD_User_ID(this.getAD_User_ID());
                lead.setR_InterestArea_ID(this.getR_InterestArea_ID());
                lead.setC_BPartner_ID(user.getC_BPartner_ID());
                lead.setR_Source_ID(source.getR_Source_ID());
                lead.save();
            }
        }
        return success;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("MContactInterest[").append("R_InterestArea_ID=").append(this.getR_InterestArea_ID()).append(",AD_User_ID=").append(this.getAD_User_ID()).append(",Subscribed=").append(this.isSubscribed()).append("]");
        return sb.toString();
    }

    public static void main(String[] args) {
        Compiere.startup((boolean)true);
        int R_InterestArea_ID = 1000002;
        int AD_User_ID = 1000002;
        MContactInterest ci = MContactInterest.get(Env.getCtx(), R_InterestArea_ID, AD_User_ID, false, null);
        ci.subscribe();
        ci.save();
        ci = MContactInterest.get(Env.getCtx(), R_InterestArea_ID, AD_User_ID, false, null);
    }
}

