/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import org.compiere.model.MProductCategory;
import org.compiere.model.X_M_DiscountSchemaBreak;
import org.compiere.util.Ctx;

public class MDiscountSchemaBreak
extends X_M_DiscountSchemaBreak {
    public MDiscountSchemaBreak(Ctx ctx, int M_DiscountSchemaBreak_ID, String trxName) {
        super(ctx, M_DiscountSchemaBreak_ID, trxName);
    }

    public MDiscountSchemaBreak(Ctx ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public boolean applies(BigDecimal Value, int M_Product_ID, int M_Product_Category_ID) {
        if (!this.isActive()) {
            return false;
        }
        if (Value.compareTo(this.getBreakValue()) < 0) {
            return false;
        }
        if (this.getM_Product_ID() == 0 && this.getM_Product_Category_ID() == 0) {
            return true;
        }
        if (this.getM_Product_ID() == M_Product_ID) {
            return true;
        }
        if (M_Product_Category_ID != 0) {
            return this.getM_Product_Category_ID() == M_Product_Category_ID;
        }
        return MProductCategory.isCategory(this.getM_Product_Category_ID(), M_Product_ID);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("MDiscountSchemaBreak[");
        sb.append(this.get_ID()).append("-Seq=").append(this.getSeqNo());
        if (this.getM_Product_Category_ID() != 0) {
            sb.append(",M_Product_Category_ID=").append(this.getM_Product_Category_ID());
        }
        if (this.getM_Product_ID() != 0) {
            sb.append(",M_Product_ID=").append(this.getM_Product_ID());
        }
        sb.append(",Break=").append(this.getBreakValue());
        if (this.isBPartnerFlatDiscount()) {
            sb.append(",FlatDiscount");
        } else {
            sb.append(",Discount=").append(this.getBreakDiscount());
        }
        sb.append("]");
        return sb.toString();
    }
}

