/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.logging.Level;
import org.compiere.model.X_T_DistributionRunDetail;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.Ctx;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class MDistributionRunDetail
extends X_T_DistributionRunDetail {
    private static CLogger s_log = CLogger.getCLogger(MDistributionRunDetail.class);
    private int m_precision = 0;

    public static MDistributionRunDetail[] get(Ctx ctx, int M_DistributionRun_ID, boolean orderBP, String trxName) {
        ArrayList<MDistributionRunDetail> list = new ArrayList<MDistributionRunDetail>();
        String sql = "SELECT * FROM T_DistributionRunDetail WHERE M_DistributionRun_ID=? ";
        sql = orderBP ? sql + "ORDER BY C_BPartner_ID, C_BPartner_Location_ID" : sql + "ORDER BY M_DistributionRunLine_ID";
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement((String)sql, (String)trxName);
            pstmt.setInt(1, M_DistributionRun_ID);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                list.add(new MDistributionRunDetail(ctx, rs, trxName));
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            s_log.log(Level.SEVERE, sql, (Throwable)e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        MDistributionRunDetail[] retValue = new MDistributionRunDetail[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    public MDistributionRunDetail(Ctx ctx, int T_DistributionRunDetail_ID, String trxName) {
        super(ctx, T_DistributionRunDetail_ID, trxName);
    }

    public MDistributionRunDetail(Ctx ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public void round(int precision) {
        BigDecimal qty;
        boolean dirty = false;
        this.m_precision = precision;
        BigDecimal min = this.getMinQty();
        if (min.scale() > this.m_precision) {
            this.setMinQty(min.setScale(this.m_precision, 4));
            dirty = true;
        }
        if ((qty = this.getQty()).scale() > this.m_precision) {
            this.setQty(qty.setScale(this.m_precision, 4));
            dirty = true;
        }
        if (dirty) {
            this.save();
        }
    }

    public boolean isCanAdjust() {
        return this.getQty().compareTo(this.getMinQty()) > 0;
    }

    public BigDecimal getActualAllocation() {
        if (this.getQty().compareTo(this.getMinQty()) > 0) {
            return this.getQty();
        }
        return this.getMinQty();
    }

    public BigDecimal adjustQty(BigDecimal difference) {
        BigDecimal diff = difference.setScale(this.m_precision, 4);
        BigDecimal qty = this.getQty();
        BigDecimal max = this.getMinQty().subtract(qty);
        BigDecimal remaining = Env.ZERO;
        if (max.compareTo(diff) > 0) {
            remaining = diff.subtract(max);
            this.setQty(qty.add(max));
        } else {
            this.setQty(qty.add(diff));
        }
        this.log.fine("Qty=" + qty + ", Min=" + this.getMinQty() + ", Max=" + max + ", Diff=" + diff + ", newQty=" + this.getQty() + ", Remaining=" + remaining);
        return remaining;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("MDistributionRunDetail[").append(this.get_ID()).append(";M_DistributionListLine_ID=").append(this.getM_DistributionListLine_ID()).append(";Qty=").append(this.getQty()).append(";Ratio=").append(this.getRatio()).append(";MinQty=").append(this.getMinQty()).append("]");
        return sb.toString();
    }
}

