/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.util.logging.Level;
import org.compiere.model.X_GL_Category;
import org.compiere.util.CCache;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.Ctx;
import org.compiere.util.DB;

public class MGLCategory
extends X_GL_Category {
    private static CLogger s_log = CLogger.getCLogger(MGLCategory.class);
    private static CCache<Integer, MGLCategory> s_cache = new CCache("GL_Category", 5);

    public static MGLCategory get(Ctx ctx, int GL_Category_ID) {
        Integer key = new Integer(GL_Category_ID);
        MGLCategory retValue = (MGLCategory)((Object)s_cache.get((Object)key));
        if (retValue != null) {
            return retValue;
        }
        retValue = new MGLCategory(ctx, GL_Category_ID, null);
        if (retValue.get_ID() != 0) {
            s_cache.put((Object)key, (Object)retValue);
        }
        return retValue;
    }

    public static MGLCategory getDefault(Ctx ctx, String CategoryType) {
        MGLCategory retValue = null;
        String sql = "SELECT * FROM GL_Category WHERE AD_Client_ID=? AND IsDefault='Y'";
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement((String)sql, null);
            pstmt.setInt(1, ctx.getAD_Client_ID());
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                MGLCategory temp = new MGLCategory(ctx, rs, null);
                if (CategoryType != null && CategoryType.equals(temp.getCategoryType())) {
                    retValue = temp;
                    break;
                }
                if (retValue != null) continue;
                retValue = temp;
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            s_log.log(Level.SEVERE, sql, (Throwable)e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        return retValue;
    }

    public static MGLCategory getDefaultSystem(Ctx ctx) {
        MGLCategory retValue = MGLCategory.getDefault(ctx, "S");
        if (retValue == null || !retValue.getCategoryType().equals("S")) {
            retValue = new MGLCategory(ctx, 0, null);
            retValue.setName("Default System");
            retValue.setCategoryType("S");
            retValue.setIsDefault(true);
            if (!retValue.save()) {
                throw new IllegalStateException("Could not save default system GL Category");
            }
        }
        return retValue;
    }

    public MGLCategory(Ctx ctx, int GL_Category_ID, String trxName) {
        super(ctx, GL_Category_ID, trxName);
        if (GL_Category_ID == 0) {
            this.setCategoryType("M");
            this.setIsDefault(false);
        }
    }

    public MGLCategory(Ctx ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }
}

