/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.logging.Level;
import org.apache.commons.net.ftp.FTPClient;
import org.compiere.model.MImage;
import org.compiere.model.MMedia;
import org.compiere.model.MMediaDeploy;
import org.compiere.model.MWebProject;
import org.compiere.model.X_CM_Media_Server;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.Ctx;
import org.compiere.util.DB;

public class MMediaServer
extends X_CM_Media_Server {
    private static CLogger s_log = CLogger.getCLogger(MMediaServer.class);
    public MWebProject m_project = null;

    public static MMediaServer[] getMediaServer(MWebProject project) {
        ArrayList<MMediaServer> list = new ArrayList<MMediaServer>();
        CPreparedStatement pstmt = null;
        String sql = "SELECT * FROM CM_Media_Server WHERE CM_WebProject_ID=? ORDER BY CM_Media_Server_ID";
        try {
            pstmt = DB.prepareStatement((String)sql, (String)project.get_TrxName());
            pstmt.setInt(1, project.getCM_WebProject_ID());
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                list.add(new MMediaServer(project.getCtx(), rs, project.get_TrxName()));
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            s_log.log(Level.SEVERE, sql, (Throwable)e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        MMediaServer[] retValue = new MMediaServer[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    public MMediaServer(Ctx ctx, int CM_Media_Server_ID, String trxName) {
        super(ctx, CM_Media_Server_ID, trxName);
    }

    public MMediaServer(Ctx ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MWebProject getWebProject() {
        if (this.m_project == null) {
            this.m_project = new MWebProject(this.getCtx(), this.getCM_WebProject_ID(), this.get_TrxName());
        }
        return this.m_project;
    }

    public void reDeployAll() {
        MMedia[] media = MMedia.getMedia(this.getWebProject());
        if (media != null && media.length > 0) {
            for (int i = 0; i < media.length; ++i) {
                MMediaDeploy thisDeploy = MMediaDeploy.getByMedia(this.getCtx(), media[i].get_ID(), this.get_ID(), true, null);
                if (!thisDeploy.isDeployed()) continue;
                this.log.log(Level.FINE, "Reset Deployed Flag on MediaItem" + media[i].get_ID());
                thisDeploy.setIsDeployed(false);
                thisDeploy.save();
            }
        }
    }

    public boolean deploy() {
        MMedia[] media = MMedia.getMediaToDeploy(this.getCtx(), this.get_ID(), this.get_TrxName());
        if (this.getIP_Address().equals("127.0.0.1") || this.getName().equals("localhost")) {
            this.log.warning("You have not defined your own server, we will not really deploy to localhost!");
            return true;
        }
        FTPClient ftp = new FTPClient();
        try {
            ftp.connect(this.getIP_Address());
            if (!ftp.login(this.getUserName(), this.getPassword())) {
                this.log.warning("Could NOT connect to " + this.getIP_Address() + " as " + this.getUserName());
                return false;
            }
            this.log.info("Connected to " + this.getIP_Address() + " as " + this.getUserName());
        }
        catch (Exception e) {
            this.log.log(Level.WARNING, "Could NOT connect to " + this.getIP_Address() + " as " + this.getUserName(), (Throwable)e);
            return false;
        }
        boolean success = true;
        String cmd = null;
        try {
            cmd = "cwd";
            ftp.changeWorkingDirectory(this.getFolder());
            cmd = "list";
            String[] fileNames = ftp.listNames();
            this.log.log(Level.FINE, "Number of files in " + this.getFolder() + ": " + fileNames.length);
            cmd = "bin";
            ftp.setFileType(2);
            for (int i = 0; i < media.length; ++i) {
                MMediaDeploy thisDeployment = MMediaDeploy.getByMedia(this.getCtx(), media[i].get_ID(), this.get_ID(), false, this.get_TrxName());
                if (media[i].isSummary() || media[i].getMediaType() == null) continue;
                this.log.log(Level.INFO, " Deploying Media Item: " + media[i].toString());
                MImage thisImage = media[i].getImage();
                byte[] buffer = thisImage.getData();
                ByteArrayInputStream is = new ByteArrayInputStream(buffer);
                String fileName = media[i].get_ID() + media[i].getExtension();
                cmd = "put " + fileName;
                ftp.storeFile(fileName, (InputStream)is);
                is.close();
                thisDeployment.setIsDeployed(true);
                thisDeployment.save();
            }
        }
        catch (Exception e) {
            this.log.log(Level.WARNING, cmd, (Throwable)e);
            success = false;
        }
        try {
            cmd = "logout";
            ftp.logout();
            this.log.log(Level.FINE, " FTP logged out");
            cmd = "disconnect";
            ftp.disconnect();
        }
        catch (Exception e) {
            this.log.log(Level.WARNING, cmd, (Throwable)e);
        }
        ftp = null;
        return success;
    }

    public boolean deleteMediaItem(MMedia t_media) {
        if (this.getIP_Address().equals("127.0.0.1") || this.getName().equals("localhost")) {
            this.log.warning("You have not defined your own server, we will not really deploy to localhost!");
            return true;
        }
        FTPClient ftp = new FTPClient();
        try {
            ftp.connect(this.getIP_Address());
            if (!ftp.login(this.getUserName(), this.getPassword())) {
                this.log.warning("Could NOT connect to " + this.getIP_Address() + " as " + this.getUserName());
                return false;
            }
            this.log.info("Connected to " + this.getIP_Address() + " as " + this.getUserName());
        }
        catch (Exception e) {
            this.log.log(Level.WARNING, "Could NOT connect to " + this.getIP_Address() + " as " + this.getUserName(), (Throwable)e);
            return false;
        }
        boolean success = true;
        String cmd = null;
        try {
            cmd = "cwd";
            ftp.changeWorkingDirectory(this.getFolder());
            if (!t_media.isSummary()) {
                this.log.log(Level.INFO, " Deleting Media Item:" + t_media.get_ID() + t_media.getExtension());
                ftp.dele(t_media.get_ID() + t_media.getExtension());
            }
        }
        catch (Exception e) {
            this.log.log(Level.WARNING, cmd, (Throwable)e);
            success = false;
        }
        try {
            cmd = "logout";
            ftp.logout();
            cmd = "disconnect";
            ftp.disconnect();
        }
        catch (Exception e) {
            this.log.log(Level.WARNING, cmd, (Throwable)e);
        }
        ftp = null;
        return success;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("MMediaServer[").append(this.get_ID()).append("-").append(this.getName()).append("]");
        return sb.toString();
    }
}

