/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.io.File;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.logging.Level;
import org.compiere.api.UICallout;
import org.compiere.framework.ModelValidationEngine;
import org.compiere.framework.PO;
import org.compiere.model.MBPartner;
import org.compiere.model.MBPartnerLocation;
import org.compiere.model.MConversionRate;
import org.compiere.model.MCurrency;
import org.compiere.model.MDocType;
import org.compiere.model.MDocTypeCounter;
import org.compiere.model.MInOut;
import org.compiere.model.MInOutLine;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MOrderLine;
import org.compiere.model.MOrderTax;
import org.compiere.model.MOrg;
import org.compiere.model.MOrgInfo;
import org.compiere.model.MPeriod;
import org.compiere.model.MPriceList;
import org.compiere.model.MProduct;
import org.compiere.model.MProductBOM;
import org.compiere.model.MProductLocator;
import org.compiere.model.MProject;
import org.compiere.model.MRefList;
import org.compiere.model.MReturnPolicy;
import org.compiere.model.MRole;
import org.compiere.model.MStorage;
import org.compiere.model.MTax;
import org.compiere.model.MUser;
import org.compiere.model.MWarehouse;
import org.compiere.model.X_C_Order;
import org.compiere.print.ReportEngine;
import org.compiere.process.DocAction;
import org.compiere.process.DocumentEngine;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.Ctx;
import org.compiere.util.DB;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.Ini;
import org.compiere.util.Msg;

public class MOrder
extends X_C_Order
implements DocAction {
    private MOrderLine[] m_lines = null;
    private MOrderTax[] m_taxes = null;
    private boolean m_forceCreation = false;
    public static final String DocSubTypeSO_Standard = "SO";
    public static final String DocSubTypeSO_Quotation = "OB";
    public static final String DocSubTypeSO_Proposal = "ON";
    public static final String DocSubTypeSO_Prepay = "PR";
    public static final String DocSubTypeSO_POS = "WR";
    public static final String DocSubTypeSO_Warehouse = "WP";
    public static final String DocSubTypeSO_OnCredit = "WI";
    public static final String DocSubTypeSO_RMA = "RM";
    private String m_processMsg = null;
    private boolean m_justPrepared = false;

    public static MOrder copyFrom(MOrder from, Timestamp dateDoc, int C_DocTypeTarget_ID, boolean counter, boolean copyASI, String trxName) {
        MOrder to = new MOrder(from.getCtx(), 0, trxName);
        to.set_TrxName(trxName);
        PO.copyValues((PO)from, (PO)to, (int)from.getAD_Client_ID(), (int)from.getAD_Org_ID());
        to.set_ValueNoCheck("C_Order_ID", I_ZERO);
        to.set_ValueNoCheck("DocumentNo", null);
        to.setDocStatus("DR");
        to.setDocAction("CO");
        to.setC_DocType_ID(0);
        to.setC_DocTypeTarget_ID(C_DocTypeTarget_ID, true);
        to.setIsSelected(false);
        to.setDateOrdered(dateDoc);
        to.setDateAcct(dateDoc);
        to.setDatePromised(dateDoc);
        to.setDatePrinted(null);
        to.setIsPrinted(false);
        to.setIsApproved(false);
        to.setIsCreditApproved(false);
        to.setC_Payment_ID(0);
        to.setC_CashLine_ID(0);
        to.setGrandTotal(Env.ZERO);
        to.setTotalLines(Env.ZERO);
        to.setIsDelivered(false);
        to.setIsInvoiced(false);
        to.setIsSelfService(false);
        to.setIsTransferred(false);
        to.setPosted(false);
        to.setProcessed(false);
        if (counter) {
            to.setRef_Order_ID(from.getC_Order_ID());
        } else {
            to.setRef_Order_ID(0);
        }
        if (!to.save(trxName)) {
            throw new IllegalStateException("Could not create Order");
        }
        if (counter) {
            from.setRef_Order_ID(to.getC_Order_ID());
        }
        if (to.copyLinesFrom(from, counter, copyASI) == 0) {
            throw new IllegalStateException("Could not create Order Lines");
        }
        return to;
    }

    public MOrder(Ctx ctx, int C_Order_ID, String trxName) {
        super(ctx, C_Order_ID, trxName);
        if (C_Order_ID == 0) {
            this.setDocStatus("DR");
            this.setDocAction(DocSubTypeSO_Prepay);
            this.setDeliveryRule("A");
            this.setFreightCostRule("I");
            this.setInvoiceRule("I");
            this.setPaymentRule("P");
            this.setPriorityRule("5");
            this.setDeliveryViaRule("P");
            this.setIsDiscountPrinted(false);
            this.setIsSelected(false);
            this.setIsTaxIncluded(false);
            this.setIsSOTrx(true);
            this.setIsDropShip(false);
            this.setSendEMail(false);
            this.setIsApproved(false);
            this.setIsPrinted(false);
            this.setIsCreditApproved(false);
            this.setIsDelivered(false);
            this.setIsInvoiced(false);
            this.setIsTransferred(false);
            this.setIsSelfService(false);
            this.setIsReturnTrx(false);
            super.setProcessed(false);
            this.setProcessing(false);
            this.setPosted(false);
            this.setDateAcct(new Timestamp(System.currentTimeMillis()));
            this.setDatePromised(new Timestamp(System.currentTimeMillis()));
            this.setDateOrdered(new Timestamp(System.currentTimeMillis()));
            this.setFreightAmt(Env.ZERO);
            this.setChargeAmt(Env.ZERO);
            this.setTotalLines(Env.ZERO);
            this.setGrandTotal(Env.ZERO);
        }
    }

    public MOrder(MProject project, boolean IsSOTrx, String DocSubTypeSO) {
        this(project.getCtx(), 0, project.get_TrxName());
        this.setAD_Client_ID(project.getAD_Client_ID());
        this.setAD_Org_ID(project.getAD_Org_ID());
        this.setC_Campaign_ID(project.getC_Campaign_ID());
        this.setSalesRep_ID(project.getSalesRep_ID());
        this.setC_Project_ID(project.getC_Project_ID());
        this.setDescription(project.getName());
        Timestamp ts = project.getDateContract();
        if (ts != null) {
            this.setDateOrdered(ts);
        }
        if ((ts = project.getDateFinish()) != null) {
            this.setDatePromised(ts);
        }
        this.setC_BPartner_ID(project.getC_BPartner_ID());
        this.setC_BPartner_Location_ID(project.getC_BPartner_Location_ID());
        this.setAD_User_ID(project.getAD_User_ID());
        this.setM_Warehouse_ID(project.getM_Warehouse_ID());
        this.setM_PriceList_ID(project.getM_PriceList_ID());
        this.setC_PaymentTerm_ID(project.getC_PaymentTerm_ID());
        this.setIsSOTrx(IsSOTrx);
        if (IsSOTrx) {
            if (DocSubTypeSO == null || DocSubTypeSO.length() == 0) {
                this.setC_DocTypeTarget_ID(DocSubTypeSO_OnCredit);
            } else {
                this.setC_DocTypeTarget_ID(DocSubTypeSO);
            }
        } else {
            this.setC_DocTypeTarget_ID();
        }
    }

    public MOrder(Ctx ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public void setClientOrg(int AD_Client_ID, int AD_Org_ID) {
        super.setClientOrg(AD_Client_ID, AD_Org_ID);
    }

    public void addDescription(String description) {
        String desc = this.getDescription();
        if (desc == null) {
            this.setDescription(description);
        } else {
            this.setDescription(desc + " | " + description);
        }
    }

    public void setC_BPartner_ID(int C_BPartner_ID) {
        super.setC_BPartner_ID(C_BPartner_ID);
        super.setBill_BPartner_ID(C_BPartner_ID);
    }

    public void setBPartner(MBPartner bp) {
        MUser[] contacts;
        MBPartnerLocation[] locs;
        String ss;
        if (bp == null || !bp.isActive()) {
            return;
        }
        this.setC_BPartner_ID(bp.getC_BPartner_ID());
        int ii = 0;
        ii = this.isSOTrx() ? bp.getC_PaymentTerm_ID() : bp.getPO_PaymentTerm_ID();
        if (ii != 0) {
            this.setC_PaymentTerm_ID(ii);
        }
        if ((ii = this.isSOTrx() ? bp.getM_PriceList_ID() : bp.getPO_PriceList_ID()) != 0) {
            this.setM_PriceList_ID(ii);
        }
        if ((ss = bp.getDeliveryRule()) != null) {
            this.setDeliveryRule(ss);
        }
        if ((ss = bp.getDeliveryViaRule()) != null) {
            this.setDeliveryViaRule(ss);
        }
        if ((ss = bp.getInvoiceRule()) != null) {
            this.setInvoiceRule(ss);
        }
        if ((ss = this.isSOTrx() ? bp.getPaymentRule() : bp.getPaymentRulePO()) != null) {
            this.setPaymentRule(ss);
        }
        if ((ii = bp.getSalesRep_ID()) != 0) {
            this.setSalesRep_ID(ii);
        }
        if ((locs = bp.getLocations(false)) != null) {
            for (int i = 0; i < locs.length; ++i) {
                if (locs[i].isShipTo()) {
                    super.setC_BPartner_Location_ID(locs[i].getC_BPartner_Location_ID());
                }
                if (!locs[i].isBillTo()) continue;
                this.setBill_Location_ID(locs[i].getC_BPartner_Location_ID());
            }
            if (this.getC_BPartner_Location_ID() == 0 && locs.length > 0) {
                super.setC_BPartner_Location_ID(locs[0].getC_BPartner_Location_ID());
            }
            if (this.getBill_Location_ID() == 0 && locs.length > 0) {
                this.setBill_Location_ID(locs[0].getC_BPartner_Location_ID());
            }
        }
        if (this.getC_BPartner_Location_ID() == 0) {
            this.log.log(Level.SEVERE, "MOrder.setBPartner - Has no Ship To Address: " + (Object)((Object)bp));
        }
        if (this.getBill_Location_ID() == 0) {
            this.log.log(Level.SEVERE, "MOrder.setBPartner - Has no Bill To Address: " + (Object)((Object)bp));
        }
        if ((contacts = bp.getContacts(false)) != null && contacts.length == 1) {
            this.setAD_User_ID(contacts[0].getAD_User_ID());
        }
    }

    @UICallout
    public void setC_BPartner_ID(String oldC_BPartner_ID, String newC_BPartner_ID, int windowNo) throws Exception {
        if (newC_BPartner_ID == null || newC_BPartner_ID.length() == 0) {
            return;
        }
        int C_BPartner_ID = Integer.parseInt(newC_BPartner_ID);
        if (C_BPartner_ID == 0) {
            return;
        }
        if (this.isReturnTrx()) {
            return;
        }
        String sql = "SELECT p.AD_Language,p.C_PaymentTerm_ID, COALESCE(p.M_PriceList_ID,g.M_PriceList_ID) AS M_PriceList_ID, p.PaymentRule,p.POReference, p.SO_Description,p.IsDiscountPrinted, p.InvoiceRule,p.DeliveryRule,p.FreightCostRule,DeliveryViaRule, p.SO_CreditLimit, p.SO_CreditLimit-p.SO_CreditUsed AS CreditAvailable, lship.C_BPartner_Location_ID,c.AD_User_ID, COALESCE(p.PO_PriceList_ID,g.PO_PriceList_ID) AS PO_PriceList_ID, p.PaymentRulePO,p.PO_PaymentTerm_ID, lbill.C_BPartner_Location_ID AS Bill_Location_ID, p.SOCreditStatus, lbill.IsShipTo FROM C_BPartner p INNER JOIN C_BP_Group g ON (p.C_BP_Group_ID=g.C_BP_Group_ID) LEFT OUTER JOIN C_BPartner_Location lbill ON (p.C_BPartner_ID=lbill.C_BPartner_ID AND lbill.IsBillTo='Y' AND lbill.IsActive='Y') LEFT OUTER JOIN C_BPartner_Location lship ON (p.C_BPartner_ID=lship.C_BPartner_ID AND lship.IsShipTo='Y' AND lship.IsActive='Y') LEFT OUTER JOIN AD_User c ON (p.C_BPartner_ID=c.C_BPartner_ID) WHERE p.C_BPartner_ID=? AND p.IsActive='Y'";
        boolean IsSOTrx = this.isSOTrx();
        try {
            CPreparedStatement pstmt = DB.prepareStatement((String)sql, null);
            pstmt.setInt(1, C_BPartner_ID);
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                String s;
                BigDecimal CreditLimit;
                String cont;
                String loc;
                super.setC_BPartner_ID(C_BPartner_ID);
                int ii = rs.getInt(IsSOTrx ? "M_PriceList_ID" : "PO_PriceList_ID");
                if (ii != 0) {
                    this.setM_PriceList_ID(null, String.valueOf(ii), windowNo);
                } else {
                    ii = this.getCtx().getContextAsInt("#M_PriceList_ID");
                    if (ii != 0) {
                        this.setM_PriceList_ID(null, String.valueOf(ii), windowNo);
                    }
                }
                this.setBill_BPartner_ID(C_BPartner_ID);
                int bill_Location_ID = rs.getInt("Bill_Location_ID");
                if (bill_Location_ID == 0) {
                    this.p_changeVO.addChangedValue("Bill_Location_ID", (Object)null);
                } else {
                    this.setBill_Location_ID(bill_Location_ID);
                }
                int shipTo_ID = rs.getInt("C_BPartner_Location_ID");
                if (this.getCtx().getContextAsInt(1113, 1113, "C_BPartner_ID") == C_BPartner_ID && (loc = this.getCtx().getContext(1113, 1113, "C_BPartner_Location_ID")).length() > 0) {
                    shipTo_ID = Integer.parseInt(loc);
                }
                if (shipTo_ID == 0) {
                    this.p_changeVO.addChangedValue("C_BPartner_Location_ID", (Object)null);
                } else {
                    this.setC_BPartner_Location_ID(shipTo_ID);
                }
                if ("Y".equals(rs.getString("IsShipTo"))) {
                    this.setBill_Location_ID(shipTo_ID);
                }
                int contID = rs.getInt("AD_User_ID");
                if (this.getCtx().getContextAsInt(1113, 1113, "C_BPartner_ID") == C_BPartner_ID && (cont = this.getCtx().getContext(1113, 1113, "AD_User_ID")).length() > 0) {
                    contID = Integer.parseInt(cont);
                }
                this.setAD_User_ID(contID);
                this.setBill_User_ID(contID);
                if (IsSOTrx && (CreditLimit = rs.getBigDecimal("SO_CreditLimit")) != null && CreditLimit.signum() != 0) {
                    BigDecimal CreditAvailable = rs.getBigDecimal("CreditAvailable");
                    if (this.p_changeVO != null && CreditAvailable != null && CreditAvailable.signum() < 0) {
                        String msg = Msg.getMsg((Ctx)this.getCtx(), (String)"CreditLimitOver", (Object)DisplayType.getNumberFormat((int)12).format(CreditAvailable));
                        this.p_changeVO.addError(msg);
                    }
                }
                if ((s = rs.getString("POReference")) != null && s.length() != 0) {
                    this.setPOReference(s);
                }
                if ((s = rs.getString("SO_Description")) != null && s.trim().length() != 0) {
                    this.setDescription(s);
                }
                s = rs.getString("IsDiscountPrinted");
                this.setIsDiscountPrinted("Y".equals(s));
                String OrderType = this.getCtx().getContext(windowNo, "OrderType");
                this.setInvoiceRule("D");
                this.setDeliveryRule("A");
                this.setPaymentRule("P");
                if (OrderType.equals(DocSubTypeSO_Prepay)) {
                    this.setInvoiceRule("I");
                    this.setDeliveryRule("R");
                } else if (OrderType.equals(DocSubTypeSO_POS)) {
                    this.setPaymentRule("B");
                } else {
                    s = rs.getString(IsSOTrx ? "PaymentRule" : "PaymentRulePO");
                    if (s != null && s.length() != 0) {
                        if (s.equals("B")) {
                            s = "P";
                        }
                        if (IsSOTrx && (s.equals("S") || s.equals("U"))) {
                            s = "P";
                        }
                        this.setPaymentRule(s);
                    }
                    if ((ii = rs.getInt(IsSOTrx ? "C_PaymentTerm_ID" : "PO_PaymentTerm_ID")) != 0) {
                        this.setC_PaymentTerm_ID(ii);
                    }
                    if ((s = rs.getString("InvoiceRule")) != null && s.length() != 0) {
                        this.setInvoiceRule(s);
                    }
                    if ((s = rs.getString("DeliveryRule")) != null && s.length() != 0) {
                        this.setDeliveryRule(s);
                    }
                    if ((s = rs.getString("FreightCostRule")) != null && s.length() != 0) {
                        this.setFreightCostRule(s);
                    }
                    if ((s = rs.getString("DeliveryViaRule")) != null && s.length() != 0) {
                        this.setDeliveryViaRule(s);
                    }
                }
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            this.log.log(Level.SEVERE, sql, (Throwable)e);
        }
    }

    @UICallout
    public void setBill_BPartner_ID(String oldBill_BPartner_ID, String newBill_BPartner_ID, int windowNo) throws Exception {
        if (newBill_BPartner_ID == null || newBill_BPartner_ID.length() == 0) {
            return;
        }
        int bill_BPartner_ID = Integer.parseInt(newBill_BPartner_ID);
        if (bill_BPartner_ID == 0) {
            return;
        }
        if (this.isReturnTrx()) {
            return;
        }
        String sql = "SELECT p.AD_Language,p.C_PaymentTerm_ID,p.M_PriceList_ID,p.PaymentRule,p.POReference,p.SO_Description,p.IsDiscountPrinted,p.InvoiceRule,p.DeliveryRule,p.FreightCostRule,DeliveryViaRule,p.SO_CreditLimit, p.SO_CreditLimit-p.SO_CreditUsed AS CreditAvailable,c.AD_User_ID,p.PO_PriceList_ID, p.PaymentRulePO, p.PO_PaymentTerm_ID,lbill.C_BPartner_Location_ID AS Bill_Location_ID FROM C_BPartner p LEFT OUTER JOIN C_BPartner_Location lbill ON (p.C_BPartner_ID=lbill.C_BPartner_ID AND lbill.IsBillTo='Y' AND lbill.IsActive='Y') LEFT OUTER JOIN AD_User c ON (p.C_BPartner_ID=c.C_BPartner_ID) WHERE p.C_BPartner_ID=? AND p.IsActive='Y'";
        boolean IsSOTrx = this.isSOTrx();
        try {
            CPreparedStatement pstmt = DB.prepareStatement((String)sql, null);
            pstmt.setInt(1, bill_BPartner_ID);
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                BigDecimal CreditLimit;
                String cont;
                String loc;
                super.setBill_BPartner_ID(bill_BPartner_ID);
                int ii = rs.getInt(IsSOTrx ? "M_PriceList_ID" : "PO_PriceList_ID");
                if (ii != 0) {
                    this.setM_PriceList_ID(null, String.valueOf(ii), windowNo);
                } else {
                    ii = this.getCtx().getContextAsInt("#M_PriceList_ID");
                    if (ii != 0) {
                        this.setM_PriceList_ID(null, String.valueOf(ii), windowNo);
                    }
                }
                int bill_Location_ID = rs.getInt("Bill_Location_ID");
                if (this.getCtx().getContextAsInt(1113, 1113, "C_BPartner_ID") == bill_BPartner_ID && (loc = this.getCtx().getContext(1113, 1113, "C_BPartner_Location_ID")).length() > 0) {
                    bill_Location_ID = Integer.parseInt(loc);
                }
                if (bill_Location_ID != 0) {
                    this.setBill_Location_ID(bill_Location_ID);
                }
                int contID = rs.getInt("AD_User_ID");
                if (this.getCtx().getContextAsInt(1113, 1113, "C_BPartner_ID") == bill_BPartner_ID && (cont = this.getCtx().getContext(1113, 1113, "AD_User_ID")).length() > 0) {
                    contID = Integer.parseInt(cont);
                }
                this.setBill_User_ID(contID);
                if (IsSOTrx && (CreditLimit = rs.getBigDecimal("SO_CreditLimit")) != null && CreditLimit.signum() != 0) {
                    BigDecimal CreditAvailable = rs.getBigDecimal("CreditAvailable");
                    if (this.p_changeVO != null && CreditAvailable != null && CreditAvailable.signum() < 0) {
                        String msg = Msg.getMsg((Ctx)this.getCtx(), (String)"CreditLimitOver", (Object)DisplayType.getNumberFormat((int)12).format(CreditAvailable));
                        this.p_changeVO.addError(msg);
                    }
                }
                String s = rs.getString("POReference");
                s = rs.getString("SO_Description");
                if (s != null && s.trim().length() != 0) {
                    this.setDescription(s);
                }
                s = rs.getString("IsDiscountPrinted");
                this.setIsDiscountPrinted("Y".equals(s));
                String OrderType = this.getCtx().getContext(windowNo, "OrderType");
                this.setInvoiceRule("D");
                this.setPaymentRule("P");
                if (OrderType.equals(DocSubTypeSO_Prepay)) {
                    this.setInvoiceRule("I");
                } else if (OrderType.equals(DocSubTypeSO_POS)) {
                    this.setPaymentRule("B");
                } else {
                    s = rs.getString(IsSOTrx ? "PaymentRule" : "PaymentRulePO");
                    if (s != null && s.length() != 0) {
                        if (s.equals("B")) {
                            s = "P";
                        }
                        if (IsSOTrx && (s.equals("S") || s.equals("U"))) {
                            s = "P";
                        }
                        this.setPaymentRule(s);
                    }
                    if ((ii = rs.getInt(IsSOTrx ? "C_PaymentTerm_ID" : "PO_PaymentTerm_ID")) != 0) {
                        this.setC_PaymentTerm_ID(ii);
                    }
                    if ((s = rs.getString("InvoiceRule")) != null && s.length() != 0) {
                        this.setInvoiceRule(s);
                    }
                }
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            this.log.log(Level.SEVERE, "bPartnerBill", (Throwable)e);
        }
    }

    public void setC_BPartner_Location_ID(int C_BPartner_Location_ID) {
        super.setC_BPartner_Location_ID(C_BPartner_Location_ID);
        super.setBill_Location_ID(C_BPartner_Location_ID);
    }

    public void setAD_User_ID(int AD_User_ID) {
        super.setAD_User_ID(AD_User_ID);
        super.setBill_User_ID(AD_User_ID);
    }

    public void setShip_BPartner_ID(int C_BPartner_ID) {
        super.setC_BPartner_ID(C_BPartner_ID);
    }

    public void setShip_Location_ID(int C_BPartner_Location_ID) {
        super.setC_BPartner_Location_ID(C_BPartner_Location_ID);
    }

    public void setShip_User_ID(int AD_User_ID) {
        super.setAD_User_ID(AD_User_ID);
    }

    public void setM_Warehouse_ID(int M_Warehouse_ID) {
        super.setM_Warehouse_ID(M_Warehouse_ID);
    }

    public void setIsDropShip(boolean IsDropShip) {
        super.setIsDropShip(IsDropShip);
    }

    @UICallout
    public void setDateOrdered(String oldDateOrdered, String newDateOrdered, int windowNo) throws Exception {
        if (newDateOrdered == null || newDateOrdered.length() == 0) {
            return;
        }
        Timestamp dateOrdered = PO.convertToTimestamp((String)newDateOrdered);
        if (dateOrdered == null) {
            return;
        }
        this.setDateOrdered(dateOrdered);
    }

    public void setDateOrdered(Timestamp dateOrdered) {
        super.setDateOrdered(dateOrdered);
        super.setDateAcct(dateOrdered);
    }

    @UICallout
    public void setC_DocTypeTarget_ID(String oldC_DocTypeTarget_ID, String newC_DocTypeTarget_ID, int windowNo) throws Exception {
        boolean newDocNo;
        if (newC_DocTypeTarget_ID == null || newC_DocTypeTarget_ID.length() == 0) {
            return;
        }
        int C_DocTypeTarget_ID = Integer.parseInt(newC_DocTypeTarget_ID);
        if (C_DocTypeTarget_ID == 0) {
            return;
        }
        String oldDocNo = this.getDocumentNo();
        boolean bl = newDocNo = oldDocNo == null;
        if (!newDocNo && oldDocNo.startsWith("<") && oldDocNo.endsWith(">")) {
            newDocNo = true;
        }
        int oldC_DocType_ID = this.getC_DocType_ID();
        String sql = "SELECT d.DocSubTypeSO,d.HasCharges,'N',d.IsDocNoControlled,s.CurrentNext,s.CurrentNextSys,s.AD_Sequence_ID,d.IsSOTrx,d.IsReturnTrx FROM C_DocType d LEFT OUTER JOIN AD_Sequence s ON (d.DocNoSequence_ID=s.AD_Sequence_ID) WHERE C_DocType_ID=?";
        try {
            ResultSet rs;
            CPreparedStatement pstmt;
            int AD_Sequence_ID = 0;
            if (!newDocNo && oldC_DocType_ID != 0) {
                pstmt = DB.prepareStatement((String)sql, null);
                pstmt.setInt(1, oldC_DocType_ID);
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    AD_Sequence_ID = rs.getInt(6);
                }
                rs.close();
                pstmt.close();
            }
            pstmt = DB.prepareStatement((String)sql, null);
            pstmt.setInt(1, C_DocTypeTarget_ID);
            rs = pstmt.executeQuery();
            String DocSubTypeSO = "";
            boolean IsSOTrx = true;
            boolean IsReturnTrx = false;
            if (rs.next()) {
                super.setC_DocTypeTarget_ID(C_DocTypeTarget_ID);
                DocSubTypeSO = rs.getString(1);
                if (DocSubTypeSO == null) {
                    DocSubTypeSO = "--";
                }
                if (this.p_changeVO != null) {
                    this.p_changeVO.setContext(this.getCtx(), windowNo, "OrderType", DocSubTypeSO);
                }
                if (!DocSubTypeSO.equals(DocSubTypeSO_Standard)) {
                    this.setIsDropShip(false);
                }
                if ("N".equals(rs.getString(8))) {
                    IsSOTrx = false;
                }
                this.setIsSOTrx(IsSOTrx);
                IsReturnTrx = "Y".equals(rs.getString(9));
                this.setIsReturnTrx(IsReturnTrx);
                if (!IsReturnTrx) {
                    if (DocSubTypeSO.equals(DocSubTypeSO_POS)) {
                        this.setDeliveryRule("F");
                    } else if (DocSubTypeSO.equals(DocSubTypeSO_Prepay)) {
                        this.setDeliveryRule("R");
                    } else {
                        this.setDeliveryRule("A");
                    }
                    if (DocSubTypeSO.equals(DocSubTypeSO_POS) || DocSubTypeSO.equals(DocSubTypeSO_Prepay) || DocSubTypeSO.equals(DocSubTypeSO_OnCredit)) {
                        this.setInvoiceRule("I");
                    } else {
                        this.setInvoiceRule("D");
                    }
                    if (DocSubTypeSO.equals(DocSubTypeSO_POS)) {
                        this.setPaymentRule("B");
                    } else {
                        this.setPaymentRule("P");
                    }
                    if (this.p_changeVO != null) {
                        this.p_changeVO.setContext(this.getCtx(), windowNo, "HasCharges", rs.getString(2));
                    }
                } else if (DocSubTypeSO.equals(DocSubTypeSO_POS)) {
                    this.setDeliveryRule("F");
                } else {
                    this.setDeliveryRule("M");
                }
                if (rs.getString(4).equals("Y")) {
                    if (!newDocNo && AD_Sequence_ID != rs.getInt(7)) {
                        newDocNo = true;
                    }
                    if (newDocNo) {
                        if (Ini.isPropertyBool((String)"CompiereSys") && Env.getCtx().getAD_Client_ID() < 1000000) {
                            this.setDocumentNo("<" + rs.getString(6) + ">");
                        } else {
                            this.setDocumentNo("<" + rs.getString(5) + ">");
                        }
                    }
                }
            }
            rs.close();
            pstmt.close();
            if (IsReturnTrx) {
                return;
            }
            if (!DocSubTypeSO.equals(DocSubTypeSO_POS) && !DocSubTypeSO.equals(DocSubTypeSO_Prepay)) {
                sql = "SELECT PaymentRule,C_PaymentTerm_ID,InvoiceRule,DeliveryRule,FreightCostRule,DeliveryViaRule, PaymentRulePO,PO_PaymentTerm_ID FROM C_BPartner WHERE C_BPartner_ID=?";
                pstmt = DB.prepareStatement((String)sql, null);
                int C_BPartner_ID = this.getC_BPartner_ID();
                pstmt.setInt(1, C_BPartner_ID);
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    String deliveryViaRule;
                    String freightCostRule;
                    String deliveryRule;
                    String invoiceRule;
                    int C_PaymentTerm_ID;
                    String paymentRule = rs.getString(IsSOTrx ? "PaymentRule" : "PaymentRulePO");
                    if (paymentRule != null && paymentRule.length() != 0) {
                        if (IsSOTrx && (paymentRule.equals("B") || paymentRule.equals("S") || paymentRule.equals("T"))) {
                            paymentRule = "P";
                        }
                        if (!IsSOTrx && paymentRule.equals("B")) {
                            paymentRule = "P";
                        }
                        this.setPaymentRule(paymentRule);
                    }
                    if ((C_PaymentTerm_ID = rs.getInt(IsSOTrx ? "C_PaymentTerm_ID" : "PO_PaymentTerm_ID")) != 0) {
                        this.setC_PaymentTerm_ID(C_PaymentTerm_ID);
                    }
                    if ((invoiceRule = rs.getString(3)) != null && invoiceRule.length() != 0) {
                        this.setInvoiceRule(invoiceRule);
                    }
                    if ((deliveryRule = rs.getString(4)) != null && deliveryRule.length() != 0) {
                        this.setDeliveryRule(deliveryRule);
                    }
                    if ((freightCostRule = rs.getString(5)) != null && freightCostRule.length() != 0) {
                        this.setFreightCostRule(freightCostRule);
                    }
                    if ((deliveryViaRule = rs.getString(6)) != null && deliveryViaRule.length() != 0) {
                        this.setDeliveryViaRule(deliveryViaRule);
                    }
                }
                rs.close();
                pstmt.close();
            }
        }
        catch (SQLException e) {
            this.log.log(Level.SEVERE, sql, (Throwable)e);
        }
    }

    public void setC_DocTypeTarget_ID(String DocSubTypeSO_x) {
        String sql = "SELECT C_DocType_ID FROM C_DocType WHERE AD_Client_ID=? AND AD_Org_ID IN (0," + this.getAD_Org_ID() + ") AND DocSubTypeSO=? AND IsReturnTrx='N' " + "ORDER BY AD_Org_ID DESC, IsDefault DESC";
        int C_DocType_ID = DB.getSQLValue(null, (String)sql, (int)this.getAD_Client_ID(), (String)DocSubTypeSO_x);
        if (C_DocType_ID <= 0) {
            this.log.severe("Not found for AD_Client_ID=" + this.getAD_Client_ID() + ", SubType=" + DocSubTypeSO_x);
        } else {
            this.log.fine("(SO) - " + DocSubTypeSO_x);
            this.setC_DocTypeTarget_ID(C_DocType_ID);
            this.setIsSOTrx(true);
            this.setIsReturnTrx(false);
        }
    }

    public void setC_DocTypeTarget_ID(int C_DocTypeTarget_ID, boolean setReturnTrx) {
        super.setC_DocTypeTarget_ID(C_DocTypeTarget_ID);
        if (setReturnTrx) {
            MDocType dt = MDocType.get((Ctx)this.getCtx(), (int)C_DocTypeTarget_ID);
            this.setIsSOTrx(dt.isSOTrx());
            this.setIsReturnTrx(dt.isReturnTrx());
        }
    }

    public void setC_DocTypeTarget_ID() {
        if (this.isSOTrx()) {
            this.setC_DocTypeTarget_ID(DocSubTypeSO_Standard);
            return;
        }
        String sql = "SELECT C_DocType_ID FROM C_DocType WHERE AD_Client_ID=? AND AD_Org_ID IN (0," + this.getAD_Org_ID() + ") AND DocBaseType='POO' AND IsReturnTrx='N' " + "ORDER BY AD_Org_ID DESC, IsDefault DESC";
        int C_DocType_ID = DB.getSQLValue(null, (String)sql, (int)this.getAD_Client_ID());
        if (C_DocType_ID <= 0) {
            this.log.severe("No POO found for AD_Client_ID=" + this.getAD_Client_ID());
        } else {
            this.log.fine("(PO) - " + C_DocType_ID);
            this.setC_DocTypeTarget_ID(C_DocType_ID);
            this.setIsReturnTrx(false);
        }
    }

    public int copyLinesFrom(MOrder otherOrder, boolean counter, boolean copyASI) {
        if (this.isProcessed() || this.isPosted() || otherOrder == null) {
            return 0;
        }
        MOrderLine[] fromLines = otherOrder.getLines(false, null);
        int count = 0;
        for (int i = 0; i < fromLines.length; ++i) {
            MOrderLine line = new MOrderLine(this);
            PO.copyValues((PO)fromLines[i], (PO)line, (int)this.getAD_Client_ID(), (int)this.getAD_Org_ID());
            line.setC_Order_ID(this.getC_Order_ID());
            line.setOrder(this);
            line.set_ValueNoCheck("C_OrderLine_ID", I_ZERO);
            if (!copyASI) {
                line.setM_AttributeSetInstance_ID(0);
                line.setS_ResourceAssignment_ID(0);
            }
            if (counter) {
                line.setRef_OrderLine_ID(fromLines[i].getC_OrderLine_ID());
            } else {
                line.setRef_OrderLine_ID(0);
            }
            line.setQtyDelivered(Env.ZERO);
            line.setQtyInvoiced(Env.ZERO);
            line.setQtyReserved(Env.ZERO);
            line.setDateDelivered(null);
            line.setDateInvoiced(null);
            if (this.getC_BPartner_ID() != otherOrder.getC_BPartner_ID()) {
                line.setTax();
            }
            line.setProcessed(false);
            if (line.save(this.get_TrxName())) {
                ++count;
            }
            if (!counter) continue;
            fromLines[i].setRef_OrderLine_ID(line.getC_OrderLine_ID());
            fromLines[i].save(this.get_TrxName());
        }
        if (fromLines.length != count) {
            this.log.log(Level.SEVERE, "Line difference - From=" + fromLines.length + " <> Saved=" + count);
        }
        return count;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("MOrder[").append(this.get_ID()).append("-").append(this.getDocumentNo()).append(",IsSOTrx=").append(this.isSOTrx()).append(",C_DocType_ID=").append(this.getC_DocType_ID()).append(", GrandTotal=").append(this.getGrandTotal()).append("]");
        return sb.toString();
    }

    public String getDocumentInfo() {
        MDocType dt = MDocType.get((Ctx)this.getCtx(), (int)this.getC_DocType_ID());
        return dt.getName() + " " + this.getDocumentNo();
    }

    public File createPDF() {
        try {
            File temp = File.createTempFile(this.get_TableName() + this.get_ID() + "_", ".pdf");
            return this.createPDF(temp);
        }
        catch (Exception e) {
            this.log.severe("Could not create PDF - " + e.getMessage());
            return null;
        }
    }

    public File createPDF(File file) {
        ReportEngine re = ReportEngine.get((Ctx)this.getCtx(), (int)0, (int)this.getC_Order_ID());
        if (re == null) {
            return null;
        }
        return re.getPDF(file);
    }

    public void setM_PriceList_ID(int M_PriceList_ID) {
        MPriceList pl = MPriceList.get(this.getCtx(), M_PriceList_ID, null);
        if (pl.get_ID() == M_PriceList_ID) {
            super.setM_PriceList_ID(M_PriceList_ID);
            this.setC_Currency_ID(pl.getC_Currency_ID());
            this.setIsTaxIncluded(pl.isTaxIncluded());
        }
    }

    @UICallout
    public void setM_PriceList_ID(String oldM_PriceList_ID, String newM_PriceList_ID, int windowNo) throws Exception {
        if (newM_PriceList_ID == null || newM_PriceList_ID.length() == 0) {
            return;
        }
        int M_PriceList_ID = Integer.parseInt(newM_PriceList_ID);
        if (M_PriceList_ID == 0) {
            return;
        }
        String sql = "SELECT pl.IsTaxIncluded,pl.EnforcePriceLimit,pl.C_Currency_ID,c.StdPrecision,plv.M_PriceList_Version_ID,plv.ValidFrom FROM M_PriceList pl,C_Currency c,M_PriceList_Version plv WHERE pl.C_Currency_ID=c.C_Currency_ID AND pl.M_PriceList_ID=plv.M_PriceList_ID AND pl.M_PriceList_ID=? ORDER BY plv.ValidFrom DESC";
        try {
            CPreparedStatement pstmt = DB.prepareStatement((String)sql, null);
            pstmt.setInt(1, M_PriceList_ID);
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                super.setM_PriceList_ID(M_PriceList_ID);
                this.setIsTaxIncluded("Y".equals(rs.getString(1)));
                if (this.p_changeVO != null) {
                    this.p_changeVO.setContext(this.getCtx(), windowNo, "EnforcePriceLimit", rs.getString(2));
                }
                Integer ii = new Integer(rs.getInt(3));
                this.setC_Currency_ID(ii);
                if (this.p_changeVO != null) {
                    this.p_changeVO.setContext(this.getCtx(), windowNo, "M_PriceList_Version_ID", rs.getInt(5));
                }
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            this.log.log(Level.SEVERE, sql, (Throwable)e);
        }
    }

    public void setM_ReturnPolicy_ID() {
        MBPartner bpartner = new MBPartner(this.getCtx(), this.getC_BPartner_ID(), null);
        if (bpartner.get_ID() != 0) {
            if (this.isSOTrx()) {
                super.setM_ReturnPolicy_ID(bpartner.getM_ReturnPolicy_ID());
            } else {
                super.setM_ReturnPolicy_ID(bpartner.getPO_ReturnPolicy_ID());
            }
        }
    }

    public void setOrigOrder(MOrder origOrder) {
        if (origOrder == null || origOrder.get_ID() == 0) {
            return;
        }
        this.setOrig_Order_ID(origOrder.getC_Order_ID());
        MBPartner bpartner = new MBPartner(this.getCtx(), origOrder.getC_BPartner_ID(), null);
        this.setOrig_InOut_ID(-1);
        this.setC_BPartner_ID(origOrder.getC_BPartner_ID());
        this.setC_BPartner_Location_ID(origOrder.getC_BPartner_Location_ID());
        this.setAD_User_ID(origOrder.getAD_User_ID());
        this.setBill_BPartner_ID(origOrder.getBill_BPartner_ID());
        this.setBill_Location_ID(origOrder.getBill_Location_ID());
        this.setBill_User_ID(origOrder.getBill_User_ID());
        this.setM_ReturnPolicy_ID();
        this.setM_PriceList_ID(origOrder.getM_PriceList_ID());
        this.setPaymentRule(origOrder.getPaymentRule());
        this.setC_PaymentTerm_ID(origOrder.getC_PaymentTerm_ID());
        this.setBill_Location_ID(origOrder.getBill_Location_ID());
        this.setInvoiceRule(origOrder.getInvoiceRule());
        this.setPaymentRule(origOrder.getPaymentRule());
        this.setDeliveryViaRule(origOrder.getDeliveryViaRule());
        this.setFreightCostRule(origOrder.getFreightCostRule());
    }

    @UICallout
    public void setOrig_Order_ID(String oldOrig_Order_ID, String newOrig_Order_ID, int windowNo) throws Exception {
        if (newOrig_Order_ID == null || newOrig_Order_ID.length() == 0) {
            return;
        }
        int Orig_Order_ID = Integer.parseInt(newOrig_Order_ID);
        if (Orig_Order_ID == 0) {
            return;
        }
        MOrder origOrder = new MOrder(this.getCtx(), Orig_Order_ID, null);
        if (origOrder.get_ID() != 0) {
            this.setOrigOrder(origOrder);
        }
    }

    public void setOrigInOut(MInOut origInOut) {
        if (origInOut == null || origInOut.get_ID() == 0) {
            return;
        }
        this.setOrig_InOut_ID(origInOut.getM_InOut_ID());
        this.setC_Project_ID(origInOut.getC_Project_ID());
        this.setC_Campaign_ID(origInOut.getC_Campaign_ID());
        this.setC_Activity_ID(origInOut.getC_Activity_ID());
        this.setAD_OrgTrx_ID(origInOut.getAD_OrgTrx_ID());
        this.setUser1_ID(origInOut.getUser1_ID());
        this.setUser2_ID(origInOut.getUser2_ID());
    }

    @UICallout
    public void setOrig_InOut_ID(String oldOrig_InOut_ID, String newOrig_InOut_ID, int windowNo) throws Exception {
        if (newOrig_InOut_ID == null || newOrig_InOut_ID.length() == 0) {
            return;
        }
        int Orig_InOut_ID = Integer.parseInt(newOrig_InOut_ID);
        if (Orig_InOut_ID == 0) {
            return;
        }
        MInOut origInOut = new MInOut(this.getCtx(), Orig_InOut_ID, null);
        if (origInOut.get_ID() != 0) {
            this.setOrigInOut(origInOut);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MOrderLine[] getLines(String whereClause, String orderClause) {
        ArrayList<MOrderLine> list = new ArrayList<MOrderLine>();
        StringBuffer sql = new StringBuffer("SELECT * FROM C_OrderLine WHERE C_Order_ID=? ");
        if (whereClause != null) {
            sql.append(whereClause);
        }
        if (orderClause != null) {
            sql.append(" ").append(orderClause);
        }
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement((String)sql.toString(), (String)this.get_TrxName());
            pstmt.setInt(1, this.getC_Order_ID());
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                MOrderLine ol = new MOrderLine(this.getCtx(), rs, this.get_TrxName());
                ol.setHeaderInfo(this);
                list.add(ol);
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, sql.toString(), (Throwable)e);
        }
        finally {
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
            }
            catch (Exception e) {}
            pstmt = null;
        }
        MOrderLine[] lines = new MOrderLine[list.size()];
        list.toArray(lines);
        return lines;
    }

    public MOrderLine[] getLines(boolean requery, String orderBy) {
        if (this.m_lines != null && !requery) {
            return this.m_lines;
        }
        String orderClause = "ORDER BY ";
        orderClause = orderBy != null && orderBy.length() > 0 ? orderClause + orderBy : orderClause + "Line";
        this.m_lines = this.getLines(null, orderClause);
        return this.m_lines;
    }

    public MOrderLine[] getLines() {
        return this.getLines(false, null);
    }

    public void renumberLines(int step) {
        int number = step;
        MOrderLine[] lines = this.getLines(true, null);
        for (int i = 0; i < lines.length; ++i) {
            MOrderLine line = lines[i];
            line.setLine(number);
            line.save(this.get_TrxName());
            number += step;
        }
        this.m_lines = null;
    }

    public boolean isOrderLine(int C_OrderLine_ID) {
        if (this.m_lines == null) {
            this.getLines();
        }
        for (int i = 0; i < this.m_lines.length; ++i) {
            if (this.m_lines[i].getC_OrderLine_ID() != C_OrderLine_ID) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MOrderTax[] getTaxes(boolean requery) {
        if (this.m_taxes != null && !requery) {
            return this.m_taxes;
        }
        ArrayList<MOrderTax> list = new ArrayList<MOrderTax>();
        String sql = "SELECT * FROM C_OrderTax WHERE C_Order_ID=?";
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement((String)sql, (String)this.get_TrxName());
            pstmt.setInt(1, this.getC_Order_ID());
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                list.add(new MOrderTax(this.getCtx(), rs, this.get_TrxName()));
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, sql, (Throwable)e);
        }
        finally {
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
            }
            catch (Exception e) {}
            pstmt = null;
        }
        this.m_taxes = new MOrderTax[list.size()];
        list.toArray(this.m_taxes);
        return this.m_taxes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MInvoice[] getInvoices(boolean hearderLinkOnly) {
        ArrayList<MInvoice> list = new ArrayList<MInvoice>();
        String sql = "SELECT * FROM C_Invoice WHERE C_Order_ID=? ORDER BY Created DESC";
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement((String)sql, (String)this.get_TrxName());
            pstmt.setInt(1, this.getC_Order_ID());
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                list.add(new MInvoice(this.getCtx(), rs, this.get_TrxName()));
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, sql, (Throwable)e);
        }
        finally {
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
            }
            catch (Exception e) {}
            pstmt = null;
        }
        MInvoice[] retValue = new MInvoice[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getC_Invoice_ID() {
        int C_Invoice_ID = 0;
        String sql = "SELECT C_Invoice_ID FROM C_Invoice WHERE C_Order_ID=? AND DocStatus IN ('CO','CL') ORDER BY Created DESC";
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement((String)sql, (String)this.get_TrxName());
            pstmt.setInt(1, this.getC_Order_ID());
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                C_Invoice_ID = rs.getInt(1);
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, "getC_Invoice_ID", (Throwable)e);
        }
        finally {
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
            }
            catch (Exception e) {}
            pstmt = null;
        }
        return C_Invoice_ID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MInOut[] getShipments(boolean hearderLinkOnly) {
        ArrayList<MInOut> list = new ArrayList<MInOut>();
        String sql = "SELECT * FROM M_InOut WHERE C_Order_ID=? ORDER BY Created DESC";
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement((String)sql, (String)this.get_TrxName());
            pstmt.setInt(1, this.getC_Order_ID());
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                list.add(new MInOut(this.getCtx(), rs, this.get_TrxName()));
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, sql, (Throwable)e);
        }
        finally {
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
            }
            catch (Exception e) {}
            pstmt = null;
        }
        MInOut[] retValue = new MInOut[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MOrder[] getRMAs() {
        ArrayList<MOrder> list = new ArrayList<MOrder>();
        String sql = "SELECT * FROM C_Order WHERE Orig_Order_ID=? ORDER BY Created DESC";
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement((String)sql, (String)this.get_TrxName());
            pstmt.setInt(1, this.getC_Order_ID());
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                list.add(new MOrder(this.getCtx(), rs, this.get_TrxName()));
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, sql, (Throwable)e);
        }
        finally {
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
            }
            catch (Exception e) {}
            pstmt = null;
        }
        MOrder[] retValue = new MOrder[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MInOutLine[] getShipmentLines() {
        ArrayList<MInOutLine> list = new ArrayList<MInOutLine>();
        String sql = "SELECT * FROM M_InOutLine iol WHERE iol.C_OrderLine_ID IN (SELECT C_OrderLine_ID FROM C_OrderLine WHERE C_Order_ID=?) ORDER BY M_InOutLine_ID";
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement((String)sql, (String)this.get_TrxName());
            pstmt.setInt(1, this.getC_Order_ID());
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                list.add(new MInOutLine(this.getCtx(), rs, this.get_TrxName()));
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, sql, (Throwable)e);
        }
        finally {
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
            }
            catch (Exception e) {}
            pstmt = null;
        }
        MInOutLine[] retValue = new MInOutLine[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    public String getCurrencyISO() {
        return MCurrency.getISO_Code((Ctx)this.getCtx(), (int)this.getC_Currency_ID());
    }

    public int getPrecision() {
        return MCurrency.getStdPrecision((Ctx)this.getCtx(), (int)this.getC_Currency_ID());
    }

    public String getDocStatusName() {
        return MRefList.getListName((Ctx)this.getCtx(), (int)131, (String)this.getDocStatus());
    }

    public void setDocAction(String DocAction2) {
        this.setDocAction(DocAction2, false);
    }

    public void setDocAction(String DocAction2, boolean forceCreation) {
        super.setDocAction(DocAction2);
        this.m_forceCreation = forceCreation;
    }

    public void setProcessed(boolean processed) {
        super.setProcessed(processed);
        if (this.get_ID() == 0) {
            return;
        }
        String set = "SET Processed='" + (processed ? "Y" : "N") + "' WHERE C_Order_ID=" + this.getC_Order_ID();
        int noLine = DB.executeUpdate((String)("UPDATE C_OrderLine " + set), (String)this.get_TrxName());
        int noTax = DB.executeUpdate((String)("UPDATE C_OrderTax " + set), (String)this.get_TrxName());
        this.m_lines = null;
        this.m_taxes = null;
        this.log.fine(processed + " - Lines=" + noLine + ", Tax=" + noTax);
    }

    protected boolean beforeSave(boolean newRecord) {
        int ii;
        MBPartner bp;
        MWarehouse wh;
        int context_AD_Org_ID;
        if (this.getAD_Org_ID() == 0 && (context_AD_Org_ID = this.getCtx().getAD_Org_ID()) != 0) {
            this.setAD_Org_ID(context_AD_Org_ID);
            this.log.warning("Changed Org to Context=" + context_AD_Org_ID);
        }
        if (this.getAD_Client_ID() == 0) {
            this.m_processMsg = "AD_Client_ID = 0";
            return false;
        }
        if (newRecord && this.getC_DocType_ID() == 0) {
            this.setC_DocType_ID(0);
        }
        if (this.getM_Warehouse_ID() == 0) {
            MOrg org = MOrg.get((Ctx)this.getCtx(), (int)this.getAD_Org_ID());
            this.setM_Warehouse_ID(org.getM_Warehouse_ID());
        }
        if ((newRecord || this.is_ValueChanged("AD_Org_ID") || this.is_ValueChanged("M_Warehouse_ID")) && (wh = MWarehouse.get((Ctx)this.getCtx(), (int)this.getM_Warehouse_ID())).getAD_Org_ID() != this.getAD_Org_ID()) {
            this.log.saveWarning("WarehouseOrgConflict", "");
        }
        if (!newRecord && this.is_ValueChanged("M_Warehouse_ID")) {
            MOrderLine[] lines = this.getLines(false, null);
            for (int i = 0; i < lines.length; ++i) {
                if (lines[i].canChangeWarehouse()) continue;
                return false;
            }
        }
        if (this.getC_BPartner_ID() == 0) {
            this.setBPartner(MBPartner.getTemplate(this.getCtx(), this.getAD_Client_ID()));
        }
        if (this.getC_BPartner_Location_ID() == 0) {
            this.setBPartner(MBPartner.get(this.getCtx(), this.getC_BPartner_ID()));
        }
        if (this.getBill_BPartner_ID() == 0) {
            this.setBill_BPartner_ID(this.getC_BPartner_ID());
            this.setBill_Location_ID(this.getC_BPartner_Location_ID());
        }
        if (this.getBill_Location_ID() == 0) {
            this.setBill_Location_ID(this.getC_BPartner_Location_ID());
        }
        if ((newRecord || this.is_ValueChanged("C_BPartner_ID")) && !(bp = MBPartner.get(this.getCtx(), this.getC_BPartner_ID())).isActive()) {
            this.log.saveError("NotActive", Msg.getMsg((Ctx)this.getCtx(), (String)"C_BPartner_ID"));
            return false;
        }
        if ((newRecord || this.is_ValueChanged("Bill_BPartner_ID")) && this.getBill_BPartner_ID() != this.getC_BPartner_ID() && !(bp = MBPartner.get(this.getCtx(), this.getBill_BPartner_ID())).isActive()) {
            this.log.saveError("NotActive", Msg.getMsg((Ctx)this.getCtx(), (String)"Bill_BPartner_ID"));
            return false;
        }
        if (this.getM_PriceList_ID() == 0 && (ii = DB.getSQLValue(null, (String)"SELECT M_PriceList_ID FROM M_PriceList WHERE AD_Client_ID=? AND IsSOPriceList=? ORDER BY IsDefault DESC", (int)this.getAD_Client_ID(), (String)(this.isSOTrx() ? "Y" : "N"))) != 0) {
            this.setM_PriceList_ID(ii);
        }
        if (this.getC_Currency_ID() == 0) {
            String sql = "SELECT C_Currency_ID FROM M_PriceList WHERE M_PriceList_ID=?";
            int ii2 = DB.getSQLValue(null, (String)sql, (int)this.getM_PriceList_ID());
            if (ii2 != 0) {
                this.setC_Currency_ID(ii2);
            } else {
                this.setC_Currency_ID(this.getCtx().getContextAsInt("#C_Currency_ID"));
            }
        }
        if (this.getSalesRep_ID() == 0 && (ii = this.getCtx().getContextAsInt("#SalesRep_ID")) != 0) {
            this.setSalesRep_ID(ii);
        }
        if (this.getC_DocTypeTarget_ID() == 0) {
            this.setC_DocTypeTarget_ID(DocSubTypeSO_Standard);
        }
        if (this.getC_PaymentTerm_ID() == 0) {
            ii = this.getCtx().getContextAsInt("#C_PaymentTerm_ID");
            if (ii != 0) {
                this.setC_PaymentTerm_ID(ii);
            } else {
                String sql = "SELECT C_PaymentTerm_ID FROM C_PaymentTerm WHERE AD_Client_ID=? AND IsDefault='Y'";
                ii = DB.getSQLValue(null, (String)sql, (int)this.getAD_Client_ID());
                if (ii != 0) {
                    this.setC_PaymentTerm_ID(ii);
                }
            }
        }
        if (this.isReturnTrx()) {
            Boolean withinPolicy = true;
            if (this.getM_ReturnPolicy_ID() == 0) {
                this.setM_ReturnPolicy_ID();
            }
            if (this.getM_ReturnPolicy_ID() != 0) {
                MInOut origInOut = new MInOut(this.getCtx(), this.getOrig_InOut_ID(), null);
                MReturnPolicy rpolicy = new MReturnPolicy(this.getCtx(), this.getM_ReturnPolicy_ID(), null);
                this.log.fine("RMA Date : " + this.getDateOrdered() + " Shipment Date : " + origInOut.getMovementDate());
                withinPolicy = rpolicy.checkReturnPolicy(origInOut.getMovementDate(), this.getDateOrdered());
            } else {
                withinPolicy = false;
            }
            if (!withinPolicy.booleanValue()) {
                if (!MRole.getDefault().isOverrideReturnPolicy()) {
                    this.log.saveError("Error", Msg.getMsg((Ctx)this.getCtx(), (String)"ReturnPolicyExceeded"));
                    return false;
                }
                this.log.saveWarning("Warning", "ReturnPolicyExceeded");
            }
        }
        return true;
    }

    protected boolean afterSave(boolean newRecord, boolean success) {
        int no;
        String sql;
        if (!success || newRecord) {
            return success;
        }
        if (this.is_ValueChanged("Description") || this.is_ValueChanged("POReference")) {
            sql = "UPDATE C_Invoice i SET (Description,POReference)=(SELECT Description, POReference FROM C_Order o WHERE i.C_Order_ID=o.C_Order_ID) WHERE DocStatus NOT IN ('RE','CL') AND C_Order_ID=" + this.getC_Order_ID();
            no = DB.executeUpdate((String)sql, (String)this.get_TrxName());
            this.log.fine("Description -> #" + no);
        }
        if (this.is_ValueChanged("PaymentRule") || this.is_ValueChanged("C_PaymentTerm_ID") || this.is_ValueChanged("DateAcct") || this.is_ValueChanged("C_Payment_ID") || this.is_ValueChanged("C_CashLine_ID")) {
            sql = "UPDATE C_Invoice i SET (PaymentRule,C_PaymentTerm_ID,DateAcct,C_Payment_ID,C_CashLine_ID)=(SELECT PaymentRule,C_PaymentTerm_ID,DateAcct,C_Payment_ID,C_CashLine_ID FROM C_Order o WHERE i.C_Order_ID=o.C_Order_ID)WHERE DocStatus NOT IN ('RE','CL') AND C_Order_ID=" + this.getC_Order_ID();
            no = DB.executeUpdate((String)sql, (String)this.get_TrxName());
            this.log.fine("Payment -> #" + no);
        }
        this.afterSaveSync("AD_Org_ID");
        this.afterSaveSync("C_BPartner_ID");
        this.afterSaveSync("C_BPartner_Location_ID");
        this.afterSaveSync("DateOrdered");
        this.afterSaveSync("DatePromised");
        this.afterSaveSync("M_Warehouse_ID");
        this.afterSaveSync("M_Shipper_ID");
        this.afterSaveSync("C_Currency_ID");
        return true;
    }

    private void afterSaveSync(String columnName) {
        if (this.is_ValueChanged(columnName)) {
            String sql = "UPDATE C_OrderLine ol SET " + columnName + " =" + "(SELECT " + columnName + " FROM C_Order o WHERE ol.C_Order_ID=o.C_Order_ID) " + "WHERE C_Order_ID=" + this.getC_Order_ID();
            int no = DB.executeUpdate((String)sql, (String)this.get_TrxName());
            this.log.fine(columnName + " Lines -> #" + no);
        }
    }

    protected boolean beforeDelete() {
        if (this.isProcessed()) {
            return false;
        }
        this.getLines();
        for (int i = 0; i < this.m_lines.length; ++i) {
            if (this.m_lines[i].beforeDelete()) continue;
            return false;
        }
        return true;
    }

    public boolean processIt(String processAction) {
        this.m_processMsg = null;
        DocumentEngine engine = new DocumentEngine((DocAction)this, this.getDocStatus());
        return engine.processIt(processAction, this.getDocAction());
    }

    public boolean unlockIt() {
        this.log.info("unlockIt - " + this.toString());
        this.setProcessing(false);
        return true;
    }

    public boolean invalidateIt() {
        this.log.info(this.toString());
        this.setDocAction(DocSubTypeSO_Prepay);
        return true;
    }

    public String prepareIt() {
        this.log.info(this.toString());
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 1);
        if (this.m_processMsg != null) {
            return "IN";
        }
        MDocType dt = MDocType.get((Ctx)this.getCtx(), (int)this.getC_DocTypeTarget_ID());
        this.setIsReturnTrx(dt.isReturnTrx());
        this.setIsSOTrx(dt.isSOTrx());
        if (!MPeriod.isOpen(this.getCtx(), this.getDateAcct(), dt.getDocBaseType())) {
            this.m_processMsg = "@PeriodClosed@";
            return "IN";
        }
        MOrderLine[] lines = this.getLines(true, "M_Product_ID");
        if (lines.length == 0) {
            this.m_processMsg = "@NoLines@";
            return "IN";
        }
        if (this.getC_DocType_ID() != this.getC_DocTypeTarget_ID()) {
            MDocType dtOld;
            if (this.getC_DocType_ID() != 0 && DocSubTypeSO_Standard.equals((dtOld = MDocType.get((Ctx)this.getCtx(), (int)this.getC_DocType_ID())).getDocSubTypeSO()) && !DocSubTypeSO_Standard.equals(dt.getDocSubTypeSO())) {
                for (int i = 0; i < lines.length; ++i) {
                    if (lines[i].getM_Warehouse_ID() == this.getM_Warehouse_ID()) continue;
                    this.log.warning("different Warehouse " + (Object)((Object)lines[i]));
                    this.m_processMsg = "@CannotChangeDocType@";
                    return "IN";
                }
            }
            if ("DR".equals(this.getDocStatus()) || "IP".equals(this.getDocStatus()) || "IN".equals(this.getDocStatus()) || this.getC_DocType_ID() == 0) {
                this.setC_DocType_ID(this.getC_DocTypeTarget_ID());
            } else if (dt.isOffer()) {
                this.setC_DocType_ID(this.getC_DocTypeTarget_ID());
            } else {
                this.m_processMsg = "@CannotChangeDocType@";
                return "IN";
            }
        }
        String mandatoryType = "='Y'";
        String sql = "SELECT COUNT(*) FROM C_OrderLine ol INNER JOIN M_Product p ON (ol.M_Product_ID=p.M_Product_ID) INNER JOIN M_AttributeSet pas ON (p.M_AttributeSet_ID=pas.M_AttributeSet_ID) WHERE pas.MandatoryType" + mandatoryType + " AND ol.M_AttributeSetInstance_ID IS NULL" + " AND ol.C_Order_ID=?";
        int no = DB.getSQLValue((String)this.get_TrxName(), (String)sql, (int)this.getC_Order_ID());
        if (no != 0) {
            this.m_processMsg = "@LinesWithoutProductAttribute@ (" + no + ")";
            return "IN";
        }
        if (this.explodeBOM()) {
            lines = this.getLines(true, "M_Product_ID");
        }
        if (!this.reserveStock(dt, lines)) {
            this.m_processMsg = "Cannot reserve Stock";
            return "IN";
        }
        if (!this.calculateTaxTotal()) {
            this.m_processMsg = "Error calculating tax";
            return "IN";
        }
        if (this.isSOTrx() && !this.isReturnTrx()) {
            MBPartner bp = MBPartner.get(this.getCtx(), this.getC_BPartner_ID());
            if ("S".equals(bp.getSOCreditStatus())) {
                this.m_processMsg = "@BPartnerCreditStop@ - @TotalOpenBalance@=" + bp.getTotalOpenBalance() + ", @SO_CreditLimit@=" + bp.getSO_CreditLimit();
                return "IN";
            }
            if ("H".equals(bp.getSOCreditStatus())) {
                this.m_processMsg = "@BPartnerCreditHold@ - @TotalOpenBalance@=" + bp.getTotalOpenBalance() + ", @SO_CreditLimit@=" + bp.getSO_CreditLimit();
                return "IN";
            }
            BigDecimal grandTotal = MConversionRate.convertBase((Ctx)this.getCtx(), (BigDecimal)this.getGrandTotal(), (int)this.getC_Currency_ID(), (Timestamp)this.getDateOrdered(), (int)this.getC_ConversionType_ID(), (int)this.getAD_Client_ID(), (int)this.getAD_Org_ID());
            if ("H".equals(bp.getSOCreditStatus(grandTotal))) {
                this.m_processMsg = "@BPartnerOverOCreditHold@ - @TotalOpenBalance@=" + bp.getTotalOpenBalance() + ", @GrandTotal@=" + grandTotal + ", @SO_CreditLimit@=" + bp.getSO_CreditLimit();
                return "IN";
            }
        }
        this.m_justPrepared = true;
        return "IP";
    }

    private boolean explodeBOM() {
        boolean retValue = false;
        String where = "AND IsActive='Y' AND EXISTS (SELECT * FROM M_Product p WHERE C_OrderLine.M_Product_ID=p.M_Product_ID AND\tp.IsBOM='Y' AND p.IsVerified='Y' AND p.IsStocked='N')";
        String sql = "SELECT COUNT(*) FROM C_OrderLine WHERE C_Order_ID=? " + where;
        int count = DB.getSQLValue((String)this.get_TrxName(), (String)sql, (int)this.getC_Order_ID());
        while (count != 0) {
            retValue = true;
            this.renumberLines(1000);
            MOrderLine[] lines = this.getLines(where, "ORDER BY Line");
            for (int i = 0; i < lines.length; ++i) {
                MOrderLine line = lines[i];
                MProduct product = MProduct.get(this.getCtx(), line.getM_Product_ID());
                this.log.fine(product.getName());
                int lineNo = line.getLine();
                MProductBOM[] boms = MProductBOM.getBOMLines(product);
                for (int j = 0; j < boms.length; ++j) {
                    MProductBOM bom = boms[j];
                    MOrderLine newLine = new MOrderLine(this);
                    newLine.setLine(++lineNo);
                    newLine.setM_Product_ID(bom.getProduct().getM_Product_ID());
                    newLine.setC_UOM_ID(bom.getProduct().getC_UOM_ID());
                    newLine.setQty(line.getQtyOrdered().multiply(bom.getBOMQty()));
                    if (bom.getDescription() != null) {
                        newLine.setDescription(bom.getDescription());
                    }
                    newLine.setPrice();
                    newLine.save(this.get_TrxName());
                }
                line.setM_Product_ID(0);
                line.setM_AttributeSetInstance_ID(0);
                line.setPrice(Env.ZERO);
                line.setPriceLimit(Env.ZERO);
                line.setPriceList(Env.ZERO);
                line.setLineNetAmt(Env.ZERO);
                line.setFreightAmt(Env.ZERO);
                String description = product.getName();
                if (product.getDescription() != null) {
                    description = description + " " + product.getDescription();
                }
                if (line.getDescription() != null) {
                    description = description + " " + line.getDescription();
                }
                line.setDescription(description);
                line.save(this.get_TrxName());
            }
            this.m_lines = null;
            count = DB.getSQLValue((String)this.get_TrxName(), (String)sql, (int)this.getC_Invoice_ID());
            this.renumberLines(10);
        }
        return retValue;
    }

    private boolean reserveStock(MDocType dt, MOrderLine[] lines) {
        boolean binding;
        if (dt == null) {
            dt = MDocType.get((Ctx)this.getCtx(), (int)this.getC_DocType_ID());
        }
        if (dt.isReturnTrx()) {
            return true;
        }
        boolean bl = binding = !dt.isProposal();
        if ("VO".equals(this.getDocAction()) || DocSubTypeSO_Quotation.equals(dt.getDocSubTypeSO()) && "CL".equals(this.getDocAction()) || this.isDropShip()) {
            binding = false;
        }
        boolean isSOTrx = this.isSOTrx();
        this.log.fine("Binding=" + binding + " - IsSOTrx=" + isSOTrx);
        int header_M_Warehouse_ID = this.getM_Warehouse_ID();
        if (DocSubTypeSO_Standard.equals(dt.getDocSubTypeSO()) || "POO".equals(dt.getDocBaseType())) {
            header_M_Warehouse_ID = 0;
        }
        BigDecimal Volume = Env.ZERO;
        BigDecimal Weight = Env.ZERO;
        for (int i = 0; i < lines.length; ++i) {
            MProduct product;
            BigDecimal target;
            BigDecimal difference;
            MOrderLine line = lines[i];
            if (header_M_Warehouse_ID != 0) {
                if (header_M_Warehouse_ID != line.getM_Warehouse_ID()) {
                    line.setM_Warehouse_ID(header_M_Warehouse_ID);
                }
                if (this.getAD_Org_ID() != line.getAD_Org_ID()) {
                    line.setAD_Org_ID(this.getAD_Org_ID());
                }
            }
            if ((difference = (target = binding ? line.getQtyOrdered() : Env.ZERO).subtract(line.getQtyReserved()).subtract(line.getQtyDelivered())).signum() == 0) {
                product = line.getProduct();
                if (product == null) continue;
                Volume = Volume.add(product.getVolume().multiply(line.getQtyOrdered()));
                Weight = Weight.add(product.getWeight().multiply(line.getQtyOrdered()));
                continue;
            }
            this.log.fine("Line=" + line.getLine() + " - Target=" + target + ",Difference=" + difference + " - Ordered=" + line.getQtyOrdered() + ",Reserved=" + line.getQtyReserved() + ",Delivered=" + line.getQtyDelivered());
            product = line.getProduct();
            if (product == null) continue;
            if (product.isStocked()) {
                BigDecimal ordered = isSOTrx ? Env.ZERO : difference;
                BigDecimal reserved = isSOTrx ? difference : Env.ZERO;
                int M_Locator_ID = 0;
                if (line.getM_AttributeSetInstance_ID() != 0) {
                    M_Locator_ID = MStorage.getM_Locator_ID(line.getM_Warehouse_ID(), line.getM_Product_ID(), line.getM_AttributeSetInstance_ID(), ordered, this.get_TrxName());
                }
                if (M_Locator_ID == 0) {
                    MWarehouse wh = MWarehouse.get((Ctx)this.getCtx(), (int)line.getM_Warehouse_ID());
                    M_Locator_ID = wh.getDefaultM_Locator_ID();
                }
                if (!MStorage.add(this.getCtx(), line.getM_Warehouse_ID(), M_Locator_ID, line.getM_Product_ID(), line.getM_AttributeSetInstance_ID(), line.getM_AttributeSetInstance_ID(), Env.ZERO, reserved, ordered, this.get_TrxName())) {
                    return false;
                }
            }
            line.setQtyReserved(line.getQtyReserved().add(difference));
            if (!line.save(this.get_TrxName())) {
                return false;
            }
            Volume = Volume.add(product.getVolume().multiply(line.getQtyOrdered()));
            Weight = Weight.add(product.getWeight().multiply(line.getQtyOrdered()));
        }
        this.setVolume(Volume);
        this.setWeight(Weight);
        return true;
    }

    private boolean calculateTaxTotal() {
        MOrderTax oTax;
        this.log.fine("");
        DB.executeUpdate((String)("DELETE FROM C_OrderTax WHERE C_Order_ID=" + this.getC_Order_ID()), (String)this.get_TrxName());
        this.m_taxes = null;
        BigDecimal totalLines = Env.ZERO;
        ArrayList<Integer> taxList = new ArrayList<Integer>();
        MOrderLine[] lines = this.getLines();
        for (int i = 0; i < lines.length; ++i) {
            MOrderLine line = lines[i];
            Integer taxID = new Integer(line.getC_Tax_ID());
            if (!taxList.contains(taxID)) {
                oTax = MOrderTax.get(line, this.getPrecision(), false, this.get_TrxName());
                oTax.setIsTaxIncluded(this.isTaxIncluded());
                if (!oTax.calculateTaxFromLines()) {
                    return false;
                }
                if (!oTax.save(this.get_TrxName())) {
                    return false;
                }
                taxList.add(taxID);
            }
            totalLines = totalLines.add(line.getLineNetAmt());
        }
        BigDecimal grandTotal = totalLines;
        MOrderTax[] taxes = this.getTaxes(true);
        for (int i = 0; i < taxes.length; ++i) {
            oTax = taxes[i];
            MTax tax = oTax.getTax();
            if (tax.isSummary()) {
                MTax[] cTaxes = tax.getChildTaxes(false);
                for (int j = 0; j < cTaxes.length; ++j) {
                    MTax cTax = cTaxes[j];
                    BigDecimal taxAmt = cTax.calculateTax(oTax.getTaxBaseAmt(), this.isTaxIncluded(), this.getPrecision());
                    MOrderTax newOTax = new MOrderTax(this.getCtx(), 0, this.get_TrxName());
                    newOTax.setClientOrg((PO)this);
                    newOTax.setC_Order_ID(this.getC_Order_ID());
                    newOTax.setC_Tax_ID(cTax.getC_Tax_ID());
                    newOTax.setPrecision(this.getPrecision());
                    newOTax.setIsTaxIncluded(this.isTaxIncluded());
                    newOTax.setTaxBaseAmt(oTax.getTaxBaseAmt());
                    newOTax.setTaxAmt(taxAmt);
                    if (!newOTax.save(this.get_TrxName())) {
                        return false;
                    }
                    if (this.isTaxIncluded()) continue;
                    grandTotal = grandTotal.add(taxAmt);
                }
                if (!oTax.delete(true, this.get_TrxName())) {
                    return false;
                }
                this.m_taxes = null;
                continue;
            }
            if (this.isTaxIncluded()) continue;
            grandTotal = grandTotal.add(oTax.getTaxAmt());
        }
        this.setTotalLines(totalLines);
        this.setGrandTotal(grandTotal);
        return true;
    }

    public boolean approveIt() {
        this.log.info("approveIt - " + this.toString());
        this.setIsApproved(true);
        return true;
    }

    public boolean rejectIt() {
        this.log.info("rejectIt - " + this.toString());
        this.setIsApproved(false);
        return true;
    }

    public String completeIt() {
        String valid;
        MOrder counter;
        MDocType dt = MDocType.get((Ctx)this.getCtx(), (int)this.getC_DocType_ID());
        String DocSubTypeSO = dt.getDocSubTypeSO();
        if (DocSubTypeSO_Prepay.equals(this.getDocAction())) {
            this.setProcessed(false);
            return "IP";
        }
        if (!this.isReturnTrx()) {
            String status;
            if (DocSubTypeSO_Proposal.equals(DocSubTypeSO) || DocSubTypeSO_Quotation.equals(DocSubTypeSO)) {
                if (DocSubTypeSO_Quotation.equals(DocSubTypeSO)) {
                    this.reserveStock(dt, this.getLines(true, "M_Product_ID"));
                }
                this.setProcessed(true);
                this.setDocAction("CL");
                return "CO";
            }
            if (!this.m_forceCreation && DocSubTypeSO_Prepay.equals(DocSubTypeSO) && this.getC_Payment_ID() == 0 && this.getC_CashLine_ID() == 0) {
                this.setProcessed(true);
                return DocSubTypeSO_Warehouse;
            }
            if (!this.m_justPrepared && !"IP".equals(status = this.prepareIt())) {
                return status;
            }
        }
        if (!this.isApproved()) {
            this.approveIt();
        }
        this.getLines(true, null);
        this.log.info(this.toString());
        StringBuffer info = new StringBuffer();
        this.setProcessed(true);
        boolean realTimePOS = false;
        MInOut shipment = null;
        if (DocSubTypeSO_OnCredit.equals(DocSubTypeSO) || DocSubTypeSO_Warehouse.equals(DocSubTypeSO) || DocSubTypeSO_POS.equals(DocSubTypeSO) || DocSubTypeSO_Prepay.equals(DocSubTypeSO)) {
            if (!"F".equals(this.getDeliveryRule())) {
                this.setDeliveryRule("F");
            }
            if ((shipment = this.createShipment(dt, realTimePOS ? null : this.getDateOrdered())) == null) {
                return "IN";
            }
            info.append("@M_InOut_ID@: ").append(shipment.getDocumentNo());
            String msg = shipment.getProcessMsg();
            if (msg != null && msg.length() > 0) {
                info.append(" (").append(msg).append(")");
            }
        }
        if (DocSubTypeSO_POS.equals(DocSubTypeSO) || DocSubTypeSO_OnCredit.equals(DocSubTypeSO) || DocSubTypeSO_Prepay.equals(DocSubTypeSO)) {
            MInvoice invoice = this.createInvoice(dt, shipment, realTimePOS ? null : this.getDateOrdered());
            if (invoice == null) {
                return "IN";
            }
            info.append(" - @C_Invoice_ID@: ").append(invoice.getDocumentNo());
            String msg = invoice.getProcessMsg();
            if (msg != null && msg.length() > 0) {
                info.append(" (").append(msg).append(")");
            }
        }
        if ((counter = this.createCounterDoc()) != null) {
            info.append(" - @CounterDoc@: @Order@=").append(counter.getDocumentNo());
        }
        if ((valid = ModelValidationEngine.get().fireDocValidate((PO)this, 9)) != null) {
            if (info.length() > 0) {
                info.append(" - ");
            }
            info.append(valid);
            this.m_processMsg = info.toString();
            return "IN";
        }
        this.setProcessed(true);
        this.m_processMsg = info.toString();
        this.setDocAction("CL");
        return "CO";
    }

    private MInOut createShipment(MDocType dt, Timestamp movementDate) {
        this.log.info("For " + dt);
        MInOut shipment = new MInOut(this, dt.getC_DocTypeShipment_ID(), movementDate);
        if (!shipment.save(this.get_TrxName())) {
            this.m_processMsg = "Could not create Shipment";
            return null;
        }
        MOrderLine[] oLines = this.getLines(true, null);
        for (int i = 0; i < oLines.length; ++i) {
            int M_Warehouse_ID;
            MProduct product;
            MOrderLine oLine = oLines[i];
            MInOutLine ioLine = new MInOutLine(shipment);
            BigDecimal MovementQty = oLine.getQtyOrdered().subtract(oLine.getQtyDelivered());
            int M_Locator_ID = MStorage.getM_Locator_ID(oLine.getM_Warehouse_ID(), oLine.getM_Product_ID(), oLine.getM_AttributeSetInstance_ID(), MovementQty, this.get_TrxName());
            if (M_Locator_ID == 0 && (M_Locator_ID = MProductLocator.getFirstM_Locator_ID(product = ioLine.getProduct(), M_Warehouse_ID = oLine.getM_Warehouse_ID())) == 0) {
                MWarehouse wh = MWarehouse.get((Ctx)this.getCtx(), (int)M_Warehouse_ID);
                M_Locator_ID = wh.getDefaultM_Locator_ID();
            }
            ioLine.setOrderLine(oLine, M_Locator_ID, MovementQty);
            ioLine.setQty(MovementQty);
            if (oLine.getQtyEntered().compareTo(oLine.getQtyOrdered()) != 0) {
                ioLine.setQtyEntered(MovementQty.multiply(oLine.getQtyEntered()).divide(oLine.getQtyOrdered(), 6, 4));
            }
            if (ioLine.save(this.get_TrxName())) continue;
            this.m_processMsg = "Could not create Shipment Line";
            return null;
        }
        String status = shipment.completeIt();
        shipment.setDocStatus(status);
        shipment.save(this.get_TrxName());
        if (!"CO".equals(status)) {
            this.m_processMsg = "@M_InOut_ID@: " + shipment.getProcessMsg();
            return null;
        }
        return shipment;
    }

    private MInvoice createInvoice(MDocType dt, MInOut shipment, Timestamp invoiceDate) {
        this.log.info(dt.toString());
        MInvoice invoice = new MInvoice(this, dt.getC_DocTypeInvoice_ID(), invoiceDate);
        if (!invoice.save(this.get_TrxName())) {
            this.m_processMsg = "Could not create Invoice";
            return null;
        }
        if (shipment != null) {
            if (!"D".equals(this.getInvoiceRule())) {
                this.setInvoiceRule("D");
            }
            MInOutLine[] sLines = shipment.getLines(false);
            for (int i = 0; i < sLines.length; ++i) {
                MInOutLine sLine = sLines[i];
                MInvoiceLine iLine = new MInvoiceLine(invoice);
                iLine.setShipLine(sLine);
                iLine.setQtyEntered(sLine.getQtyEntered());
                iLine.setQtyInvoiced(sLine.getMovementQty());
                if (!iLine.save(this.get_TrxName())) {
                    this.m_processMsg = "Could not create Invoice Line from Shipment Line";
                    return null;
                }
                sLine.setIsInvoiced(true);
                if (sLine.save(this.get_TrxName())) continue;
                this.log.warning("Could not update Shipment line: " + (Object)((Object)sLine));
            }
        } else {
            if (!"I".equals(this.getInvoiceRule())) {
                this.setInvoiceRule("I");
            }
            MOrderLine[] oLines = this.getLines();
            for (int i = 0; i < oLines.length; ++i) {
                MOrderLine oLine = oLines[i];
                MInvoiceLine iLine = new MInvoiceLine(invoice);
                iLine.setOrderLine(oLine);
                iLine.setQtyInvoiced(oLine.getQtyOrdered().subtract(oLine.getQtyInvoiced()));
                if (oLine.getQtyOrdered().compareTo(oLine.getQtyEntered()) == 0) {
                    iLine.setQtyEntered(iLine.getQtyInvoiced());
                } else {
                    iLine.setQtyEntered(iLine.getQtyInvoiced().multiply(oLine.getQtyEntered()).divide(oLine.getQtyOrdered(), 12, 4));
                }
                if (iLine.save(this.get_TrxName())) continue;
                this.m_processMsg = "Could not create Invoice Line from Order Line";
                return null;
            }
        }
        String status = invoice.completeIt();
        invoice.setDocStatus(status);
        invoice.save(this.get_TrxName());
        this.setC_CashLine_ID(invoice.getC_CashLine_ID());
        if (!"CO".equals(status)) {
            this.m_processMsg = "@C_Invoice_ID@: " + invoice.getProcessMsg();
            return null;
        }
        return invoice;
    }

    private MOrder createCounterDoc() {
        if (this.getRef_Order_ID() != 0) {
            return null;
        }
        MOrg org = MOrg.get((Ctx)this.getCtx(), (int)this.getAD_Org_ID());
        int counterC_BPartner_ID = org.getLinkedC_BPartner_ID(this.get_TrxName());
        if (counterC_BPartner_ID == 0) {
            return null;
        }
        MBPartner bp = new MBPartner(this.getCtx(), this.getC_BPartner_ID(), this.get_TrxName());
        int counterAD_Org_ID = bp.getAD_OrgBP_ID_Int();
        if (counterAD_Org_ID == 0) {
            return null;
        }
        MBPartner counterBP = new MBPartner(this.getCtx(), counterC_BPartner_ID, this.get_TrxName());
        MOrgInfo counterOrgInfo = MOrgInfo.get((Ctx)this.getCtx(), (int)counterAD_Org_ID, null);
        this.log.info("Counter BP=" + counterBP.getName());
        int C_DocTypeTarget_ID = 0;
        MDocTypeCounter counterDT = MDocTypeCounter.getCounterDocType(this.getCtx(), this.getC_DocType_ID());
        if (counterDT != null) {
            this.log.fine(counterDT.toString());
            if (!counterDT.isCreateCounter() || !counterDT.isValid()) {
                return null;
            }
            C_DocTypeTarget_ID = counterDT.getCounter_C_DocType_ID();
        } else {
            C_DocTypeTarget_ID = MDocTypeCounter.getCounterDocType_ID(this.getCtx(), this.getC_DocType_ID());
            this.log.fine("Indirect C_DocTypeTarget_ID=" + C_DocTypeTarget_ID);
            if (C_DocTypeTarget_ID <= 0) {
                return null;
            }
        }
        MOrder counter = MOrder.copyFrom(this, this.getDateOrdered(), C_DocTypeTarget_ID, true, false, this.get_TrxName());
        counter.setAD_Org_ID(counterAD_Org_ID);
        counter.setM_Warehouse_ID(counterOrgInfo.getM_Warehouse_ID());
        counter.setBPartner(counterBP);
        counter.setDatePromised(this.getDatePromised());
        counter.setSalesRep_ID(this.getSalesRep_ID());
        counter.save(this.get_TrxName());
        MOrderLine[] counterLines = counter.getLines(true, null);
        for (int i = 0; i < counterLines.length; ++i) {
            MOrderLine counterLine = counterLines[i];
            counterLine.setOrder(counter);
            counterLine.setPrice();
            counterLine.setTax();
            counterLine.save(this.get_TrxName());
        }
        this.log.fine(counter.toString());
        if (counterDT != null && counterDT.getDocAction() != null) {
            counter.setDocAction(counterDT.getDocAction());
            counter.processIt(counterDT.getDocAction());
            counter.save(this.get_TrxName());
        }
        return counter;
    }

    public boolean voidIt() {
        MOrderLine[] lines = this.getLines(true, "M_Product_ID");
        this.log.info(this.toString());
        for (int i = 0; i < lines.length; ++i) {
            MOrderLine line = lines[i];
            BigDecimal old = line.getQtyOrdered();
            if (old.signum() == 0) continue;
            line.addDescription(Msg.getMsg((Ctx)this.getCtx(), (String)"Voided") + " (" + old + ")");
            line.setQtyLostSales(old);
            line.setQty(Env.ZERO);
            line.setLineNetAmt(Env.ZERO);
            line.save(this.get_TrxName());
        }
        this.addDescription(Msg.getMsg((Ctx)this.getCtx(), (String)"Voided"));
        if (!this.reserveStock(null, lines)) {
            this.m_processMsg = "Cannot unreserve Stock (void)";
            return false;
        }
        if (!this.createReversals()) {
            return false;
        }
        this.setProcessed(true);
        this.setDocAction("--");
        return true;
    }

    private boolean createReversals() {
        if (!this.isSOTrx()) {
            return true;
        }
        this.log.info("");
        StringBuffer info = new StringBuffer();
        info.append("@M_InOut_ID@:");
        MInOut[] shipments = this.getShipments(false);
        for (int i = 0; i < shipments.length; ++i) {
            MInOut ship = shipments[i];
            if ("CL".equals(ship.getDocStatus()) || "RE".equals(ship.getDocStatus()) || "VO".equals(ship.getDocStatus())) continue;
            ship.set_TrxName(this.get_TrxName());
            if (!"CO".equals(ship.getDocStatus())) {
                if (ship.voidIt()) {
                    ship.setDocStatus("VO");
                }
            } else if (!ship.isOnlyForOrder(this)) {
                ship.reverseCorrectIt(this);
                info.append(" Parial ").append(ship.getDocumentNo());
            } else if (ship.reverseCorrectIt()) {
                ship.setDocStatus("RE");
                info.append(" ").append(ship.getDocumentNo());
            } else {
                this.m_processMsg = "Could not reverse Shipment " + (Object)((Object)ship);
                return false;
            }
            ship.setDocAction("--");
            ship.save(this.get_TrxName());
        }
        info.append(" - @C_Invoice_ID@:");
        MInvoice[] invoices = this.getInvoices(false);
        for (int i = 0; i < invoices.length; ++i) {
            MInvoice invoice = invoices[i];
            if ("CL".equals(invoice.getDocStatus()) || "RE".equals(invoice.getDocStatus()) || "VO".equals(invoice.getDocStatus())) continue;
            invoice.set_TrxName(this.get_TrxName());
            if (!"CO".equals(invoice.getDocStatus())) {
                if (invoice.voidIt()) {
                    invoice.setDocStatus("VO");
                }
            } else if (invoice.reverseCorrectIt()) {
                invoice.setDocStatus("RE");
                info.append(" ").append(invoice.getDocumentNo());
            } else {
                this.m_processMsg = "Could not reverse Invoice " + (Object)((Object)invoice);
                return false;
            }
            invoice.setDocAction("--");
            invoice.save(this.get_TrxName());
        }
        info.append("@C_Order_ID@:");
        MOrder[] rmas = this.getRMAs();
        for (int i = 0; i < rmas.length; ++i) {
            MOrder rma = rmas[i];
            if ("CL".equals(rma.getDocStatus()) || "RE".equals(rma.getDocStatus()) || "VO".equals(rma.getDocStatus())) continue;
            rma.set_TrxName(this.get_TrxName());
            if (!"CO".equals(rma.getDocStatus())) {
                if (rma.voidIt()) {
                    rma.setDocStatus("VO");
                }
            } else if (rma.reverseCorrectIt()) {
                rma.setDocStatus("RE");
                info.append(" ").append(rma.getDocumentNo());
            } else {
                this.m_processMsg = "Could not reverse RMA " + (Object)((Object)rma);
                return false;
            }
            rma.setDocAction("--");
            rma.save(this.get_TrxName());
        }
        this.m_processMsg = info.toString();
        return true;
    }

    public boolean closeIt() {
        this.log.info(this.toString());
        MOrderLine[] lines = this.getLines(true, "M_Product_ID");
        for (int i = 0; i < lines.length; ++i) {
            MOrderLine line = lines[i];
            BigDecimal old = line.getQtyOrdered();
            if (old.compareTo(line.getQtyDelivered()) == 0) continue;
            line.setQtyLostSales(line.getQtyOrdered().subtract(line.getQtyDelivered()));
            line.setQtyOrdered(line.getQtyDelivered());
            line.addDescription("Close (" + old + ")");
            line.save(this.get_TrxName());
        }
        if (!this.reserveStock(null, lines)) {
            this.m_processMsg = "Cannot unreserve Stock (close)";
            return false;
        }
        this.setProcessed(true);
        this.setDocAction("--");
        return true;
    }

    public boolean reverseCorrectIt() {
        this.log.info(this.toString());
        return this.voidIt();
    }

    public boolean reverseAccrualIt() {
        this.log.info(this.toString());
        return false;
    }

    public boolean reActivateIt() {
        this.log.info(this.toString());
        MDocType dt = MDocType.get((Ctx)this.getCtx(), (int)this.getC_DocType_ID());
        String DocSubTypeSO = dt.getDocSubTypeSO();
        if (DocSubTypeSO_Prepay.equals(DocSubTypeSO)) {
            MDocType newDT = null;
            MDocType[] dts = MDocType.getOfClient((Ctx)this.getCtx());
            for (int i = 0; i < dts.length; ++i) {
                MDocType type = dts[i];
                if (!DocSubTypeSO_Prepay.equals(type.getDocSubTypeSO()) || !type.isDefault() && newDT != null) continue;
                newDT = type;
            }
            if (newDT == null) {
                return false;
            }
            this.setC_DocType_ID(newDT.getC_DocType_ID());
            this.setIsReturnTrx(newDT.isReturnTrx());
        }
        if (!this.isSOTrx()) {
            this.log.info("Existing documents not modified - " + dt);
        } else if (DocSubTypeSO_OnCredit.equals(DocSubTypeSO) || DocSubTypeSO_Warehouse.equals(DocSubTypeSO) || DocSubTypeSO_POS.equals(DocSubTypeSO)) {
            if (!this.createReversals()) {
                return false;
            }
        } else {
            this.log.info("Existing documents not modified - SubType=" + DocSubTypeSO);
        }
        this.setDocAction("CO");
        this.setProcessed(false);
        return true;
    }

    public String getSummary() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getDocumentNo());
        sb.append(": ").append(Msg.translate((Ctx)this.getCtx(), (String)"GrandTotal")).append("=").append(this.getGrandTotal());
        if (this.m_lines != null) {
            sb.append(" (#").append(this.m_lines.length).append(")");
        }
        if (this.getDescription() != null && this.getDescription().length() > 0) {
            sb.append(" - ").append(this.getDescription());
        }
        return sb.toString();
    }

    public String getProcessMsg() {
        return this.m_processMsg;
    }

    public int getDoc_User_ID() {
        return this.getSalesRep_ID();
    }

    public BigDecimal getApprovalAmt() {
        return this.getGrandTotal();
    }
}

