/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.logging.Level;
import org.compiere.model.MPaySelectionLine;
import org.compiere.model.X_C_PaySelection;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.Ctx;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class MPaySelection
extends X_C_PaySelection {
    private MPaySelectionLine[] m_lines = null;
    private int m_C_Currency_ID = 0;

    public MPaySelection(Ctx ctx, int C_PaySelection_ID, String trxName) {
        super(ctx, C_PaySelection_ID, trxName);
        if (C_PaySelection_ID == 0) {
            this.setTotalAmt(Env.ZERO);
            this.setIsApproved(false);
            this.setProcessed(false);
            this.setProcessing(false);
        }
    }

    public MPaySelection(Ctx ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MPaySelectionLine[] getLines(boolean requery) {
        if (this.m_lines != null && !requery) {
            return this.m_lines;
        }
        ArrayList<MPaySelectionLine> list = new ArrayList<MPaySelectionLine>();
        String sql = "SELECT * FROM C_PaySelectionLine WHERE C_PaySelection_ID=? ORDER BY Line";
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement((String)sql, (String)this.get_TrxName());
            pstmt.setInt(1, this.getC_PaySelection_ID());
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                list.add(new MPaySelectionLine(this.getCtx(), rs, this.get_TrxName()));
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, "getLines", (Throwable)e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        this.m_lines = new MPaySelectionLine[list.size()];
        list.toArray(this.m_lines);
        return this.m_lines;
    }

    public int getC_Currency_ID() {
        if (this.m_C_Currency_ID == 0) {
            String sql = "SELECT C_Currency_ID FROM C_BankAccount WHERE C_BankAccount_ID=?";
            this.m_C_Currency_ID = DB.getSQLValue(null, (String)sql, (int)this.getC_BankAccount_ID());
        }
        return this.m_C_Currency_ID;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("MPaySelection[");
        sb.append(this.get_ID()).append(",").append(this.getName()).append("]");
        return sb.toString();
    }
}

