/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.logging.Level;
import org.compiere.api.UICallout;
import org.compiere.framework.PO;
import org.compiere.model.MInvoice;
import org.compiere.model.MPaySelection;
import org.compiere.model.X_C_PaySelectionLine;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.Ctx;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class MPaySelectionLine
extends X_C_PaySelectionLine {
    private MInvoice m_invoice = null;

    public MPaySelectionLine(Ctx ctx, int C_PaySelectionLine_ID, String trxName) {
        super(ctx, C_PaySelectionLine_ID, trxName);
        if (C_PaySelectionLine_ID == 0) {
            this.setIsSOTrx(false);
            this.setOpenAmt(Env.ZERO);
            this.setPayAmt(Env.ZERO);
            this.setDiscountAmt(Env.ZERO);
            this.setDifferenceAmt(Env.ZERO);
            this.setIsManual(false);
        }
    }

    public MPaySelectionLine(Ctx ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MPaySelectionLine(MPaySelection ps, int Line, String PaymentRule) {
        this(ps.getCtx(), 0, ps.get_TrxName());
        this.setClientOrg((PO)ps);
        this.setC_PaySelection_ID(ps.getC_PaySelection_ID());
        this.setLine(Line);
        this.setPaymentRule(PaymentRule);
    }

    public void setInvoice(int C_Invoice_ID, boolean isSOTrx, BigDecimal OpenAmt, BigDecimal PayAmt, BigDecimal DiscountAmt) {
        this.setC_Invoice_ID(C_Invoice_ID);
        this.setIsSOTrx(isSOTrx);
        this.setOpenAmt(OpenAmt);
        this.setPayAmt(PayAmt);
        this.setDiscountAmt(DiscountAmt);
        this.setDifferenceAmt(OpenAmt.subtract(PayAmt).subtract(DiscountAmt));
    }

    @UICallout
    public void setC_Invoice_ID(String oldC_Invoice_ID, String newC_Invoice_ID, int windowNo) throws Exception {
        if (newC_Invoice_ID == null || newC_Invoice_ID.length() == 0) {
            return;
        }
        int C_Invoice_ID = Integer.parseInt(newC_Invoice_ID);
        this.p_changeVO.setContext(this.getCtx(), windowNo, "C_Invoice_ID", C_Invoice_ID);
        this.setC_Invoice_ID(C_Invoice_ID);
        if (C_Invoice_ID == 0) {
            this.setPayAmt(Env.ZERO);
            this.setDiscountAmt(Env.ZERO);
            this.setDifferenceAmt(Env.ZERO);
            return;
        }
        int C_BankAccount_ID = this.getCtx().getContextAsInt(windowNo, "C_BankAccount_ID");
        Timestamp PayDate = new Timestamp(this.getCtx().getContextAsTime(windowNo, "PayDate"));
        BigDecimal OpenAmt = Env.ZERO;
        BigDecimal DiscountAmt = Env.ZERO;
        boolean IsSOTrx = Boolean.FALSE;
        String sql = "SELECT currencyConvert(invoiceOpen(i.C_Invoice_ID, 0), i.C_Currency_ID,ba.C_Currency_ID, i.DateInvoiced, i.C_ConversionType_ID, i.AD_Client_ID, i.AD_Org_ID), paymentTermDiscount(i.GrandTotal,i.C_Currency_ID,i.C_PaymentTerm_ID,i.DateInvoiced, ?), i.IsSOTrx FROM C_Invoice_v i, C_BankAccount ba WHERE i.C_Invoice_ID=? AND ba.C_BankAccount_ID=?";
        try {
            CPreparedStatement pstmt = DB.prepareStatement((String)sql, null);
            pstmt.setInt(1, C_Invoice_ID);
            pstmt.setInt(2, C_BankAccount_ID);
            pstmt.setTimestamp(3, PayDate);
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                OpenAmt = rs.getBigDecimal(1);
                DiscountAmt = rs.getBigDecimal(2);
                IsSOTrx = "Y".equals(rs.getString(3));
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            this.log.log(Level.SEVERE, sql, (Throwable)e);
        }
        this.log.fine(" - OpenAmt=" + OpenAmt + " (Invoice=" + C_Invoice_ID + ",BankAcct=" + C_BankAccount_ID + ")");
        this.setInvoice(C_Invoice_ID, IsSOTrx, OpenAmt, OpenAmt.subtract(DiscountAmt), DiscountAmt);
    }

    @UICallout
    public void setPayAmt(String oldPayAmt, String newPayAmt, int windowNo) throws Exception {
        if (newPayAmt == null || newPayAmt.length() == 0) {
            return;
        }
        BigDecimal PayAmt = PO.convertToBigDecimal((String)newPayAmt);
        BigDecimal OpenAmt = this.getOpenAmt();
        BigDecimal DiscountAmt = this.getDiscountAmt();
        BigDecimal DifferenceAmt = OpenAmt.subtract(PayAmt).subtract(DiscountAmt);
        int C_Invoice_ID = this.getC_Invoice_ID();
        if (C_Invoice_ID == 0) {
            PayAmt = Env.ZERO;
            DifferenceAmt = Env.ZERO;
            DiscountAmt = Env.ZERO;
            this.setDiscountAmt(DiscountAmt);
        }
        this.log.fine("OpenAmt=" + OpenAmt + " - PayAmt=" + PayAmt + ", Discount=" + DiscountAmt + ", Difference=" + DifferenceAmt);
        this.setPayAmt(PayAmt);
        this.setDifferenceAmt(DifferenceAmt);
    }

    public MInvoice getInvoice() {
        if (this.m_invoice == null) {
            this.m_invoice = new MInvoice(this.getCtx(), this.getC_Invoice_ID(), this.get_TrxName());
        }
        return this.m_invoice;
    }

    protected boolean beforeSave(boolean newRecord) {
        this.setDifferenceAmt(this.getOpenAmt().subtract(this.getPayAmt()).subtract(this.getDiscountAmt()));
        return true;
    }

    protected boolean afterSave(boolean newRecord, boolean success) {
        this.setHeader();
        return success;
    }

    protected boolean afterDelete(boolean success) {
        this.setHeader();
        return success;
    }

    private void setHeader() {
        String sql = "UPDATE C_PaySelection ps SET TotalAmt = (SELECT COALESCE(SUM(psl.PayAmt),0) FROM C_PaySelectionLine psl WHERE ps.C_PaySelection_ID=psl.C_PaySelection_ID AND psl.IsActive='Y') WHERE C_PaySelection_ID=" + this.getC_PaySelection_ID();
        DB.executeUpdate((String)sql, (String)this.get_TrxName());
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("MPaySelectionLine[");
        sb.append(this.get_ID()).append(",C_Invoice_ID=").append(this.getC_Invoice_ID()).append(",PayAmt=").append(this.getPayAmt()).append(",DifferenceAmt=").append(this.getDifferenceAmt()).append("]");
        return sb.toString();
    }
}

