/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.logging.Level;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoicePaySchedule;
import org.compiere.model.MPaySchedule;
import org.compiere.model.X_C_PaymentTerm;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.Ctx;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class MPaymentTerm
extends X_C_PaymentTerm {
    private static final BigDecimal HUNDRED = new BigDecimal(100);
    private MPaySchedule[] m_schedule;

    public MPaymentTerm(Ctx ctx, int C_PaymentTerm_ID, String trxName) {
        super(ctx, C_PaymentTerm_ID, trxName);
        if (C_PaymentTerm_ID == 0) {
            this.setAfterDelivery(false);
            this.setNetDays(0);
            this.setDiscount(Env.ZERO);
            this.setDiscount2(Env.ZERO);
            this.setDiscountDays(0);
            this.setDiscountDays2(0);
            this.setGraceDays(0);
            this.setIsDueFixed(false);
            this.setIsValid(false);
        }
    }

    public MPaymentTerm(Ctx ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MPaySchedule[] getSchedule(boolean requery) {
        if (this.m_schedule != null && !requery) {
            return this.m_schedule;
        }
        String sql = "SELECT * FROM C_PaySchedule WHERE C_PaymentTerm_ID=? ORDER BY NetDays";
        ArrayList<MPaySchedule> list = new ArrayList<MPaySchedule>();
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement((String)sql, (String)this.get_TrxName());
            pstmt.setInt(1, this.getC_PaymentTerm_ID());
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                MPaySchedule ps = new MPaySchedule(this.getCtx(), rs, this.get_TrxName());
                ps.setParent(this);
                list.add(ps);
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, "getSchedule", (Throwable)e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        this.m_schedule = new MPaySchedule[list.size()];
        list.toArray(this.m_schedule);
        return this.m_schedule;
    }

    public String validate() {
        this.getSchedule(true);
        if (this.m_schedule.length == 0) {
            this.setIsValid(true);
            return "@OK@";
        }
        if (this.m_schedule.length == 1) {
            this.setIsValid(false);
            return "@Invalid@ @Count@ # = 1 (@C_PaySchedule_ID@)";
        }
        BigDecimal total = Env.ZERO;
        for (int i = 0; i < this.m_schedule.length; ++i) {
            BigDecimal percent = this.m_schedule[i].getPercentage();
            if (percent == null) continue;
            total = total.add(percent);
        }
        boolean valid = total.compareTo(HUNDRED) == 0;
        this.setIsValid(valid);
        for (int i = 0; i < this.m_schedule.length; ++i) {
            if (this.m_schedule[i].isValid() == valid) continue;
            this.m_schedule[i].setIsValid(valid);
            this.m_schedule[i].save();
        }
        String msg = "@OK@";
        if (!valid) {
            msg = "@Total@ = " + total + " - @Difference@ = " + HUNDRED.subtract(total);
        }
        return Msg.parseTranslation((Ctx)this.getCtx(), (String)msg);
    }

    public boolean apply(int C_Invoice_ID) {
        MInvoice invoice = new MInvoice(this.getCtx(), C_Invoice_ID, this.get_TrxName());
        if (invoice == null || invoice.get_ID() == 0) {
            this.log.log(Level.SEVERE, "apply - Not valid C_Invoice_ID=" + C_Invoice_ID);
            return false;
        }
        return this.apply(invoice);
    }

    public boolean apply(MInvoice invoice) {
        if (invoice == null || invoice.get_ID() == 0) {
            this.log.log(Level.SEVERE, "No valid invoice - " + (Object)((Object)invoice));
            return false;
        }
        if (!this.isValid()) {
            return this.applyNoSchedule(invoice);
        }
        this.getSchedule(true);
        if (this.m_schedule.length <= 1) {
            return this.applyNoSchedule(invoice);
        }
        return this.applySchedule(invoice);
    }

    private boolean applyNoSchedule(MInvoice invoice) {
        this.deleteInvoicePaySchedule(invoice.getC_Invoice_ID(), invoice.get_TrxName());
        if (invoice.getC_PaymentTerm_ID() != this.getC_PaymentTerm_ID()) {
            invoice.setC_PaymentTerm_ID(this.getC_PaymentTerm_ID());
        }
        if (invoice.isPayScheduleValid()) {
            invoice.setIsPayScheduleValid(false);
        }
        return false;
    }

    private boolean applySchedule(MInvoice invoice) {
        this.deleteInvoicePaySchedule(invoice.getC_Invoice_ID(), invoice.get_TrxName());
        MInvoicePaySchedule ips = null;
        BigDecimal remainder = invoice.getGrandTotal();
        for (int i = 0; i < this.m_schedule.length; ++i) {
            ips = new MInvoicePaySchedule(invoice, this.m_schedule[i]);
            ips.save(invoice.get_TrxName());
            this.log.fine(ips.toString());
            remainder = remainder.subtract(ips.getDueAmt());
        }
        if (remainder.compareTo(Env.ZERO) != 0 && ips != null) {
            ips.setDueAmt(ips.getDueAmt().add(remainder));
            ips.save(invoice.get_TrxName());
            this.log.fine("Remainder=" + remainder + " - " + (Object)((Object)ips));
        }
        if (invoice.getC_PaymentTerm_ID() != this.getC_PaymentTerm_ID()) {
            invoice.setC_PaymentTerm_ID(this.getC_PaymentTerm_ID());
        }
        return invoice.validatePaySchedule();
    }

    private void deleteInvoicePaySchedule(int C_Invoice_ID, String trxName) {
        String sql = "DELETE FROM C_InvoicePaySchedule WHERE C_Invoice_ID=" + C_Invoice_ID;
        int no = DB.executeUpdate((String)sql, (String)trxName);
        this.log.fine("C_Invoice_ID=" + C_Invoice_ID + " - #" + no);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("MPaymentTerm[");
        sb.append(this.get_ID()).append("-").append(this.getName()).append(",Valid=").append(this.isValid()).append("]");
        return sb.toString();
    }

    protected boolean beforeSave(boolean newRecord) {
        if (this.isDueFixed()) {
            int dd = this.getFixMonthDay();
            if (dd < 1 || dd > 31) {
                this.log.saveError("Error", Msg.parseTranslation((Ctx)this.getCtx(), (String)"@Invalid@ @FixMonthDay@"));
                return false;
            }
            dd = this.getFixMonthCutoff();
            if (dd < 1 || dd > 31) {
                this.log.saveError("Error", Msg.parseTranslation((Ctx)this.getCtx(), (String)"@Invalid@ @FixMonthCutoff@"));
                return false;
            }
        }
        if (!newRecord || !this.isValid()) {
            this.validate();
        }
        return true;
    }
}

