/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.logging.Level;
import org.compiere.model.MCurrency;
import org.compiere.model.MPriceListVersion;
import org.compiere.model.X_M_PriceList;
import org.compiere.util.CCache;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.Ctx;
import org.compiere.util.DB;

public class MPriceList
extends X_M_PriceList {
    private static CLogger s_log = CLogger.getCLogger(MPriceList.class);
    private static CCache<Integer, MPriceList> s_cache = new CCache("M_PriceList", 5);
    private MPriceListVersion m_plv = null;
    private Integer m_precision = null;

    public static MPriceList get(Ctx ctx, int M_PriceList_ID, String trxName) {
        Integer key = new Integer(M_PriceList_ID);
        MPriceList retValue = (MPriceList)((Object)s_cache.get((Object)key));
        if (retValue == null) {
            retValue = new MPriceList(ctx, M_PriceList_ID, trxName);
            s_cache.put((Object)key, (Object)retValue);
        }
        return retValue;
    }

    public static MPriceList getDefault(Ctx ctx, boolean IsSOPriceList) {
        int AD_Client_ID = ctx.getAD_Client_ID();
        MPriceList retValue2 = null;
        for (MPriceList retValue2 : s_cache.values()) {
            if (!retValue2.isDefault() || retValue2.getAD_Client_ID() != AD_Client_ID) continue;
            return retValue2;
        }
        retValue2 = null;
        String sql = "SELECT * FROM M_PriceList WHERE AD_Client_ID=? AND IsDefault='Y' AND IsSOPriceList=?ORDER BY M_PriceList_ID";
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement((String)sql, null);
            pstmt.setInt(1, AD_Client_ID);
            if (IsSOPriceList) {
                pstmt.setString(2, "Y");
            } else {
                pstmt.setString(2, "N");
            }
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                retValue2 = new MPriceList(ctx, rs, null);
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            s_log.log(Level.SEVERE, sql, (Throwable)e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        if (retValue2 != null) {
            Integer key = new Integer(retValue2.getM_PriceList_ID());
            s_cache.put((Object)key, (Object)retValue2);
        }
        return retValue2;
    }

    public static int getStandardPrecision(Ctx ctx, int M_PriceList_ID) {
        MPriceList pl = MPriceList.get(ctx, M_PriceList_ID, null);
        return pl.getStandardPrecision();
    }

    public static int getPricePrecision(Ctx ctx, int M_PriceList_ID) {
        MPriceList pl = MPriceList.get(ctx, M_PriceList_ID, null);
        return pl.getPricePrecision();
    }

    public MPriceList(Ctx ctx, int M_PriceList_ID, String trxName) {
        super(ctx, M_PriceList_ID, trxName);
        if (M_PriceList_ID == 0) {
            this.setEnforcePriceLimit(false);
            this.setIsDefault(false);
            this.setIsSOPriceList(false);
            this.setIsTaxIncluded(false);
            this.setPricePrecision(2);
        }
    }

    public MPriceList(Ctx ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MPriceListVersion getPriceListVersion(Timestamp valid) {
        if (valid == null) {
            valid = new Timestamp(System.currentTimeMillis());
        }
        if (this.m_plv != null && this.m_plv.getValidFrom().before(valid)) {
            return this.m_plv;
        }
        String sql = "SELECT * FROM M_PriceList_Version WHERE M_PriceList_ID=? AND TRUNC(ValidFrom,'DD')<=? AND IsActive='Y'ORDER BY ValidFrom DESC";
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement((String)sql, (String)this.get_TrxName());
            pstmt.setInt(1, this.getM_PriceList_ID());
            pstmt.setTimestamp(2, valid);
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                this.m_plv = new MPriceListVersion(this.getCtx(), rs, this.get_TrxName());
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, sql, (Throwable)e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        if (this.m_plv == null) {
            this.log.warning("None found M_PriceList_ID=" + this.getM_PriceList_ID() + " - " + valid + " - " + sql);
        } else {
            this.log.fine(this.m_plv.toString());
        }
        return this.m_plv;
    }

    public int getStandardPrecision() {
        if (this.m_precision == null) {
            MCurrency c = MCurrency.get((Ctx)this.getCtx(), (int)this.getC_Currency_ID());
            this.m_precision = new Integer(c.getStdPrecision());
        }
        return this.m_precision;
    }
}

