/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.logging.Level;
import org.compiere.framework.PO;
import org.compiere.model.MPriceList;
import org.compiere.model.MProductPrice;
import org.compiere.model.X_M_PriceList_Version;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.Ctx;
import org.compiere.util.DB;
import org.compiere.util.DisplayType;
import org.compiere.util.TimeUtil;

public class MPriceListVersion
extends X_M_PriceList_Version {
    private MProductPrice[] m_pp = null;
    private MPriceList m_pl = null;

    public MPriceListVersion(Ctx ctx, int M_PriceList_Version_ID, String trxName) {
        super(ctx, M_PriceList_Version_ID, trxName);
        if (M_PriceList_Version_ID == 0) {
            // empty if block
        }
    }

    public MPriceListVersion(Ctx ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MPriceListVersion(MPriceList pl) {
        this(pl.getCtx(), 0, pl.get_TrxName());
        this.setClientOrg((PO)pl);
        this.setM_PriceList_ID(pl.getM_PriceList_ID());
    }

    public MPriceList getPriceList() {
        if (this.m_pl == null && this.getM_PriceList_ID() != 0) {
            this.m_pl = MPriceList.get(this.getCtx(), this.getM_PriceList_ID(), null);
        }
        return this.m_pl;
    }

    public MProductPrice[] getProductPrice(boolean refresh) {
        if (this.m_pp != null && !refresh) {
            return this.m_pp;
        }
        this.m_pp = this.getProductPrice(null);
        return this.m_pp;
    }

    public MProductPrice[] getProductPrice(String whereClause) {
        ArrayList<MProductPrice> list = new ArrayList<MProductPrice>();
        String sql = "SELECT * FROM M_ProductPrice WHERE M_PriceList_Version_ID=?";
        if (whereClause != null) {
            sql = sql + " " + whereClause;
        }
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement((String)sql, (String)this.get_TrxName());
            pstmt.setInt(1, this.getM_PriceList_Version_ID());
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                list.add(new MProductPrice(this.getCtx(), rs, this.get_TrxName()));
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, sql, (Throwable)e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        MProductPrice[] pp = new MProductPrice[list.size()];
        list.toArray(pp);
        return pp;
    }

    public void setName() {
        if (this.getValidFrom() == null) {
            this.setValidFrom(TimeUtil.getDay(null));
        }
        if (this.getName() == null) {
            String name = DisplayType.getDateFormat((int)15).format(this.getValidFrom());
            this.setName(name);
        }
    }

    protected boolean beforeSave(boolean newRecord) {
        this.setName();
        return true;
    }
}

