/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.logging.Level;
import org.compiere.model.MProduct;
import org.compiere.model.X_M_Product_BOM;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.Ctx;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class MProductBOM
extends X_M_Product_BOM {
    private static CLogger s_log = CLogger.getCLogger(MProductBOM.class);
    private MProduct m_product = null;

    public static MProductBOM[] getBOMLines(MProduct product) {
        return MProductBOM.getBOMLines(product.getCtx(), product.getM_Product_ID(), product.get_TrxName());
    }

    public static MProductBOM[] getBOMLines(Ctx ctx, int M_Product_ID, String trxName) {
        String sql = "SELECT * FROM M_Product_BOM WHERE M_Product_ID=? ORDER BY Line";
        ArrayList<MProductBOM> list = new ArrayList<MProductBOM>();
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement((String)sql, (String)trxName);
            pstmt.setInt(1, M_Product_ID);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                list.add(new MProductBOM(ctx, rs, trxName));
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            s_log.log(Level.SEVERE, sql, (Throwable)e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        MProductBOM[] retValue = new MProductBOM[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    public MProductBOM(Ctx ctx, int M_Product_BOM_ID, String trxName) {
        super(ctx, M_Product_BOM_ID, trxName);
        if (M_Product_BOM_ID == 0) {
            this.setBOMQty(Env.ZERO);
        }
    }

    public MProductBOM(Ctx ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MProduct getProduct() {
        if (this.m_product == null && this.getM_ProductBOM_ID() != 0) {
            this.m_product = MProduct.get(this.getCtx(), this.getM_ProductBOM_ID());
        }
        return this.m_product;
    }

    public void setM_ProductBOM_ID(int M_ProductBOM_ID) {
        super.setM_ProductBOM_ID(M_ProductBOM_ID);
        this.m_product = null;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("MProductBOM[");
        sb.append(this.get_ID()).append(",Line=").append(this.getLine()).append(",Type=").append(this.getBOMType()).append(",Qty=").append(this.getBOMQty());
        if (this.m_product == null) {
            sb.append(",M_Product_ID=").append(this.getM_ProductBOM_ID());
        } else {
            sb.append(",").append((Object)this.m_product);
        }
        sb.append("]");
        return sb.toString();
    }

    protected boolean afterSave(boolean newRecord, boolean success) {
        if (newRecord || this.is_ValueChanged("M_ProductBOM_ID")) {
            MProduct product = new MProduct(this.getCtx(), this.getM_Product_ID(), this.get_TrxName());
            if (this.get_TrxName() != null) {
                product.load(this.get_TrxName());
            }
            if (product.isVerified()) {
                product.setIsVerified(false);
                product.save(this.get_TrxName());
            }
        }
        return success;
    }
}

