/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.logging.Level;
import org.compiere.framework.PO;
import org.compiere.model.MProduct;
import org.compiere.model.X_M_Product_Costing;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.Ctx;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class MProductCosting
extends X_M_Product_Costing {
    private static CLogger s_log = CLogger.getCLogger(MProductCosting.class);

    public static MProductCosting[] getOfProduct(Ctx ctx, int M_Product_ID, String trxName) {
        String sql = "SELECT * FROM M_Product_Costing WHERE M_Product_ID=?";
        ArrayList<MProductCosting> list = new ArrayList<MProductCosting>();
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement((String)sql, (String)trxName);
            pstmt.setInt(1, M_Product_ID);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                list.add(new MProductCosting(ctx, rs, trxName));
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            s_log.log(Level.SEVERE, sql, (Throwable)e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        MProductCosting[] retValue = new MProductCosting[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    public static MProductCosting get(Ctx ctx, int M_Product_ID, int C_AcctSchema_ID, String trxName) {
        MProductCosting retValue = null;
        String sql = "SELECT * FROM M_Product_Costing WHERE M_Product_ID=? AND C_AcctSchema_ID=?";
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement((String)sql, (String)trxName);
            pstmt.setInt(1, M_Product_ID);
            pstmt.setInt(2, C_AcctSchema_ID);
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                retValue = new MProductCosting(ctx, rs, trxName);
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            s_log.log(Level.SEVERE, sql, (Throwable)e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        return retValue;
    }

    public MProductCosting(Ctx ctx, int ignored, String trxName) {
        super(ctx, ignored, trxName);
        if (ignored != 0) {
            throw new IllegalArgumentException("Multi-Key");
        }
        this.setCostAverage(Env.ZERO);
        this.setCostAverageCumAmt(Env.ZERO);
        this.setCostAverageCumQty(Env.ZERO);
        this.setCostStandard(Env.ZERO);
        this.setCostStandardCumAmt(Env.ZERO);
        this.setCostStandardCumQty(Env.ZERO);
        this.setCostStandardPOAmt(Env.ZERO);
        this.setCostStandardPOQty(Env.ZERO);
        this.setCurrentCostPrice(Env.ZERO);
        this.setFutureCostPrice(Env.ZERO);
        this.setPriceLastInv(Env.ZERO);
        this.setPriceLastPO(Env.ZERO);
        this.setTotalInvAmt(Env.ZERO);
        this.setTotalInvQty(Env.ZERO);
    }

    public MProductCosting(MProduct product, int C_AcctSchema_ID) {
        super(product.getCtx(), 0, product.get_TrxName());
        this.setClientOrg((PO)product);
        this.setM_Product_ID(product.getM_Product_ID());
        this.setC_AcctSchema_ID(C_AcctSchema_ID);
    }

    public MProductCosting(Ctx ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }
}

