/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URL;
import java.sql.ResultSet;
import java.util.logging.Level;
import org.compiere.model.X_M_ProductDownload;
import org.compiere.util.CCache;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.Ctx;
import org.compiere.util.DB;

public class MProductDownload
extends X_M_ProductDownload {
    private static CCache<Integer, MProductDownload> s_cache = new CCache("M_ProductDownload", 20);
    private static CLogger s_log = CLogger.getCLogger(MProductDownload.class);

    public static void migrateDownloads(Ctx ctx) {
        String sql = "SELECT COUNT(*) FROM M_ProductDownload";
        int no = DB.getSQLValue(null, (String)sql);
        if (no > 0) {
            return;
        }
        int count = 0;
        sql = "SELECT AD_Client_ID, AD_Org_ID, M_Product_ID, Name, DownloadURL FROM M_Product WHERE DownloadURL IS NOT NULL";
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement((String)sql, null);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                int AD_Client_ID = rs.getInt(1);
                int AD_Org_ID = rs.getInt(2);
                int M_Product_ID = rs.getInt(3);
                String Name = rs.getString(4);
                String DownloadURL = rs.getString(5);
                MProductDownload pdl = new MProductDownload(ctx, 0, null);
                pdl.setClientOrg(AD_Client_ID, AD_Org_ID);
                pdl.setM_Product_ID(M_Product_ID);
                pdl.setName(Name);
                pdl.setDownloadURL(DownloadURL);
                if (pdl.save()) {
                    ++count;
                    String sqlUpdate = "UPDATE M_Product SET DownloadURL = NULL WHERE M_Product_ID=" + M_Product_ID;
                    int updated = DB.executeUpdate((String)sqlUpdate, null);
                    if (updated == 1) continue;
                    s_log.warning("Product not updated");
                    continue;
                }
                s_log.warning("Product Download not created M_Product_ID=" + M_Product_ID);
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            s_log.log(Level.SEVERE, sql, (Throwable)e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        s_log.info("#" + count);
    }

    public static MProductDownload get(Ctx ctx, int M_ProductDownload_ID) {
        Integer key = new Integer(M_ProductDownload_ID);
        MProductDownload retValue = (MProductDownload)((Object)s_cache.get((Object)key));
        if (retValue != null) {
            return retValue;
        }
        retValue = new MProductDownload(ctx, M_ProductDownload_ID, null);
        if (retValue.get_ID() != 0) {
            s_cache.put((Object)key, (Object)retValue);
        }
        return retValue;
    }

    public MProductDownload(Ctx ctx, int M_ProductDownload_ID, String trxName) {
        super(ctx, M_ProductDownload_ID, trxName);
        if (M_ProductDownload_ID == 0) {
            // empty if block
        }
    }

    public MProductDownload(Ctx ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("MProductDownload[").append(this.get_ID()).append(",M_Product_ID=").append(this.getM_Product_ID()).append(",").append(this.getDownloadURL()).append("]");
        return sb.toString();
    }

    public String getDownloadName() {
        String url = this.getDownloadURL();
        if (url == null || !this.isActive()) {
            return null;
        }
        int pos = Math.max(url.lastIndexOf(47), url.lastIndexOf(92));
        if (pos != -1) {
            return url.substring(pos + 1);
        }
        return url;
    }

    public URL getDownloadURL(String directory) {
        String dl_url = this.getDownloadURL();
        if (dl_url == null || !this.isActive()) {
            return null;
        }
        URL url = null;
        try {
            if (dl_url.indexOf("://") != -1) {
                url = new URL(dl_url);
            } else {
                File f = this.getDownloadFile(directory);
                if (f != null) {
                    url = f.toURL();
                }
            }
        }
        catch (Exception ex) {
            this.log.log(Level.SEVERE, dl_url, (Throwable)ex);
            return null;
        }
        return url;
    }

    public File getDownloadFile(String directory) {
        File file = new File(this.getDownloadURL());
        if (file.exists()) {
            return file;
        }
        if (directory == null || directory.length() == 0) {
            this.log.log(Level.SEVERE, "Not found " + this.getDownloadURL());
            return null;
        }
        String downloadURL2 = directory;
        if (!downloadURL2.endsWith(File.separator)) {
            downloadURL2 = downloadURL2 + File.separator;
        }
        if ((file = new File(downloadURL2 = downloadURL2 + this.getDownloadURL())).exists()) {
            return file;
        }
        this.log.log(Level.SEVERE, "Not found " + this.getDownloadURL() + " + " + downloadURL2);
        return null;
    }

    public InputStream getDownloadStream(String directory) {
        String dl_url = this.getDownloadURL();
        if (dl_url == null || !this.isActive()) {
            return null;
        }
        InputStream in = null;
        try {
            if (dl_url.indexOf("://") != -1) {
                URL url = new URL(dl_url);
                in = url.openStream();
            } else {
                File file = this.getDownloadFile(directory);
                if (file == null) {
                    return null;
                }
                in = new FileInputStream(file);
            }
        }
        catch (Exception ex) {
            this.log.log(Level.SEVERE, dl_url, (Throwable)ex);
            return null;
        }
        return in;
    }
}

