/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.logging.Level;
import org.compiere.model.MLocator;
import org.compiere.model.MProduct;
import org.compiere.model.X_M_ProductLocator;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.Ctx;
import org.compiere.util.DB;

public class MProductLocator
extends X_M_ProductLocator {
    private static CLogger s_log = CLogger.getCLogger(MProductLocator.class);

    public static MLocator[] getLocators(MProduct product, int M_Warehouse_ID) {
        ArrayList<MLocator> list = new ArrayList<MLocator>();
        String sql = "SELECT * FROM M_Locator l WHERE l.IsActive='Y' AND (M_Locator_ID IN (SELECT M_Locator_ID FROM M_Product WHERE M_Product_ID=?) OR M_Locator_ID IN (SELECT M_Locator_ID FROM M_ProductLocator WHERE M_Product_ID=? AND IsActive='Y')) AND M_Warehouse_ID=? ORDER BY PriorityNo DESC";
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement((String)sql, (String)product.get_TrxName());
            pstmt.setInt(1, product.getM_Product_ID());
            pstmt.setInt(2, product.getM_Product_ID());
            pstmt.setInt(3, M_Warehouse_ID);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                list.add(new MLocator(product.getCtx(), rs, product.get_TrxName()));
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            s_log.log(Level.SEVERE, sql, (Throwable)e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        MLocator[] retValue = new MLocator[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    public static int getFirstM_Locator_ID(MProduct product, int M_Warehouse_ID) {
        if (product == null || M_Warehouse_ID == 0) {
            return 0;
        }
        int M_Locator_ID = 0;
        String sql = "SELECT M_Locator_ID FROM M_Locator l WHERE l.IsActive='Y' AND (M_Locator_ID IN (SELECT M_Locator_ID FROM M_Product WHERE M_Product_ID=?) OR M_Locator_ID IN (SELECT M_Locator_ID FROM M_ProductLocator WHERE M_Product_ID=? AND IsActive='Y')) AND M_Warehouse_ID=? ORDER BY PriorityNo DESC";
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement((String)sql, (String)product.get_TrxName());
            pstmt.setInt(1, product.getM_Product_ID());
            pstmt.setInt(2, product.getM_Product_ID());
            pstmt.setInt(3, M_Warehouse_ID);
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                M_Locator_ID = rs.getInt(1);
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            s_log.log(Level.SEVERE, sql, (Throwable)e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        return M_Locator_ID;
    }

    public MProductLocator(Ctx ctx, int M_ProductLocator_ID, String trxName) {
        super(ctx, M_ProductLocator_ID, trxName);
    }

    public MProductLocator(Ctx ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }
}

