/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.logging.Level;
import org.compiere.framework.PO;
import org.compiere.model.MAccount;
import org.compiere.model.MPriceList;
import org.compiere.model.MProjectIssue;
import org.compiere.model.MProjectLine;
import org.compiere.model.MProjectPhase;
import org.compiere.model.MProjectType;
import org.compiere.model.MProjectTypePhase;
import org.compiere.model.X_C_Project;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.Ctx;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class MProject
extends X_C_Project {
    private int m_M_PriceList_ID = 0;

    public static MProject copyFrom(Ctx ctx, int C_Project_ID, Timestamp dateDoc, String trxName) {
        MProject from = new MProject(ctx, C_Project_ID, trxName);
        if (from.getC_Project_ID() == 0) {
            throw new IllegalArgumentException("From Project not found C_Project_ID=" + C_Project_ID);
        }
        MProject to = new MProject(ctx, 0, trxName);
        PO.copyValues((PO)from, (PO)to, (int)from.getAD_Client_ID(), (int)from.getAD_Org_ID());
        to.set_ValueNoCheck("C_Project_ID", I_ZERO);
        String Value = to.getValue() + " ";
        String Time2 = dateDoc.toString();
        int length = Value.length() + Time2.length();
        Value = length <= 40 ? Value + Time2 : Value + Time2.substring(length - 40);
        to.setValue(Value);
        to.setInvoicedAmt(Env.ZERO);
        to.setProjectBalanceAmt(Env.ZERO);
        to.setProcessed(false);
        if (!to.save()) {
            throw new IllegalStateException("Could not create Project");
        }
        if (to.copyDetailsFrom(from) == 0) {
            throw new IllegalStateException("Could not create Project Details");
        }
        return to;
    }

    public MProject(Ctx ctx, int C_Project_ID, String trxName) {
        super(ctx, C_Project_ID, trxName);
        if (C_Project_ID == 0) {
            this.setCommittedAmt(Env.ZERO);
            this.setCommittedQty(Env.ZERO);
            this.setInvoicedAmt(Env.ZERO);
            this.setInvoicedQty(Env.ZERO);
            this.setPlannedAmt(Env.ZERO);
            this.setPlannedMarginAmt(Env.ZERO);
            this.setPlannedQty(Env.ZERO);
            this.setProjectBalanceAmt(Env.ZERO);
            this.setProjInvoiceRule("-");
            this.setProjectLineLevel("P");
            this.setIsCommitCeiling(false);
            this.setIsCommitment(false);
            this.setIsSummary(false);
            this.setProcessed(false);
        }
    }

    public MProject(Ctx ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public int getC_ProjectType_ID_Int() {
        String pj = super.getC_ProjectType_ID();
        if (pj == null) {
            return 0;
        }
        int C_ProjectType_ID = 0;
        try {
            C_ProjectType_ID = Integer.parseInt(pj);
        }
        catch (Exception ex) {
            this.log.log(Level.SEVERE, pj, (Throwable)ex);
        }
        return C_ProjectType_ID;
    }

    public void setC_ProjectType_ID(int C_ProjectType_ID) {
        if (C_ProjectType_ID == 0) {
            super.set_Value("C_ProjectType_ID", null);
        } else {
            super.set_Value("C_ProjectType_ID", (Object)new Integer(C_ProjectType_ID));
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("MProject[").append(this.get_ID()).append("-").append(this.getValue()).append(",ProjectCategory=").append(this.getProjectCategory()).append("]");
        return sb.toString();
    }

    public int getM_PriceList_ID() {
        if (this.getM_PriceList_Version_ID() == 0) {
            return 0;
        }
        if (this.m_M_PriceList_ID > 0) {
            return this.m_M_PriceList_ID;
        }
        String sql = "SELECT M_PriceList_ID FROM M_PriceList_Version WHERE M_PriceList_Version_ID=?";
        this.m_M_PriceList_ID = DB.getSQLValue(null, (String)sql, (int)this.getM_PriceList_Version_ID());
        return this.m_M_PriceList_ID;
    }

    public void setM_PriceList_Version_ID(int M_PriceList_Version_ID) {
        super.setM_PriceList_Version_ID(M_PriceList_Version_ID);
        this.m_M_PriceList_ID = 0;
    }

    public MProjectLine[] getLines() {
        ArrayList<MProjectLine> list = new ArrayList<MProjectLine>();
        String sql = "SELECT * FROM C_ProjectLine WHERE C_Project_ID=? ORDER BY Line";
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement((String)sql, (String)this.get_TrxName());
            pstmt.setInt(1, this.getC_Project_ID());
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                list.add(new MProjectLine(this.getCtx(), rs, this.get_TrxName()));
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (SQLException ex) {
            this.log.log(Level.SEVERE, sql, (Throwable)ex);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
        }
        catch (SQLException ex1) {
            // empty catch block
        }
        pstmt = null;
        MProjectLine[] retValue = new MProjectLine[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    public MProjectIssue[] getIssues() {
        ArrayList<MProjectIssue> list = new ArrayList<MProjectIssue>();
        String sql = "SELECT * FROM C_ProjectIssue WHERE C_Project_ID=? ORDER BY Line";
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement((String)sql, (String)this.get_TrxName());
            pstmt.setInt(1, this.getC_Project_ID());
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                list.add(new MProjectIssue(this.getCtx(), rs, this.get_TrxName()));
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (SQLException ex) {
            this.log.log(Level.SEVERE, sql, (Throwable)ex);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
        }
        catch (SQLException ex1) {
            // empty catch block
        }
        pstmt = null;
        MProjectIssue[] retValue = new MProjectIssue[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    public MProjectPhase[] getPhases() {
        ArrayList<MProjectPhase> list = new ArrayList<MProjectPhase>();
        String sql = "SELECT * FROM C_ProjectPhase WHERE C_Project_ID=? ORDER BY SeqNo";
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement((String)sql, (String)this.get_TrxName());
            pstmt.setInt(1, this.getC_Project_ID());
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                list.add(new MProjectPhase(this.getCtx(), rs, this.get_TrxName()));
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (SQLException ex) {
            this.log.log(Level.SEVERE, sql, (Throwable)ex);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
        }
        catch (SQLException ex1) {
            // empty catch block
        }
        pstmt = null;
        MProjectPhase[] retValue = new MProjectPhase[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    public int copyDetailsFrom(MProject project) {
        if (this.isProcessed() || project == null) {
            return 0;
        }
        int count = this.copyLinesFrom(project) + this.copyPhasesFrom(project);
        return count;
    }

    public int copyLinesFrom(MProject project) {
        if (this.isProcessed() || project == null) {
            return 0;
        }
        int count = 0;
        MProjectLine[] fromLines = project.getLines();
        for (int i = 0; i < fromLines.length; ++i) {
            MProjectLine line = new MProjectLine(this.getCtx(), 0, project.get_TrxName());
            PO.copyValues((PO)fromLines[i], (PO)line, (int)this.getAD_Client_ID(), (int)this.getAD_Org_ID());
            line.setC_Project_ID(this.getC_Project_ID());
            line.setInvoicedAmt(Env.ZERO);
            line.setInvoicedQty(Env.ZERO);
            line.setC_OrderPO_ID(0);
            line.setC_Order_ID(0);
            line.setProcessed(false);
            if (!line.save()) continue;
            ++count;
        }
        if (fromLines.length != count) {
            this.log.log(Level.SEVERE, "Lines difference - Project=" + fromLines.length + " <> Saved=" + count);
        }
        return count;
    }

    public int copyPhasesFrom(MProject fromProject) {
        if (this.isProcessed() || fromProject == null) {
            return 0;
        }
        int count = 0;
        int taskCount = 0;
        MProjectPhase[] myPhases = this.getPhases();
        MProjectPhase[] fromPhases = fromProject.getPhases();
        for (int i = 0; i < fromPhases.length; ++i) {
            int C_Phase_ID = fromPhases[i].getC_Phase_ID();
            boolean exists = false;
            if (C_Phase_ID == 0) {
                exists = false;
            } else {
                for (int ii = 0; ii < myPhases.length; ++ii) {
                    if (myPhases[ii].getC_Phase_ID() != C_Phase_ID) continue;
                    exists = true;
                    break;
                }
            }
            if (exists) {
                this.log.info("Phase already exists here, ignored - " + (Object)((Object)fromPhases[i]));
                continue;
            }
            MProjectPhase toPhase = new MProjectPhase(this.getCtx(), 0, this.get_TrxName());
            PO.copyValues((PO)fromPhases[i], (PO)toPhase, (int)this.getAD_Client_ID(), (int)this.getAD_Org_ID());
            toPhase.setC_Project_ID(this.getC_Project_ID());
            toPhase.setC_Order_ID(0);
            toPhase.setIsComplete(false);
            if (!toPhase.save()) continue;
            ++count;
            taskCount += toPhase.copyTasksFrom(fromPhases[i]);
        }
        if (fromPhases.length != count) {
            this.log.warning("Count difference - Project=" + fromPhases.length + " <> Saved=" + count);
        }
        return count + taskCount;
    }

    public void setProjectType(MProjectType type) {
        if (type == null) {
            return;
        }
        this.setC_ProjectType_ID(type.getC_ProjectType_ID());
        this.setProjectCategory(type.getProjectCategory());
        if ("S".equals(this.getProjectCategory())) {
            this.copyPhasesFrom(type);
        }
    }

    public int copyPhasesFrom(MProjectType type) {
        int count = 0;
        int taskCount = 0;
        MProjectTypePhase[] typePhases = type.getPhases();
        for (int i = 0; i < typePhases.length; ++i) {
            MProjectPhase toPhase = new MProjectPhase(this, typePhases[i]);
            if (!toPhase.save()) continue;
            ++count;
            taskCount += toPhase.copyTasksFrom(typePhases[i]);
        }
        this.log.fine("#" + count + "/" + taskCount + " - " + (Object)((Object)type));
        if (typePhases.length != count) {
            this.log.log(Level.SEVERE, "Count difference - Type=" + typePhases.length + " <> Saved=" + count);
        }
        return count;
    }

    protected boolean beforeSave(boolean newRecord) {
        MPriceList pl;
        if (this.getAD_User_ID() == -1) {
            this.setAD_User_ID(0);
        }
        if (this.is_ValueChanged("M_PriceList_Version_ID") && this.getM_PriceList_Version_ID() != 0 && (pl = MPriceList.get(this.getCtx(), this.getM_PriceList_ID(), null)) != null && pl.get_ID() != 0) {
            this.setC_Currency_ID(pl.getC_Currency_ID());
        }
        return true;
    }

    protected boolean afterSave(boolean newRecord, boolean success) {
        if (newRecord & success) {
            this.insert_Accounting("C_Project_Acct", "C_AcctSchema_Default", null);
        }
        if (success && !newRecord && (this.is_ValueChanged("Value") || this.is_ValueChanged("Name"))) {
            MAccount.updateValueDescription((Ctx)this.getCtx(), (String)("C_Project_ID=" + this.getC_Project_ID()), (String)this.get_TrxName());
        }
        return success;
    }

    protected boolean beforeDelete() {
        return this.delete_Accounting("C_Project_Acct");
    }
}

