/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.logging.Level;
import org.compiere.framework.PO;
import org.compiere.model.MProject;
import org.compiere.model.MProjectTask;
import org.compiere.model.MProjectTypePhase;
import org.compiere.model.MProjectTypeTask;
import org.compiere.model.X_C_ProjectPhase;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.Ctx;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class MProjectPhase
extends X_C_ProjectPhase {
    public MProjectPhase(Ctx ctx, int C_ProjectPhase_ID, String trxName) {
        super(ctx, C_ProjectPhase_ID, trxName);
        if (C_ProjectPhase_ID == 0) {
            this.setCommittedAmt(Env.ZERO);
            this.setIsCommitCeiling(false);
            this.setIsComplete(false);
            this.setSeqNo(0);
            this.setPlannedAmt(Env.ZERO);
            this.setPlannedQty(Env.ZERO);
            this.setQty(Env.ZERO);
        }
    }

    public MProjectPhase(Ctx ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MProjectPhase(MProject project) {
        this(project.getCtx(), 0, project.get_TrxName());
        this.setClientOrg((PO)project);
        this.setC_Project_ID(project.getC_Project_ID());
    }

    public MProjectPhase(MProject project, MProjectTypePhase phase) {
        this(project);
        this.setC_Phase_ID(phase.getC_Phase_ID());
        this.setName(phase.getName());
        this.setSeqNo(phase.getSeqNo());
        this.setDescription(phase.getDescription());
        this.setHelp(phase.getHelp());
        if (phase.getM_Product_ID() != 0) {
            this.setM_Product_ID(phase.getM_Product_ID());
        }
        this.setQty(phase.getStandardQty());
    }

    public MProjectTask[] getTasks() {
        ArrayList<MProjectTask> list = new ArrayList<MProjectTask>();
        String sql = "SELECT * FROM C_ProjectTask WHERE C_ProjectPhase_ID=? ORDER BY SeqNo";
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement((String)sql, (String)this.get_TrxName());
            pstmt.setInt(1, this.getC_ProjectPhase_ID());
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                list.add(new MProjectTask(this.getCtx(), rs, this.get_TrxName()));
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (SQLException ex) {
            this.log.log(Level.SEVERE, sql, (Throwable)ex);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
        }
        catch (SQLException ex1) {
            // empty catch block
        }
        pstmt = null;
        MProjectTask[] retValue = new MProjectTask[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    public int copyTasksFrom(MProjectPhase fromPhase) {
        if (fromPhase == null) {
            return 0;
        }
        int count = 0;
        MProjectTask[] myTasks = this.getTasks();
        MProjectTask[] fromTasks = fromPhase.getTasks();
        for (int i = 0; i < fromTasks.length; ++i) {
            int C_Task_ID = fromTasks[i].getC_Task_ID();
            boolean exists = false;
            if (C_Task_ID == 0) {
                exists = false;
            } else {
                for (int ii = 0; ii < myTasks.length; ++ii) {
                    if (myTasks[ii].getC_Task_ID() != C_Task_ID) continue;
                    exists = true;
                    break;
                }
            }
            if (exists) {
                this.log.info("Task already exists here, ignored - " + (Object)((Object)fromTasks[i]));
                continue;
            }
            MProjectTask toTask = new MProjectTask(this.getCtx(), 0, this.get_TrxName());
            PO.copyValues((PO)fromTasks[i], (PO)toTask, (int)this.getAD_Client_ID(), (int)this.getAD_Org_ID());
            toTask.setC_ProjectPhase_ID(this.getC_ProjectPhase_ID());
            if (!toTask.save()) continue;
            ++count;
        }
        if (fromTasks.length != count) {
            this.log.warning("Count difference - ProjectPhase=" + fromTasks.length + " <> Saved=" + count);
        }
        return count;
    }

    public int copyTasksFrom(MProjectTypePhase fromPhase) {
        if (fromPhase == null) {
            return 0;
        }
        int count = 0;
        MProjectTypeTask[] fromTasks = fromPhase.getTasks();
        for (int i = 0; i < fromTasks.length; ++i) {
            MProjectTask toTask = new MProjectTask(this, fromTasks[i]);
            if (!toTask.save()) continue;
            ++count;
        }
        this.log.fine("#" + count + " - " + (Object)((Object)fromPhase));
        if (fromTasks.length != count) {
            this.log.log(Level.SEVERE, "Count difference - TypePhase=" + fromTasks.length + " <> Saved=" + count);
        }
        return count;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("MProjectPhase[");
        sb.append(this.get_ID()).append("-").append(this.getSeqNo()).append("-").append(this.getName()).append("]");
        return sb.toString();
    }
}

